/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.util.teleport;

import fi.dy.masa.enderutilities.EnderUtilities;
import fi.dy.masa.enderutilities.item.base.ItemModule;
import fi.dy.masa.enderutilities.network.PacketHandler;
import fi.dy.masa.enderutilities.network.message.MessageAddEffects;
import fi.dy.masa.enderutilities.util.ChunkLoading;
import fi.dy.masa.enderutilities.util.EntityUtils;
import fi.dy.masa.enderutilities.util.PositionHelper;
import fi.dy.masa.enderutilities.util.PositionUtils;
import fi.dy.masa.enderutilities.util.nbt.TargetData;
import fi.dy.masa.enderutilities.util.nbt.UtilItemModular;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityMinecartContainer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.BossInfoServer;
import net.minecraft.world.Teleporter;
import net.minecraft.world.World;
import net.minecraft.world.WorldProviderEnd;
import net.minecraft.world.WorldServer;
import net.minecraft.world.end.DragonFightManager;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class TeleportEntity {
    private static boolean teleportInProgress;

    public static boolean isTeleportInProgress() {
        return teleportInProgress;
    }

    public static void addTeleportSoundsAndParticles(World world, double x, double y, double z) {
        if (!world.field_72995_K) {
            PacketHandler.INSTANCE.sendToAllAround((IMessage)new MessageAddEffects(1, 3, x, y, z), new NetworkRegistry.TargetPoint(world.field_73011_w.getDimension(), x, y, z, 24.0));
        }
    }

    public static boolean canTeleportEntity(Entity entity) {
        return !EntityUtils.doesEntityStackHaveBlacklistedEntities(entity);
    }

    public static boolean teleportEntityRandomly(Entity entity, double maxDist) {
        World world = entity.func_130014_f_();
        if (!TeleportEntity.canTeleportEntity(entity) || world.field_72995_K) {
            return false;
        }
        double deltaYaw = 0.0;
        double deltaPitch = 0.0;
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        maxDist -= (double)world.field_73012_v.nextFloat() * maxDist / 2.0;
        for (int i = 0; i < 20; ++i) {
            deltaYaw = (double)world.field_73012_v.nextFloat() * 2.0 * Math.PI;
            deltaPitch = (double)world.field_73012_v.nextFloat() * 0.5 * Math.PI;
            x = entity.field_70165_t;
            y = entity.field_70163_u;
            z = entity.field_70161_v;
            x += Math.cos(deltaPitch) * Math.cos(deltaYaw) * maxDist;
            z += Math.cos(deltaPitch) * Math.sin(deltaYaw) * maxDist;
            y += Math.sin(deltaPitch) * maxDist;
            if (entity.func_174813_aQ() == null || !world.func_184144_a(entity, entity.func_174813_aQ()).isEmpty()) continue;
            TeleportEntity.addTeleportSoundsAndParticles(world, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
            entity.func_70012_b(x, y, z, entity.field_70177_z, entity.field_70125_A);
            TeleportEntity.addTeleportSoundsAndParticles(world, x, y, z);
            return true;
        }
        return false;
    }

    public static boolean teleportEntityWithProjectile(Entity entity, Entity projectile, RayTraceResult rayTraceResult, float teleportDamage, boolean allowMounts, boolean allowRiders) {
        Entity entNew;
        if (!TeleportEntity.canTeleportEntity(entity)) {
            return false;
        }
        PositionHelper pos = new PositionHelper(rayTraceResult, projectile);
        if (rayTraceResult.field_72313_a == RayTraceResult.Type.BLOCK) {
            pos.adjustPositionToTouchFace(entity, rayTraceResult.field_178784_b);
        }
        if ((entNew = TeleportEntity.teleportEntity(entity, pos.posX, pos.posY, pos.posZ, projectile.func_130014_f_().field_73011_w.getDimension(), allowMounts, allowRiders)) != null) {
            Entity bottom;
            if (teleportDamage != 0.0f && (bottom = EntityUtils.getBottomEntity(entNew)) instanceof EntityLivingBase) {
                bottom.func_70097_a(DamageSource.field_76379_h, teleportDamage);
            }
            entNew.field_70143_R = 0.0f;
            return true;
        }
        return false;
    }

    public static Entity teleportEntityUsingModularItem(Entity entity, ItemStack stack, boolean allowMounts, boolean allowRiders) {
        return TeleportEntity.teleportEntityUsingItem(entity, UtilItemModular.getSelectedModuleStack(stack, ItemModule.ModuleType.TYPE_LINKCRYSTAL), allowMounts, allowRiders);
    }

    public static Entity teleportEntityUsingItem(Entity entity, ItemStack stack, boolean allowMounts, boolean allowRiders) {
        TargetData target = TargetData.getTargetFromItem(stack);
        if (target != null) {
            return TeleportEntity.teleportEntityUsingTarget(entity, target, true, allowMounts, allowRiders);
        }
        return null;
    }

    public static Entity teleportEntityUsingTarget(Entity entity, TargetData target, boolean adjustTargetPosition, boolean allowMounts, boolean allowRiders) {
        if (target == null || entity == null) {
            return null;
        }
        if (adjustTargetPosition) {
            target = PositionUtils.adjustTargetPosition(target, entity);
        }
        if (target.hasRotation) {
            entity.func_70012_b(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, target.yaw, target.pitch);
        }
        return TeleportEntity.teleportEntity(entity, target.dPosX, target.dPosY, target.dPosZ, target.dimension, allowMounts, allowRiders);
    }

    public static Entity teleportEntity(Entity entityIn, double x, double y, double z, int dimDst, boolean allowMounts, boolean allowRiders) {
        Entity teleported;
        if (entityIn == null || entityIn.func_130014_f_() == null || entityIn.func_130014_f_().field_72995_K) {
            return null;
        }
        if (!allowMounts && entityIn.func_184218_aH()) {
            return null;
        }
        if (!allowRiders && entityIn.func_184207_aI()) {
            return null;
        }
        if (!TeleportEntity.canTeleportEntity(entityIn)) {
            return null;
        }
        UUID uuidOriginal = entityIn.func_110124_au();
        Entity entity = EntityUtils.getBottomEntity(entityIn);
        List passengers = null;
        boolean ridden = false;
        boolean reCreate = EntityUtils.doesEntityStackHavePlayers(entityIn);
        boolean isOriginal = entity != entityIn;
        ridden = entity.func_184207_aI();
        if (ridden) {
            passengers = entity.func_184188_bt();
            for (Entity passenger : passengers) {
                passenger.func_184210_p();
            }
        }
        if ((teleported = TeleportEntity.teleportEntity(entity, x, y, z, dimDst, reCreate)) == null) {
            return null;
        }
        teleported.field_70143_R = 0.0f;
        if (ridden) {
            for (Entity passenger : passengers) {
                Entity teleportedPassenger = TeleportEntity.teleportEntity(passenger, x, y, z, dimDst, allowMounts, allowRiders);
                if (teleportedPassenger == null) continue;
                teleportedPassenger.func_184205_a(teleported, true);
            }
        }
        if (isOriginal) {
            teleported = EntityUtils.findEntityFromStackByUUID(teleported, uuidOriginal);
        }
        return teleported;
    }

    private static Entity teleportEntity(Entity entity, double x, double y, double z, int dimDst, boolean forceRecreate) {
        EnderTeleportEvent event;
        if (entity == null || !entity.func_70089_S() || !TeleportEntity.canTeleportEntity(entity) || entity.func_130014_f_().field_72995_K) {
            return null;
        }
        if (entity instanceof EntityLivingBase && MinecraftForge.EVENT_BUS.post((Event)(event = new EnderTeleportEvent((EntityLivingBase)entity, x, y, z, 0.0f)))) {
            return null;
        }
        TeleportEntity.addTeleportSoundsAndParticles(entity.func_130014_f_(), entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
        if (entity instanceof EntityLiving) {
            ((EntityLiving)entity).func_191989_p(0.0f);
            ((EntityLiving)entity).func_70661_as().func_75499_g();
        }
        if ((entity = entity.func_130014_f_().field_73011_w.getDimension() != dimDst ? TeleportEntity.teleportEntityToDimension(entity, x, y, z, dimDst) : TeleportEntity.teleportEntityInsideSameDimension(entity, x, y, z)) != null) {
            TeleportEntity.addTeleportSoundsAndParticles(entity.func_130014_f_(), x, y, z);
        }
        return entity;
    }

    private static Entity teleportEntityInsideSameDimension(Entity entity, double x, double y, double z) {
        entity.func_130014_f_().func_72964_e((int)Math.floor(x / 16.0), (int)Math.floor(z / 16.0));
        entity.func_70012_b(x, y, z, entity.field_70177_z, entity.field_70125_A);
        entity.func_70634_a(x, y, z);
        return entity;
    }

    private static Entity teleportEntityToDimension(Entity entity, double x, double y, double z, int dimDst) {
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        WorldServer worldDst = server.func_71218_a(dimDst);
        teleportInProgress = true;
        if (worldDst == null || !ForgeHooks.onTravelToDimension((Entity)entity, (int)dimDst)) {
            teleportInProgress = false;
            return null;
        }
        teleportInProgress = false;
        int chunkX = (int)Math.floor(x / 16.0);
        int chunkZ = (int)Math.floor(z / 16.0);
        ChunkLoading.getInstance().loadChunkForcedWithModTicket(dimDst, chunkX, chunkZ, 10);
        if (entity instanceof EntityPlayerMP) {
            EntityPlayerMP player = (EntityPlayerMP)entity;
            World worldOld = player.func_130014_f_();
            DummyTeleporter teleporter = new DummyTeleporter(worldDst);
            player.func_70012_b(x, y, z, player.field_70177_z, player.field_70125_A);
            server.func_184103_al().transferPlayerToDimension(player, dimDst, (Teleporter)teleporter);
            if (worldOld.field_73011_w instanceof WorldProviderEnd) {
                TeleportEntity.removeDragonBossBarHack(player, (WorldProviderEnd)worldOld.field_73011_w);
            }
            player.func_70634_a(x, y, z);
            worldDst.func_72866_a((Entity)player, false);
            player.func_82242_a(0);
            player.func_71118_n();
        } else {
            Entity entityNew;
            WorldServer worldSrc = (WorldServer)entity.func_130014_f_();
            if (entity instanceof EntityMinecartContainer) {
                ((EntityMinecartContainer)entity).func_184174_b(false);
            }
            if ((entityNew = EntityList.func_191304_a(entity.getClass(), (World)worldDst)) != null) {
                EntityUtils.copyDataFromOld(entityNew, entity);
                entityNew.func_70012_b(x, y, z, entity.field_70177_z, entity.field_70125_A);
                boolean flag = entityNew.field_98038_p;
                entityNew.field_98038_p = true;
                worldDst.func_72838_d(entityNew);
                entityNew.field_98038_p = flag;
                worldDst.func_72866_a(entityNew, false);
                entity.field_70128_L = true;
                worldSrc.func_72900_e(entity);
                worldSrc.func_72866_a(entity, false);
                worldSrc.func_82742_i();
                worldDst.func_82742_i();
            }
            entity = entityNew;
        }
        return entity;
    }

    private static void removeDragonBossBarHack(EntityPlayerMP player, WorldProviderEnd provider) {
        DragonFightManager manager = provider.func_186063_s();
        if (manager != null) {
            try {
                BossInfoServer bossInfo = (BossInfoServer)ObfuscationReflectionHelper.getPrivateValue(DragonFightManager.class, (Object)manager, (String)"field_186109_c");
                if (bossInfo != null) {
                    bossInfo.func_186761_b(player);
                }
            }
            catch (Exception e) {
                EnderUtilities.logger.warn("TP: Failed to get DragonFightManager#bossInfo");
            }
        }
    }

    private static class DummyTeleporter
    extends Teleporter {
        public DummyTeleporter(WorldServer world) {
            super(world);
        }

        public boolean func_85188_a(Entity entityIn) {
            return true;
        }

        public boolean func_180620_b(Entity entityIn, float rotationYaw) {
            return true;
        }

        public void func_85189_a(long worldTime) {
        }

        public void func_180266_a(Entity entityIn, float rotationYaw) {
        }
    }
}

