/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.jei;

import com.buuz135.industrial.api.extractor.ExtractorEntry;
import com.buuz135.industrial.api.recipe.BioReactorEntry;
import com.buuz135.industrial.api.recipe.FluidDictionaryEntry;
import com.buuz135.industrial.api.recipe.LaserDrillEntry;
import com.buuz135.industrial.api.recipe.ProteinReactorEntry;
import com.buuz135.industrial.api.recipe.ore.OreFluidEntryFermenter;
import com.buuz135.industrial.api.recipe.ore.OreFluidEntryRaw;
import com.buuz135.industrial.api.recipe.ore.OreFluidEntrySieve;
import com.buuz135.industrial.book.BookCategory;
import com.buuz135.industrial.config.CustomConfiguration;
import com.buuz135.industrial.gui.conveyor.GuiConveyor;
import com.buuz135.industrial.jei.extractor.ExtractorRecipeCategory;
import com.buuz135.industrial.jei.extractor.ExtractorRecipeWrapper;
import com.buuz135.industrial.jei.fluiddictionary.FluidDictionaryCategory;
import com.buuz135.industrial.jei.fluiddictionary.FluidDictionaryWrapper;
import com.buuz135.industrial.jei.ghost.ConveyorGhostSlotHandler;
import com.buuz135.industrial.jei.laser.LaserRecipeCategory;
import com.buuz135.industrial.jei.laser.LaserRecipeWrapper;
import com.buuz135.industrial.jei.machineproduce.MachineProduceCategory;
import com.buuz135.industrial.jei.machineproduce.MachineProduceWrapper;
import com.buuz135.industrial.jei.manual.ManualCategory;
import com.buuz135.industrial.jei.manual.ManualWrapper;
import com.buuz135.industrial.jei.ore.OreFermenterCategory;
import com.buuz135.industrial.jei.ore.OreFermenterWrapper;
import com.buuz135.industrial.jei.ore.OreSieveCategory;
import com.buuz135.industrial.jei.ore.OreSieveWrapper;
import com.buuz135.industrial.jei.ore.OreWasherCategory;
import com.buuz135.industrial.jei.ore.OreWasherWrapper;
import com.buuz135.industrial.jei.petrifiedgen.PetrifiedBurnTimeCategory;
import com.buuz135.industrial.jei.petrifiedgen.PetrifiedBurnTimeWrapper;
import com.buuz135.industrial.jei.reactor.ReactorRecipeCategory;
import com.buuz135.industrial.jei.reactor.ReactorRecipeWrapper;
import com.buuz135.industrial.jei.sludge.SludgeRefinerRecipeCategory;
import com.buuz135.industrial.jei.sludge.SludgeRefinerRecipeWrapper;
import com.buuz135.industrial.jei.stonework.StoneWorkCategory;
import com.buuz135.industrial.jei.stonework.StoneWorkWrapper;
import com.buuz135.industrial.proxy.BlockRegistry;
import com.buuz135.industrial.proxy.FluidsRegistry;
import com.buuz135.industrial.proxy.ItemRegistry;
import com.buuz135.industrial.tile.block.CustomOrientedBlock;
import com.buuz135.industrial.tile.generator.PetrifiedFuelGeneratorTile;
import com.buuz135.industrial.tile.world.MaterialStoneWorkFactoryTile;
import com.buuz135.industrial.utils.CraftingUtils;
import com.buuz135.industrial.utils.ItemStackWeightedItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import mezz.jei.api.IJeiRuntime;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.IRecipeRegistry;
import mezz.jei.api.IRecipesGui;
import mezz.jei.api.ISubtypeRegistry;
import mezz.jei.api.JEIPlugin;
import mezz.jei.api.gui.IGhostIngredientHandler;
import mezz.jei.api.ingredients.IModIngredientRegistration;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeCategoryRegistration;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.WeightedRandom;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;

@JEIPlugin
public class JEICustomPlugin
implements IModPlugin {
    private static IRecipesGui recipesGui;
    private static IRecipeRegistry recipeRegistry;
    private SludgeRefinerRecipeCategory sludgeRefinerRecipeCategory;
    private ReactorRecipeCategory bioReactorRecipeCategory;
    private ReactorRecipeCategory proteinReactorRecipeCategory;
    private LaserRecipeCategory laserRecipeCategory;
    private MachineProduceCategory machineProduceCategory;
    private PetrifiedBurnTimeCategory petrifiedBurnTimeCategory;
    private ManualCategory manualCategory;
    private FluidDictionaryCategory fluidDictionaryCategory;
    private StoneWorkCategory stoneWorkCategory;
    private ExtractorRecipeCategory extractorRecipeCategory;
    private OreWasherCategory oreWasherCategory;
    private OreFermenterCategory oreFermenterCategory;
    private OreSieveCategory oreSieveCategory;

    public static void showUses(ItemStack stack) {
        if (recipesGui != null && recipeRegistry != null) {
            recipesGui.show(recipeRegistry.createFocus(IFocus.Mode.INPUT, (Object)stack));
        }
    }

    public void registerItemSubtypes(ISubtypeRegistry subtypeRegistry) {
        subtypeRegistry.useNbtForSubtypes(new Item[]{ItemRegistry.itemInfinityDrill});
    }

    public void registerIngredients(IModIngredientRegistration registry) {
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        if (BlockRegistry.sludgeRefinerBlock.isEnabled()) {
            this.sludgeRefinerRecipeCategory = new SludgeRefinerRecipeCategory(registry.getJeiHelpers().getGuiHelper());
            registry.addRecipeCategories(new IRecipeCategory[]{this.sludgeRefinerRecipeCategory});
        }
        if (BlockRegistry.bioReactorBlock.isEnabled()) {
            this.bioReactorRecipeCategory = new ReactorRecipeCategory(registry.getJeiHelpers().getGuiHelper(), "Bioreactor accepted items");
            registry.addRecipeCategories(new IRecipeCategory[]{this.bioReactorRecipeCategory});
        }
        if (BlockRegistry.proteinReactorBlock.isEnabled()) {
            this.proteinReactorRecipeCategory = new ReactorRecipeCategory(registry.getJeiHelpers().getGuiHelper(), "Protein reactor accepted items");
            registry.addRecipeCategories(new IRecipeCategory[]{this.proteinReactorRecipeCategory});
        }
        if (BlockRegistry.laserBaseBlock.isEnabled() || BlockRegistry.laserDrillBlock.isEnabled()) {
            this.laserRecipeCategory = new LaserRecipeCategory(registry.getJeiHelpers().getGuiHelper());
            registry.addRecipeCategories(new IRecipeCategory[]{this.laserRecipeCategory});
        }
        this.machineProduceCategory = new MachineProduceCategory(registry.getJeiHelpers().getGuiHelper());
        registry.addRecipeCategories(new IRecipeCategory[]{this.machineProduceCategory});
        if (BlockRegistry.petrifiedFuelGeneratorBlock.isEnabled()) {
            this.petrifiedBurnTimeCategory = new PetrifiedBurnTimeCategory(registry.getJeiHelpers().getGuiHelper());
            registry.addRecipeCategories(new IRecipeCategory[]{this.petrifiedBurnTimeCategory});
        }
        if (BlockRegistry.fluidDictionaryConverterBlock.isEnabled() && !FluidDictionaryEntry.FLUID_DICTIONARY_RECIPES.isEmpty()) {
            this.fluidDictionaryCategory = new FluidDictionaryCategory(registry.getJeiHelpers().getGuiHelper());
            registry.addRecipeCategories(new IRecipeCategory[]{this.fluidDictionaryCategory});
        }
        if (BlockRegistry.materialStoneWorkFactoryBlock.isEnabled()) {
            this.stoneWorkCategory = new StoneWorkCategory(registry.getJeiHelpers().getGuiHelper());
            registry.addRecipeCategories(new IRecipeCategory[]{this.stoneWorkCategory});
        }
        if (BlockRegistry.treeFluidExtractorBlock.isEnabled()) {
            this.extractorRecipeCategory = new ExtractorRecipeCategory(registry.getJeiHelpers().getGuiHelper());
            registry.addRecipeCategories(new IRecipeCategory[]{this.extractorRecipeCategory});
        }
        if (CustomConfiguration.enableBookEntriesInJEI) {
            this.manualCategory = new ManualCategory(registry.getJeiHelpers().getGuiHelper());
            registry.addRecipeCategories(new IRecipeCategory[]{this.manualCategory});
        }
        if (BlockRegistry.oreWasherBlock.isEnabled()) {
            this.oreWasherCategory = new OreWasherCategory(registry.getJeiHelpers().getGuiHelper());
            registry.addRecipeCategories(new IRecipeCategory[]{this.oreWasherCategory});
        }
        if (BlockRegistry.oreFermenterBlock.isEnabled()) {
            this.oreFermenterCategory = new OreFermenterCategory(registry.getJeiHelpers().getGuiHelper());
            registry.addRecipeCategories(new IRecipeCategory[]{this.oreFermenterCategory});
        }
        if (BlockRegistry.oreSieveBlock.isEnabled()) {
            this.oreSieveCategory = new OreSieveCategory(registry.getJeiHelpers().getGuiHelper());
            registry.addRecipeCategories(new IRecipeCategory[]{this.oreSieveCategory});
        }
    }

    public void register(IModRegistry registry) {
        if (BlockRegistry.sludgeRefinerBlock.isEnabled()) {
            int maxWeight = WeightedRandom.func_76272_a(BlockRegistry.sludgeRefinerBlock.getItems());
            ArrayList wrapperList = new ArrayList();
            BlockRegistry.sludgeRefinerBlock.getItems().forEach(itemStackWeightedItem -> wrapperList.add(new SludgeRefinerRecipeWrapper((ItemStackWeightedItem)((Object)itemStackWeightedItem), maxWeight)));
            registry.addRecipes(wrapperList, this.sludgeRefinerRecipeCategory.getUid());
            registry.addRecipeCatalyst((Object)new ItemStack((Block)BlockRegistry.sludgeRefinerBlock), new String[]{this.sludgeRefinerRecipeCategory.getUid()});
        }
        if (BlockRegistry.bioReactorBlock.isEnabled()) {
            ArrayList bioreactor = new ArrayList();
            BioReactorEntry.BIO_REACTOR_ENTRIES.forEach(entry -> bioreactor.add(new ReactorRecipeWrapper(entry.getStack(), FluidsRegistry.BIOFUEL, BlockRegistry.bioReactorBlock.getBaseAmount())));
            registry.addRecipes(bioreactor, this.bioReactorRecipeCategory.getUid());
            registry.addRecipeCatalyst((Object)new ItemStack((Block)BlockRegistry.bioReactorBlock), new String[]{this.bioReactorRecipeCategory.getUid()});
        }
        if (BlockRegistry.proteinReactorBlock.isEnabled()) {
            ArrayList proteinreactor = new ArrayList();
            ProteinReactorEntry.PROTEIN_REACTOR_ENTRIES.forEach(entry -> proteinreactor.add(new ReactorRecipeWrapper(entry.getStack(), FluidsRegistry.PROTEIN, BlockRegistry.proteinReactorBlock.getBaseAmount())));
            registry.addRecipes(proteinreactor, this.proteinReactorRecipeCategory.getUid());
            registry.addRecipeCatalyst((Object)new ItemStack((Block)BlockRegistry.proteinReactorBlock), new String[]{this.proteinReactorRecipeCategory.getUid()});
        }
        if (BlockRegistry.laserBaseBlock.isEnabled() || BlockRegistry.laserDrillBlock.isEnabled()) {
            ArrayList laserRecipeWrappers = new ArrayList();
            LaserDrillEntry.LASER_DRILL_UNIQUE_VALUES.forEach(entry -> laserRecipeWrappers.add(new LaserRecipeWrapper((LaserDrillEntry.LaserDrillEntryExtended)entry)));
            registry.addRecipes(laserRecipeWrappers, this.laserRecipeCategory.getUid());
            registry.addRecipeCatalyst((Object)new ItemStack((Block)BlockRegistry.laserDrillBlock), new String[]{this.laserRecipeCategory.getUid()});
            registry.addRecipeCatalyst((Object)new ItemStack((Block)BlockRegistry.laserBaseBlock), new String[]{this.laserRecipeCategory.getUid()});
        }
        if (BlockRegistry.resourcefulFurnaceBlock.isEnabled()) {
            registry.addRecipeCatalyst((Object)new ItemStack((Block)BlockRegistry.resourcefulFurnaceBlock), new String[]{"minecraft.smelting"});
        }
        if (BlockRegistry.potionEnervatorBlock.isEnabled()) {
            registry.addRecipeCatalyst((Object)new ItemStack((Block)BlockRegistry.potionEnervatorBlock), new String[]{"minecraft.brewing"});
        }
        registry.addRecipes((Collection)Stream.of(new MachineProduceWrapper((Block)BlockRegistry.sporesRecreatorBlock, new ItemStack((Block)Blocks.field_150338_P)), new MachineProduceWrapper((Block)BlockRegistry.sporesRecreatorBlock, new ItemStack((Block)Blocks.field_150337_Q)), new MachineProduceWrapper((Block)BlockRegistry.sewageCompostSolidiferBlock, new ItemStack((Item)ItemRegistry.fertilizer)), new MachineProduceWrapper((Block)BlockRegistry.dyeMixerBlock, new ItemStack((Item)ItemRegistry.artificalDye, 1, Short.MAX_VALUE)), new MachineProduceWrapper((Block)BlockRegistry.lavaFabricatorBlock, new ItemStack(Items.field_151129_at)), new MachineProduceWrapper((Block)BlockRegistry.waterResourcesCollectorBlock, new ItemStack(Items.field_151115_aP, 1, Short.MAX_VALUE)), new MachineProduceWrapper((Block)BlockRegistry.mobRelocatorBlock, FluidUtil.getFilledBucket((FluidStack)new FluidStack((Fluid)FluidsRegistry.ESSENCE, 1000))), new MachineProduceWrapper((Block)BlockRegistry.cropRecolectorBlock, FluidUtil.getFilledBucket((FluidStack)new FluidStack((Fluid)FluidsRegistry.SLUDGE, 1000))), new MachineProduceWrapper((Block)BlockRegistry.waterCondensatorBlock, FluidUtil.getFilledBucket((FluidStack)new FluidStack(FluidRegistry.WATER, 1000))), new MachineProduceWrapper((Block)BlockRegistry.animalResourceHarvesterBlock, FluidUtil.getFilledBucket((FluidStack)new FluidStack((Fluid)FluidsRegistry.MILK, 1000))), new MachineProduceWrapper((Block)BlockRegistry.mobSlaughterFactoryBlock, FluidUtil.getFilledBucket((FluidStack)new FluidStack((Fluid)FluidsRegistry.MEAT, 1000))), new MachineProduceWrapper((Block)BlockRegistry.mobSlaughterFactoryBlock, FluidUtil.getFilledBucket((FluidStack)new FluidStack((Fluid)FluidsRegistry.PINK_SLIME, 1000))), new MachineProduceWrapper((Block)BlockRegistry.latexProcessingUnitBlock, new ItemStack((Item)ItemRegistry.tinyDryRubber)), new MachineProduceWrapper((Block)BlockRegistry.animalByproductRecolectorBlock, FluidUtil.getFilledBucket((FluidStack)new FluidStack((Fluid)FluidsRegistry.SEWAGE, 1000))), new MachineProduceWrapper((Block)BlockRegistry.lavaFabricatorBlock, FluidUtil.getFilledBucket((FluidStack)new FluidStack(FluidRegistry.LAVA, 1000))), new MachineProduceWrapper((Block)BlockRegistry.proteinReactorBlock, FluidUtil.getFilledBucket((FluidStack)new FluidStack((Fluid)FluidsRegistry.PROTEIN, 1000))), new MachineProduceWrapper((Block)BlockRegistry.frosterBlock, new ItemStack(Items.field_151126_ay)), new MachineProduceWrapper((Block)BlockRegistry.frosterBlock, new ItemStack(Blocks.field_150432_aD)), new MachineProduceWrapper((Block)BlockRegistry.frosterBlock, new ItemStack(Blocks.field_150403_cj))).filter(machineProduceWrapper -> ((CustomOrientedBlock)machineProduceWrapper.getBlock()).isEnabled()).collect(Collectors.toList()), this.machineProduceCategory.getUid());
        if (BlockRegistry.materialStoneWorkFactoryBlock.isEnabled()) {
            ArrayList<StoneWorkWrapper> perfectStoneWorkWrappers = new ArrayList<StoneWorkWrapper>();
            List<StoneWorkWrapper> wrappers = this.findAllStoneWorkOutputs(new ArrayList<MaterialStoneWorkFactoryTile.Mode>());
            for (StoneWorkWrapper workWrapper : new ArrayList<StoneWorkWrapper>(wrappers)) {
                if (!perfectStoneWorkWrappers.stream().noneMatch(stoneWorkWrapper -> workWrapper.getOutput().func_77969_a(stoneWorkWrapper.getOutput()))) continue;
                boolean isSomoneShorter = false;
                for (StoneWorkWrapper workWrapperCompare : new ArrayList<StoneWorkWrapper>(wrappers)) {
                    if (!workWrapper.getOutput().func_77969_a(workWrapperCompare.getOutput())) continue;
                    ArrayList<MaterialStoneWorkFactoryTile.Mode> workWrapperCompareModes = new ArrayList<MaterialStoneWorkFactoryTile.Mode>(workWrapperCompare.getModes());
                    workWrapperCompareModes.removeIf(mode -> mode == MaterialStoneWorkFactoryTile.Mode.NONE);
                    ArrayList<MaterialStoneWorkFactoryTile.Mode> workWrapperModes = new ArrayList<MaterialStoneWorkFactoryTile.Mode>(workWrapper.getModes());
                    workWrapperModes.removeIf(mode -> mode == MaterialStoneWorkFactoryTile.Mode.NONE);
                    if (workWrapperModes.size() <= workWrapperCompareModes.size()) continue;
                    isSomoneShorter = true;
                    break;
                }
                if (isSomoneShorter) continue;
                perfectStoneWorkWrappers.add(workWrapper);
            }
            registry.addRecipes(perfectStoneWorkWrappers, this.stoneWorkCategory.getUid());
            registry.addRecipeCatalyst((Object)new ItemStack((Block)BlockRegistry.materialStoneWorkFactoryBlock), new String[]{this.stoneWorkCategory.getUid()});
        }
        if (BlockRegistry.petrifiedFuelGeneratorBlock.isEnabled()) {
            ArrayList petrifiedBurnTimeWrappers = new ArrayList();
            registry.getIngredientRegistry().getFuels().stream().filter(PetrifiedFuelGeneratorTile::acceptsInputStack).forEach(stack -> petrifiedBurnTimeWrappers.add(new PetrifiedBurnTimeWrapper((ItemStack)stack, TileEntityFurnace.func_145952_a((ItemStack)stack))));
            registry.addRecipes(petrifiedBurnTimeWrappers, this.petrifiedBurnTimeCategory.getUid());
            registry.addRecipeCatalyst((Object)new ItemStack((Block)BlockRegistry.petrifiedFuelGeneratorBlock), new String[]{this.petrifiedBurnTimeCategory.getUid()});
        }
        if (CustomConfiguration.enableBookEntriesInJEI) {
            for (BookCategory category : BookCategory.values()) {
                registry.addRecipes((Collection)category.getEntries().values().stream().map(ManualWrapper::new).collect(Collectors.toList()), this.manualCategory.getUid());
            }
            registry.addRecipeCatalyst((Object)new ItemStack((Item)ItemRegistry.bookManualItem), new String[]{this.manualCategory.getUid()});
        }
        if (this.fluidDictionaryCategory != null) {
            registry.addRecipeCatalyst((Object)new ItemStack((Block)BlockRegistry.fluidDictionaryConverterBlock), new String[]{this.fluidDictionaryCategory.getUid()});
            registry.addRecipes((Collection)FluidDictionaryEntry.FLUID_DICTIONARY_RECIPES.stream().map(FluidDictionaryWrapper::new).collect(Collectors.toList()), this.fluidDictionaryCategory.getUid());
        }
        if (this.extractorRecipeCategory != null) {
            registry.addRecipeCatalyst((Object)new ItemStack((Block)BlockRegistry.treeFluidExtractorBlock), new String[]{this.extractorRecipeCategory.getUid()});
            registry.addRecipes((Collection)ExtractorEntry.EXTRACTOR_ENTRIES.stream().map(ExtractorRecipeWrapper::new).collect(Collectors.toList()), this.extractorRecipeCategory.getUid());
        }
        if (this.oreWasherCategory != null) {
            registry.addRecipeCatalyst((Object)new ItemStack((Block)BlockRegistry.oreWasherBlock), new String[]{this.oreWasherCategory.getUid()});
            registry.addRecipes((Collection)OreFluidEntryRaw.ORE_RAW_ENTRIES.stream().map(OreWasherWrapper::new).collect(Collectors.toList()), this.oreWasherCategory.getUid());
        }
        if (this.oreFermenterCategory != null) {
            registry.addRecipeCatalyst((Object)new ItemStack((Block)BlockRegistry.oreFermenterBlock), new String[]{this.oreFermenterCategory.getUid()});
            registry.addRecipes((Collection)OreFluidEntryFermenter.ORE_FLUID_FERMENTER.stream().map(OreFermenterWrapper::new).collect(Collectors.toList()), this.oreFermenterCategory.getUid());
        }
        if (this.oreSieveCategory != null) {
            registry.addRecipeCatalyst((Object)new ItemStack((Block)BlockRegistry.oreSieveBlock), new String[]{this.oreSieveCategory.getUid()});
            registry.addRecipes((Collection)OreFluidEntrySieve.ORE_FLUID_SIEVE.stream().map(OreSieveWrapper::new).collect(Collectors.toList()), this.oreSieveCategory.getUid());
        }
        registry.addGhostIngredientHandler(GuiConveyor.class, (IGhostIngredientHandler)new ConveyorGhostSlotHandler());
    }

    public ItemStack getStoneWorkOutputFrom(ItemStack stack, MaterialStoneWorkFactoryTile.Mode mode) {
        if (mode == MaterialStoneWorkFactoryTile.Mode.FURNACE) {
            return FurnaceRecipes.func_77602_a().func_151395_a(stack).func_77946_l();
        }
        if (mode == MaterialStoneWorkFactoryTile.Mode.CRAFT_BIG || mode == MaterialStoneWorkFactoryTile.Mode.CRAFT_SMALL) {
            return CraftingUtils.findOutput(mode == MaterialStoneWorkFactoryTile.Mode.CRAFT_BIG ? 3 : 2, stack, null);
        }
        if (mode == MaterialStoneWorkFactoryTile.Mode.GRIND) {
            return CraftingUtils.getCrushOutput(stack);
        }
        return ItemStack.field_190927_a;
    }

    public ItemStack getStoneWorkOutputFrom(List<MaterialStoneWorkFactoryTile.Mode> modes) {
        ItemStack stack = new ItemStack(Blocks.field_150347_e);
        for (MaterialStoneWorkFactoryTile.Mode mode : modes) {
            if (mode == MaterialStoneWorkFactoryTile.Mode.NONE || !(stack = this.getStoneWorkOutputFrom(stack.func_77946_l(), mode)).func_190926_b()) continue;
            return ItemStack.field_190927_a;
        }
        return stack;
    }

    public List<StoneWorkWrapper> findAllStoneWorkOutputs(List<MaterialStoneWorkFactoryTile.Mode> usedModes) {
        ArrayList<StoneWorkWrapper> wrappers = new ArrayList<StoneWorkWrapper>();
        if (usedModes.size() >= 4) {
            return wrappers;
        }
        for (MaterialStoneWorkFactoryTile.Mode mode : MaterialStoneWorkFactoryTile.Mode.values()) {
            if (mode == MaterialStoneWorkFactoryTile.Mode.NONE) continue;
            ArrayList<MaterialStoneWorkFactoryTile.Mode> usedModesInternal = new ArrayList<MaterialStoneWorkFactoryTile.Mode>(usedModes);
            usedModesInternal.add(mode);
            ItemStack output = this.getStoneWorkOutputFrom(new ArrayList<MaterialStoneWorkFactoryTile.Mode>(usedModesInternal));
            if (output.func_190926_b()) continue;
            wrappers.add(new StoneWorkWrapper(new ArrayList<MaterialStoneWorkFactoryTile.Mode>(usedModesInternal), output.func_77946_l()));
            wrappers.addAll(this.findAllStoneWorkOutputs(new ArrayList<MaterialStoneWorkFactoryTile.Mode>(usedModesInternal)));
        }
        return wrappers;
    }

    public void onRuntimeAvailable(IJeiRuntime jeiRuntime) {
        recipesGui = jeiRuntime.getRecipesGui();
        recipeRegistry = jeiRuntime.getRecipeRegistry();
    }
}

