/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.infinitylib.proxy;

import com.infinityraider.infinitylib.InfinityMod;
import com.infinityraider.infinitylib.block.IInfinityBlock;
import com.infinityraider.infinitylib.block.IInfinityBlockWithTile;
import com.infinityraider.infinitylib.config.InfinityConfigurationHandler;
import com.infinityraider.infinitylib.entity.EntityRegistryEntry;
import com.infinityraider.infinitylib.item.IInfinityItem;
import com.infinityraider.infinitylib.modules.Module;
import com.infinityraider.infinitylib.proxy.base.IProxyBase;
import com.infinityraider.infinitylib.sound.SidedSoundDelegate;
import com.infinityraider.infinitylib.sound.SoundDelegateServer;
import com.infinityraider.infinitylib.utility.IRecipeRegisterer;
import com.infinityraider.infinitylib.utility.ReflectionHelper;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.VillagerRegistry;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public interface IProxy
extends IProxyBase {
    default public void registerRegistries(InfinityMod mod, RegistryEvent.NewRegistry registrar) {
    }

    default public void registerBlocks(InfinityMod mod, IForgeRegistry<Block> registry) {
        if (mod.getModBlockRegistry() != null) {
            ReflectionHelper.forEachValueIn(mod.getModBlockRegistry(), IInfinityBlock.class, block -> {
                if (block instanceof Block && block.isEnabled()) {
                    mod.getLogger().debug("Registering Block: " + block.getInternalName(), new Object[0]);
                    String unlocalized = mod.getModId().toLowerCase() + ':' + block.getInternalName();
                    ((Block)block).func_149663_c(unlocalized);
                    this.register(mod, registry, (Block)block, block.getInternalName());
                    for (String tag : block.getOreTags()) {
                        OreDictionary.registerOre((String)tag, (Block)((Block)block));
                    }
                }
            });
            ReflectionHelper.forEachValueIn(mod.getModBlockRegistry(), IInfinityBlockWithTile.class, block -> {
                if (block.isEnabled()) {
                    mod.getLogger().debug("Registering Tile for Block: " + block.getInternalName(), new Object[0]);
                    Object te = block.func_149915_a(null, 0);
                    if (!1.$assertionsDisabled && te == null) {
                        throw new AssertionError();
                    }
                    GameRegistry.registerTileEntity(te.getClass(), (String)(mod.getModId().toLowerCase() + ":tile." + block.getInternalName()));
                }
            });
        }
    }

    default public void registerItems(InfinityMod mod, IForgeRegistry<Item> registry) {
        if (mod.getModBlockRegistry() != null) {
            ReflectionHelper.forEachValueIn(mod.getModBlockRegistry(), IInfinityBlock.class, block -> {
                if (block.isEnabled()) {
                    block.getItemBlock().ifPresent(item -> {
                        mod.getLogger().debug("Registering ItemBlock: " + block.getInternalName(), new Object[0]);
                        String unlocalized = mod.getModId().toLowerCase() + ":" + block.getInternalName();
                        item.func_77655_b(unlocalized);
                        this.register(mod, registry, item, block.getInternalName());
                    });
                }
            });
        }
        if (mod.getModItemRegistry() != null) {
            ReflectionHelper.forEachValueIn(mod.getModItemRegistry(), IInfinityItem.class, item -> {
                if (item instanceof Item && item.isEnabled()) {
                    mod.getLogger().debug("Registering Item: " + item.getInternalName(), new Object[0]);
                    String unlocalized = mod.getModId().toLowerCase() + ':' + item.getInternalName();
                    ((Item)item).func_77655_b(unlocalized);
                    this.register(mod, registry, (Item)item, item.getInternalName());
                    for (String tag : item.getOreTags()) {
                        OreDictionary.registerOre((String)tag, (Item)((Item)item));
                    }
                }
            });
        }
    }

    default public void registerRecipes(InfinityMod mod, IForgeRegistry<IRecipe> registry) {
        if (mod.getModBlockRegistry() != null) {
            ReflectionHelper.forEachValueIn(mod.getModBlockRegistry(), IRecipeRegisterer.class, r -> r.registerRecipes(registry));
        }
        if (mod.getModItemRegistry() != null) {
            ReflectionHelper.forEachValueIn(mod.getModItemRegistry(), IRecipeRegisterer.class, r -> r.registerRecipes(registry));
        }
    }

    default public void registerBiomes(InfinityMod mod, IForgeRegistry<Biome> registry) {
        if (mod.getModBiomeRegistry() != null) {
            ReflectionHelper.forEachValueIn(mod.getModBiomeRegistry(), Biome.class, biome -> this.register(mod, registry, biome, biome.func_185359_l()));
        }
    }

    default public void registerEnchantments(InfinityMod mod, IForgeRegistry<Enchantment> registry) {
        if (mod.getModEnchantmentRegistry() != null) {
            ReflectionHelper.forEachValueIn(mod.getModEnchantmentRegistry(), Enchantment.class, enchantment -> this.register(mod, registry, enchantment, enchantment.func_77320_a()));
        }
    }

    default public void registerEntities(InfinityMod mod, IForgeRegistry<EntityEntry> registry) {
        if (mod.getModEntityRegistry() != null) {
            ReflectionHelper.forEachValueIn(mod.getModEntityRegistry(), EntityRegistryEntry.class, entry -> {
                if (entry.isEnabled()) {
                    entry.register(mod, registry);
                }
            });
        }
    }

    default public void registerPotions(InfinityMod mod, IForgeRegistry<Potion> registry) {
        if (mod.getModPotionRegistry() != null) {
            ReflectionHelper.forEachValueIn(mod.getModPotionRegistry(), Potion.class, potion -> this.register(mod, registry, potion, potion.func_76393_a()));
        }
    }

    default public void registerPotionTypes(InfinityMod mod, IForgeRegistry<PotionType> registry) {
        if (mod.getModPotionTypeRegistry() != null) {
            ReflectionHelper.forEachValueIn(mod.getModPotionTypeRegistry(), PotionType.class, type -> this.register(mod, registry, type, type.func_185174_b("type")));
        }
    }

    default public void registerSounds(InfinityMod mod, IForgeRegistry<SoundEvent> registry) {
        if (mod.getModSoundRegistry() != null) {
            ReflectionHelper.forEachValueIn(mod.getModSoundRegistry(), SoundEvent.class, sound -> this.register(mod, registry, sound, sound.func_187503_a().func_110623_a()));
        }
    }

    default public void registerVillagerProfessions(InfinityMod mod, IForgeRegistry<VillagerRegistry.VillagerProfession> registry) {
        if (mod.getModVillagerProfessionRegistry() != null) {
            ReflectionHelper.forEachValueIn(mod.getModVillagerProfessionRegistry(), VillagerRegistry.VillagerProfession.class, profession -> this.register(mod, registry, profession, profession.toString()));
        }
    }

    default public <T extends IForgeRegistryEntry<T>> void register(InfinityMod mod, IForgeRegistry<T> registry, T object, String name) {
        object.setRegistryName(new ResourceLocation(mod.getModId().toLowerCase(), name.toLowerCase()));
        registry.register(object);
    }

    @Override
    default public void initEnd(FMLInitializationEvent event) {
        Module.getActiveModules().forEach(Module::init);
    }

    @Override
    default public void postInitEnd(FMLPostInitializationEvent event) {
        Module.getActiveModules().forEach(Module::postInit);
    }

    default public void initModConfiguration(InfinityConfigurationHandler handler) {
        handler.initializeConfiguration();
    }

    default public SidedSoundDelegate getSoundDelegate() {
        return new SoundDelegateServer();
    }

    @Override
    default public void registerEventHandlers() {
        for (Module module : Module.getActiveModules()) {
            module.getCommonEventHandlers().forEach(this::registerEventHandler);
        }
    }

    @Override
    default public void registerCapabilities() {
        for (Module module : Module.getActiveModules()) {
            module.getCapabilities().forEach(this::registerCapability);
        }
    }

    @Override
    default public void activateRequiredModules() {
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }
}

