/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.infinitylib.utility;

import com.infinityraider.infinitylib.InfinityMod;
import com.infinityraider.infinitylib.config.ModConfiguration;
import java.text.MessageFormat;
import net.minecraftforge.fml.common.FMLLog;
import org.apache.logging.log4j.Level;

public class InfinityLogger {
    private final InfinityMod mod;

    public InfinityLogger(InfinityMod mod) {
        this.mod = mod;
    }

    public void log(Level logLevel, String format, Object ... objects) {
        try {
            FMLLog.log((String)this.mod.getModId(), (Level)logLevel, (String)MessageFormat.format(format, objects), (Object[])new Object[0]);
        }
        catch (IllegalArgumentException ex) {
            FMLLog.log((String)this.mod.getModId(), (Level)logLevel, (String)format, (Object[])new Object[0]);
        }
    }

    public void all(String format, Object ... objects) {
        this.log(Level.ALL, format, objects);
    }

    public void debug(String format, Object ... objects) {
        if (ModConfiguration.getInstance().debug()) {
            this.log(Level.INFO, "[DEBUG]: " + format, objects);
        }
    }

    public void error(String format, Object ... objects) {
        this.log(Level.ERROR, format, objects);
    }

    public void fatal(String format, Object ... objects) {
        this.log(Level.FATAL, format, objects);
    }

    public void info(String format, Object ... objects) {
        this.log(Level.INFO, format, objects);
    }

    public void off(String format, Object ... objects) {
        this.log(Level.OFF, format, objects);
    }

    public void trace(String format, Object ... objects) {
        this.log(Level.TRACE, format, objects);
    }

    public void warn(String format, Object ... objects) {
        this.log(Level.WARN, format, objects);
    }

    public void printStackTrace(Exception e) {
        if (ModConfiguration.getInstance().debug()) {
            e.printStackTrace();
        }
    }
}

