/*
 * Decompiled with CFR 0.152.
 */
package sblectric.lightningcraft.integration.jei.crusher;

import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IDrawableAnimated;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.BlankRecipeCategory;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.translation.I18n;
import sblectric.lightningcraft.integration.jei.crusher.LightningCrusherRecipeWrapper;

public class LightningCrusherRecipeCategory
extends BlankRecipeCategory {
    public static final String UID = "lightningcraft.crusher_recipe_category";
    public static final String NAME = I18n.func_74838_a((String)"lightningcraft.crusher_recipe_category");
    private static final int INPUT = 0;
    private static final int OUTPUT = 1;
    public static final ResourceLocation location = new ResourceLocation("lightningcraft", "textures/gui/container/lpfurnace.png");
    private IDrawable background;
    private IDrawableAnimated flame;
    private IDrawableAnimated arrow;

    public LightningCrusherRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(location, 55, 16, 82, 54);
        IDrawableStatic flameDrawable = guiHelper.createDrawable(location, 176, 0, 14, 14);
        this.flame = guiHelper.createAnimatedDrawable(flameDrawable, 160, IDrawableAnimated.StartDirection.TOP, true);
        IDrawableStatic arrowDrawable = guiHelper.createDrawable(location, 176, 14, 24, 17);
        this.arrow = guiHelper.createAnimatedDrawable(arrowDrawable, 80, IDrawableAnimated.StartDirection.LEFT, false);
    }

    public String getUid() {
        return UID;
    }

    public String getTitle() {
        return NAME;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public void drawExtras(Minecraft minecraft) {
        this.flame.draw(minecraft, 2, 20);
        this.arrow.draw(minecraft, 24, 18);
    }

    public void setRecipe(IRecipeLayout recipeLayout, IRecipeWrapper recipeWrapper, IIngredients ingredients) {
        IGuiItemStackGroup stacks = recipeLayout.getItemStacks();
        stacks.init(0, true, 0, 0);
        stacks.init(1, false, 60, 18);
        if (recipeWrapper instanceof LightningCrusherRecipeWrapper) {
            LightningCrusherRecipeWrapper lirWrapper = (LightningCrusherRecipeWrapper)recipeWrapper;
            stacks.set(0, lirWrapper.getInputs());
            stacks.set(1, lirWrapper.getOutputs());
        }
    }

    public String getModName() {
        return "LightningCraft";
    }
}

