/*
 * Decompiled with CFR 0.152.
 */
package sblectric.lightningcraft.integration.tconstruct;

import java.util.List;
import net.minecraftforge.fluids.Fluid;
import sblectric.lightningcraft.api.util.JointList;
import sblectric.lightningcraft.config.LCConfig;
import sblectric.lightningcraft.init.LCFluids;
import sblectric.lightningcraft.integration.tconstruct.TraitLightning;
import sblectric.lightningcraft.integration.tconstruct.TraitRepair;
import sblectric.lightningcraft.ref.Log;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.materials.ExtraMaterialStats;
import slimeknights.tconstruct.library.materials.HandleMaterialStats;
import slimeknights.tconstruct.library.materials.HeadMaterialStats;
import slimeknights.tconstruct.library.materials.IMaterialStats;
import slimeknights.tconstruct.library.materials.Material;
import slimeknights.tconstruct.library.traits.AbstractTrait;
import slimeknights.tconstruct.library.traits.ITrait;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;
import slimeknights.tconstruct.tools.traits.TraitAutosmelt;

public class ToolIntegration {
    private static List<Material> matList;
    public static Material electricium;
    public static Material skyfather;
    public static Material mystic;
    public static AbstractTrait lightning1;
    public static AbstractTrait lightning2;
    public static AbstractTrait repairTrait;

    public static void mainRegistry() {
        matList = new JointList<Material>();
        ToolIntegration.addMaterials();
    }

    private static void addMaterials() {
        Class<?> traitHolder = null;
        try {
            traitHolder = Class.forName("slimeknights.tconstruct.tools.TinkerTraits");
        }
        catch (ClassNotFoundException e1) {
            try {
                traitHolder = Class.forName("slimeknights.tconstruct.tools.TinkerMaterials");
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        AbstractTrait autosmelt = null;
        try {
            autosmelt = (AbstractTrait)traitHolder.getField("autosmelt").get(null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (autosmelt != null) {
            electricium = ToolIntegration.addMaterial("electricium", LCFluids.moltenElectricium, "Electricium", lightning1);
            skyfather = ToolIntegration.addMaterial("skyfather", LCFluids.moltenSkyfather, "Skyfather", lightning2, autosmelt);
            mystic = ToolIntegration.addMaterial("mystic", LCFluids.moltenMystic, "Mystic", lightning2, autosmelt, repairTrait);
            TinkerRegistry.addMaterialStats((Material)electricium, (IMaterialStats)new HeadMaterialStats(800, 8.0f, 7.0f, 4), (IMaterialStats[])new IMaterialStats[]{new HandleMaterialStats(0.9f, 50), new ExtraMaterialStats(100)});
            TinkerRegistry.addMaterialStats((Material)skyfather, (IMaterialStats)new HeadMaterialStats(1000, 12.0f, 9.0f, 5), (IMaterialStats[])new IMaterialStats[]{new HandleMaterialStats(0.9f, 60), new ExtraMaterialStats(100)});
            TinkerRegistry.addMaterialStats((Material)mystic, (IMaterialStats)new HeadMaterialStats(1200, 15.0f, 11.0f, 6), (IMaterialStats[])new IMaterialStats[]{new HandleMaterialStats(0.9f, 70), new ExtraMaterialStats(100)});
        } else {
            Log.logger.error("Unable to find Tinker's Construct trait class, aborting tool integration.");
        }
    }

    private static Material addMaterial(String name, Fluid fluid, String oreSuffix, AbstractTrait ... traits) {
        Material mat = new Material(name, fluid.getColor());
        mat.setFluid(fluid);
        mat.addCommonItems(oreSuffix);
        mat.setCraftable(false);
        mat.setCastable(true);
        for (AbstractTrait t : traits) {
            if (t instanceof TraitAutosmelt && !LCConfig.autoSmelt || t instanceof TraitRepair && !LCConfig.autoRepair) continue;
            mat.addTrait((ITrait)t);
        }
        TinkerRegistry.addMaterial((Material)mat);
        matList.add(mat);
        return mat;
    }

    public static void registerMaterials() {
        for (Material m : matList) {
            TinkerSmeltery.registerToolpartMeltingCasting((Material)m);
        }
    }

    static {
        lightning1 = new TraitLightning(1);
        lightning2 = new TraitLightning(2);
        repairTrait = new TraitRepair();
    }
}

