/*
 * Decompiled with CFR 0.152.
 */
package sblectric.lightningcraft.items;

import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import sblectric.lightningcraft.api.capabilities.ILightningUpgradable;
import sblectric.lightningcraft.blocks.PortalUnderworld;
import sblectric.lightningcraft.config.LCConfig;
import sblectric.lightningcraft.init.LCCapabilities;
import sblectric.lightningcraft.init.LCNetwork;
import sblectric.lightningcraft.items.base.ItemMeta;
import sblectric.lightningcraft.network.MessageLightningUpgrade;
import sblectric.lightningcraft.ref.LCText;
import sblectric.lightningcraft.util.Effect;

public class ItemMaterial
extends ItemMeta {
    public ItemMaterial() {
        super(15, false, new boolean[0]);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List list, ITooltipFlag flag) {
        switch (stack.func_77952_i()) {
            case 5: {
                list.add(LCText.getDemonBloodLore());
                break;
            }
            case 6: {
                list.add(LCText.getUnderworldChargeLore());
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public EnumRarity func_77613_e(ItemStack stack) {
        int type = stack.func_77952_i();
        if (type == 11 || type == 14) {
            return EnumRarity.EPIC;
        }
        if (type >= 5) {
            return EnumRarity.RARE;
        }
        return EnumRarity.COMMON;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        int i = stack.func_77952_i();
        return i == 0 || i == 9 || i == 11 || i == 14;
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        switch (stack.func_77952_i()) {
            case 4: {
                TileEntity tile = world.func_175625_s(pos);
                if (LCConfig.upgradeEnabled && tile != null && tile.hasCapability(LCCapabilities.LIGHTNING_UPGRADABLE, null) && !((ILightningUpgradable)tile.getCapability(LCCapabilities.LIGHTNING_UPGRADABLE, null)).isUpgraded()) {
                    EnumActionResult r = ((ILightningUpgradable)tile.getCapability(LCCapabilities.LIGHTNING_UPGRADABLE, null)).onLightningUpgrade(stack, player, world, pos, hand, facing, hitX, hitY, hitZ);
                    if (r == EnumActionResult.SUCCESS && !world.field_72995_K) {
                        stack.func_190920_e(stack.func_190916_E() - 1);
                        tile.func_70296_d();
                        LCNetwork.net.sendToAllAround((IMessage)new MessageLightningUpgrade(pos), new NetworkRegistry.TargetPoint(world.field_73011_w.getDimension(), (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 1024.0));
                    }
                    return r;
                }
                return EnumActionResult.FAIL;
            }
            case 6: {
                if (!world.field_72995_K && PortalUnderworld.ignitePortal(world, pos.func_177984_a())) {
                    if (!player.field_71075_bZ.field_75098_d) {
                        stack.func_190920_e(stack.func_190916_E() - 1);
                    }
                    Effect.lightning(world, pos.func_177958_n(), pos.func_177956_o() + 1, pos.func_177952_p());
                    if (stack.func_190916_E() <= 0) {
                        stack = ItemStack.field_190927_a;
                    }
                }
                return EnumActionResult.SUCCESS;
            }
        }
        return super.func_180614_a(player, world, pos, hand, facing, hitX, hitY, hitZ);
    }
}

