/*
 * Decompiled with CFR 0.152.
 */
package sblectric.lightningcraft.tiles;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntityHopper;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.event.ForgeEventFactory;
import sblectric.lightningcraft.api.util.StackHelper;
import sblectric.lightningcraft.config.LCConfig;
import sblectric.lightningcraft.tiles.TileEntityLightningItemHandler;
import sblectric.lightningcraft.util.LCMisc;

public class TileEntityLightningMiner
extends TileEntityLightningItemHandler.Upgradable {
    public static final int nStacks = 9;
    public static final int[] stacksInt = StackHelper.makeIntArray(9);
    public static final int rangeStock = 16;
    public static final int rangeUpgraded = 24;
    public static final int breakModTime = 20;
    private static final int maxRetryFactor = 11;
    private static Block[] fillerBlocks = LCMisc.getBlocksFromRegs(LCConfig.minerFillerBlocks);
    public EnumMode mode = EnumMode.access$000();
    public boolean replaceBlocks = true;
    private int retries = 0;

    public TileEntityLightningMiner() {
        this.setSizeInventory(9);
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K && this.field_145850_b.func_82737_E() % 20L == 0L) {
            this.doOperation();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void doOperation() {
        boolean flag;
        BlockPos find;
        block7: {
            int n;
            int[] nArray;
            ItemStack stack;
            block10: {
                block9: {
                    Block block;
                    IBlockState state;
                    block8: {
                        block6: {
                            if (!this.hasLPCell()) return;
                            if (!this.canDrawCellPower(this.mode.cost)) return;
                            if (this.field_145850_b.func_175640_z(this.field_174879_c)) return;
                            int effectiveRange = this.getEffectiveRange();
                            EnumFacing face = EnumFacing.func_82600_a((int)this.func_145832_p());
                            BlockPos initial = this.field_174879_c.func_177967_a(face, this.random.nextInt(effectiveRange) + 1);
                            switch (this.mode) {
                                case NONE: {
                                    return;
                                }
                                case SHAFT: {
                                    this.mineBlock(initial);
                                    return;
                                }
                            }
                            int width = this.mode == EnumMode.TUNNEL ? 2 : effectiveRange;
                            int rad = width / 2;
                            EnumFacing.Axis mineAxis = face.func_176740_k();
                            find = initial;
                            for (EnumFacing.Axis a : EnumFacing.Axis.values()) {
                                if (a == mineAxis) continue;
                                find = find.func_177967_a(face.func_176732_a(a), this.random.nextInt(width + 1) - rad);
                            }
                            state = this.field_145850_b.func_180495_p(find);
                            block = state == null ? null : state.func_177230_c();
                            flag = false;
                            if (this.mode != EnumMode.ORES) break block6;
                            if (block == null || Item.func_150898_a((Block)block) == null || ((stack = new ItemStack(block, 1, block.func_176201_c(state))).func_190926_b() || !stack.func_77977_a().toLowerCase().contains("ore")) && !StackHelper.oreDictNameStartsWith(stack, "ore")) break block7;
                            flag = true;
                            break block7;
                        }
                        if (this.mode != EnumMode.LOGS) break block8;
                        if (block == null || Item.func_150898_a((Block)block) == null || (stack = new ItemStack(block, 1, block.func_176201_c(state))).func_190926_b() || !StackHelper.oreDictNameStartsWith(stack, "log")) break block7;
                        flag = true;
                        break block7;
                    }
                    if (this.mode != EnumMode.MATCHING) break block9;
                    if (block == null || Item.func_150898_a((Block)block) == null) break block7;
                    stack = new ItemStack(block, 1, block.func_176201_c(state));
                    nArray = stacksInt;
                    n = nArray.length;
                    break block10;
                }
                flag = true;
                break block7;
            }
            for (int i = 0; i < n; ++i) {
                int slot = nArray[i];
                if (!StackHelper.areItemStacksEqualForCrafting(this.func_70301_a(slot), stack)) continue;
                flag = true;
                break;
            }
        }
        this.mineBlock(find, flag);
    }

    private boolean mineBlock(BlockPos minePos) {
        return this.mineBlock(minePos, true);
    }

    private boolean mineBlock(BlockPos minePos, boolean cond) {
        EnumFacing face = EnumFacing.func_82600_a((int)this.func_145832_p());
        IBlockState mineState = this.field_145850_b.func_180495_p(minePos);
        Block mineBlock = mineState.func_177230_c();
        if (cond && mineBlock != null && !mineBlock.isAir(mineState, (IBlockAccess)this.field_145850_b, minePos) && mineState.func_185887_b(this.field_145850_b, minePos) >= 0.0f) {
            List drops = mineBlock.getDrops((IBlockAccess)this.field_145850_b, minePos, mineState, 0);
            float chance = ForgeEventFactory.fireBlockHarvesting((List)drops, (World)this.field_145850_b, (BlockPos)minePos, (IBlockState)this.field_145850_b.func_180495_p(minePos), (int)0, (float)1.0f, (boolean)false, null);
            if (this.random.nextFloat() <= chance) {
                boolean flag = false;
                if (this.replaceBlocks) {
                    if (!LCMisc.inArray(mineBlock, fillerBlocks)) {
                        for (int slot : stacksInt) {
                            Block block;
                            ItemStack s = this.func_70301_a(slot);
                            if (s.func_190926_b() || (block = Block.func_149634_a((Item)s.func_77973_b())) == null || s.func_77952_i() != 0 || !LCMisc.inArray(block, fillerBlocks)) continue;
                            s.func_190920_e(s.func_190916_E() - 1);
                            if (s.func_190916_E() <= 0) {
                                this.func_70299_a(slot, null);
                            }
                            this.field_145850_b.func_180501_a(minePos, block.func_176223_P(), 3);
                            flag = true;
                        }
                    }
                } else {
                    this.field_145850_b.func_175698_g(minePos);
                    flag = true;
                }
                if (flag) {
                    this.field_145850_b.func_175718_b(2001, minePos, Block.func_176210_f((IBlockState)mineState));
                    this.drawCellPower(this.mode.cost);
                    Object object = drops.iterator();
                    while (object.hasNext()) {
                        ItemStack drop = (ItemStack)object.next();
                        ItemStack leftover = TileEntityHopper.func_174918_a((IInventory)this, (IInventory)this, (ItemStack)drop, (EnumFacing)face);
                        if (leftover.func_190926_b()) continue;
                        Block.func_180635_a((World)this.field_145850_b, (BlockPos)this.field_174879_c, (ItemStack)leftover);
                    }
                    this.retries = 0;
                    this.func_70296_d();
                    return true;
                }
            }
        }
        this.rescheduleOperation();
        return false;
    }

    public int getEffectiveRange() {
        return this.isUpgraded() ? 24 : 16;
    }

    private int getNumRetries() {
        return Math.min(LCConfig.minerMaxRetries, this.getEffectiveRange() * 11);
    }

    public void rescheduleOperation() {
        ++this.retries;
        if (this.retries > this.getNumRetries()) {
            this.retries = 0;
        }
        if (this.retries < this.getNumRetries()) {
            ((WorldServer)this.field_145850_b).func_152344_a(() -> this.doOperation());
        }
    }

    public void rotateOperatingMode() {
        this.mode = EnumMode.assignMode((this.mode.id + 1) % EnumMode.values().length);
        this.func_70296_d();
    }

    public void toggleBlockReplacement() {
        this.replaceBlocks = !this.replaceBlocks;
        this.func_70296_d();
    }

    @Override
    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.mode = EnumMode.assignMode(tagCompound.func_74762_e("operatingMode"));
        this.replaceBlocks = tagCompound.func_74767_n("replaceBlocks");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        super.func_189515_b(tagCompound);
        tagCompound.func_74768_a("operatingMode", this.mode.id);
        tagCompound.func_74757_a("replaceBlocks", this.replaceBlocks);
        return tagCompound;
    }

    public boolean func_94041_b(int par1, ItemStack itemstack) {
        return true;
    }

    public int[] func_180463_a(EnumFacing facing) {
        return stacksInt;
    }

    public boolean func_180462_a(int par1, ItemStack itemstack, EnumFacing facing) {
        return true;
    }

    public boolean func_180461_b(int par1, ItemStack itemstack, EnumFacing facing) {
        return true;
    }

    public static enum EnumMode {
        NONE(0, "Disabled", 0.0),
        SHAFT(1, "1x1 Tunnel", 0.5),
        TUNNEL(2, "3x3 Tunnel", 0.8),
        ORES(3, "Seek Ores", 1.5),
        LOGS(4, "Seek Logs", 1.3),
        MATCHING(5, "Slot Matching", 1.8),
        ALL(6, "All in Range", 1.2);

        private static EnumMode DEFAULT;
        private int id;
        private String name;
        private double cost;

        private EnumMode(int id, String name, double cost) {
            this.id = id;
            this.name = name;
            this.cost = cost;
        }

        public String getName() {
            return this.name;
        }

        public int getID() {
            return this.id;
        }

        public double getCost() {
            return this.cost;
        }

        public static EnumMode assignMode(int id) {
            for (EnumMode m : EnumMode.values()) {
                if (m.id != id) continue;
                return m;
            }
            return DEFAULT;
        }

        static /* synthetic */ EnumMode access$000() {
            return DEFAULT;
        }

        static {
            DEFAULT = NONE;
        }
    }
}

