/*
 * Decompiled with CFR 0.152.
 */
package sblectric.lightningcraft.tiles;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import sblectric.lightningcraft.tiles.TileEntityBase;
import sblectric.lightningcraft.tiles.TileEntityLightningTransmitter;

public class TileEntityLightningReceiver
extends TileEntityBase {
    public TileEntityLightningTransmitter tx;
    public BlockPos txPos = new BlockPos(0, -2, 0);
    public double rolloff;
    public double efficiency;
    public double storedPower;
    public double maxPower;
    public boolean outOfRange;

    public TileEntityLightningReceiver(double rolloff) {
        this.rolloff = rolloff;
    }

    public TileEntityLightningReceiver() {
        this(0.0);
    }

    public String getName() {
        return "Lightning Receiver";
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            TileEntity tile;
            int txX = this.txPos.func_177958_n();
            int txY = this.txPos.func_177956_o();
            int txZ = this.txPos.func_177952_p();
            boolean hasTx = true;
            this.outOfRange = false;
            if (txY >= 0 && (tile = this.field_145850_b.func_175625_s(this.txPos)) != null && tile instanceof TileEntityLightningTransmitter) {
                this.tx = (TileEntityLightningTransmitter)tile;
                double distanceSq = this.tx.func_145835_a(this.getX(), this.getY(), this.getZ());
                if (distanceSq <= this.tx.range * this.tx.range) {
                    if (this.tx.hasLPCell()) {
                        this.storedPower = this.tx.cellPower;
                        this.maxPower = this.tx.maxPower;
                        this.efficiency = this.tx.quality - distanceSq * this.rolloff;
                    } else {
                        hasTx = false;
                    }
                } else {
                    hasTx = false;
                    this.outOfRange = true;
                }
            } else {
                hasTx = false;
            }
            if (!hasTx) {
                this.storedPower = 0.0;
                this.maxPower = -1.0;
                this.efficiency = -1.0;
            }
        }
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        int x = tagCompound.func_74762_e("TransmitterX");
        int y = tagCompound.func_74762_e("TransmitterY");
        int z = tagCompound.func_74762_e("TransmitterZ");
        this.txPos = new BlockPos(x, y, z);
        this.storedPower = tagCompound.func_74769_h("StoredPower");
        this.maxPower = tagCompound.func_74769_h("MaxPower");
        this.rolloff = tagCompound.func_74769_h("Rolloff");
        this.efficiency = tagCompound.func_74769_h("Efficiency");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        super.func_189515_b(tagCompound);
        tagCompound.func_74780_a("TransmitterX", (double)this.txPos.func_177958_n());
        tagCompound.func_74780_a("TransmitterY", (double)this.txPos.func_177956_o());
        tagCompound.func_74780_a("TransmitterZ", (double)this.txPos.func_177952_p());
        tagCompound.func_74780_a("StoredPower", this.storedPower);
        tagCompound.func_74780_a("MaxPower", this.maxPower);
        tagCompound.func_74780_a("Rolloff", this.rolloff);
        tagCompound.func_74780_a("Efficiency", this.efficiency);
        return tagCompound;
    }
}

