/*
 * Decompiled with CFR 0.152.
 */
package sblectric.lightningcraft.util;

import net.darkhax.tesla.api.ITeslaConsumer;
import net.darkhax.tesla.api.ITeslaHolder;
import net.darkhax.tesla.api.ITeslaProducer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.common.Optional;

@Optional.InterfaceList(value={@Optional.Interface(iface="net.darkhax.tesla.api.ITeslaConsumer", modid="tesla"), @Optional.Interface(iface="net.darkhax.tesla.api.ITeslaProducer", modid="tesla"), @Optional.Interface(iface="net.darkhax.tesla.api.ITeslaHolder", modid="tesla")})
public class EnergyStorage
implements ITeslaConsumer,
ITeslaProducer,
ITeslaHolder,
IEnergyStorage {
    protected int energy;
    protected int capacity;
    protected int maxReceive;
    protected int maxExtract;

    public EnergyStorage(int capacity) {
        this(capacity, capacity, capacity);
    }

    public EnergyStorage(int capacity, int maxTransfer) {
        this(capacity, maxTransfer, maxTransfer);
    }

    public EnergyStorage(int capacity, int maxReceive, int maxExtract) {
        this.capacity = capacity;
        this.maxReceive = maxReceive;
        this.maxExtract = maxExtract;
    }

    public EnergyStorage readFromNBT(NBTTagCompound nbt) {
        this.energy = nbt.func_74762_e("storedRF");
        if (this.energy > this.capacity) {
            this.energy = this.capacity;
        }
        return this;
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        if (this.energy < 0) {
            this.energy = 0;
        }
        nbt.func_74768_a("storedRF", this.energy);
        return nbt;
    }

    public EnergyStorage setCapacity(int capacity) {
        this.capacity = capacity;
        if (this.energy > capacity) {
            this.energy = capacity;
        }
        return this;
    }

    public EnergyStorage setMaxTransfer(int maxTransfer) {
        this.setMaxReceive(maxTransfer);
        this.setMaxExtract(maxTransfer);
        return this;
    }

    public EnergyStorage setMaxReceive(int maxReceive) {
        this.maxReceive = maxReceive;
        return this;
    }

    public EnergyStorage setMaxExtract(int maxExtract) {
        this.maxExtract = maxExtract;
        return this;
    }

    public int getMaxReceive() {
        return this.maxReceive;
    }

    public int getMaxExtract() {
        return this.maxExtract;
    }

    public void setEnergyStored(int energy) {
        this.energy = energy;
        if (this.energy > this.capacity) {
            this.energy = this.capacity;
        } else if (this.energy < 0) {
            this.energy = 0;
        }
    }

    public void modifyEnergyStored(int energy) {
        this.energy += energy;
        if (this.energy > this.capacity) {
            this.energy = this.capacity;
        } else if (this.energy < 0) {
            this.energy = 0;
        }
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        int energyReceived = Math.min(this.capacity - this.energy, Math.min(this.maxReceive, maxReceive));
        if (!simulate) {
            this.energy += energyReceived;
        }
        return energyReceived;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        int energyExtracted = Math.min(this.energy, Math.min(this.maxExtract, maxExtract));
        if (!simulate) {
            this.energy -= energyExtracted;
        }
        return energyExtracted;
    }

    public int getEnergyStored() {
        return this.energy;
    }

    public int getMaxEnergyStored() {
        return this.capacity;
    }

    public long getStoredPower() {
        return this.energy;
    }

    public long getCapacity() {
        return this.capacity;
    }

    public long takePower(long power, boolean simulated) {
        if (power > Integer.MAX_VALUE) {
            power = Integer.MAX_VALUE;
        }
        return this.extractEnergy((int)power, simulated);
    }

    public long givePower(long power, boolean simulated) {
        if (power > Integer.MAX_VALUE) {
            power = Integer.MAX_VALUE;
        }
        return this.receiveEnergy((int)power, simulated);
    }

    public boolean canExtract() {
        return this.getMaxExtract() > 0;
    }

    public boolean canReceive() {
        return this.getMaxReceive() > 0;
    }
}

