/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.modularmachinery.common.crafting.helper;

import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import hellfirepvp.modularmachinery.common.crafting.ComponentType;
import hellfirepvp.modularmachinery.common.crafting.MachineRecipe;
import hellfirepvp.modularmachinery.common.crafting.command.ControllerCommandSender;
import hellfirepvp.modularmachinery.common.crafting.helper.ComponentOutputRestrictor;
import hellfirepvp.modularmachinery.common.crafting.helper.ComponentRequirement;
import hellfirepvp.modularmachinery.common.crafting.helper.ComponentSelectorTag;
import hellfirepvp.modularmachinery.common.crafting.helper.CraftCheck;
import hellfirepvp.modularmachinery.common.crafting.helper.ProcessingComponent;
import hellfirepvp.modularmachinery.common.machine.MachineComponent;
import hellfirepvp.modularmachinery.common.modifier.ModifierReplacement;
import hellfirepvp.modularmachinery.common.modifier.RecipeModifier;
import hellfirepvp.modularmachinery.common.tiles.TileMachineController;
import hellfirepvp.modularmachinery.common.util.PriorityProvider;
import hellfirepvp.modularmachinery.common.util.ResultChance;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class RecipeCraftingContext {
    private static final Random RAND = new Random();
    private final MachineRecipe recipe;
    private final TileMachineController machineController;
    private final ControllerCommandSender commandSender;
    private int currentCraftingTick = 0;
    private Map<String, Map<MachineComponent<?>, ProcessingComponent<?>>> typeComponents = new HashMap();
    private Map<String, List<RecipeModifier>> modifiers = new HashMap<String, List<RecipeModifier>>();
    private List<ComponentOutputRestrictor> currentRestrictions = Lists.newArrayList();

    public RecipeCraftingContext(MachineRecipe recipe, TileMachineController controller) {
        this.recipe = recipe;
        this.machineController = controller;
        this.commandSender = new ControllerCommandSender(this.machineController);
    }

    public TileMachineController getMachineController() {
        return this.machineController;
    }

    public MachineRecipe getParentRecipe() {
        return this.recipe;
    }

    public void setCurrentCraftingTick(int currentCraftingTick) {
        this.currentCraftingTick = currentCraftingTick;
    }

    public int getCurrentCraftingTick() {
        return this.currentCraftingTick;
    }

    @Nonnull
    public List<RecipeModifier> getModifiers(String target) {
        return this.modifiers.computeIfAbsent(target, t -> new LinkedList());
    }

    public float getDurationMultiplier() {
        float dur = this.recipe.getRecipeTotalTickTime();
        float result = RecipeModifier.applyModifiers(this.getModifiers("duration"), "duration", null, dur, false);
        return dur / result;
    }

    public void addRestriction(ComponentOutputRestrictor restrictor) {
        this.currentRestrictions.add(restrictor);
    }

    public Iterable<ProcessingComponent<?>> getComponentsFor(ComponentType type, @Nullable ComponentSelectorTag tag) {
        String key = type.getRegistryName();
        if (key.equalsIgnoreCase("gas")) {
            key = "fluid";
        }
        Collection<ProcessingComponent<?>> components = this.typeComponents.computeIfAbsent(key, s -> new HashMap()).values();
        if (tag == null) {
            return components;
        }
        return new PriorityProvider(components, compList -> (ProcessingComponent)Iterators.tryFind(compList.iterator(), comp -> tag.equals(comp.getTag())).orNull());
    }

    public CraftingCheckResult ioTick(int currentTick) {
        ProcessingComponent<?> component;
        CraftCheck result;
        Iterator<ProcessingComponent<?>> iterator;
        ComponentRequirement.PerTick perTickRequirement;
        float durMultiplier = this.getDurationMultiplier();
        for (ComponentRequirement requirement : this.recipe.getCraftingRequirements()) {
            if (!(requirement instanceof ComponentRequirement.PerTick) || requirement.getActionType() == MachineComponent.IOType.OUTPUT) continue;
            perTickRequirement = (ComponentRequirement.PerTick)requirement;
            perTickRequirement.resetIOTick(this);
            perTickRequirement.startIOTick(this, durMultiplier);
            iterator = this.getComponentsFor(requirement.getRequiredComponentType(), requirement.getTag()).iterator();
            while (iterator.hasNext() && !(result = perTickRequirement.doIOTick((component = iterator.next()).getComponent(), this)).isSuccess()) {
            }
            CraftCheck result2 = perTickRequirement.resetIOTick(this);
            if (result2.isSuccess()) continue;
            CraftingCheckResult res = new CraftingCheckResult();
            res.addError(result2.getUnlocalizedMessage());
            return res;
        }
        for (ComponentRequirement requirement : this.recipe.getCraftingRequirements()) {
            if (!(requirement instanceof ComponentRequirement.PerTick) || requirement.getActionType() == MachineComponent.IOType.INPUT) continue;
            perTickRequirement = (ComponentRequirement.PerTick)requirement;
            perTickRequirement.resetIOTick(this);
            perTickRequirement.startIOTick(this, durMultiplier);
            iterator = this.getComponentsFor(requirement.getRequiredComponentType(), requirement.getTag()).iterator();
            while (iterator.hasNext() && !(result = perTickRequirement.doIOTick((component = iterator.next()).getComponent(), this)).isSuccess()) {
            }
            perTickRequirement.resetIOTick(this);
        }
        this.recipe.getCommandContainer().runTickCommands(this.commandSender, currentTick);
        return CraftingCheckResult.SUCCESS;
    }

    public void startCrafting() {
        this.startCrafting(RAND.nextLong());
    }

    public void startCrafting(long seed) {
        ResultChance chance = new ResultChance(seed);
        for (ComponentRequirement requirement : this.recipe.getCraftingRequirements()) {
            if (requirement.getActionType() == MachineComponent.IOType.OUTPUT) continue;
            requirement.startRequirementCheck(chance, this);
            for (ProcessingComponent<?> component : this.getComponentsFor(requirement.getRequiredComponentType(), requirement.getTag())) {
                if (!requirement.startCrafting(component.getComponent(), this, chance)) continue;
                requirement.endRequirementCheck();
                break;
            }
            requirement.endRequirementCheck();
        }
        this.recipe.getCommandContainer().runStartCommands(this.commandSender);
    }

    public void finishCrafting() {
        this.finishCrafting(RAND.nextLong());
    }

    public void finishCrafting(long seed) {
        ResultChance chance = new ResultChance(seed);
        for (ComponentRequirement requirement : this.recipe.getCraftingRequirements()) {
            if (requirement.getActionType() == MachineComponent.IOType.INPUT) continue;
            requirement.startRequirementCheck(chance, this);
            for (ProcessingComponent<?> component : this.getComponentsFor(requirement.getRequiredComponentType(), requirement.getTag())) {
                if (!requirement.finishCrafting(component.getComponent(), this, chance)) continue;
                requirement.endRequirementCheck();
                break;
            }
            requirement.endRequirementCheck();
        }
        this.recipe.getCommandContainer().runFinishCommands(this.commandSender);
    }

    public CraftingCheckResult canStartCrafting() {
        this.currentRestrictions.clear();
        CraftingCheckResult result = new CraftingCheckResult();
        float successfulRequirements = 0.0f;
        float requirements = this.recipe.getCraftingRequirements().size();
        block0: for (ComponentRequirement requirement : this.recipe.getCraftingRequirements()) {
            requirement.startRequirementCheck(ResultChance.GUARANTEED, this);
            Iterable<ProcessingComponent<?>> components = this.getComponentsFor(requirement.getRequiredComponentType(), requirement.getTag());
            if (!Iterables.isEmpty(components)) {
                ArrayList errorMessages = Lists.newArrayList();
                for (ProcessingComponent<?> component : components) {
                    CraftCheck check = requirement.canStartCrafting(component.getComponent(), this, this.currentRestrictions);
                    if (check.isSuccess()) {
                        requirement.endRequirementCheck();
                        successfulRequirements += 1.0f;
                        continue block0;
                    }
                    if (check.isInvalid() || check.getUnlocalizedMessage().isEmpty()) continue;
                    errorMessages.add(check.getUnlocalizedMessage());
                }
                errorMessages.forEach(x$0 -> result.addError(x$0));
            } else {
                result.addError(requirement.getRequiredComponentType().getMissingComponentErrorMessage(requirement.getActionType()));
            }
            requirement.endRequirementCheck();
        }
        result.setValidity(successfulRequirements / requirements);
        this.currentRestrictions.clear();
        return result;
    }

    public <T> void addComponent(MachineComponent<T> component, @Nullable ComponentSelectorTag tag) {
        Map components = this.typeComponents.computeIfAbsent(component.getComponentType().getRegistryName(), s -> new HashMap());
        components.put(component, new ProcessingComponent<T>(component, component.getContainerProvider(), tag));
    }

    public void addModifier(ModifierReplacement modifier) {
        List<RecipeModifier> modifiers = modifier.getModifiers();
        for (RecipeModifier mod : modifiers) {
            this.modifiers.computeIfAbsent(mod.getTarget(), target -> new LinkedList()).add(mod);
        }
    }

    @Nullable
    public Object getProvidedCraftingComponent(MachineComponent component) {
        Map components = this.typeComponents.computeIfAbsent(component.getComponentType().getRegistryName(), s -> new HashMap());
        ProcessingComponent processingComponent = components.getOrDefault(component, null);
        return processingComponent != null ? processingComponent.getProvidedComponent() : null;
    }

    public static class CraftingCheckResult {
        private static final CraftingCheckResult SUCCESS = new CraftingCheckResult();
        private Map<String, Integer> unlocErrorMessages = new HashMap<String, Integer>();
        private float validity = 0.0f;

        private CraftingCheckResult() {
        }

        private void setValidity(float validity) {
            this.validity = validity;
        }

        private void addError(String unlocError) {
            if (!unlocError.isEmpty()) {
                int count = this.unlocErrorMessages.getOrDefault(unlocError, 0);
                this.unlocErrorMessages.put(unlocError, ++count);
            }
        }

        public float getValidity() {
            return this.validity;
        }

        public List<String> getUnlocalizedErrorMessages() {
            return this.unlocErrorMessages.entrySet().stream().sorted(Comparator.comparing(Map.Entry::getValue)).map(Map.Entry::getKey).collect(Collectors.toList());
        }

        public boolean isFailure() {
            return !this.unlocErrorMessages.isEmpty();
        }
    }
}

