/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.modularmagic.common.crafting.requirement;

import com.google.common.collect.Lists;
import fr.frinn.modularmagic.common.integration.jei.component.JEIComponentConstellation;
import fr.frinn.modularmagic.common.tile.TileConstellationProvider;
import hellfirepvp.astralsorcery.common.constellation.IConstellation;
import hellfirepvp.modularmachinery.common.crafting.ComponentType;
import hellfirepvp.modularmachinery.common.crafting.helper.ComponentRequirement;
import hellfirepvp.modularmachinery.common.crafting.helper.CraftCheck;
import hellfirepvp.modularmachinery.common.crafting.helper.RecipeCraftingContext;
import hellfirepvp.modularmachinery.common.machine.MachineComponent;
import hellfirepvp.modularmachinery.common.util.ResultChance;
import java.util.List;
import javax.annotation.Nonnull;

public class RequirementConstellation
extends ComponentRequirement {
    public IConstellation constellation;

    public RequirementConstellation(MachineComponent.IOType actionType, IConstellation constellation) {
        super(ComponentType.Registry.getComponent((String)"constellation"), actionType);
        this.constellation = constellation;
    }

    public boolean startCrafting(MachineComponent component, RecipeCraftingContext context, ResultChance chance) {
        return this.canStartCrafting(component, context, Lists.newArrayList()).isSuccess();
    }

    public boolean finishCrafting(MachineComponent component, RecipeCraftingContext context, ResultChance chance) {
        return true;
    }

    @Nonnull
    public CraftCheck canStartCrafting(MachineComponent component, RecipeCraftingContext context, List restrictions) {
        if (this.getActionType() == MachineComponent.IOType.OUTPUT) {
            return CraftCheck.failure((String)"error.modularmagic.requirement.invalid");
        }
        if (component.getContainerProvider() == null || !(component.getContainerProvider() instanceof TileConstellationProvider)) {
            return CraftCheck.failure((String)"error.modularmagic.requirement.constellation.missingprovider");
        }
        TileConstellationProvider provider = (TileConstellationProvider)((Object)component.getContainerProvider());
        if (provider.isConstellationInSky(this.constellation)) {
            return CraftCheck.success();
        }
        return CraftCheck.failure((String)"error.modularmagic.requirement.constellation.less");
    }

    public ComponentRequirement deepCopy() {
        return this;
    }

    public ComponentRequirement deepCopyModified(List list) {
        return this;
    }

    public void startRequirementCheck(ResultChance contextChance, RecipeCraftingContext context) {
    }

    public void endRequirementCheck() {
    }

    public ComponentRequirement.JEIComponent provideJEIComponent() {
        return new JEIComponentConstellation(this);
    }
}

