/*
 * Decompiled with CFR 0.152.
 */
package jotato.quantumflux.machines.cluster;

import jotato.quantumflux.ConfigMan;
import jotato.quantumflux.Logger;
import jotato.quantumflux.blocks.BlockBase;
import jotato.quantumflux.helpers.BlockHelpers;
import jotato.quantumflux.machines.cluster.EnumQuibitCluster;
import jotato.quantumflux.machines.cluster.ItemBlockQuibitCluster;
import jotato.quantumflux.machines.cluster.QuibitClusterSettings;
import jotato.quantumflux.machines.cluster.TileCreativeCluster;
import jotato.quantumflux.machines.cluster.TileQuibitCluster;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockQuibitCluster
extends BlockBase
implements ITileEntityProvider {
    public static final PropertyEnum LEVEL = PropertyEnum.func_177709_a((String)"level", EnumQuibitCluster.class);

    public BlockQuibitCluster() {
        super(Material.field_151576_e, "quibitCluster", ItemBlockQuibitCluster.class, 3.0f);
    }

    @Override
    public void initModel() {
        EnumQuibitCluster[] allLevels;
        Item itemBlock = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation("quantumflux", "quibitCluster"));
        for (EnumQuibitCluster level : allLevels = EnumQuibitCluster.values()) {
            String name = String.format("%s_%s", this.getRegistryName(), level.name());
            Logger.devLog("    Registering model for %s", name);
            ModelLoader.setCustomModelResourceLocation((Item)itemBlock, (int)level.getMetadata(), (ModelResourceLocation)new ModelResourceLocation(name, "inventory"));
        }
    }

    public int func_180651_a(IBlockState state) {
        EnumQuibitCluster enumLevel = (EnumQuibitCluster)((Object)state.func_177229_b((IProperty)LEVEL));
        return enumLevel.getMetadata();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(CreativeTabs itemIn, NonNullList<ItemStack> items) {
        EnumQuibitCluster[] allLevels;
        Item itemBlock = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation("quantumflux", "quibitCluster"));
        for (EnumQuibitCluster level : allLevels = EnumQuibitCluster.values()) {
            items.add((Object)new ItemStack(itemBlock, 1, level.getMetadata()));
        }
    }

    public IBlockState func_176203_a(int meta) {
        int bits = meta;
        EnumQuibitCluster level = EnumQuibitCluster.byMetadata(bits);
        return this.func_176223_P().func_177226_a((IProperty)LEVEL, (Comparable)((Object)level));
    }

    public int func_176201_c(IBlockState state) {
        EnumQuibitCluster level = (EnumQuibitCluster)((Object)state.func_177229_b((IProperty)LEVEL));
        int bits = level.getMetadata();
        return bits;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{LEVEL});
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        EnumQuibitCluster level = EnumQuibitCluster.byMetadata(stack.func_77960_j());
        worldIn.func_175656_a(pos, state.func_177226_a((IProperty)LEVEL, (Comparable)((Object)level)));
    }

    public static QuibitClusterSettings getQuibitClusterSettings(ItemStack item) {
        return new QuibitClusterSettings(item.func_77952_i());
    }

    public static QuibitClusterSettings getQuibitClusterSettings(int level) {
        return new QuibitClusterSettings(level);
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        if (meta == 0) {
            return new TileCreativeCluster();
        }
        return new TileQuibitCluster(BlockQuibitCluster.getQuibitClusterSettings(meta));
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (worldIn.field_72995_K) {
            return false;
        }
        TileEntity te = worldIn.func_175625_s(pos);
        if (te instanceof TileQuibitCluster) {
            TileQuibitCluster teqc = (TileQuibitCluster)worldIn.func_175625_s(pos);
            if (ConfigMan.isDebug) {
                playerIn.func_145747_a((ITextComponent)new TextComponentString(String.valueOf(teqc.lastUsed)));
            }
        }
        return BlockHelpers.BroadcastRFStored(playerIn, te);
    }
}

