/*
 * Decompiled with CFR 0.152.
 */
package jotato.quantumflux.machines.zpe;

import cofh.redstoneflux.api.IEnergyProvider;
import cofh.redstoneflux.api.IEnergyReceiver;
import cofh.redstoneflux.impl.EnergyStorage;
import javax.annotation.Nullable;
import jotato.quantumflux.ConfigMan;
import jotato.quantumflux.blocks.TileBase;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class TileZeroPointExtractor
extends TileBase
implements IEnergyProvider,
IEnergyStorage,
ITickable {
    private EnergyStorage energy = new EnergyStorage(ConfigMan.zpe_maxPowerGen, Integer.MAX_VALUE);

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        tag = super.func_189515_b(tag);
        NBTTagCompound energyTag = new NBTTagCompound();
        this.energy.writeToNBT(energyTag);
        tag.func_74782_a("Energy", (NBTBase)energyTag);
        return tag;
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        NBTTagCompound energyTag = tag.func_74775_l("Energy");
        this.energy.readFromNBT(energyTag);
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        this.energy.receiveEnergy(Math.max(ConfigMan.zpe_maxPowerGen - this.func_174877_v().func_177956_o(), 1), false);
        for (EnumFacing dir : EnumFacing.values()) {
            int used;
            int tosend;
            IEnergyReceiver receiver;
            BlockPos targetBlock = this.func_174877_v().func_177971_a(dir.func_176730_m());
            TileEntity tile = this.field_145850_b.func_175625_s(targetBlock);
            if (tile == null) continue;
            if (tile instanceof IEnergyReceiver) {
                receiver = (IEnergyReceiver)tile;
                if (!receiver.canConnectEnergy(dir.func_176734_d())) continue;
                tosend = this.energy.extractEnergy(ConfigMan.zpe_maxPowerGen, true);
                used = receiver.receiveEnergy(dir.func_176734_d(), tosend, false);
                if (used > 0) {
                    this.func_70296_d();
                }
                this.energy.extractEnergy(used, false);
                continue;
            }
            if (!tile.hasCapability(CapabilityEnergy.ENERGY, dir.func_176734_d()) || !(receiver = (IEnergyStorage)tile.getCapability(CapabilityEnergy.ENERGY, dir.func_176734_d())).canReceive()) continue;
            tosend = this.energy.extractEnergy(ConfigMan.zpe_maxPowerGen, true);
            used = receiver.receiveEnergy(tosend, false);
            if (used > 0) {
                this.func_70296_d();
            }
            this.energy.extractEnergy(used, false);
        }
    }

    public boolean canConnectEnergy(EnumFacing from) {
        return true;
    }

    public int extractEnergy(EnumFacing from, int maxExtract, boolean simulate) {
        return this.energy.extractEnergy(maxExtract, simulate);
    }

    public int getEnergyStored(EnumFacing from) {
        return this.energy.getEnergyStored();
    }

    public int getMaxEnergyStored(EnumFacing from) {
        return this.energy.getMaxEnergyStored();
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY) {
            return (T)((Object)this);
        }
        return (T)super.getCapability(capability, facing);
    }

    public boolean canExtract() {
        return this.canConnectEnergy(null);
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        return this.extractEnergy(null, maxExtract, simulate);
    }

    public boolean canReceive() {
        return false;
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        return 0;
    }

    public int getEnergyStored() {
        return this.getEnergyStored(null);
    }

    public int getMaxEnergyStored() {
        return this.getMaxEnergyStored(null);
    }
}

