/*
 * Decompiled with CFR 0.152.
 */
package morethanhidden.restrictedportals;

import java.util.ArrayList;
import java.util.List;
import morethanhidden.restrictedportals.handlers.CraftingHandler;
import morethanhidden.restrictedportals.handlers.EventHandler;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatBase;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="restrictedportals", name="Restricted Portals", version="1.12-0.6.3", acceptedMinecraftVersions="[1.12]")
public class RestrictedPortals {
    @Mod.Instance(value="restrictedportals")
    public static RestrictedPortals instance;
    public static Logger logger;
    public static StatBase[] portalUnlock;
    public static String[] idSplit;
    public static ItemStack[] itemList;
    public static List<Block> pblockwhitelist;
    public static boolean[] metaUsed;
    public static String[] nameSplit;
    public Configuration config;
    public static String blockedmessage;
    public static String craftedmessage;
    public static boolean preventEPDeath;
    public static boolean consumed;

    @Mod.EventHandler
    public void preinit(FMLPreInitializationEvent event) {
        this.config = new Configuration(event.getSuggestedConfigurationFile());
    }

    @Mod.EventHandler
    public void Init(FMLInitializationEvent event) {
        this.config.load();
        blockedmessage = this.config.get("general", "Blocked Message", "Please craft a %item% to enter the %dim%").getString();
        craftedmessage = this.config.get("general", "Crafted Message", "%dim% Unlocked!").getString();
        String craftItemRaw = this.config.get("general", "Crafted Items", "minecraft:flint_and_steel,minecraft:ender_eye").getString();
        String dimNameRaw = this.config.get("general", "Dimension Names", "Nether,End").getString();
        String dimIDRaw = this.config.get("general", "Dimension IDs", "-1,1").getString();
        preventEPDeath = this.config.getBoolean("Prevent End Portal Death", "general", true, "Teleports player to Spawn or their bed when trying to enter a End portal");
        consumed = this.config.getBoolean("Consume item rather than craft", "general", false, "Right Click item on Portal Rather than Craft");
        String pblockwhitelistRaw = this.config.get("general", "Consumable Portal Block Whitelist", "minecraft:portal,minecraft:end_portal").getString();
        this.config.save();
        String[] craftSplit = craftItemRaw.split(",");
        nameSplit = dimNameRaw.split(",");
        idSplit = dimIDRaw.split(",");
        String[] pblockwhitelistSplit = pblockwhitelistRaw.split(",");
        itemList = new ItemStack[nameSplit.length];
        portalUnlock = new StatBase[nameSplit.length];
        metaUsed = new boolean[nameSplit.length];
        for (int i = 0; i < nameSplit.length; ++i) {
            String[] itemsplit = craftSplit[i].split(":");
            int meta = 0;
            if (itemsplit.length == 3) {
                meta = Integer.parseInt(itemsplit[2]);
                RestrictedPortals.metaUsed[i] = true;
            } else {
                RestrictedPortals.metaUsed[i] = false;
            }
            Item item = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(itemsplit[0], itemsplit[1]));
            RestrictedPortals.itemList[i] = item != null ? new ItemStack(item, 1, meta) : new ItemStack((Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation(itemsplit[0], itemsplit[1])), 1, meta);
            if (itemList[i] == null) {
                // empty if block
            }
            if (idSplit[i].equals("")) {
                logger.info("Please fix the " + nameSplit[i] + " Dimension ID in the Config");
            } else if (itemList[i] == null || itemList[i].func_190926_b()) {
                logger.info("Please fix the " + nameSplit[i] + " Item in the Config");
            }
            RestrictedPortals.portalUnlock[i] = new StatBase("rpunlock." + nameSplit[i], (ITextComponent)new TextComponentString("rpunlock." + nameSplit[i])).func_75966_h().func_75971_g();
        }
        for (String pblock : pblockwhitelistSplit) {
            pblockwhitelist.add((Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation(pblock.trim())));
        }
        EventHandler eventHandler = new EventHandler();
        MinecraftForge.EVENT_BUS.register((Object)eventHandler);
        MinecraftForge.EVENT_BUS.register((Object)new CraftingHandler());
    }

    static {
        logger = LogManager.getLogger((String)"restrictedportals");
        pblockwhitelist = new ArrayList<Block>();
    }
}

