/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.container.item;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.items.wrapper.InvWrapper;
import thaumicenergistics.api.ThEApi;
import thaumicenergistics.client.gui.GuiHandler;
import thaumicenergistics.container.ContainerBase;
import thaumicenergistics.container.part.ContainerArcaneInscriber;
import thaumicenergistics.container.slot.SlotGhost;
import thaumicenergistics.init.ModGUIs;
import thaumicenergistics.network.packets.PacketUIAction;
import thaumicenergistics.util.ForgeUtil;
import thaumicenergistics.util.KnowledgeCoreUtil;
import thaumicenergistics.util.inventory.ThEInternalInventory;

public class ContainerKnowledgeCore
extends ContainerBase {
    private static final int SLOT_NUM = 9;
    private final ModGUIs GUIAction;
    private ItemStack knowledgeCoreStack;
    private ContainerArcaneInscriber inscriber;
    private ThEInternalInventory inventory;

    public ContainerKnowledgeCore(EntityPlayer player, ModGUIs GUIAction, Container inscriber) {
        super(player);
        this.GUIAction = GUIAction;
        try {
            this.inscriber = (ContainerArcaneInscriber)inscriber;
            this.knowledgeCoreStack = this.inscriber.getInventory("upgrades").getStackInSlot(0);
            this.initInv();
            this.addSlots(8, 15);
        }
        catch (ClassCastException ex) {
            ex.printStackTrace();
        }
    }

    private void initInv() {
        this.inventory = new ThEInternalInventory("KCore", 9, 1);
    }

    private void addSlots(int offsetX, int offsetY) {
        for (int i = 0; i < 9; ++i) {
            KnowledgeCoreUtil.Recipe recipe;
            SlotGhost slotGhost = new SlotGhost(this.inventory, i, offsetX + i * 18, offsetY);
            if (KnowledgeCoreUtil.hasRecipe(this.knowledgeCoreStack, i) && (recipe = KnowledgeCoreUtil.getRecipe(this.knowledgeCoreStack, i)) != null) {
                slotGhost.func_75215_d(recipe.getResult());
            }
            this.func_75146_a(slotGhost);
        }
    }

    @Override
    public void onAction(EntityPlayerMP player, PacketUIAction packet) {
        if (ForgeUtil.isServer()) {
            if (packet.index > -1) {
                switch (packet.action) {
                    case KNOWLEDGE_CORE_ADD: {
                        this.playWriteSound((EntityPlayer)player);
                        ThEInternalInventory ingredients = (ThEInternalInventory)((InvWrapper)this.inscriber.getInventory("crafting")).getInv();
                        ItemStack result = this.inscriber.getInventory("result").getStackInSlot(0);
                        KnowledgeCoreUtil.setRecipe(this.knowledgeCoreStack, packet.index, new KnowledgeCoreUtil.Recipe(ingredients, result, this.inscriber.getCurrentRequiredVis()));
                        break;
                    }
                    case KNOWLEDGE_CORE_DEL: {
                        this.playWriteSound((EntityPlayer)player);
                        KnowledgeCoreUtil.setRecipe(this.knowledgeCoreStack, packet.index, null);
                    }
                }
            }
            if (KnowledgeCoreUtil.isEmpty(this.knowledgeCoreStack)) {
                ThEApi.instance().items().blankKnowledgeCore().maybeStack(1).ifPresent(blank -> ((InvWrapper)this.inscriber.getInventory("upgrades")).getInv().func_70299_a(0, blank));
            }
            GuiHandler.openGUI(ModGUIs.ARCANE_INSCRIBER, (EntityPlayer)player, this.inscriber.getPartPos(), this.inscriber.getPartSide());
        }
    }

    public void playWriteSound(EntityPlayer player) {
        player.field_70170_p.func_184133_a(player, this.inscriber.getPartPos(), new SoundEvent(ThEApi.instance().sounds().knowledgeCoreWrite()), SoundCategory.BLOCKS, 1.0f, 1.0f);
    }

    public ModGUIs getGUIAction() {
        return this.GUIAction;
    }

    public ItemStack getKnowledgeCoreStack() {
        return this.knowledgeCoreStack;
    }

    public ContainerArcaneInscriber getInscriber() {
        return this.inscriber;
    }
}

