/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.container.part;

import appeng.api.config.Actionable;
import appeng.api.storage.IMEMonitorHandlerReceiver;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.util.IConfigurableObject;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import thaumcraft.api.crafting.IArcaneRecipe;
import thaumicenergistics.api.ThEApi;
import thaumicenergistics.client.gui.GuiHandler;
import thaumicenergistics.container.ActionType;
import thaumicenergistics.container.ICraftingContainer;
import thaumicenergistics.container.part.ContainerArcaneTerminal;
import thaumicenergistics.container.slot.SlotArcaneGhostMatrix;
import thaumicenergistics.container.slot.SlotArcaneResult;
import thaumicenergistics.container.slot.SlotKnowledgeCore;
import thaumicenergistics.init.ModGUIs;
import thaumicenergistics.integration.thaumcraft.TCCraftingManager;
import thaumicenergistics.item.ItemKnowledgeCore;
import thaumicenergistics.network.PacketHandler;
import thaumicenergistics.network.packets.PacketIsArcaneUpdate;
import thaumicenergistics.network.packets.PacketUIAction;
import thaumicenergistics.part.PartArcaneInscriber;
import thaumicenergistics.util.AEUtil;
import thaumicenergistics.util.ForgeUtil;
import thaumicenergistics.util.ItemHandlerUtil;
import thaumicenergistics.util.KnowledgeCoreUtil;
import thaumicenergistics.util.ThELog;
import thaumicenergistics.util.inventory.ThEInternalInventory;

public class ContainerArcaneInscriber
extends ContainerArcaneTerminal
implements IMEMonitorHandlerReceiver<IAEItemStack>,
ICraftingContainer,
IConfigurableObject {
    public boolean recipeIsArcane = false;

    public ContainerArcaneInscriber(EntityPlayer player, PartArcaneInscriber part) {
        super(player, part);
    }

    @Override
    public void onAction(EntityPlayerMP player, PacketUIAction packet) {
        super.onAction(player, packet);
        if (ForgeUtil.isServer()) {
            ItemStack knowledgeCore = this.getInventory("upgrades").getStackInSlot(0);
            if (knowledgeCore.func_190926_b()) {
                return;
            }
            boolean currentIsBlank = ((ItemKnowledgeCore)knowledgeCore.func_77973_b()).isBlank();
            ItemStack result = this.getInventory("result").getStackInSlot(0);
            if (packet.action == ActionType.KNOWLEDGE_CORE_ADD && !result.func_190926_b() && this.recipeIsArcane) {
                if (currentIsBlank) {
                    ThEApi.instance().items().knowledgeCore().maybeStack(1).ifPresent(newCore -> ((InvWrapper)this.getInventory("upgrades")).getInv().func_70299_a(0, newCore));
                } else if (KnowledgeCoreUtil.hasRecipe(knowledgeCore, result.func_77973_b())) {
                    return;
                }
                GuiHandler.openGUI(ModGUIs.KNOWLEDGE_CORE_ADD, (EntityPlayer)player, this.part.getLocation().getPos(), this.part.side);
            } else if (packet.action == ActionType.KNOWLEDGE_CORE_DEL && !currentIsBlank) {
                GuiHandler.openGUI(ModGUIs.KNOWLEDGE_CORE_DEL, (EntityPlayer)player, this.part.getLocation().getPos(), this.part.side);
            } else if (packet.action == ActionType.KNOWLEDGE_CORE_VIEW && !currentIsBlank) {
                GuiHandler.openGUI(ModGUIs.KNOWLEDGE_CORE_VIEW, (EntityPlayer)player, this.part.getLocation().getPos(), this.part.side);
            }
        }
    }

    public void refreshIsArcane() {
        if (ForgeUtil.isClient()) {
            return;
        }
        InvWrapper crafting = (InvWrapper)this.getInventory("crafting");
        boolean recipeIsArcane = this.recipe != null && !crafting.getInv().func_191420_l() ? TCCraftingManager.findArcaneRecipe((IItemHandler)crafting, this.player) != null : false;
        if (this.recipeIsArcane != recipeIsArcane) {
            this.recipeIsArcane = recipeIsArcane;
            PacketHandler.sendToPlayer((EntityPlayerMP)this.player, new PacketIsArcaneUpdate(recipeIsArcane));
        }
    }

    @Override
    public void onMatrixChanged() {
        super.onMatrixChanged();
        this.refreshIsArcane();
    }

    @Override
    protected void clearCrafting() {
        IItemHandler crafting = this.getInventory("crafting");
        for (int slot = 0; slot < crafting.getSlots(); ++slot) {
            crafting.extractItem(slot, crafting.getStackInSlot(slot).func_190916_E(), false);
        }
    }

    @Override
    protected float getRequiredVis(IRecipe recipe, EntityPlayer player) {
        if (!(recipe instanceof IArcaneRecipe)) {
            return -1.0f;
        }
        return ((IArcaneRecipe)recipe).getVis();
    }

    @Override
    public void handleJEITransfer(EntityPlayer player, NBTTagCompound tag) {
        NBTBase normal = tag.func_74781_a("normal");
        NBTBase crystals = tag.func_74781_a("crystal");
        this.clearCrafting();
        this.onMatrixChanged();
        this.handleJEITag(0, normal, true);
        this.handleJEITag(9, crystals, false);
        this.onMatrixChanged();
    }

    private void handleJEITag(int startAtSlot, NBTBase ingredientGroup, boolean mustBeSingle) {
        IItemHandler crafting = this.getInventory("crafting");
        IItemHandler playerInv = this.getInventory("player");
        if (ingredientGroup == null || ingredientGroup.func_82582_d()) {
            return;
        }
        NBTTagList subs = (NBTTagList)ingredientGroup;
        for (int i = 0; i < subs.func_74745_c(); ++i) {
            int slot = startAtSlot + i;
            NBTTagCompound ingredient = ((NBTTagList)subs.func_179238_g(i)).func_150305_b(0);
            ItemStack stack = new ItemStack(ingredient);
            if (stack.func_190926_b()) continue;
            ThELog.debug("Adding {} for {}", stack.func_82833_r(), slot);
            IAEItemStack aeStack = (IAEItemStack)this.channel.createStack((Object)stack);
            if (aeStack == null) {
                ThELog.warn("Failed to create IAEItemStack for {}, report to developer!", stack.toString());
                continue;
            }
            IAEItemStack aeExtract = AEUtil.inventoryExtract(aeStack, this.monitor, this.part.source, null, Actionable.SIMULATE);
            if (aeExtract != null && aeExtract.getStackSize() > 0L) {
                ItemStack AEExtractStack = aeExtract.createItemStack();
                if (mustBeSingle) {
                    AEExtractStack.func_190920_e(1);
                }
                crafting.insertItem(slot, AEExtractStack, false);
            }
            if (!crafting.getStackInSlot(slot).func_190926_b()) continue;
            ThELog.debug("Failed to pull item from ae inv, trying player inventory", new Object[0]);
            ItemStack invExtract = ItemHandlerUtil.extract(playerInv, stack, true);
            if (invExtract.func_190926_b()) continue;
            if (mustBeSingle) {
                invExtract.func_190920_e(1);
            }
            crafting.insertItem(slot, invExtract, false);
        }
        ThELog.debug("Failed to find valid item", new Object[0]);
    }

    @Override
    public ItemStack onCraft(ItemStack toCraft) {
        return ItemStack.field_190927_a;
    }

    @Override
    protected void addMatrixSlots(int offsetX, int offsetY) {
        int j;
        int i;
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 3; ++j) {
                this.func_75146_a(new SlotArcaneGhostMatrix(this, i * 3 + j, offsetX + j * 18, offsetY + i * 18));
            }
        }
        offsetX += 104;
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 2; ++j) {
                this.func_75146_a(new SlotArcaneGhostMatrix(this, 9 + (i * 2 + j), offsetX + j * 18, offsetY + i * 18));
            }
        }
        this.craftingResult = new ThEInternalInventory("Result", 1, 64);
        this.resultSlot = new SlotArcaneResult(this, this.player, 0, (offsetX -= 104) + 84, offsetY + 18);
        this.func_75146_a(this.resultSlot);
        this.onMatrixChanged();
    }

    @Override
    protected void addUpgradeSlots(int offsetX, int offsetY) {
        this.func_75146_a(new SlotKnowledgeCore(this.getInventory("upgrades"), 0, offsetX, offsetY));
    }

    @Override
    protected float getWorldVis() {
        return Float.MAX_VALUE;
    }

    @Override
    protected float getDiscount(EntityPlayer player) {
        return 0.0f;
    }
}

