/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.integration.appeng.util;

import appeng.api.config.Settings;
import appeng.api.util.IConfigManager;
import java.util.EnumMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import thaumicenergistics.config.AESettings;

public class ThEConfigManager
implements IConfigManager {
    private Map<Settings, Enum> settings = new EnumMap<Settings, Enum>(Settings.class);

    public void registerSetting(Settings setting, Enum<?> defaultValue) {
        this.settings.put(setting, defaultValue);
    }

    public void registerSettings(@Nullable AESettings.SUBJECT settingSubject) {
        AESettings.registerSettings(settingSubject, this);
    }

    public Enum<?> putSetting(Settings setting, Enum<?> value) {
        Enum<?> old = this.getSetting(setting);
        this.settings.put(setting, value);
        return old;
    }

    public Enum<?> getSetting(Settings setting) {
        Enum v = this.settings.get(setting);
        if (v == null) {
            throw new IllegalStateException("Setting '" + setting + "' has not been registered!");
        }
        return v;
    }

    public void writeToNBT(NBTTagCompound tag) {
        this.settings.forEach((key, value) -> tag.func_74778_a(key.name(), value.name()));
    }

    public void readFromNBT(NBTTagCompound tag) {
        this.settings.forEach((key, old) -> {
            Object newValue;
            if (!tag.func_74764_b(key.name())) {
                return;
            }
            String value = tag.func_74779_i(key.name());
            try {
                newValue = Enum.valueOf(old.getDeclaringClass(), value);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
                return;
            }
            this.putSetting((Settings)key, (Enum<?>)newValue);
        });
    }

    public Set<Settings> getSettings() {
        return this.settings.keySet();
    }
}

