/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.util.inventory;

import appeng.api.config.Upgrades;
import appeng.api.implementations.items.IUpgradeModule;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import net.minecraft.item.ItemStack;
import thaumicenergistics.api.IThEUpgrade;
import thaumicenergistics.api.ThEApi;
import thaumicenergistics.item.ItemKnowledgeCore;
import thaumicenergistics.util.ForgeUtil;
import thaumicenergistics.util.inventory.ThEInternalInventory;

public class ThEUpgradeInventory
extends ThEInternalInventory {
    private boolean cached = false;
    private Map<Object, Integer> cachedUpgrades = new HashMap<Object, Integer>();
    private ItemStack upgradable;

    public ThEUpgradeInventory(String customName, int size, int stackLimit, ItemStack upgradable) {
        this(customName, size, stackLimit);
        this.upgradable = upgradable;
    }

    public ThEUpgradeInventory(String customName, int size, int stackLimit) {
        super(customName, size, stackLimit);
    }

    public boolean isKnowledgeCoreSlot() {
        return false;
    }

    @Override
    public boolean func_94041_b(int index, ItemStack stack) {
        if (stack.func_77973_b() instanceof ItemKnowledgeCore && !this.isKnowledgeCoreSlot()) {
            return false;
        }
        if (!(stack.func_77973_b() instanceof IUpgradeModule) && !ThEApi.instance().upgrades().getUpgrade(stack).isPresent()) {
            return false;
        }
        if (this.upgradable == null) {
            return true;
        }
        return this.getMaxUpgrades(stack) > 0 && this.getUpgrades(stack) < this.getMaxUpgrades(stack);
    }

    @Override
    public void func_70296_d() {
        super.func_70296_d();
        this.cached = false;
    }

    public int getUpgrades(Object o) {
        if (!this.cached) {
            this.calculateUpgrades();
        }
        if (o instanceof ItemStack) {
            ItemStack stack = (ItemStack)o;
            if (stack.func_77973_b() instanceof IUpgradeModule) {
                o = ((IUpgradeModule)stack.func_77973_b()).getType(stack);
            } else {
                Optional<IThEUpgrade> upgrade = ThEApi.instance().upgrades().getUpgrade(stack);
                if (upgrade.isPresent()) {
                    o = upgrade.get();
                }
            }
        }
        return this.cachedUpgrades.getOrDefault(o, 0);
    }

    private void calculateUpgrades() {
        this.cachedUpgrades.clear();
        this.iterator().forEachRemaining(stack -> {
            ThEApi.instance().upgrades().getUpgrade((ItemStack)stack).ifPresent(upgrade -> this.cachedUpgrades.put(upgrade, this.cachedUpgrades.getOrDefault(upgrade, 0) + stack.func_190916_E()));
            if (stack.func_77973_b() instanceof IUpgradeModule) {
                IUpgradeModule item = (IUpgradeModule)stack.func_77973_b();
                Upgrades upgrade2 = item.getType(stack);
                if (upgrade2 == null) {
                    return;
                }
                this.cachedUpgrades.put(upgrade2, this.cachedUpgrades.getOrDefault(upgrade2, 0) + stack.func_190916_E());
            }
        });
        this.cached = true;
    }

    private int getMaxUpgrades(ItemStack upgradeStack) {
        Upgrades upgrade2;
        AtomicInteger max = new AtomicInteger(0);
        ThEApi.instance().upgrades().getUpgrade(upgradeStack).ifPresent(upgrade -> max.set(upgrade.getSupported(this.upgradable)));
        if (upgradeStack.func_77973_b() instanceof IUpgradeModule && (upgrade2 = ((IUpgradeModule)upgradeStack.func_77973_b()).getType(upgradeStack)) != null) {
            Stream stream = upgrade2.getSupported().keySet().stream();
            Optional<ItemStack> upgradable = stream.filter(o -> ForgeUtil.areItemStacksEqual(this.upgradable, o)).findFirst();
            upgradable.ifPresent(stack -> max.set(upgrade2.getSupported().getOrDefault(upgradable.get(), 0)));
        }
        return max.get();
    }
}

