/*
 * Decompiled with CFR 0.152.
 */
package caffeinatedpinkie.tmel;

import caffeinatedpinkie.tmel.GeneratorHelper;
import caffeinatedpinkie.tmel.LoggerTMEL;
import caffeinatedpinkie.tmel.TMEL;
import caffeinatedpinkie.tmel.common.modifiers.RecipeDisabler;
import java.util.HashMap;
import java.util.Map;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Config(modid="tmel")
public class ConfigTMEL {
    @Config.Name(value="Default Recipes")
    @Config.Comment(value={"Disable or enable any recipes added in by Extra Utilities. By disabling an item in the list, all recipes that are added by Extra Utilities to craft that item are disabled. The same is true for enabling one. Doing so requires a restart of the game."})
    @Config.RequiresMcRestart
    public static Map<String, Boolean> defaultRecipes = new HashMap<String, Boolean>();
    @Config.Name(value="Disable Efficiency Loss")
    @Config.Comment(value={"Enabling this disables efficiency loss in all generators."})
    public static boolean disableEL = true;
    @Config.Name(value="Disable Grid Power")
    @Config.Comment(value={"Enabling this disables the use of GP in all machines and makes it impossible to overload the grid."})
    public static boolean disableGP;
    @Config.Name(value="Grid Power Multipliers")
    @Config.Comment(value={"Multipliers for the GP production rates. All values must be at least 0 and less than 3.4028235E38."})
    public static Map<String, Float> gpRateMultipliers;
    @Config.Name(value="Verbose?")
    @Config.Comment(value={"If true, debug messages will be sent to the client or server console."})
    public static boolean verbose;

    public static void postInit(FMLPostInitializationEvent event) {
        LoggerTMEL.log(() -> {
            RecipeDisabler.recipes.forEach((name, recipe) -> defaultRecipes.put((String)name, true));
            GeneratorHelper.forEachGenerator(generator -> gpRateMultipliers.put(GeneratorHelper.getName(generator), Float.valueOf(1.0f)));
            ConfigManager.sync((String)"tmel", (Config.Type)Config.Type.INSTANCE);
        }, "Config setup");
    }

    static {
        gpRateMultipliers = new HashMap<String, Float>();
    }

    @Mod.EventBusSubscriber
    public static class EventHandler {
        @SubscribeEvent
        public static void onConfigChangedEvent(ConfigChangedEvent.OnConfigChangedEvent event) {
            if (event.getModID().equals("tmel")) {
                ConfigManager.sync((String)"tmel", (Config.Type)Config.Type.INSTANCE);
                TMEL.refresh();
            }
        }
    }
}

