/*
 * Decompiled with CFR 0.152.
 */
package youyihj.zenutils.api.cotx.block;

import com.google.common.collect.BiMap;
import com.google.common.collect.EnumHashBiMap;
import com.teamacronymcoders.base.registrysystem.BlockRegistry;
import com.teamacronymcoders.contenttweaker.ContentTweaker;
import com.teamacronymcoders.contenttweaker.api.ctobjects.blockmaterial.IBlockMaterialDefinition;
import crafttweaker.annotations.ZenRegister;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import stanhebben.zenscript.annotations.ZenClass;
import youyihj.zenutils.api.cotx.block.DirectionalBlockContent;
import youyihj.zenutils.api.cotx.block.ExpandBlockRepresentation;

@ZenRegister
@ZenClass(value="mods.zenutils.cotx.DirectionalBlock")
public class DirectionalBlockRepresentation
extends ExpandBlockRepresentation {
    private final Directions directions;

    public DirectionalBlockRepresentation(String unlocalizedName, IBlockMaterialDefinition blockMaterial, Directions directions) {
        super(unlocalizedName, blockMaterial);
        this.directions = directions;
    }

    public Directions getDirections() {
        return this.directions;
    }

    @Override
    public void register() {
        ((BlockRegistry)ContentTweaker.instance.getRegistry(BlockRegistry.class, "BLOCK")).register((Block)DirectionalBlockContent.create(this));
    }

    public static enum Directions {
        ALL(EnumFacing.values()),
        HORIZONTAL(EnumFacing.Plane.HORIZONTAL.func_179516_a()),
        VERTICAL(EnumFacing.Plane.VERTICAL.func_179516_a());

        private final BiMap<EnumFacing, Integer> metaFacingMapping = EnumHashBiMap.create(EnumFacing.class);
        private final IProperty<EnumFacing> blockProperty;
        private final EnumFacing[] validFacings;

        private Directions(EnumFacing[] validFacings) {
            this.validFacings = validFacings;
            this.blockProperty = PropertyEnum.func_177706_a((String)"facing", EnumFacing.class, (Enum[])validFacings);
            this.fillMetaMapping();
        }

        public EnumFacing[] getValidFacings() {
            return this.validFacings;
        }

        public IProperty<EnumFacing> getBlockProperty() {
            return this.blockProperty;
        }

        public int toMeta(IBlockState state) {
            return (Integer)this.metaFacingMapping.get((Object)state.func_177229_b(this.blockProperty));
        }

        public IBlockState toState(int meta, IBlockState defaultState) {
            return defaultState.func_177226_a(this.blockProperty, (Comparable)this.metaFacingMapping.inverse().get((Object)meta));
        }

        private void fillMetaMapping() {
            for (int i = 0; i < this.validFacings.length; ++i) {
                this.metaFacingMapping.put((Object)this.validFacings[i], (Object)i);
            }
        }
    }
}

