/*
 * Decompiled with CFR 0.152.
 */
package youyihj.zenutils.impl.reload;

import crafttweaker.CrafttweakerImplementationAPI;
import crafttweaker.api.event.MTEventManager;
import crafttweaker.util.EventList;
import crafttweaker.util.IEventHandler;
import java.lang.reflect.Field;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import youyihj.zenutils.ZenUtils;
import youyihj.zenutils.api.cotx.brackets.LateGetContentLookup;
import youyihj.zenutils.api.reload.ScriptReloadEvent;
import youyihj.zenutils.api.util.ZenUtilsGlobal;
import youyihj.zenutils.impl.util.InternalUtils;
import youyihj.zenutils.impl.util.ReflectUtils;

@Mod.EventBusSubscriber
public class ReloadEventHandler {
    @SubscribeEvent
    public static void onReloadPre(ScriptReloadEvent.Pre event) {
        InternalUtils.getAllEventLists().forEach(EventList::clear);
        ReloadEventHandler.reRegisterInternalEvents();
        ZenUtilsGlobal.addRegexLogFilter("Recipe name \\[.*\\] has duplicate uses, defaulting to calculated hash!");
        if (InternalUtils.isContentTweakerInstalled()) {
            LateGetContentLookup.refreshFields();
            LateGetContentLookup.clear();
        }
        ZenUtils.tweaker.onReload();
    }

    @SubscribeEvent
    public static void onReloadPost(ScriptReloadEvent.Post event) {
        int reloadActionCount = ZenUtils.tweaker.getReloadableActions().size();
        if (reloadActionCount != 0) {
            event.getRequester().func_145747_a((ITextComponent)new TextComponentString(reloadActionCount + " actions reloaded."));
        }
    }

    private static void reRegisterInternalEvents() {
        try {
            Field listenLogin = ReflectUtils.removePrivate(CrafttweakerImplementationAPI.class, "LISTEN_LOGIN");
            Field listenLogout = ReflectUtils.removePrivate(CrafttweakerImplementationAPI.class, "LISTEN_LOGOUT");
            MTEventManager events = CrafttweakerImplementationAPI.events;
            events.onPlayerLoggedIn((IEventHandler)listenLogin.get(null));
            events.onPlayerLoggedOut((IEventHandler)listenLogout.get(null));
            events.onPlayerInteract((IEventHandler)CrafttweakerImplementationAPI.LISTEN_BLOCK_INFO);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            e.printStackTrace();
        }
    }
}

