/*
 * Decompiled with CFR 0.152.
 */
package net.elnounch.mc.biggerpacketsplz;

public class Logger {
    private static ClassLoader classLoader = Logger.class.getClassLoader();
    private static LoggerStyle style = Logger.findStyle();
    private Class<?> log4jLoggerClass;
    private Object log4jLogger;
    private Object javaLogger;
    private String prefix;

    private static LoggerStyle findStyle() {
        try {
            Class<?> loggerClass = classLoader.loadClass("org.apache.logging.log4j.Logger");
            return LoggerStyle.LOG4J;
        }
        catch (Throwable t) {
            t.printStackTrace();
            return LoggerStyle.STDOUT;
        }
    }

    public Logger() {
        this("");
    }

    public Logger(String part) {
        switch (style) {
            case LOG4J: {
                try {
                    Class<?> logManagerClass = classLoader.loadClass("org.apache.logging.log4j.LogManager");
                    this.log4jLoggerClass = classLoader.loadClass("org.apache.logging.log4j.Logger");
                    this.log4jLogger = logManagerClass.getMethod("getLogger", String.class).invoke(null, "biggerpacketsplz" + (part.length() > 0 ? "." + part : ""));
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
                break;
            }
            default: {
                this.prefix = part;
            }
        }
    }

    private String injectArgs(String proto, Object ... args) {
        String res = proto;
        for (Object obj : args) {
            res = res.replaceFirst("[{][}]", obj.toString());
        }
        return res;
    }

    public void error(String message, Object ... params) {
        switch (style) {
            case LOG4J: {
                try {
                    this.log4jLoggerClass.getMethod("error", String.class, Object[].class).invoke(this.log4jLogger, message, params);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
                break;
            }
            default: {
                System.err.println(this.injectArgs(message, params));
            }
        }
    }

    public void info(String message, Object ... params) {
        switch (style) {
            case LOG4J: {
                try {
                    this.log4jLoggerClass.getMethod("info", String.class, Object[].class).invoke(this.log4jLogger, message, params);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
                break;
            }
            default: {
                System.out.println(this.injectArgs(message, params));
            }
        }
    }

    public void debug(String message, Object ... params) {
        switch (style) {
            case LOG4J: {
                try {
                    this.log4jLoggerClass.getMethod("debug", String.class, Object[].class).invoke(this.log4jLogger, message, params);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
                break;
            }
            default: {
                System.out.println(this.injectArgs(message, params));
            }
        }
    }

    private static enum LoggerStyle {
        STDOUT,
        JAVA,
        LOG4J;

    }
}

