/*
 * Decompiled with CFR 0.152.
 */
package gcewing.architecture;

import gcewing.architecture.BaseBlockUtils;
import gcewing.architecture.BaseTileEntity;
import gcewing.architecture.BaseUtils;
import gcewing.architecture.BlockPos;
import gcewing.architecture.CladdingItem;
import gcewing.architecture.EnumWorldBlockLayer;
import gcewing.architecture.IBlockState;
import gcewing.architecture.Shape;
import gcewing.architecture.Trans3;
import gcewing.architecture.Utils;
import gcewing.architecture.Vector3;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;

public class ShapeTE
extends BaseTileEntity {
    public Shape shape;
    public IBlockState baseBlockState;
    public IBlockState secondaryBlockState;
    public int disabledConnections;
    private byte offsetX;

    public static ShapeTE get(IBlockAccess world, BlockPos pos) {
        TileEntity te;
        if (world != null && (te = BaseBlockUtils.getWorldTileEntity(world, pos)) instanceof ShapeTE) {
            return (ShapeTE)te;
        }
        return null;
    }

    public ShapeTE() {
        this.shape = Shape.RoofTile;
        this.baseBlockState = BaseBlockUtils.getDefaultBlockState(Blocks.field_150344_f);
    }

    public ShapeTE(Shape s, IBlockState b) {
        this.shape = s;
        this.baseBlockState = b;
    }

    public ShapeTE(Shape s, Block b, int d) {
        this.shape = s;
        this.baseBlockState = BaseBlockUtils.getBlockStateFromMeta(b, d);
    }

    double getOffsetX() {
        return (double)this.offsetX * 0.0625;
    }

    public void setOffsetX(double value) {
        this.offsetX = (byte)(16.0 * value);
    }

    @Override
    public Trans3 localToGlobalTransformation(Vector3 origin) {
        return super.localToGlobalTransformation(origin).translate(this.getOffsetX(), 0.0, 0.0);
    }

    public boolean connectionIsEnabledGlobal(EnumFacing dir) {
        return (this.disabledConnections & 1 << dir.ordinal()) == 0;
    }

    public void setConnectionEnabledGlobal(EnumFacing dir, boolean state) {
        int bit = 1 << dir.ordinal();
        this.disabledConnections = state ? (this.disabledConnections &= ~bit) : (this.disabledConnections |= bit);
        this.markChanged();
    }

    public void toggleConnectionGlobal(EnumFacing dir) {
        boolean newState = !this.connectionIsEnabledGlobal(dir);
        this.setConnectionEnabledGlobal(dir, newState);
        ShapeTE nte = this.getNeighbourGlobal(dir);
        if (nte != null) {
            nte.setConnectionEnabledGlobal(BaseUtils.oppositeFacing(dir), newState);
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.readShapeFromNBT(nbt);
        this.readSecondaryMaterialFromNBT(nbt);
        this.offsetX = nbt.func_74771_c("offsetX");
    }

    @Override
    public void readFromItemStackNBT(NBTTagCompound nbt) {
        this.readShapeFromNBT(nbt);
    }

    protected void readShapeFromNBT(NBTTagCompound nbt) {
        this.shape = Shape.forId(nbt.func_74762_e("Shape"));
        this.baseBlockState = this.nbtGetBlockState(nbt, "BaseName", "BaseData");
        if (this.baseBlockState == null) {
            this.baseBlockState = BaseBlockUtils.getDefaultBlockState(Blocks.field_150344_f);
        }
        this.disabledConnections = nbt.func_74762_e("Disconnected");
    }

    protected void readSecondaryMaterialFromNBT(NBTTagCompound nbt) {
        this.secondaryBlockState = this.nbtGetBlockState(nbt, "Name2", "Data2");
    }

    protected IBlockState nbtGetBlockState(NBTTagCompound nbt, String nameField, String dataField) {
        String blockName = nbt.func_74779_i(nameField);
        if (blockName != null && blockName.length() > 0) {
            Block block = Block.func_149684_b((String)blockName);
            int data = nbt.func_74762_e(dataField);
            if (block == null) {
                block = Blocks.field_150344_f;
                data = 0;
            }
            IBlockState state = BaseBlockUtils.getBlockStateFromMeta(block, data);
            return state;
        }
        return null;
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        this.writeShapeToNBT(nbt);
        this.writeSecondaryMaterialToNBT(nbt);
        if (this.offsetX != 0) {
            nbt.func_74774_a("offsetX", this.offsetX);
        }
    }

    @Override
    public void writeToItemStackNBT(NBTTagCompound nbt) {
        this.writeShapeToNBT(nbt);
    }

    protected void writeShapeToNBT(NBTTagCompound nbt) {
        if (this.shape != null) {
            nbt.func_74768_a("Shape", this.shape.id);
            this.nbtSetBlockState(nbt, "BaseName", "BaseData", this.baseBlockState);
        }
        if (this.disabledConnections != 0) {
            nbt.func_74768_a("Disconnected", this.disabledConnections);
        }
    }

    protected void writeSecondaryMaterialToNBT(NBTTagCompound nbt) {
        this.nbtSetBlockState(nbt, "Name2", "Data2", this.secondaryBlockState);
    }

    protected void nbtSetBlockState(NBTTagCompound nbt, String nameField, String dataField, IBlockState state) {
        if (state != null) {
            Block block = state.getBlock();
            nbt.func_74778_a(nameField, BaseBlockUtils.getNameForBlock(block));
            nbt.func_74768_a(dataField, BaseBlockUtils.getMetaFromBlockState(state));
        }
    }

    public void onChiselUse(EntityPlayer player, EnumFacing face, float hitX, float hitY, float hitZ) {
        this.shape.kind.onChiselUse(this, player, face, this.hitVec(hitX, hitY, hitZ));
    }

    public void onHammerUse(EntityPlayer player, EnumFacing face, float hitX, float hitY, float hitZ) {
        this.shape.kind.onHammerUse(this, player, face, this.hitVec(hitX, hitY, hitZ));
    }

    protected Vector3 hitVec(float hitX, float hitY, float hitZ) {
        return new Vector3((double)hitX - 0.5, (double)hitY - 0.5, (double)hitZ - 0.5);
    }

    public EnumFacing globalFace(EnumFacing face) {
        return this.localToGlobalRotation().t(face);
    }

    public EnumFacing localFace(EnumFacing face) {
        return this.localToGlobalRotation().it(face);
    }

    public boolean applySecondaryMaterial(ItemStack stack, EntityPlayer player) {
        IBlockState materialState = null;
        Item item = stack.func_77973_b();
        if (item instanceof CladdingItem && this.shape.kind.acceptsCladding()) {
            materialState = ((CladdingItem)item).blockStateFromStack(stack);
        } else {
            IBlockState state;
            Block block = Block.func_149634_a((Item)item);
            if (block != null && this.shape.kind.isValidSecondaryMaterial(state = BaseBlockUtils.getBlockStateFromMeta(block, BaseUtils.getStackMetadata(stack)))) {
                materialState = state;
            }
        }
        if (materialState != null) {
            if (this.secondaryBlockState == null) {
                this.setSecondaryMaterial(materialState);
                if (!Utils.playerIsInCreativeMode(player)) {
                    --stack.field_77994_a;
                }
            }
            return true;
        }
        return false;
    }

    public void setSecondaryMaterial(IBlockState state) {
        this.secondaryBlockState = state;
        this.markChanged();
    }

    public boolean canRenderInLayer(EnumWorldBlockLayer layer) {
        if (BaseBlockUtils.blockCanRenderInLayer(this.baseBlockState.getBlock(), layer)) {
            return true;
        }
        if (this.secondaryBlockState != null) {
            return BaseBlockUtils.blockCanRenderInLayer(this.secondaryBlockState.getBlock(), layer);
        }
        return false;
    }

    public ShapeTE getNeighbourGlobal(EnumFacing dir) {
        return ShapeTE.get((IBlockAccess)this.field_145850_b, this.getPos().offset(dir));
    }

    public ShapeTE getConnectedNeighbourGlobal(EnumFacing dir) {
        ShapeTE nte;
        if (this.field_145850_b != null && this.connectionIsEnabledGlobal(dir) && (nte = this.getNeighbourGlobal(dir)) != null && nte.connectionIsEnabledGlobal(BaseUtils.oppositeFacing(dir))) {
            return nte;
        }
        return null;
    }
}

