/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.common.blocks.multiblock;

import com.brandon3055.draconicevolution.DraconicEvolution;
import com.brandon3055.draconicevolution.common.ModBlocks;
import com.brandon3055.draconicevolution.common.blocks.BlockDE;
import com.brandon3055.draconicevolution.common.lib.References;
import com.brandon3055.draconicevolution.common.tileentities.multiblocktiles.TileEnergyStorageCore;
import com.brandon3055.draconicevolution.common.utills.IHudDisplayBlock;
import com.brandon3055.draconicevolution.common.utills.LogHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Collections;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class EnergyStorageCore
extends BlockDE
implements IHudDisplayBlock,
ITileEntityProvider {
    public EnergyStorageCore() {
        super(Material.field_151573_f);
        this.func_149711_c(10.0f);
        this.func_149752_b(20.0f);
        this.func_149647_a(DraconicEvolution.tabBlocksItems);
        this.func_149663_c("energyStorageCore");
        ModBlocks.register(this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        this.field_149761_L = iconRegister.func_94245_a(References.RESOURCESPREFIX + "energy_storage_core");
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public boolean hasTileEntity(int metadata) {
        return true;
    }

    public TileEntity func_149915_a(World world, int metadata) {
        return new TileEnergyStorageCore();
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float subX, float subY, float subZ) {
        if (!world.field_72995_K) {
            TileEntity tile = world.func_147438_o(x, y, z);
            if (!(tile instanceof TileEnergyStorageCore)) {
                LogHelper.error("Missing Tile Entity (EnergyStorageCore)");
                return false;
            }
            TileEnergyStorageCore core = (TileEnergyStorageCore)tile;
            List<String> information = core.getDisplayInformation(false);
            for (String message : information) {
                player.func_146105_b((IChatComponent)new ChatComponentText(message));
            }
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_149646_a(IBlockAccess world, int x, int y, int z, int side) {
        ForgeDirection direction = ForgeDirection.getOrientation((int)side);
        TileEntity tile = world.func_147438_o(x - direction.offsetX, y - direction.offsetY, z - direction.offsetZ);
        if (!(tile instanceof TileEnergyStorageCore)) {
            LogHelper.error("Missing Tile Entity (EnergyStorageCore)(shouldSideBeRendered)");
            return true;
        }
        TileEnergyStorageCore core = (TileEnergyStorageCore)tile;
        return !core.isOnline() && super.func_149646_a(world, x, y, z, side);
    }

    public void func_149695_a(World world, int x, int y, int z, Block neighbor) {
        TileEnergyStorageCore core;
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TileEnergyStorageCore && (core = (TileEnergyStorageCore)tile).isOnline() && core.getTier() == 0) {
            core.validateStructure(false);
        }
    }

    public void func_149749_a(World world, int x, int y, int z, Block blockBroken, int metadata) {
        TileEnergyStorageCore core;
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TileEnergyStorageCore && (core = (TileEnergyStorageCore)tile).isOnline() && core.getTier() == 0) {
            core.deactivateStabilizers();
        }
        super.func_149749_a(world, x, y, z, blockBroken, metadata);
    }

    public AxisAlignedBB func_149633_g(World world, int x, int y, int z) {
        TileEnergyStorageCore core;
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TileEnergyStorageCore && (core = (TileEnergyStorageCore)tile).isOnline()) {
            return AxisAlignedBB.func_72330_a((double)((double)core.field_145851_c + 0.5), (double)((double)core.field_145848_d + 0.5), (double)((double)core.field_145849_e + 0.5), (double)((double)core.field_145851_c + 0.5), (double)((double)core.field_145848_d + 0.5), (double)((double)core.field_145849_e + 0.5));
        }
        return super.func_149633_g(world, x, y, z);
    }

    @Override
    public List<String> getDisplayData(World world, int x, int y, int z) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (!(tile instanceof TileEnergyStorageCore)) {
            LogHelper.error("Missing Tile Entity (EnergyStorageCore getDisplayData)");
            return Collections.emptyList();
        }
        TileEnergyStorageCore core = (TileEnergyStorageCore)tile;
        return core.getDisplayInformation(true);
    }
}

