/*
 * Decompiled with CFR 0.152.
 */
package modtweaker2.mods.thaumcraft.handlers;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IItemStack;
import modtweaker2.helpers.InputHelper;
import modtweaker2.mods.thaumcraft.ThaumcraftHelper;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;
import thaumcraft.api.ThaumcraftApi;

@ZenClass(value="mods.thaumcraft.Warp")
public class Warp {
    @ZenMethod
    public static void addToResearch(String key, int warp) {
        MineTweakerAPI.apply((IUndoableAction)new Add(key, warp));
    }

    @ZenMethod
    public static void addToItem(IItemStack stack, int warp) {
        MineTweakerAPI.apply((IUndoableAction)new Add(InputHelper.toStack(stack), warp));
    }

    @ZenMethod
    public static void removeFromResearch(String key) {
        MineTweakerAPI.apply((IUndoableAction)new Remove(key));
    }

    @ZenMethod
    public static void removeFromItem(IItemStack stack) {
        MineTweakerAPI.apply((IUndoableAction)new Remove(InputHelper.toStack(stack)));
    }

    @ZenMethod
    public static void removeAll() {
        MineTweakerAPI.apply((IUndoableAction)new MassRemove(RemoveType.BOTH));
    }

    @ZenMethod
    public static void removeAllResearch() {
        MineTweakerAPI.apply((IUndoableAction)new MassRemove(RemoveType.RESEARCH));
    }

    @ZenMethod
    public static void removeAllItems() {
        MineTweakerAPI.apply((IUndoableAction)new MassRemove(RemoveType.ITEMS));
    }

    private static class MassRemove
    implements IUndoableAction {
        HashMap<Object, Integer> oldMap = new HashMap();
        RemoveType type;

        public MassRemove(RemoveType typ) {
            this.type = typ;
        }

        public void apply() {
            block6: {
                block7: {
                    block5: {
                        if (this.type != RemoveType.BOTH) break block5;
                        for (Object key : ThaumcraftHelper.warpList.keySet()) {
                            this.oldMap.put(key, ThaumcraftHelper.warpList.get(key));
                        }
                        ThaumcraftHelper.warpList.clear();
                        break block6;
                    }
                    if (this.type != RemoveType.ITEMS) break block7;
                    for (Object key : ThaumcraftHelper.warpList.keySet()) {
                        if (!(key instanceof List)) continue;
                        this.oldMap.put(key, ThaumcraftHelper.warpList.get(key));
                    }
                    for (Object key : this.oldMap.keySet()) {
                        ThaumcraftHelper.warpList.remove(key);
                    }
                    break block6;
                }
                if (this.type != RemoveType.RESEARCH) break block6;
                for (Object key : ThaumcraftHelper.warpList.keySet()) {
                    if (!(key instanceof String)) continue;
                    this.oldMap.put(key, ThaumcraftHelper.warpList.get(key));
                }
                for (Object key : this.oldMap.keySet()) {
                    ThaumcraftHelper.warpList.remove(key);
                }
            }
        }

        public boolean canUndo() {
            return this.oldMap.size() > 0;
        }

        public String describe() {
            if (this.type == RemoveType.RESEARCH) {
                return "Clearing All Research Warp";
            }
            if (this.type == RemoveType.ITEMS) {
                return "Clearing All Item Warp";
            }
            return "Clearing All Warp";
        }

        public void undo() {
            for (Object key : this.oldMap.keySet()) {
                ThaumcraftHelper.warpList.put(key, this.oldMap.get(key));
            }
        }

        public String describeUndo() {
            if (this.type == RemoveType.RESEARCH) {
                return "Restoring All Research Warp";
            }
            if (this.type == RemoveType.ITEMS) {
                return "Restoring All Item Warp";
            }
            return "Restoring All Warp";
        }

        public Object getOverrideKey() {
            return null;
        }
    }

    public static enum RemoveType {
        RESEARCH,
        ITEMS,
        BOTH;

    }

    private static class Remove
    implements IUndoableAction {
        Object target;
        int warp;

        public Remove(Object targ) {
            this.target = targ;
        }

        public void apply() {
            if (this.target instanceof String) {
                this.warp = ThaumcraftHelper.warpList.remove(this.target);
            } else if (this.target instanceof ItemStack) {
                this.warp = ThaumcraftHelper.warpList.remove(Arrays.asList(((ItemStack)this.target).func_77973_b(), ((ItemStack)this.target).func_77960_j()));
            }
        }

        public boolean canUndo() {
            return this.warp > 0;
        }

        public String describe() {
            String desc = "Removing warp from ";
            if (this.target instanceof String) {
                desc = desc + (String)this.target;
            } else if (this.target instanceof ItemStack) {
                desc = desc + ((ItemStack)this.target).func_82833_r();
            }
            return desc;
        }

        public void undo() {
            if (this.target instanceof String) {
                ThaumcraftApi.addWarpToResearch((String)((String)this.target), (int)this.warp);
            } else if (this.target instanceof ItemStack) {
                ThaumcraftApi.addWarpToItem((ItemStack)((ItemStack)this.target), (int)this.warp);
            }
        }

        public String describeUndo() {
            String desc = "Restoring " + this.warp + " warp to ";
            if (this.target instanceof String) {
                desc = desc + (String)this.target;
            } else if (this.target instanceof ItemStack) {
                desc = desc + ((ItemStack)this.target).func_82833_r();
            }
            return desc;
        }

        public Object getOverrideKey() {
            return null;
        }
    }

    private static class Add
    implements IUndoableAction {
        Object target;
        int warp;

        public Add(Object targ, int amount) {
            this.target = targ;
            this.warp = amount;
        }

        public void apply() {
            if (this.target instanceof String) {
                ThaumcraftApi.addWarpToResearch((String)((String)this.target), (int)this.warp);
            } else if (this.target instanceof ItemStack) {
                ThaumcraftApi.addWarpToItem((ItemStack)((ItemStack)this.target), (int)this.warp);
            }
        }

        public boolean canUndo() {
            return ThaumcraftApi.getWarp((Object)this.target) > 0;
        }

        public String describe() {
            String desc = "Adding " + this.warp + " warp to ";
            if (this.target instanceof String) {
                desc = desc + (String)this.target;
            } else if (this.target instanceof ItemStack) {
                desc = desc + ((ItemStack)this.target).func_82833_r();
            }
            return desc;
        }

        public void undo() {
            if (this.target instanceof String) {
                ThaumcraftHelper.warpList.remove(this.target);
            } else if (this.target instanceof ItemStack) {
                ThaumcraftHelper.warpList.remove(Arrays.asList(((ItemStack)this.target).func_77973_b(), ((ItemStack)this.target).func_77960_j()));
            }
        }

        public String describeUndo() {
            String desc = "Removing warp from ";
            if (this.target instanceof String) {
                desc = desc + (String)this.target;
            } else if (this.target instanceof ItemStack) {
                desc = desc + ((ItemStack)this.target).func_82833_r();
            }
            return desc;
        }

        public Object getOverrideKey() {
            return null;
        }
    }
}

