/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.items;

import java.util.List;
import java.util.Locale;
import mods.railcraft.common.items.IItemMetaEnum;
import mods.railcraft.common.items.ItemRailcraft;
import mods.railcraft.common.items.RailcraftItem;
import mods.railcraft.common.plugins.forge.CraftingPlugin;
import mods.railcraft.common.plugins.forge.LootPlugin;
import mods.railcraft.common.plugins.forge.RailcraftRegistry;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraftforge.oredict.OreDictionary;

public class ItemGear
extends ItemRailcraft {
    public ItemGear() {
        this.func_77627_a(true);
        this.func_77656_e(0);
    }

    @Override
    public void initItem() {
        for (EnumGear gear : EnumGear.values()) {
            ItemStack stack = new ItemStack((Item)this, 1, gear.ordinal());
            RailcraftRegistry.register(stack);
        }
        OreDictionary.registerOre((String)"gearIron", (ItemStack)RailcraftItem.gear.getStack(1, EnumGear.IRON));
        ItemStack itemStack = new ItemStack((Item)this, 1, EnumGear.BUSHING.ordinal());
        LootPlugin.addLootRailway(itemStack, 1, 8, "gear.bushing");
    }

    @Override
    public void func_94581_a(IIconRegister iconRegister) {
        for (EnumGear gear : EnumGear.VALUES) {
            gear.icon = iconRegister.func_94245_a("railcraft:part.gear." + gear.name().toLowerCase(Locale.ENGLISH).replace("_", "."));
        }
    }

    public void func_150895_a(Item item, CreativeTabs tab, List list) {
        for (EnumGear gear : EnumGear.VALUES) {
            list.add(new ItemStack((Item)this, 1, gear.ordinal()));
        }
    }

    public IIcon func_77617_a(int damage) {
        if (damage < 0 || damage >= EnumGear.VALUES.length) {
            return EnumGear.IRON.icon;
        }
        return EnumGear.VALUES[damage].icon;
    }

    @Override
    public void defineRecipes() {
        ItemStack bushing = RailcraftItem.gear.getStack(EnumGear.BUSHING);
        RailcraftItem gear = RailcraftItem.gear;
        CraftingPlugin.addShapedRecipe(gear.getStack(2, EnumGear.BUSHING), "TT", "TT", Character.valueOf('T'), "ingotTin");
        CraftingPlugin.addShapedRecipe(gear.getStack(EnumGear.GOLD_PLATE), " G ", "GBG", " G ", Character.valueOf('G'), "nuggetGold", Character.valueOf('B'), bushing);
        CraftingPlugin.addShapedRecipe(gear.getStack(EnumGear.IRON), " I ", "IBI", " I ", Character.valueOf('I'), "ingotIron", Character.valueOf('B'), bushing);
        CraftingPlugin.addShapedRecipe(gear.getStack(EnumGear.STEEL), " I ", "IBI", " I ", Character.valueOf('I'), "ingotSteel", Character.valueOf('B'), bushing);
    }

    public String func_77667_c(ItemStack stack) {
        int damage = stack.func_77960_j();
        if (damage < 0 || damage >= EnumGear.VALUES.length) {
            return "";
        }
        switch (EnumGear.VALUES[damage]) {
            case GOLD_PLATE: {
                return "item.railcraft.part.gear.gold.plate";
            }
            case IRON: {
                return "item.railcraft.part.gear.iron";
            }
            case STEEL: {
                return "item.railcraft.part.gear.steel";
            }
            case BUSHING: {
                return "item.railcraft.part.gear.bushing";
            }
        }
        return "";
    }

    public static enum EnumGear implements IItemMetaEnum
    {
        GOLD_PLATE("ingotGold"),
        IRON("blockIron"),
        STEEL("blockSteel"),
        BUSHING("ingotTin");

        public static final EnumGear[] VALUES;
        private IIcon icon;
        private Object alternate;

        private EnumGear(Object alt) {
            this.alternate = alt;
        }

        @Override
        public Object getAlternate() {
            return this.alternate;
        }

        @Override
        public Class<? extends ItemRailcraft> getItemClass() {
            return ItemGear.class;
        }

        static {
            VALUES = EnumGear.values();
        }
    }
}

