/*
 * Decompiled with CFR 0.152.
 */
package squeek.spiceoflife.foodtracker;

import java.util.Set;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import squeek.applecore.api.food.FoodValues;
import squeek.spiceoflife.compat.IByteIO;
import squeek.spiceoflife.foodtracker.foodgroups.FoodGroup;
import squeek.spiceoflife.foodtracker.foodgroups.FoodGroupRegistry;
import squeek.spiceoflife.interfaces.IPackable;
import squeek.spiceoflife.interfaces.ISaveable;

public class FoodEaten
implements IPackable,
ISaveable {
    public static final FoodValues dummyFoodValues = new FoodValues(0, 0.0f);
    public FoodValues foodValues = dummyFoodValues;
    public ItemStack itemStack = null;

    public FoodEaten() {
    }

    public FoodEaten(ItemStack food) {
        this.itemStack = food;
    }

    public String toString() {
        return this.itemStack.func_82833_r();
    }

    public int hashCode() {
        return this.itemStack.func_77973_b().hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof FoodEaten)) {
            return false;
        }
        FoodEaten other = (FoodEaten)obj;
        Item item = this.itemStack.func_77973_b();
        Item otherItem = other.itemStack.func_77973_b();
        return Item.field_150901_e.func_148750_c((Object)item).equals(Item.field_150901_e.func_148750_c((Object)otherItem)) && item.equals(otherItem) && this.itemStack.func_77960_j() == other.itemStack.func_77960_j();
    }

    public static FoodEaten loadFromNBTData(NBTTagCompound nbtFood) {
        FoodEaten foodEaten = new FoodEaten();
        foodEaten.readFromNBTData(nbtFood);
        return foodEaten;
    }

    public Set<FoodGroup> getFoodGroups() {
        return FoodGroupRegistry.getFoodGroupsForFood(this.itemStack);
    }

    @Override
    public void writeToNBTData(NBTTagCompound nbtFood) {
        if (this.itemStack != null) {
            this.itemStack.func_77955_b(nbtFood);
        }
        if (this.foodValues != null && this.foodValues.hunger != 0) {
            nbtFood.func_74777_a("Hunger", (short)this.foodValues.hunger);
        }
        if (this.foodValues != null && this.foodValues.saturationModifier != 0.0f) {
            nbtFood.func_74776_a("Saturation", this.foodValues.saturationModifier);
        }
    }

    @Override
    public void readFromNBTData(NBTTagCompound nbtFood) {
        this.itemStack = ItemStack.func_77949_a((NBTTagCompound)nbtFood);
        this.foodValues = new FoodValues((int)nbtFood.func_74765_d("Hunger"), nbtFood.func_74760_g("Saturation"));
    }

    @Override
    public void pack(IByteIO data) {
        data.writeShort(this.foodValues != null ? this.foodValues.hunger : 0);
        data.writeFloat(this.foodValues != null ? this.foodValues.saturationModifier : 0.0f);
        data.writeItemStack(this.itemStack);
    }

    @Override
    public void unpack(IByteIO data) {
        short hunger = data.readShort();
        float saturationModifier = data.readFloat();
        this.foodValues = new FoodValues((int)hunger, saturationModifier);
        this.itemStack = data.readItemStack();
    }
}

