/*
 * Decompiled with CFR 0.152.
 */
package shukaro.warptheory.handlers.warpevents;

import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import shukaro.warptheory.handlers.IWorldTickWarpEvent;
import shukaro.warptheory.handlers.WarpHandler;
import shukaro.warptheory.util.BlockCoord;
import shukaro.warptheory.util.MiscHelper;
import shukaro.warptheory.util.NameMetaPair;
import shukaro.warptheory.util.RandomBlockHelper;

public class WarpDecay
extends IWorldTickWarpEvent {
    public WarpDecay(int minWarp) {
        super("biomeDecay", minWarp, world -> 512 + world.field_73012_v.nextInt(256));
    }

    @Override
    public boolean canDo(World world, EntityPlayer player) {
        for (String n : MiscHelper.getWarpTag(player).func_150296_c()) {
            if (!n.startsWith("biome") || n.equals(this.getName())) continue;
            return false;
        }
        return true;
    }

    @Override
    public int triggerEvent(int eventAmount, World world, EntityPlayer player) {
        BlockCoord target = RandomBlockHelper.randomBlock(world, player, 8, block -> MiscHelper.hasNonSolidNeighbor(world, block));
        if (target == null) {
            return 0;
        }
        NameMetaPair pair = new NameMetaPair(target.getBlock(world), target.getMeta(world));
        if (WarpHandler.decayMappings.containsKey(pair) || pair.getBlock() instanceof IPlantable || pair.getBlock().func_149688_o() == Material.field_151584_j) {
            NameMetaPair decayed = WarpHandler.decayMappings.get(pair);
            if (decayed == null) {
                decayed = new NameMetaPair(Blocks.field_150350_a, 0);
            }
            if (world.func_147465_d(target.x, target.y, target.z, decayed.getBlock(), decayed.getMetadata(), 3)) {
                if (target.isAir((IBlockAccess)world)) {
                    world.func_72889_a(null, 2001, target.x, target.y, target.z, Block.func_149682_b((Block)pair.getBlock()) + (pair.getMetadata() << 12));
                }
                return 1;
            }
        }
        return 0;
    }
}

