/*
 * Decompiled with CFR 0.152.
 */
package alkalus.main.core.util;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class AutoMap<V>
implements Iterable<V>,
Cloneable,
Serializable {
    private final Map<Integer, V> mInternalMap = new ConcurrentHashMap<Integer, V>();
    private int mInternalID = 0;
    private static final long serialVersionUID = 3771412318075131790L;

    @Override
    public Iterator<V> iterator() {
        return this.values().iterator();
    }

    public synchronized boolean setValue(V object) {
        int mOriginalID = this.mInternalID;
        this.put(object);
        return this.mInternalMap.get(mOriginalID).equals(object) || mOriginalID > this.mInternalID;
    }

    public synchronized V put(V object) {
        return this.set(object);
    }

    public synchronized V set(V object) {
        return this.mInternalMap.put(this.mInternalID++, object);
    }

    public synchronized V get(int id) {
        return this.mInternalMap.get(id);
    }

    public synchronized Collection<V> values() {
        return this.mInternalMap.values();
    }

    public synchronized int size() {
        return this.mInternalMap.size();
    }

    public synchronized int hashCode() {
        return this.mInternalMap.hashCode();
    }

    public synchronized boolean containsKey(int key) {
        return this.mInternalMap.containsKey(key);
    }

    public synchronized boolean containsValue(V value) {
        return this.mInternalMap.containsValue(value);
    }

    public synchronized boolean isEmpty() {
        return this.mInternalMap.isEmpty();
    }

    public synchronized boolean clear() {
        this.mInternalID = 0;
        this.mInternalMap.clear();
        return true;
    }

    public synchronized V[] toArray() {
        Collection<V> col = this.mInternalMap.values();
        Object[] val = col.toArray();
        return val;
    }
}

