/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.coremod;

import com.glodblock.github.coremod.transform.CraftingCpuTransformer;
import com.glodblock.github.coremod.transform.CraftingTreeNodeTransformer;
import com.glodblock.github.coremod.transform.DualityInterfaceTransformer;
import com.glodblock.github.coremod.transform.ExternalStorageRegistryTransformer;
import com.glodblock.github.coremod.transform.GuiCraftingTransformer;
import com.glodblock.github.coremod.transform.NEITransfermer;
import com.glodblock.github.coremod.transform.PacketCompressedNBTTransformer;
import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;

public class FCClassTransformer
implements IClassTransformer {
    public byte[] transform(String name, String transformedName, byte[] code) {
        ClassMapper tform;
        switch (transformedName) {
            case "appeng.crafting.CraftingTreeNode": {
                tform = CraftingTreeNodeTransformer.INSTANCE;
                break;
            }
            case "appeng.me.cluster.implementations.CraftingCPUCluster": {
                tform = CraftingCpuTransformer.INSTANCE;
                break;
            }
            case "appeng.helpers.DualityInterface": {
                tform = DualityInterfaceTransformer.INSTANCE;
                break;
            }
            case "appeng.client.gui.implementations.GuiCraftingCPU": 
            case "appeng.client.gui.implementations.GuiCraftConfirm": 
            case "net.p455w0rd.wirelesscraftingterminal.client.gui.GuiCraftConfirm": 
            case "appeng.client.gui.widgets.GuiCraftingTree": {
                tform = GuiCraftingTransformer.INSTANCE;
                break;
            }
            case "appeng.integration.modules.NEI": {
                tform = NEITransfermer.INSTANCE;
                break;
            }
            case "appeng.core.features.registries.ExternalStorageRegistry": {
                tform = ExternalStorageRegistryTransformer.INSTANCE;
                break;
            }
            case "appeng.core.sync.packets.PacketCompressedNBT": {
                tform = PacketCompressedNBTTransformer.INSTANCE;
                break;
            }
            default: {
                return code;
            }
        }
        System.out.println("[AE2FC] Transforming class: " + transformedName);
        return tform.transformClass(code);
    }

    public static interface Transform {
        public byte[] transformClass(byte[] var1);
    }

    public static abstract class ClassMapper
    implements Transform {
        @Override
        public byte[] transformClass(byte[] code) {
            ClassReader reader = new ClassReader(code);
            ClassWriter writer = new ClassWriter(reader, this.getWriteFlags());
            reader.accept(this.getClassMapper((ClassVisitor)writer), 8);
            return writer.toByteArray();
        }

        protected int getWriteFlags() {
            return 0;
        }

        protected abstract ClassVisitor getClassMapper(ClassVisitor var1);
    }
}

