/*
 * Decompiled with CFR 0.152.
 */
package de.eydamos.backpack.util;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import de.eydamos.backpack.inventory.InventoryPickup;
import de.eydamos.backpack.inventory.container.ContainerPickup;
import de.eydamos.backpack.item.ItemBackpackBase;
import de.eydamos.backpack.item.ItemsBackpack;
import de.eydamos.backpack.misc.ConfigurationBackpack;
import de.eydamos.backpack.saves.BackpackSave;
import de.eydamos.backpack.saves.PlayerSave;
import de.eydamos.backpack.util.NBTItemStackUtil;
import de.eydamos.backpack.util.NBTUtil;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;

public class BackpackUtil {
    public static void playOpenSound(Entity ent) {
        if (ConfigurationBackpack.PLAY_OPEN_SOUND) {
            String soundName = "Backpack:OpenBackpack";
            float volume = 0.7f;
            float maxSpeed = 0.2f;
            float minSpeed = 0.9f;
            ent.field_70170_p.func_72956_a(ent, soundName, volume, (float)(Math.random() * (double)maxSpeed + (double)minSpeed));
        }
    }

    public static boolean isEnderBackpack(ItemStack itemStack) {
        return itemStack != null && itemStack.func_77960_j() == 31999;
    }

    public static boolean isServerSide() {
        return FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER;
    }

    public static boolean isServerSide(World world) {
        return !world.field_72995_K;
    }

    public static String getUUID(NBTTagCompound nbtTagCompound) {
        if (NBTUtil.hasTag(nbtTagCompound, "backpack-UID")) {
            return NBTUtil.getString(nbtTagCompound, "backpack-UID");
        }
        return null;
    }

    public static byte getType(ItemStack backpack) {
        if (backpack.func_77973_b() == ItemsBackpack.backpack) {
            return 1;
        }
        if (backpack.func_77973_b() == ItemsBackpack.workbenchBackpack) {
            return 2;
        }
        return 0;
    }

    public static void pickupItem(EntityPlayer entityPlayer, ItemStack itemStack) {
        PlayerSave playerSave = new PlayerSave(entityPlayer);
        ItemStack backpack = playerSave.getPersonalBackpack();
        if (backpack != null) {
            InventoryPickup inventoryPickup = new InventoryPickup();
            inventoryPickup.setInventoryContent(backpack);
            ContainerPickup container = new ContainerPickup(ItemBackpackBase.getInventory(backpack, entityPlayer), new BackpackSave(backpack));
            boolean hasPickedUp = false;
            for (int i = 0; i < inventoryPickup.func_70302_i_(); ++i) {
                ItemStack pickupItemStack = inventoryPickup.func_70301_a(i);
                if (!BackpackUtil.areStacksEqual(pickupItemStack, itemStack, true)) continue;
                hasPickedUp = container.pickupItem(itemStack) || hasPickedUp;
            }
            if (hasPickedUp) {
                container.func_75134_a(entityPlayer);
            }
        }
    }

    public static boolean canStack(ItemStack stack1, ItemStack stack2) {
        return stack1 == null || stack2 == null || stack1.func_77973_b() == stack2.func_77973_b() && (!stack1.func_77981_g() || stack1.func_77960_j() == stack2.func_77960_j()) && ItemStack.func_77970_a((ItemStack)stack1, (ItemStack)stack2) && stack1.func_77985_e();
    }

    public static boolean areStacksEqual(ItemStack firstStack, ItemStack secondStack) {
        return BackpackUtil.areStacksEqual(firstStack, secondStack, false);
    }

    public static boolean areStacksEqual(ItemStack firstStack, ItemStack secondStack, boolean useOreDictionary) {
        if (firstStack == null || secondStack == null) {
            return false;
        }
        if (firstStack.func_77969_a(secondStack)) {
            return true;
        }
        if (!firstStack.func_77981_g() && !secondStack.func_77981_g() && firstStack.func_77973_b() == secondStack.func_77973_b()) {
            return true;
        }
        return useOreDictionary && BackpackUtil.areStacksEqualByOD(firstStack, secondStack);
    }

    public static boolean areStacksEqualByOD(ItemStack firstStack, ItemStack secondStack) {
        if (firstStack == null || secondStack == null) {
            return false;
        }
        int[] oreIdFirst = OreDictionary.getOreIDs((ItemStack)firstStack);
        int[] oreIdSecond = OreDictionary.getOreIDs((ItemStack)secondStack);
        for (int a : oreIdFirst) {
            for (int b : oreIdSecond) {
                if (a != b) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean UUIDEquals(ItemStack suspicious, ItemStack original) {
        if (suspicious != null && original != null && NBTItemStackUtil.hasTag(suspicious, "backpack-UID") && NBTItemStackUtil.hasTag(original, "backpack-UID")) {
            String UIDsuspicious = NBTItemStackUtil.getString(suspicious, "backpack-UID");
            String UIDoriginal = NBTItemStackUtil.getString(original, "backpack-UID");
            return BackpackUtil.UUIDEquals(UIDsuspicious, UIDoriginal);
        }
        return false;
    }

    public static boolean UUIDEquals(ItemStack suspicious, String original) {
        if (suspicious != null && original != null && NBTItemStackUtil.hasTag(suspicious, "backpack-UID")) {
            String UIDsuspicious = NBTItemStackUtil.getString(suspicious, "backpack-UID");
            return BackpackUtil.UUIDEquals(UIDsuspicious, original);
        }
        return false;
    }

    public static boolean UUIDEquals(String suspicious, String original) {
        if (suspicious != null && original != null) {
            try {
                UUID UIDsuspicious = UUID.fromString(suspicious);
                UUID UIDoriginal = UUID.fromString(original);
                return UIDsuspicious.equals(UIDoriginal);
            }
            catch (IllegalArgumentException e) {
                return false;
            }
        }
        return false;
    }
}

