/*
 * Decompiled with CFR 0.152.
 */
package com.github.bartimaeusnek.crossmod.thaumcraft.tile;

import com.github.bartimaeusnek.crossmod.thaumcraft.util.ThaumcraftHandler;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.items.GT_MetaBase_Item;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_BasicBatteryBuffer;
import gregtech.api.util.GT_ModHandler;
import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import net.minecraft.item.ItemStack;

public class GT_WandBuffer
extends GT_MetaTileEntity_BasicBatteryBuffer {
    public GT_WandBuffer(int aID, String aName, String aNameRegional, int aTier, String aDescription, int aSlotCount) {
        super(aID, aName, aNameRegional, aTier, aDescription, aSlotCount);
    }

    public GT_WandBuffer(String aName, int aTier, String aDescription, ITexture[][][] aTextures, int aSlotCount) {
        super(aName, aTier, aDescription, aTextures, aSlotCount);
    }

    public GT_WandBuffer(String aName, int aTier, String[] aDescription, ITexture[][][] aTextures, int aSlotCount) {
        super(aName, aTier, aDescription, aTextures, aSlotCount);
    }

    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        if (aBaseMetaTileEntity.isServerSide()) {
            this.mCharge = aBaseMetaTileEntity.getStoredEU() / 2L > aBaseMetaTileEntity.getEUCapacity() / 3L;
            this.mDecharge = aBaseMetaTileEntity.getStoredEU() < aBaseMetaTileEntity.getEUCapacity() / 3L;
            this.mBatteryCount = 0;
            this.mChargeableCount = 0;
            for (ItemStack tStack : this.mInventory) {
                if (!ThaumcraftHandler.isWand(tStack)) continue;
                ++this.mBatteryCount;
                ++this.mChargeableCount;
            }
        }
    }

    public boolean allowPullStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, byte aSide, ItemStack aStack) {
        return ThaumcraftHandler.isWand(aStack);
    }

    public boolean allowPutStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, byte aSide, ItemStack aStack) {
        return ThaumcraftHandler.isWand(aStack);
    }

    public int func_70297_j_() {
        return 1;
    }

    public long[] getStoredEnergy() {
        boolean scaleOverflow = false;
        boolean storedOverflow = false;
        long tScale = this.getBaseMetaTileEntity().getEUCapacity();
        long tStored = this.getBaseMetaTileEntity().getStoredEU();
        if (this.mInventory != null) {
            for (ItemStack aStack : this.mInventory) {
                if (!GT_ModHandler.isElectricItem((ItemStack)aStack)) continue;
                if (aStack.func_77973_b() instanceof GT_MetaBase_Item) {
                    Long[] stats = ((GT_MetaBase_Item)aStack.func_77973_b()).getElectricStats(aStack);
                    if (stats == null) continue;
                    if (stats[0] > 0x3FFFFFFFFFFFFFFFL) {
                        scaleOverflow = true;
                    }
                    tScale += stats[0].longValue();
                    long tStep = ((GT_MetaBase_Item)aStack.func_77973_b()).getRealCharge(aStack);
                    if (tStep > 0x3FFFFFFFFFFFFFFFL) {
                        storedOverflow = true;
                    }
                    tStored += tStep;
                    continue;
                }
                if (!(aStack.func_77973_b() instanceof IElectricItem)) continue;
                tStored += (long)ElectricItem.manager.getCharge(aStack);
                tScale += (long)((IElectricItem)aStack.func_77973_b()).getMaxCharge(aStack);
            }
        }
        if (scaleOverflow) {
            tScale = Long.MAX_VALUE;
        }
        if (storedOverflow) {
            tStored = Long.MAX_VALUE;
        }
        return new long[]{tStored, tScale};
    }
}

