/*
 * Decompiled with CFR 0.152.
 */
package com.caedis.duradisplay.config;

import com.caedis.duradisplay.config.OverlayConfig;
import crazypants.enderio.config.Config;
import gregtech.GT_Mod;
import java.io.File;
import java.util.Arrays;
import net.minecraft.launchwrapper.Launch;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;

public class DuraDisplayConfig {
    public static OverlayConfig.DurabilityOverlayConfig DurabilityConfig = new OverlayConfig.DurabilityOverlayConfig();
    public static OverlayConfig.ChargeOverlayConfig ChargeConfig = new OverlayConfig.ChargeOverlayConfig();
    public static final String CATEGORY_CHARGE = "charge";
    public static final String CATEGORY_DURABILITY = "durability";
    private static boolean configLoaded = false;
    public static boolean Enable = true;
    public static Configuration config = null;

    public static void loadConfig() {
        if (configLoaded) {
            return;
        }
        configLoaded = true;
        File configDir = new File(Launch.minecraftHome, "config");
        if (!configDir.isDirectory()) {
            configDir.mkdirs();
        }
        File configFile = new File(configDir, "duradisplay.cfg");
        config = new Configuration(configFile);
        DuraDisplayConfig.reloadConfigObject();
        if (config.hasChanged()) {
            config.save();
        }
    }

    public static void reloadConfigObject() {
        Enable = config.getBoolean("Enable", "general", Enable, "Enable/disable the entire mod");
        DuraDisplayConfig.DurabilityConfig.Enabled = config.getBoolean("Enable", CATEGORY_DURABILITY, DuraDisplayConfig.DurabilityConfig.Enabled, "Enable durability module");
        DuraDisplayConfig.DurabilityConfig.RenderBar = config.getBoolean("RenderBar", CATEGORY_DURABILITY, DuraDisplayConfig.DurabilityConfig.RenderBar, "Render durability bar");
        DuraDisplayConfig.ChargeConfig.Enabled = config.getBoolean("Enable", CATEGORY_CHARGE, DuraDisplayConfig.ChargeConfig.Enabled, "Enable charge module");
        DuraDisplayConfig.ChargeConfig.RenderBar = config.getBoolean("RenderBar", CATEGORY_CHARGE, DuraDisplayConfig.ChargeConfig.RenderBar, "Render charge bar");
        DuraDisplayConfig.DurabilityConfig.Position = config.getInt("Position", CATEGORY_DURABILITY, DuraDisplayConfig.DurabilityConfig.Position, 1, 9, "Location in item where the durability percentage will be (numpad style)");
        DuraDisplayConfig.ChargeConfig.Position = config.getInt("Position", CATEGORY_CHARGE, DuraDisplayConfig.ChargeConfig.Position, 1, 9, "Location in item where the charge percentage will be (numpad style)");
        DuraDisplayConfig.DurabilityConfig.ShowWhenFull = config.getBoolean("ShowWhenFull", CATEGORY_DURABILITY, DuraDisplayConfig.DurabilityConfig.ShowWhenFull, "Show durability percentage when item is undamaged/full");
        DuraDisplayConfig.ChargeConfig.ShowWhenFull = config.getBoolean("ShowWhenFull", CATEGORY_CHARGE, DuraDisplayConfig.ChargeConfig.ShowWhenFull, "Show charge percentage when item is full");
        DuraDisplayConfig.DurabilityConfig.UseColorThreshold = config.getBoolean("UseColorThreshold", CATEGORY_DURABILITY, DuraDisplayConfig.DurabilityConfig.UseColorThreshold, "Use the color thresholds instead of the default gradient coloring.");
        DuraDisplayConfig.ChargeConfig.UseColorThreshold = config.getBoolean("UseColorThreshold", CATEGORY_CHARGE, DuraDisplayConfig.ChargeConfig.UseColorThreshold, "Use the color thresholds instead of the static blue color.");
        Property dura_colorThresh = config.get(CATEGORY_DURABILITY, "ColorThresholds", DuraDisplayConfig.DurabilityConfig.ColorThreshold, "List of numbers in ascending order from 0-100 that set the thresholds for durability color mapping. Colors are from Red -> Yellow -> Green with Red being less than or equal to the first value and Green being greater than or equal to the last value");
        DuraDisplayConfig.DurabilityConfig.ColorThreshold = dura_colorThresh.getDoubleList();
        DuraDisplayConfig.DurabilityConfig.ColorThreshold = Arrays.stream(DuraDisplayConfig.DurabilityConfig.ColorThreshold).filter(num -> num >= 0.0 && num <= 100.0).sorted().toArray();
        dura_colorThresh.set(DuraDisplayConfig.DurabilityConfig.ColorThreshold);
        Property charge_colorThresh = config.get(CATEGORY_CHARGE, "ColorThresholds", DuraDisplayConfig.ChargeConfig.ColorThreshold, "List of numbers in ascending order from 0-100 that set the thresholds for charge color mapping. Colors are from Red -> Orange -> Blue with Red being less than or equal to the first value and Blue being greater than or equal to the last value");
        DuraDisplayConfig.ChargeConfig.ColorThreshold = charge_colorThresh.getDoubleList();
        DuraDisplayConfig.ChargeConfig.ColorThreshold = Arrays.stream(DuraDisplayConfig.ChargeConfig.ColorThreshold).filter(num -> num >= 0.0 && num <= 100.0).sorted().toArray();
        charge_colorThresh.set(DuraDisplayConfig.ChargeConfig.ColorThreshold);
        if (config.hasChanged()) {
            config.save();
        }
        GT_Mod.gregtechproxy.mRenderItemDurabilityBar = Enable && (!DuraDisplayConfig.DurabilityConfig.Enabled || DuraDisplayConfig.DurabilityConfig.RenderBar);
        GT_Mod.gregtechproxy.mRenderItemChargeBar = Enable && (!DuraDisplayConfig.ChargeConfig.Enabled || DuraDisplayConfig.ChargeConfig.RenderBar);
        Config.renderChargeBar = Enable && (!DuraDisplayConfig.ChargeConfig.Enabled || DuraDisplayConfig.ChargeConfig.RenderBar);
        Config.renderDurabilityBar = Enable && (!DuraDisplayConfig.DurabilityConfig.Enabled || DuraDisplayConfig.DurabilityConfig.RenderBar);
    }
}

