/*
 * Decompiled with CFR 0.152.
 */
package bloodasp.galacticgreg.auxiliary;

import cpw.mods.fml.common.FMLLog;
import java.util.ArrayList;
import org.apache.logging.log4j.Level;

public final class LogHelper {
    private ArrayList<String> _mReportedCategories = new ArrayList();
    private boolean doDebugLogs = false;
    private boolean doTraceLogs = false;
    private boolean quietMode = false;
    private String _mModID = "";
    private static final String STR_NOCAT = "ihaznocathegory";
    private static final String STR_TOKEN_ONETIMEMESSAGE = " OTM";

    public LogHelper(String pModID) {
        this._mModID = pModID;
    }

    public void setQuietMode(boolean pEnabled) {
        this.quietMode = pEnabled;
    }

    public void setDebugOutput(boolean pEnabled) {
        this.doDebugLogs = pEnabled;
    }

    public void setTraceOutput(boolean pEnabled) {
        this.doTraceLogs = pEnabled;
    }

    public void ResetCategories() {
        this._mReportedCategories = new ArrayList();
    }

    public void log(String pCategory, Level pLogLevel, String pMessage, Object ... args) {
        if (pLogLevel == Level.DEBUG && !this.doDebugLogs) {
            return;
        }
        if (pLogLevel == Level.TRACE && !this.doTraceLogs) {
            return;
        }
        if (pLogLevel != Level.ERROR && pLogLevel != Level.FATAL && pLogLevel != Level.WARN && this.quietMode) {
            return;
        }
        String tt = "";
        if (!pCategory.equals(STR_NOCAT)) {
            tt = STR_TOKEN_ONETIMEMESSAGE;
            if (this._mReportedCategories.contains(pCategory)) {
                return;
            }
            this._mReportedCategories.add(pCategory);
        }
        FMLLog.log((String)(this._mModID.toUpperCase() + tt), (Level)pLogLevel, (String)pMessage, (Object[])args);
    }

    public void ot_all(String pCategory, String object, Object ... args) {
        this.log(pCategory, Level.ALL, object, args);
    }

    public void ot_debug(String pCategory, String object, Object ... args) {
        this.log(pCategory, Level.DEBUG, object, args);
    }

    public void ot_error(String pCategory, String object, Object ... args) {
        this.log(pCategory, Level.ERROR, object, args);
    }

    public void ot_fatal(String pCategory, String object, Object ... args) {
        this.log(pCategory, Level.FATAL, object, args);
    }

    public void ot_info(String pCategory, String object, Object ... args) {
        this.log(pCategory, Level.INFO, object, args);
    }

    public void ot_off(String pCategory, String object, Object ... args) {
        this.log(pCategory, Level.OFF, object, args);
    }

    public void ot_trace(String pCategory, String object, Object ... args) {
        this.log(pCategory, Level.TRACE, object, args);
    }

    public void ot_warn(String pCategory, String object, Object ... args) {
        this.log(pCategory, Level.WARN, object, args);
    }

    public void all(String object, Object ... args) {
        this.log(STR_NOCAT, Level.ALL, object, args);
    }

    public void debug(String object, Object ... args) {
        this.log(STR_NOCAT, Level.DEBUG, object, args);
    }

    public void error(String object, Object ... args) {
        this.log(STR_NOCAT, Level.ERROR, object, args);
    }

    public void fatal(String object, Object ... args) {
        this.log(STR_NOCAT, Level.FATAL, object, args);
    }

    public void info(String object, Object ... args) {
        this.log(STR_NOCAT, Level.INFO, object, args);
    }

    public void off(String object, Object ... args) {
        this.log(STR_NOCAT, Level.OFF, object, args);
    }

    public void trace(String object, Object ... args) {
        this.log(STR_NOCAT, Level.TRACE, object, args);
    }

    public void warn(String object, Object ... args) {
        this.log(STR_NOCAT, Level.WARN, object, args);
    }
}

