/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.multitileentity.multiblock.base;

import gregtech.api.enums.GT_Values;
import gregtech.api.logic.PowerLogic;
import gregtech.api.logic.interfaces.PowerLogicHost;
import gregtech.api.multitileentity.multiblock.base.Controller;
import gregtech.api.util.GT_Utility;
import java.util.List;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class PowerController<T extends PowerController<T>>
extends Controller<T>
implements PowerLogicHost {
    protected PowerLogic power = new PowerLogic().setType(PowerLogic.RECEIVER);

    @Override
    public void writeMultiTileNBT(NBTTagCompound nbt) {
        super.writeMultiTileNBT(nbt);
        this.power.writeToNBT(nbt);
    }

    @Override
    public void readMultiTileNBT(NBTTagCompound nbt) {
        super.readMultiTileNBT(nbt);
        this.power.loadFromNBT(nbt);
    }

    @Override
    public PowerLogic getPowerLogic(ForgeDirection side) {
        return this.power;
    }

    @Override
    public boolean checkMachine() {
        boolean result = super.checkMachine();
        this.power.setEnergyCapacity(GT_Values.V[this.tier] * 2L * 60L * 20L);
        this.power.setAmperage(2L);
        this.power.setMaxVoltage(GT_Values.V[this.tier]);
        return result;
    }

    @Override
    public void getWailaNBTData(EntityPlayerMP player, TileEntity tile, NBTTagCompound tag, World world, int x, int y, int z) {
        super.getWailaNBTData(player, tile, tag, world, x, y, z);
        tag.func_74757_a("isActive", this.isActive());
        if (this.isActive()) {
            tag.func_74772_a("energyUsage", this.eut);
            tag.func_74772_a("energyTier", (long)this.tier);
        }
    }

    @Override
    public void getWailaBody(ItemStack itemStack, List<String> currentTip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        super.getWailaBody(itemStack, currentTip, accessor, config);
        NBTTagCompound tag = accessor.getNBTData();
        boolean isActive = tag.func_74767_n("isActive");
        if (isActive) {
            long energyTier = tag.func_74763_f("energyTier");
            long actualEnergyUsage = tag.func_74763_f("energyUsage");
            if (actualEnergyUsage > 0L) {
                currentTip.add(StatCollector.func_74837_a((String)"GT5U.waila.energy.use_with_amperage", (Object[])new Object[]{GT_Utility.formatNumbers(actualEnergyUsage), GT_Utility.getAmperageForTier(actualEnergyUsage, (byte)energyTier), GT_Utility.getColoredTierNameFromTier((byte)energyTier)}));
            } else if (actualEnergyUsage < 0L) {
                currentTip.add(StatCollector.func_74837_a((String)"GT5U.waila.energy.produce_with_amperage", (Object[])new Object[]{GT_Utility.formatNumbers(-actualEnergyUsage), GT_Utility.getAmperageForTier(-actualEnergyUsage, (byte)energyTier), GT_Utility.getColoredTierNameFromTier((byte)energyTier)}));
            }
        }
    }
}

