/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.util;

import appeng.util.ReadableNumberConverter;
import codechicken.lib.gui.GuiDraw;
import codechicken.nei.PositionedStack;
import com.google.common.collect.Iterables;
import com.gtnewhorizons.modularui.api.GlStateManager;
import com.gtnewhorizons.modularui.api.ModularUITextures;
import com.gtnewhorizons.modularui.api.drawable.FallbackableUITexture;
import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.drawable.UITexture;
import com.gtnewhorizons.modularui.api.forge.IItemHandlerModifiable;
import com.gtnewhorizons.modularui.api.math.Alignment;
import com.gtnewhorizons.modularui.api.math.Pos2d;
import com.gtnewhorizons.modularui.api.math.Size;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.common.widget.DrawableWidget;
import com.gtnewhorizons.modularui.common.widget.ProgressBar;
import com.gtnewhorizons.modularui.common.widget.SlotWidget;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModContainer;
import gnu.trove.map.TByteObjectMap;
import gnu.trove.map.hash.TByteObjectHashMap;
import gregtech.GT_Mod;
import gregtech.api.GregTech_API;
import gregtech.api.enums.ConfigCategories;
import gregtech.api.enums.Dyes;
import gregtech.api.enums.Element;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Mods;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.enums.SteamVariant;
import gregtech.api.enums.SubTag;
import gregtech.api.gui.GT_GUIColorOverride;
import gregtech.api.gui.modularui.FallbackableSteamTexture;
import gregtech.api.gui.modularui.GT_UITextures;
import gregtech.api.gui.modularui.SteamTexture;
import gregtech.api.interfaces.IGT_RecipeMap;
import gregtech.api.interfaces.tileentity.IHasWorldObjectAndCoords;
import gregtech.api.objects.GT_ItemStack;
import gregtech.api.objects.ItemData;
import gregtech.api.objects.MaterialStack;
import gregtech.api.recipe.check.FindRecipeResult;
import gregtech.api.util.GT_Config;
import gregtech.api.util.GT_LanguageManager;
import gregtech.api.util.GT_Log;
import gregtech.api.util.GT_ModHandler;
import gregtech.api.util.GT_OreDictUnificator;
import gregtech.api.util.GT_RecipeBuilder;
import gregtech.api.util.GT_RecipeConstants;
import gregtech.api.util.GT_RecipeMapUtil;
import gregtech.api.util.GT_Utility;
import gregtech.api.util.extensions.ArrayExt;
import gregtech.common.gui.modularui.UIHelper;
import gregtech.common.items.GT_FluidDisplayItem;
import gregtech.common.misc.spaceprojects.SpaceProjectManager;
import gregtech.common.misc.spaceprojects.interfaces.ISpaceProject;
import gregtech.common.power.EUPower;
import gregtech.common.power.Power;
import gregtech.common.power.UnspecifiedEUPower;
import gregtech.common.tileentities.machines.basic.GT_MetaTileEntity_Replicator;
import gregtech.nei.FusionSpecialValueFormatter;
import gregtech.nei.GT_NEI_DefaultHandler;
import gregtech.nei.HeatingCoilSpecialValueFormatter;
import gregtech.nei.INEISpecialInfoFormatter;
import gregtech.nei.NEIRecipeInfo;
import ic2.api.recipe.Recipes;
import ic2.core.Ic2Items;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mods.railcraft.api.crafting.RailcraftCraftingManager;
import mods.railcraft.common.blocks.aesthetics.cube.EnumCube;
import mods.railcraft.common.items.RailcraftToolItems;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class GT_Recipe
implements Comparable<GT_Recipe> {
    public ItemStack[] mInputs;
    public ItemStack[] mOutputs;
    public FluidStack[] mFluidInputs;
    public FluidStack[] mFluidOutputs;
    public int[] mChances;
    public Object mSpecialItems;
    public int mDuration;
    public int mEUt;
    public int mSpecialValue;
    public boolean mEnabled;
    public boolean mHidden;
    public boolean mFakeRecipe;
    public boolean mCanBeBuffered;
    public boolean mNeedsEmptyOutput;
    public boolean isNBTSensitive;
    private String[] neiDesc;
    public List<ModContainer> owners;
    public List<List<StackTraceElement>> stackTraces;
    public static boolean GTppRecipeHelper;

    private GT_Recipe(GT_Recipe aRecipe, boolean shallow) {
        this.mEnabled = true;
        this.mHidden = false;
        this.mFakeRecipe = false;
        this.mCanBeBuffered = true;
        this.mNeedsEmptyOutput = false;
        this.isNBTSensitive = false;
        this.neiDesc = null;
        this.owners = new ArrayList<ModContainer>();
        this.stackTraces = new ArrayList<List<StackTraceElement>>();
        this.mInputs = shallow ? aRecipe.mInputs : GT_Utility.copyItemArray(aRecipe.mInputs);
        this.mOutputs = shallow ? aRecipe.mOutputs : GT_Utility.copyItemArray(aRecipe.mOutputs);
        this.mSpecialItems = aRecipe.mSpecialItems;
        this.mChances = aRecipe.mChances;
        this.mFluidInputs = shallow ? aRecipe.mFluidInputs : GT_Utility.copyFluidArray(aRecipe.mFluidInputs);
        this.mFluidOutputs = shallow ? aRecipe.mFluidOutputs : GT_Utility.copyFluidArray(aRecipe.mFluidOutputs);
        this.mDuration = aRecipe.mDuration;
        this.mSpecialValue = aRecipe.mSpecialValue;
        this.mEUt = aRecipe.mEUt;
        this.mNeedsEmptyOutput = aRecipe.mNeedsEmptyOutput;
        this.mCanBeBuffered = aRecipe.mCanBeBuffered;
        this.mFakeRecipe = aRecipe.mFakeRecipe;
        this.mEnabled = aRecipe.mEnabled;
        this.mHidden = aRecipe.mHidden;
        this.owners = new ArrayList<ModContainer>(aRecipe.owners);
        this.reloadOwner();
    }

    GT_Recipe(ItemStack[] mInputs, ItemStack[] mOutputs, FluidStack[] mFluidInputs, FluidStack[] mFluidOutputs, int[] mChances, Object mSpecialItems, int mDuration, int mEUt, int mSpecialValue, boolean mEnabled, boolean mHidden, boolean mFakeRecipe, boolean mCanBeBuffered, boolean mNeedsEmptyOutput, String[] neiDesc) {
        this.mEnabled = true;
        this.mHidden = false;
        this.mFakeRecipe = false;
        this.mCanBeBuffered = true;
        this.mNeedsEmptyOutput = false;
        this.isNBTSensitive = false;
        this.neiDesc = null;
        this.owners = new ArrayList<ModContainer>();
        this.stackTraces = new ArrayList<List<StackTraceElement>>();
        this.mInputs = mInputs;
        this.mOutputs = mOutputs;
        this.mFluidInputs = mFluidInputs;
        this.mFluidOutputs = mFluidOutputs;
        this.mChances = mChances;
        this.mSpecialItems = mSpecialItems;
        this.mDuration = mDuration;
        this.mEUt = mEUt;
        this.mSpecialValue = mSpecialValue;
        this.mEnabled = mEnabled;
        this.mHidden = mHidden;
        this.mFakeRecipe = mFakeRecipe;
        this.mCanBeBuffered = mCanBeBuffered;
        this.mNeedsEmptyOutput = mNeedsEmptyOutput;
        this.neiDesc = neiDesc;
        this.reloadOwner();
    }

    public GT_Recipe(boolean aOptimize, ItemStack[] aInputs, ItemStack[] aOutputs, Object aSpecialItems, int[] aChances, FluidStack[] aFluidInputs, FluidStack[] aFluidOutputs, int aDuration, int aEUt, int aSpecialValue) {
        int i;
        this.mEnabled = true;
        this.mHidden = false;
        this.mFakeRecipe = false;
        this.mCanBeBuffered = true;
        this.mNeedsEmptyOutput = false;
        this.isNBTSensitive = false;
        this.neiDesc = null;
        this.owners = new ArrayList<ModContainer>();
        this.stackTraces = new ArrayList<List<StackTraceElement>>();
        if (aInputs == null) {
            aInputs = new ItemStack[]{};
        }
        if (aOutputs == null) {
            aOutputs = new ItemStack[]{};
        }
        if (aFluidInputs == null) {
            aFluidInputs = new FluidStack[]{};
        }
        if (aFluidOutputs == null) {
            aFluidOutputs = new FluidStack[]{};
        }
        if (aChances == null) {
            aChances = new int[aOutputs.length];
        }
        if (aChances.length < aOutputs.length) {
            aChances = Arrays.copyOf(aChances, aOutputs.length);
        }
        aInputs = ArrayExt.withoutTrailingNulls(aInputs, ItemStack[]::new);
        aOutputs = ArrayExt.withoutTrailingNulls(aOutputs, ItemStack[]::new);
        aFluidInputs = ArrayExt.withoutNulls(aFluidInputs, FluidStack[]::new);
        aFluidOutputs = ArrayExt.withoutNulls(aFluidOutputs, FluidStack[]::new);
        GT_OreDictUnificator.setStackArray(true, aInputs);
        GT_OreDictUnificator.setStackArray(true, aOutputs);
        for (ItemStack tStack : aOutputs) {
            GT_Utility.updateItemStack(tStack);
        }
        for (i = 0; i < aChances.length; ++i) {
            if (aChances[i] > 0) continue;
            aChances[i] = 10000;
        }
        for (i = 0; i < aFluidInputs.length; ++i) {
            aFluidInputs[i] = aFluidInputs[i].copy();
        }
        for (i = 0; i < aFluidOutputs.length; ++i) {
            aFluidOutputs[i] = aFluidOutputs[i].copy();
        }
        for (ItemStack aInput : aInputs) {
            if (aInput == null || Items.field_151008_G.getDamage(aInput) == Short.MAX_VALUE) continue;
            for (int j = 0; j < aOutputs.length; ++j) {
                if (!GT_Utility.areStacksEqual(aInput, aOutputs[j]) || aChances[j] < 10000) continue;
                if (aInput.field_77994_a >= aOutputs[j].field_77994_a) {
                    aInput.field_77994_a -= aOutputs[j].field_77994_a;
                    aOutputs[j] = null;
                    continue;
                }
                aOutputs[j].field_77994_a -= aInput.field_77994_a;
            }
        }
        if (aOptimize && aDuration >= 32) {
            ArrayList<ItemStack> tList = new ArrayList<ItemStack>();
            tList.addAll(Arrays.asList(aInputs));
            tList.addAll(Arrays.asList(aOutputs));
            for (int i2 = 0; i2 < tList.size(); ++i2) {
                if (tList.get(i2) != null) continue;
                tList.remove(i2--);
            }
            for (byte i2 = (byte)Math.min(64, aDuration / 16); i2 > 1; i2 = (byte)(i2 - 1)) {
                if (aDuration / i2 < 16) continue;
                boolean temp = true;
                for (ItemStack stack : tList) {
                    if (stack.field_77994_a % i2 == 0) continue;
                    temp = false;
                    break;
                }
                if (temp) {
                    for (FluidStack fluidStack : aFluidInputs) {
                        if (fluidStack.amount % i2 == 0) continue;
                        temp = false;
                        break;
                    }
                }
                if (temp) {
                    for (FluidStack fluidStack : aFluidOutputs) {
                        if (fluidStack.amount % i2 == 0) continue;
                        temp = false;
                        break;
                    }
                }
                if (!temp) continue;
                for (ItemStack itemStack : tList) {
                    itemStack.field_77994_a /= i2;
                }
                for (FluidStack fluidStack : aFluidInputs) {
                    fluidStack.amount /= i2;
                }
                for (FluidStack fluidStack : aFluidOutputs) {
                    fluidStack.amount /= i2;
                }
                aDuration /= i2;
            }
        }
        this.mInputs = aInputs;
        this.mOutputs = aOutputs;
        this.mSpecialItems = aSpecialItems;
        this.mChances = aChances;
        this.mFluidInputs = aFluidInputs;
        this.mFluidOutputs = aFluidOutputs;
        this.mDuration = aDuration;
        this.mSpecialValue = aSpecialValue;
        this.mEUt = aEUt;
        this.reloadOwner();
    }

    public GT_Recipe(ItemStack aInput1, ItemStack aOutput1, int aFuelValue, int aType) {
        this(aInput1, aOutput1, null, null, null, aFuelValue, aType);
    }

    private static FluidStack[] tryGetFluidInputsFromCells(ItemStack aInput) {
        FluidStack[] fluidStackArray;
        FluidStack tFluid = GT_Utility.getFluidForFilledItem(aInput, true);
        if (tFluid == null) {
            fluidStackArray = null;
        } else {
            FluidStack[] fluidStackArray2 = new FluidStack[1];
            fluidStackArray = fluidStackArray2;
            fluidStackArray2[0] = tFluid;
        }
        return fluidStackArray;
    }

    public GT_Recipe(ItemStack aInput1, ItemStack aOutput1, ItemStack aOutput2, ItemStack aOutput3, ItemStack aOutput4, int aSpecialValue, int aType) {
        this(true, new ItemStack[]{aInput1}, new ItemStack[]{aOutput1, aOutput2, aOutput3, aOutput4}, null, null, null, null, 0, 0, Math.max(1, aSpecialValue));
        if (this.mInputs.length > 0 && aSpecialValue > 0) {
            switch (aType) {
                case 0: {
                    GT_Recipe_Map.sDieselFuels.addRecipe(this);
                    GT_Recipe_Map.sLargeBoilerFakeFuels.addDieselRecipe(this);
                    break;
                }
                case 1: {
                    GT_Recipe_Map.sTurbineFuels.addRecipe(this);
                    break;
                }
                case 2: {
                    GT_Recipe_Map.sHotFuels.addRecipe(this);
                    break;
                }
                case 4: {
                    GT_Recipe_Map.sPlasmaFuels.addRecipe(this);
                    break;
                }
                case 5: {
                    GT_Recipe_Map.sMagicFuels.addRecipe(this);
                    break;
                }
                default: {
                    GT_Recipe_Map.sDenseLiquidFuels.addRecipe(this);
                    GT_Recipe_Map.sLargeBoilerFakeFuels.addDenseLiquidRecipe(this);
                }
            }
        }
    }

    public GT_Recipe(FluidStack aInput1, FluidStack aInput2, FluidStack aOutput1, int aDuration, int aEUt, int aSpecialValue) {
        this(true, null, null, null, null, new FluidStack[]{aInput1, aInput2}, new FluidStack[]{aOutput1}, Math.max(aDuration, 1), aEUt, Math.max(Math.min(aSpecialValue, 160000000), 0));
        if (this.mInputs.length > 1) {
            GT_Recipe_Map.sFusionRecipes.addRecipe(this);
        }
    }

    public GT_Recipe(ItemStack aInput1, ItemStack aOutput1, ItemStack aOutput2, int aDuration, int aEUt) {
        this(true, new ItemStack[]{aInput1}, new ItemStack[]{aOutput1, aOutput2}, null, null, null, null, aDuration, aEUt, 0);
        if (this.mInputs.length > 0 && this.mOutputs[0] != null) {
            GT_Recipe_Map.sLatheRecipes.addRecipe(this);
        }
    }

    public GT_Recipe(ItemStack aInput1, int aCellAmount, ItemStack aOutput1, ItemStack aOutput2, ItemStack aOutput3, ItemStack aOutput4, int aDuration, int aEUt) {
        this(true, new ItemStack[]{aInput1, aCellAmount > 0 ? ItemList.Cell_Empty.get(Math.min(64, Math.max(1, aCellAmount)), new Object[0]) : null}, new ItemStack[]{aOutput1, aOutput2, aOutput3, aOutput4}, null, null, null, null, Math.max(aDuration, 1), Math.max(aEUt, 1), 0);
        if (this.mInputs.length > 0 && this.mOutputs[0] != null) {
            GT_Recipe_Map.sDistillationRecipes.addRecipe(this);
        }
    }

    public GT_Recipe(ItemStack aInput1, int aInput2, ItemStack aOutput1, ItemStack aOutput2) {
        this(true, new ItemStack[]{aInput1, GT_ModHandler.getIC2Item("industrialTnt", aInput2 > 0 ? (long)Math.min(aInput2, 64) : 1L, new ItemStack(Blocks.field_150335_W, aInput2 > 0 ? Math.min(aInput2, 64) : 1))}, new ItemStack[]{aOutput1, aOutput2}, null, null, null, null, 20, 30, 0);
        if (this.mInputs.length > 0 && this.mOutputs[0] != null) {
            GT_Recipe_Map.sImplosionRecipes.addRecipe(this);
        }
    }

    public GT_Recipe(int aEUt, int aDuration, ItemStack aInput1, ItemStack aOutput1) {
        this(true, new ItemStack[]{aInput1, ItemList.Circuit_Integrated.getWithDamage(0L, aInput1.field_77994_a, new Object[0])}, new ItemStack[]{aOutput1}, null, null, null, null, Math.max(aDuration, 1), Math.max(aEUt, 1), 0);
        if (this.mInputs.length > 0 && this.mOutputs[0] != null) {
            GT_Recipe_Map.sBenderRecipes.addRecipe(this);
        }
    }

    public GT_Recipe(ItemStack aInput1, ItemStack aInput2, int aEUt, int aDuration, ItemStack aOutput1) {
        ItemStack[] itemStackArray;
        if (aInput2 == null) {
            ItemStack[] itemStackArray2 = new ItemStack[1];
            itemStackArray = itemStackArray2;
            itemStackArray2[0] = aInput1;
        } else {
            ItemStack[] itemStackArray3 = new ItemStack[2];
            itemStackArray3[0] = aInput1;
            itemStackArray = itemStackArray3;
            itemStackArray3[1] = aInput2;
        }
        this(true, itemStackArray, new ItemStack[]{aOutput1}, null, null, null, null, Math.max(aDuration, 1), Math.max(aEUt, 1), 0);
        if (this.mInputs.length > 0 && this.mOutputs[0] != null) {
            GT_Recipe_Map.sAlloySmelterRecipes.addRecipe(this);
        }
    }

    public GT_Recipe(ItemStack aInput1, int aEUt, ItemStack aInput2, int aDuration, ItemStack aOutput1, ItemStack aOutput2) {
        ItemStack[] itemStackArray;
        if (aInput2 == null) {
            ItemStack[] itemStackArray2 = new ItemStack[1];
            itemStackArray = itemStackArray2;
            itemStackArray2[0] = aInput1;
        } else {
            ItemStack[] itemStackArray3 = new ItemStack[2];
            itemStackArray3[0] = aInput1;
            itemStackArray = itemStackArray3;
            itemStackArray3[1] = aInput2;
        }
        this(true, itemStackArray, new ItemStack[]{aOutput1, aOutput2}, null, null, null, null, Math.max(aDuration, 1), Math.max(aEUt, 1), 0);
        if (this.mInputs.length > 0 && this.mOutputs[0] != null) {
            GT_Recipe_Map.sCannerRecipes.addRecipe(this);
        }
    }

    public GT_Recipe(ItemStack aInput1, ItemStack aOutput1, int aDuration) {
        this(true, new ItemStack[]{aInput1}, new ItemStack[]{aOutput1}, null, null, null, null, Math.max(aDuration, 1), 120, 0);
        if (this.mInputs.length > 0 && this.mOutputs[0] != null) {
            GT_Recipe_Map.sVacuumRecipes.addRecipe(this);
        }
    }

    public GT_Recipe(ItemStack aInput1, ItemStack aOutput1, int aDuration, int aEUt, int VACUUM) {
        this(true, new ItemStack[]{aInput1}, new ItemStack[]{aOutput1}, null, null, null, null, Math.max(aDuration, 1), aEUt, 0);
        if (this.mInputs.length > 0 && this.mOutputs[0] != null) {
            GT_Recipe_Map.sVacuumRecipes.addRecipe(this);
        }
    }

    public GT_Recipe(FluidStack aInput1, FluidStack aOutput1, int aDuration, int aEUt) {
        this(false, null, null, null, null, new FluidStack[]{aInput1}, new FluidStack[]{aOutput1}, Math.max(aDuration, 1), aEUt, 0);
        if (this.mFluidInputs.length > 0 && this.mFluidOutputs[0] != null) {
            GT_Recipe_Map.sVacuumRecipes.addRecipe(this);
        }
    }

    public GT_Recipe(ItemStack[] aInputs, ItemStack[] aOutputs, Object aSpecialItems, int[] aChances, FluidStack[] aFluidInputs, FluidStack[] aFluidOutputs, int aDuration, int aEUt, int aSpecialValue) {
        this(true, aInputs, aOutputs, aSpecialItems, aChances, aFluidInputs, aFluidOutputs, aDuration, aEUt, aSpecialValue);
    }

    public static void reInit() {
        GT_Log.out.println("GT_Mod: Re-Unificating Recipes.");
        for (GT_Recipe_Map tMapEntry : GT_Recipe_Map.sMappings) {
            tMapEntry.reInit();
        }
    }

    public ItemStack getRepresentativeInput(int aIndex) {
        if (aIndex < 0 || aIndex >= this.mInputs.length) {
            return null;
        }
        return GT_Utility.copyOrNull(this.mInputs[aIndex]);
    }

    public ItemStack getOutput(int aIndex) {
        if (aIndex < 0 || aIndex >= this.mOutputs.length) {
            return null;
        }
        return GT_Utility.copyOrNull(this.mOutputs[aIndex]);
    }

    public int getOutputChance(int aIndex) {
        if (this.mChances == null) {
            return 10000;
        }
        if (aIndex < 0 || aIndex >= this.mChances.length) {
            return 10000;
        }
        return this.mChances[aIndex];
    }

    public FluidStack getRepresentativeFluidInput(int aIndex) {
        if (aIndex < 0 || aIndex >= this.mFluidInputs.length || this.mFluidInputs[aIndex] == null) {
            return null;
        }
        return this.mFluidInputs[aIndex].copy();
    }

    public FluidStack getFluidOutput(int aIndex) {
        if (aIndex < 0 || aIndex >= this.mFluidOutputs.length || this.mFluidOutputs[aIndex] == null) {
            return null;
        }
        return this.mFluidOutputs[aIndex].copy();
    }

    public void checkCellBalance() {
        int tOutputAmount;
        if (!GT_Values.D2 || this.mInputs.length < 1) {
            return;
        }
        int tInputAmount = GT_ModHandler.getCapsuleCellContainerCountMultipliedWithStackSize(this.mInputs);
        if (tInputAmount < (tOutputAmount = GT_ModHandler.getCapsuleCellContainerCountMultipliedWithStackSize(this.mOutputs))) {
            if (!Materials.Tin.contains(this.mInputs)) {
                GT_Log.err.println("You get more Cells, than you put in? There must be something wrong.");
                new Exception().printStackTrace(GT_Log.err);
            }
        } else if (tInputAmount > tOutputAmount && !Materials.Tin.contains(this.mOutputs)) {
            GT_Log.err.println("You get less Cells, than you put in? GT Machines usually don't destroy Cells.");
            new Exception().printStackTrace(GT_Log.err);
        }
    }

    public GT_Recipe copy() {
        return new GT_Recipe(this, false);
    }

    public GT_Recipe copyShallow() {
        return new GT_Recipe(this, true);
    }

    public boolean isRecipeInputEqual(boolean aDecreaseStacksizeBySuccess, FluidStack[] aFluidInputs, ItemStack ... aInputs) {
        return this.isRecipeInputEqual(aDecreaseStacksizeBySuccess, false, 1, aFluidInputs, aInputs);
    }

    public boolean isRecipeInputEqual(boolean aDecreaseStacksizeBySuccess, boolean aDontCheckStackSizes, FluidStack[] aFluidInputs, ItemStack ... aInputs) {
        return this.isRecipeInputEqual(aDecreaseStacksizeBySuccess, aDontCheckStackSizes, 1, aFluidInputs, aInputs);
    }

    public boolean isRecipeInputEqual(boolean aDecreaseStacksizeBySuccess, boolean aDontCheckStackSizes, int amountMultiplier, FluidStack[] aFluidInputs, ItemStack ... aInputs) {
        int remainingCost;
        boolean inputFound;
        if (this.mInputs.length > 0 && aInputs == null) {
            return false;
        }
        if (this.mFluidInputs.length > 0 && aFluidInputs == null) {
            return false;
        }
        Integer[] newFluidAmounts = null;
        if (aFluidInputs != null) {
            newFluidAmounts = new Integer[aFluidInputs.length];
            for (FluidStack recipeFluidCost : this.mFluidInputs) {
                if (recipeFluidCost == null) continue;
                inputFound = false;
                remainingCost = recipeFluidCost.amount * amountMultiplier;
                for (int i = 0; i < aFluidInputs.length; ++i) {
                    FluidStack providedFluid = aFluidInputs[i];
                    if (providedFluid == null || !providedFluid.isFluidEqual(recipeFluidCost)) continue;
                    inputFound = true;
                    if (newFluidAmounts[i] == null) {
                        newFluidAmounts[i] = providedFluid.amount;
                    }
                    if (aDontCheckStackSizes || newFluidAmounts[i] >= remainingCost) {
                        Integer[] integerArray = newFluidAmounts;
                        int n = i;
                        Integer.valueOf(integerArray[n] - remainingCost);
                        remainingCost = 0;
                        break;
                    }
                    remainingCost -= newFluidAmounts[i].intValue();
                    newFluidAmounts[i] = 0;
                }
                if (remainingCost <= 0 && inputFound) continue;
                return false;
            }
        }
        Integer[] newItemAmounts = null;
        if (aInputs != null) {
            newItemAmounts = new Integer[aInputs.length];
            for (ItemStack recipeItemCost : this.mInputs) {
                ItemStack unifiedItemCost = GT_OreDictUnificator.get_nocopy(true, recipeItemCost);
                if (unifiedItemCost == null) continue;
                inputFound = false;
                remainingCost = recipeItemCost.field_77994_a * amountMultiplier;
                for (int i = 0; i < aInputs.length; ++i) {
                    ItemStack providedItem = aInputs[i];
                    if (this.isNBTSensitive && !GT_Utility.areStacksEqual(providedItem, unifiedItemCost, false) || !this.isNBTSensitive && !GT_OreDictUnificator.isInputStackEqual(providedItem, unifiedItemCost) || GTppRecipeHelper && (GT_Utility.areStacksEqual(providedItem, Ic2Items.FluidCell.func_77946_l(), true) || GT_Utility.areStacksEqual(providedItem, ItemList.Tool_DataStick.get(1L, new Object[0]), true) || GT_Utility.areStacksEqual(providedItem, ItemList.Tool_DataOrb.get(1L, new Object[0]), true)) && !GT_Utility.areStacksEqual(providedItem, recipeItemCost, false)) continue;
                    inputFound = true;
                    if (newItemAmounts[i] == null) {
                        newItemAmounts[i] = providedItem.field_77994_a;
                    }
                    if (aDontCheckStackSizes || newItemAmounts[i] >= remainingCost) {
                        Integer[] integerArray = newItemAmounts;
                        int n = i;
                        Integer.valueOf(integerArray[n] - remainingCost);
                        remainingCost = 0;
                        break;
                    }
                    remainingCost -= newItemAmounts[i].intValue();
                    newItemAmounts[i] = 0;
                }
                if (remainingCost <= 0 && inputFound) continue;
                return false;
            }
        }
        if (aDecreaseStacksizeBySuccess) {
            int i;
            if (aFluidInputs != null) {
                for (i = 0; i < aFluidInputs.length; ++i) {
                    if (newFluidAmounts[i] == null) continue;
                    aFluidInputs[i].amount = newFluidAmounts[i];
                }
            }
            if (aInputs != null) {
                for (i = 0; i < aInputs.length; ++i) {
                    if (newItemAmounts[i] == null) continue;
                    aInputs[i].field_77994_a = newItemAmounts[i];
                }
            }
        }
        return true;
    }

    @Override
    public int compareTo(GT_Recipe recipe) {
        if (this.mEUt != recipe.mEUt) {
            return this.mEUt - recipe.mEUt;
        }
        if (this.mDuration != recipe.mDuration) {
            return this.mDuration - recipe.mDuration;
        }
        if (this.mSpecialValue != recipe.mSpecialValue) {
            return this.mSpecialValue - recipe.mSpecialValue;
        }
        if (this.mFluidInputs.length != recipe.mFluidInputs.length) {
            return this.mFluidInputs.length - recipe.mFluidInputs.length;
        }
        if (this.mInputs.length != recipe.mInputs.length) {
            return this.mInputs.length - recipe.mInputs.length;
        }
        return 0;
    }

    public String[] getNeiDesc() {
        return this.neiDesc;
    }

    protected void setNeiDesc(String ... neiDesc) {
        this.neiDesc = neiDesc;
    }

    @Deprecated
    public ArrayList<PositionedStack> getInputPositionedStacks() {
        return null;
    }

    @Deprecated
    public ArrayList<PositionedStack> getOutputPositionedStacks() {
        return null;
    }

    public void reloadOwner() {
        this.setOwner(Loader.instance().activeModContainer());
        List<String> excludedClasses = Arrays.asList("java.lang.Thread", "gregtech.api.util.GT_Recipe", "gregtech.api.util.GT_RecipeBuilder", "gregtech.api.util.GT_Recipe$GT_Recipe_Map", "gregtech.common.GT_RecipeAdder");
        if (GT_Mod.gregtechproxy.mNEIRecipeOwnerStackTrace) {
            ArrayList<StackTraceElement> toAdd = new ArrayList<StackTraceElement>();
            for (StackTraceElement stackTrace : Thread.currentThread().getStackTrace()) {
                if (!excludedClasses.stream().noneMatch(c -> stackTrace.getClassName().equals(c))) continue;
                toAdd.add(stackTrace);
            }
            this.stackTraces.add(toAdd);
        }
    }

    public void setOwner(ModContainer newOwner) {
        ModContainer oldOwner;
        ModContainer modContainer = oldOwner = this.owners.size() > 0 ? this.owners.get(this.owners.size() - 1) : null;
        if (newOwner != null && newOwner != oldOwner) {
            this.owners.add(newOwner);
        }
    }

    public void setOwner(String modId) {
        for (ModContainer mod : Loader.instance().getModList()) {
            if (!mod.getModId().equals(modId)) continue;
            this.setOwner(mod);
            return;
        }
    }

    public GT_Recipe setInputs(ItemStack ... aInputs) {
        this.mInputs = ArrayExt.withoutTrailingNulls(aInputs, ItemStack[]::new);
        return this;
    }

    public GT_Recipe setOutputs(ItemStack ... aOutputs) {
        this.mOutputs = ArrayExt.withoutTrailingNulls(aOutputs, ItemStack[]::new);
        return this;
    }

    public GT_Recipe setFluidInputs(FluidStack ... aInputs) {
        this.mFluidInputs = ArrayExt.withoutTrailingNulls(aInputs, FluidStack[]::new);
        return this;
    }

    public GT_Recipe setFluidOutputs(FluidStack ... aOutputs) {
        this.mFluidOutputs = ArrayExt.withoutTrailingNulls(aOutputs, FluidStack[]::new);
        return this;
    }

    public GT_Recipe setDuration(int aDuration) {
        this.mDuration = aDuration;
        return this;
    }

    public GT_Recipe setEUt(int aEUt) {
        this.mEUt = aEUt;
        return this;
    }

    public static class GT_Recipe_Map
    implements IGT_RecipeMap {
        public static final Collection<GT_Recipe_Map> sMappings = new ArrayList<GT_Recipe_Map>();
        public static final Map<String, GT_Recipe_Map> sIndexedMappings = new HashMap<String, GT_Recipe_Map>();
        static final String TEXTURES_GUI_BASICMACHINES = "textures/gui/basicmachines";
        public static final GT_Recipe_Map sOreWasherRecipes = new GT_Recipe_Map(new HashSet<GT_Recipe>(500), "gt.recipe.orewasher", null, null, Mods.GregTech.getResourcePath("textures/gui/basicmachines", "OreWasher"), 1, 3, 1, 1, 1, "", 1, "", true, true).setSlotOverlay(false, false, (IDrawable)GT_UITextures.OVERLAY_SLOT_CRUSHED_ORE).setSlotOverlay(false, true, (IDrawable)GT_UITextures.OVERLAY_SLOT_DUST).setRecipeConfigFile("orewasher", GT_RecipeMapUtil.FIRST_ITEM_INPUT).setProgressBar(GT_UITextures.PROGRESSBAR_BATH, ProgressBar.Direction.CIRCULAR_CW);
        public static final GT_Recipe_Map sThermalCentrifugeRecipes = new GT_Recipe_Map(new HashSet<GT_Recipe>(1000), "gt.recipe.thermalcentrifuge", null, null, Mods.GregTech.getResourcePath("textures/gui/basicmachines", "ThermalCentrifuge"), 1, 3, 1, 0, 2, "", 1, "", true, true).setSlotOverlay(false, false, (IDrawable)GT_UITextures.OVERLAY_SLOT_CRUSHED_ORE).setSlotOverlay(false, true, (IDrawable)GT_UITextures.OVERLAY_SLOT_DUST).setRecipeConfigFile("thermalcentrifuge", GT_RecipeMapUtil.FIRST_ITEM_INPUT).setProgressBar(GT_UITextures.PROGRESSBAR_ARROW, ProgressBar.Direction.RIGHT);
        public static final GT_Recipe_Map sCompressorRecipes = new GT_Recipe_Map(new HashSet<GT_Recipe>(750), "gt.recipe.compressor", null, null, Mods.GregTech.getResourcePath("textures/gui/basicmachines", "Compressor"), 1, 1, 1, 0, 1, "", 1, "", true, true).setSlotOverlay(false, false, (IDrawable)GT_UITextures.OVERLAY_SLOT_COMPRESSOR).setRecipeConfigFile("compressor", GT_RecipeMapUtil.FIRST_ITEM_INPUT).setProgressBar(GT_UITextures.PROGRESSBAR_COMPRESS, ProgressBar.Direction.RIGHT).setSlotOverlaySteam(false, GT_UITextures.OVERLAY_SLOT_COMPRESSOR_STEAM).setProgressBarSteam(GT_UITextures.PROGRESSBAR_COMPRESS_STEAM);
        public static final GT_Recipe_Map sExtractorRecipes = new GT_Recipe_Map(new HashSet<GT_Recipe>(250), "gt.recipe.extractor", null, null, Mods.GregTech.getResourcePath("textures/gui/basicmachines", "Extractor"), 1, 1, 1, 0, 1, "", 1, "", true, true).setSlotOverlay(false, false, (IDrawable)GT_UITextures.OVERLAY_SLOT_CENTRIFUGE).setRecipeConfigFile("extractor", GT_RecipeMapUtil.FIRST_ITEM_INPUT).setProgressBar(GT_UITextures.PROGRESSBAR_EXTRACT, ProgressBar.Direction.RIGHT).setSlotOverlaySteam(false, GT_UITextures.OVERLAY_SLOT_CENTRIFUGE_STEAM).setProgressBarSteam(GT_UITextures.PROGRESSBAR_EXTRACT_STEAM);
        public static final GT_Recipe_Map sRecyclerRecipes = new GT_Recipe_Map_Recycler(new HashSet<GT_Recipe>(0), "ic.recipe.recycler", null, "ic2.recycler", Mods.GregTech.getResourcePath("textures/gui/basicmachines", "Recycler"), 1, 1, 1, 0, 1, "", 1, "", true, false).setSlotOverlay(false, false, (IDrawable)GT_UITextures.OVERLAY_SLOT_RECYCLE).setProgressBar(GT_UITextures.PROGRESSBAR_RECYCLE, ProgressBar.Direction.CIRCULAR_CW);
        public static final GT_Recipe_Map sFurnaceRecipes = new GT_Recipe_Map_Furnace(new HashSet<GT_Recipe>(0), "mc.recipe.furnace", "Furnace", "smelting", Mods.GregTech.getResourcePath("textures/gui/basicmachines", "E_Furnace"), 1, 1, 1, 0, 1, "", 1, "", true, false).setSlotOverlay(false, false, (IDrawable)GT_UITextures.OVERLAY_SLOT_FURNACE).setProgressBar(GT_UITextures.PROGRESSBAR_ARROW, ProgressBar.Direction.RIGHT).setSlotOverlaySteam(false, GT_UITextures.OVERLAY_SLOT_FURNACE_STEAM).setProgressBarSteam(GT_UITextures.PROGRESSBAR_ARROW_STEAM);
        public static final GT_Recipe_Map sMicrowaveRecipes = new GT_Recipe_Map_Microwave(new HashSet<GT_Recipe>(0), "gt.recipe.microwave", null, "smelting", Mods.GregTech.getResourcePath("textures/gui/basicmachines", "E_Furnace"), 1, 1, 1, 0, 1, "", 1, "", true, false).setSlotOverlay(false, false, (IDrawable)GT_UITextures.OVERLAY_SLOT_FURNACE).setProgressBar(GT_UITextures.PROGRESSBAR_ARROW, ProgressBar.Direction.RIGHT);
        public static final GT_Recipe_Map sScannerFakeRecipes = new GT_Recipe_Map(new HashSet<GT_Recipe>(300), "gt.recipe.scanner", null, null, Mods.GregTech.getResourcePath("textures/gui/basicmachines", "Scanner"), 1, 1, 1, 0, 1, "", 1, "", true, true).setSlotOverlay(false, false, (IDrawable)GT_UITextures.OVERLAY_SLOT_MICROSCOPE).setSlotOverlay(false, false, true, true, (IDrawable)GT_UITextures.OVERLAY_SLOT_DATA_ORB).setProgressBar(GT_UITextures.PROGRESSBAR_ARROW, ProgressBar.Direction.RIGHT);
        public static final GT_Recipe_Map sRockBreakerFakeRecipes = new GT_Recipe_Map(new HashSet<GT_Recipe>(200), "gt.recipe.rockbreaker", null, null, Mods.GregTech.getResourcePath("textures/gui/basicmachines", "RockBreaker"), 2, 1, 0, 0, 1, "", 1, "", true, true).setSlotOverlay(false, false, (IDrawable)GT_UITextures.OVERLAY_SLOT_DUST).setSlotOverlay(false, true, (IDrawable)GT_UITextures.OVERLAY_SLOT_CRUSHED_ORE).setProgressBar(GT_UITextures.PROGRESSBAR_MACERATE, ProgressBar.Direction.RIGHT);
        @Deprecated
        public static final GT_Recipe_Map sByProductList = new GT_Recipe_Map(new HashSet<GT_Recipe>(1000), "gt.recipe.byproductlist", "Ore Byproduct List", null, Mods.GregTech.getResourcePath("textures/gui/basicmachines", "Default"), 1, 6, 1, 0, 1, "", 1, "", true, false).setProgressBar(GT_UITextures.PROGRESSBAR_ARROW, ProgressBar.Direction.RIGHT);
        public static final GT_Recipe_Map sReplicatorFakeRecipes = new ReplicatorFakeMap(new HashSet<GT_Recipe>(100), "gt.recipe.replicator", null, null, Mods.GregTech.getResourcePath("textures/gui/basicmachines", "Replicator"), 0, 1, 0, 1, 1, "", 1, "", true, true).setSlotOverlay(false, false, (IDrawable)GT_UITextures.OVERLAY_SLOT_CANISTER).setSlotOverlay(true, false, (IDrawable)GT_UITextures.OVERLAY_SLOT_UUM).setSlotOverlay(false, false, true, true, (IDrawable)GT_UITextures.OVERLAY_SLOT_DATA_ORB).setProgressBar(GT_UITextures.PROGRESSBAR_ARROW, ProgressBar.Direction.RIGHT);
        public static final GT_Recipe_Map sAssemblylineVisualRecipes = new GT_Recipe_Map_AssemblyLineFake(new HashSet<GT_Recipe>(110), "gt.recipe.fakeAssemblylineProcess", "Assemblyline Process", null, Mods.GregTech.getResourcePath("textures", "gui", "FakeAssemblyline"), 16, 1, 1, 0, 1, "", 1, "", true, true).setSlotOverlay(false, false, true, true, (IDrawable)GT_UITextures.OVERLAY_SLOT_DATA_ORB).setUsualFluidInputCount(4).setDisableOptimize(true);
        public static final GT_Recipe_Map sPlasmaArcFurnaceRecipes = new GT_Recipe_Map(new HashSet<GT_Recipe>(20000), "gt.recipe.plasmaarcfurnace", null, null, Mods.GregTech.getResourcePath("textures/gui/basicmachines", "PlasmaArcFurnace"), 1, 9, 1, 1, 1, "", 1, "", true, true).setProgressBar(GT_UITextures.PROGRESSBAR_ARROW, ProgressBar.Direction.RIGHT).setRecipeConfigFile("arcfurnace", GT_RecipeMapUtil.FIRST_ITEM_INPUT);
        public static final GT_Recipe_Map sArcFurnaceRecipes = new GT_Recipe_Map(new HashSet<GT_Recipe>(20000), "gt.recipe.arcfurnace", null, null, Mods.GregTech.getResourcePath("textures/gui/basicmachines", "ArcFurnace"), 1, 9, 1, 1, 3, "", 1, "", true, true).setProgressBar(GT_UITextures.PROGRESSBAR_ARROW, ProgressBar.Direction.RIGHT).setRecipeConfigFile("arcfurnace", GT_RecipeMapUtil.FIRST_ITEM_INPUT);
        public static final GT_Recipe_Map sPrinterRecipes = new GT_Recipe_Map_Printer(new HashSet<GT_Recipe>(5), "gt.recipe.printer", null, null, Mods.GregTech.getResourcePath("textures/gui/basicmachines", "Printer"), 1, 1, 1, 1, 1, "", 1, "", true, true).setSlotOverlay(false, false, (IDrawable)GT_UITextures.OVERLAY_SLOT_PAGE_BLANK).setSlotOverlay(false, true, (IDrawable)GT_UITextures.OVERLAY_SLOT_PAGE_PRINTED).setSlotOverlay(false, false, true, true, (IDrawable)GT_UITextures.OVERLAY_SLOT_DATA_STICK).setRecipeConfigFile("printer", GT_RecipeMapUtil.FIRST_ITEM_INPUT).setProgressBar(GT_UITextures.PROGRESSBAR_ARROW, ProgressBar.Direction.RIGHT);
        public static final GT_Recipe_Map sSifterRecipes = new GT_Recipe_Map(new HashSet<GT_Recipe>(105), "gt.recipe.sifter", null, null, Mods.GregTech.getResourcePath("textures/gui/basicmachines", "Sifter"), 1, 9, 0, 0, 1, "", 1, "", true, true).setProgressBar(GT_UITextures.PROGRESSBAR_SIFT, ProgressBar.Direction.DOWN).setRecipeConfigFile("sifter", GT_RecipeMapUtil.FIRST_ITEM_INPUT);
        public static final GT_Recipe_Map sPressRecipes = new GT_Recipe_Map_FormingPress(new HashSet<GT_Recipe>(300), "gt.recipe.press", null, null, Mods.GregTech.getResourcePath("textures/gui/basicmachines", "Press3"), 6, 1, 2, 0, 1, "", 1, "", true, true).setSlotOverlay(false, false, true, (IDrawable)GT_UITextures.OVERLAY_SLOT_PRESS_1).setSlotOverlay(false, false, false, (IDrawable)GT_UITextures.OVERLAY_SLOT_PRESS_2).setSlotOverlay(false, true, (IDrawable)GT_UITextures.OVERLAY_SLOT_PRESS_3).setRecipeConfigFile("press", GT_RecipeMapUtil.FIRST_ITEM_OUTPUT).setProgressBar(GT_UITextures.PROGRESSBAR_COMPRESS, ProgressBar.Direction.RIGHT);
        public static final GT_Recipe_Map sLaserEngraverRecipes = new GT_Recipe_Map(new HashSet<GT_Recipe>(810), "gt.recipe.laserengraver", null, null, Mods.GregTech.getResourcePath("textures/gui/basicmachines", "LaserEngraver2"), 4, 4, 0, 0, 1, "", 1, "", true, true).setSlotOverlay(false, false, false, (IDrawable)GT_UITextures.OVERLAY_SLOT_LENS).setProgressBar(GT_UITextures.PROGRESSBAR_ARROW, ProgressBar.Direction.RIGHT).setRecipeConfigFile("laserengraving", GT_RecipeMapUtil.FIRST_ITEM_OUTPUT).setUsualFluidInputCount(2).setUsualFluidOutputCount(2);
        public static final GT_Recipe_Map sMixerRecipes = new GT_Recipe_Map(new HashSet<GT_Recipe>(900), "gt.recipe.mixer", null, null, Mods.GregTech.getResourcePath("textures/gui/basicmachines", "Mixer6"), 9, 4, 1, 0, 1, "", 1, "", true, true).setSlotOverlay(false, false, (IDrawable)GT_UITextures.OVERLAY_SLOT_DUST).setSlotOverlay(false, true, (IDrawable)GT_UITextures.OVERLAY_SLOT_DUST).setRecipeConfigFile("mixer", GT_RecipeMapUtil.FIRST_ITEM_OR_FLUID_OUTPUT).setProgressBar(GT_UITextures.PROGRESSBAR_MIXER, ProgressBar.Direction.CIRCULAR_CW);
        public static final GT_Recipe_Map sAutoclaveRecipes = new GT_Recipe_Map(new HashSet<GT_Recipe>(300), "gt.recipe.autoclave", null, null, Mods.GregTech.getResourcePath("textures/gui/basicmachines", "Autoclave4"), 2, 4, 1, 1, 1, "", 1, "", true, true).setSlotOverlay(false, false, (IDrawable)GT_UITextures.OVERLAY_SLOT_DUST).setSlotOverlay(false, true, true, (IDrawable)GT_UITextures.OVERLAY_SLOT_GEM).setSlotOverlay(false, true, false, (IDrawable)GT_UITextures.OVERLAY_SLOT_DUST).setRecipeConfigFile("autoclave", GT_RecipeMapUtil.FIRST_ITEM_INPUT).setProgressBar(GT_UITextures.PROGRESSBAR_ARROW, ProgressBar.Direction.RIGHT);
        public static final GT_Recipe_Map sElectroMagneticSeparatorRecipes = new GT_Recipe_Map(new HashSet<GT_Recipe>(50), "gt.recipe.electromagneticseparator", null, null, Mods.GregTech.getResourcePath("textures/gui/basicmachines", "ElectromagneticSeparator"), 1, 3, 1, 0, 1, "", 1, "", true, true).setSlotOverlay(false, false, (IDrawable)GT_UITextures.OVERLAY_SLOT_CRUSHED_ORE).setSlotOverlay(false, true, (IDrawable)GT_UITextures.OVERLAY_SLOT_DUST).setRecipeConfigFile("electromagneticseparator", GT_RecipeMapUtil.FIRST_ITEM_INPUT).setProgressBar(GT_UITextures.PROGRESSBAR_MAGNET, ProgressBar.Direction.RIGHT);
        public static final GT_Recipe_Map sPolarizerRecipes = new GT_Recipe_Map(new HashSet<GT_Recipe>(300), "gt.recipe.polarizer", null, null, Mods.GregTech.getResourcePath("textures/gui/basicmachines", "Polarizer"), 1, 1, 1, 0, 1, "", 1, "", true, true).setProgressBar(GT_UITextures.PROGRESSBAR_MAGNET, ProgressBar.Direction.RIGHT).setRecipeConfigFile("polarizer", GT_RecipeMapUtil.FIRST_ITEM_INPUT);
        public static final GT_Recipe_Map sMaceratorRecipes = new GT_Recipe_Map_Macerator(new HashSet<GT_Recipe>(16600), "gt.recipe.macerator", null, null, Mods.GregTech.getResourcePath("textures/gui/basicmachines", "Macerator4"), 1, 4, 1, 0, 1, "", 1, "", true, true).setSlotOverlay(false, false, (IDrawable)GT_UITextures.OVERLAY_SLOT_CRUSHED_ORE).setSlotOverlay(false, true, (IDrawable)GT_UITextures.OVERLAY_SLOT_DUST).setProgressBar(GT_UITextures.PROGRESSBAR_MACERATE, ProgressBar.Direction.RIGHT).setRecipeConfigFile("pulveriser", GT_RecipeMapUtil.FIRST_ITEM_INPUT).setSlotOverlaySteam(false, GT_UITextures.OVERLAY_SLOT_CRUSHED_ORE_STEAM).setSlotOverlaySteam(true, GT_UITextures.OVERLAY_SLOT_DUST_STEAM).setProgressBarSteam(GT_UITextures.PROGRESSBAR_MACERATE_STEAM);
        public static final GT_Recipe_Map sChemicalBathRecipes = new GT_Recipe_Map(new HashSet<GT_Recipe>(2550), "gt.recipe.chemicalbath", null, null, Mods.GregTech.getResourcePath("textures/gui/basicmachines", "ChemicalBath"), 1, 3, 1, 1, 1, "", 1, "", true, true).setProgressBar(GT_UITextures.PROGRESSBAR_BATH, ProgressBar.Direction.CIRCULAR_CW).setRecipeConfigFile("chemicalbath", GT_RecipeMapUtil.FIRST_ITEM_INPUT);
        public static final GT_Recipe_Map sFluidCannerRecipes = new GT_Recipe_Map_FluidCanner(new HashSet<GT_Recipe>(2100), "gt.recipe.fluidcanner", null, null, Mods.GregTech.getResourcePath("textures/gui/basicmachines", "FluidCanner"), 1, 1, 1, 0, 1, "", 1, "", true, true).setSlotOverlay(false, false, (IDrawable)GT_UITextures.OVERLAY_SLOT_CANISTER).setSlotOverlay(false, true, (IDrawable)GT_UITextures.OVERLAY_SLOT_CANISTER).setRecipeConfigFile("canning", GT_RecipeMapUtil.FIRST_ITEM_INPUT).setProgressBar(GT_UITextures.PROGRESSBAR_CANNER, ProgressBar.Direction.RIGHT);
        public static final GT_Recipe_Map sBrewingRecipes = new GT_Recipe_Map(new HashSet<GT_Recipe>(450), "gt.recipe.brewer", "Brewing Machine", null, Mods.GregTech.getResourcePath("textures/gui/basicmachines", "PotionBrewer"), 1, 0, 1, 1, 1, "", 1, "", true, true).setSlotOverlay(false, false, (IDrawable)GT_UITextures.OVERLAY_SLOT_CAULDRON).setRecipeConfigFile("brewing", GT_RecipeMapUtil.FIRST_FLUIDSTACK_OUTPUT).setProgressBar(GT_UITextures.PROGRESSBAR_ARROW_MULTIPLE, ProgressBar.Direction.RIGHT);
        public static final GT_Recipe_Map sFluidHeaterRecipes = new GT_Recipe_Map(new HashSet<GT_Recipe>(10), "gt.recipe.fluidheater", null, null, Mods.GregTech.getResourcePath("textures/gui/basicmachines", "FluidHeater"), 1, 0, 0, 0, 1, "", 1, "", true, true).setSlotOverlay(true, false, (IDrawable)GT_UITextures.OVERLAY_SLOT_HEATER_1).setSlotOverlay(true, true, (IDrawable)GT_UITextures.OVERLAY_SLOT_HEATER_2).setRecipeConfigFile("fluidheater", GT_RecipeMapUtil.FIRST_FLUIDSTACK_OUTPUT).setProgressBar(GT_UITextures.PROGRESSBAR_ARROW_MULTIPLE, ProgressBar.Direction.RIGHT);
        public static final GT_Recipe_Map sDistilleryRecipes = new GT_Recipe_Map(new HashSet<GT_Recipe>(400), "gt.recipe.distillery", null, null, Mods.GregTech.getResourcePath("textures/gui/basicmachines", "Distillery"), 1, 1, 1, 1, 1, "", 1, "", true, true).setSlotOverlay(true, false, (IDrawable)GT_UITextures.OVERLAY_SLOT_BEAKER_1).setSlotOverlay(true, true, (IDrawable)GT_UITextures.OVERLAY_SLOT_BEAKER_2).setRecipeConfigFile("distillery", GT_RecipeMapUtil.FIRST_FLUIDSTACK_OUTPUT).setRecipeSpecialHandler((GT_Recipe r) -> {
            int aInput = r.mFluidInputs[0].amount;
            int aOutput = r.mFluidOutputs[0].amount;
            int aDuration = r.mDuration;
            int tScale = (Math.max(aInput, aOutput) + 999) / 1000;
            if (tScale <= 0) {
                tScale = 1;
            }
            if (tScale > 1) {
                int i;
                for (i = tScale; i <= 5; ++i) {
                    if (aInput % i != 0 || aDuration % i != 0) continue;
                    tScale = i;
                    break;
                }
                for (i = tScale; i <= 5; ++i) {
                    if (aInput % i != 0 || aDuration % i != 0 || aOutput % i != 0) continue;
                    tScale = i;
                    break;
                }
                aInput = (aInput + tScale - 1) / tScale;
                aOutput /= tScale;
                if (!GT_Utility.isArrayEmptyOrNull(r.mOutputs)) {
                    ItemData tData = GT_OreDictUnificator.getItemData(r.mOutputs[0]);
                    r.mOutputs[0] = tData != null && (tData.mPrefix == OrePrefixes.dust || OrePrefixes.dust.mFamiliarPrefixes.contains((Object)tData.mPrefix)) ? GT_OreDictUnificator.getDust(tData.mMaterial.mMaterial, tData.mMaterial.mAmount * (long)r.mOutputs[0].field_77994_a / (long)tScale) : (r.mOutputs[0].field_77994_a / tScale == 0 ? GT_Values.NI : GT_Utility.copyAmount((long)(r.mOutputs[0].field_77994_a / tScale), r.mOutputs[0]));
                }
                aDuration = (aDuration + tScale - 1) / tScale;
                r.mFluidInputs[0] = GT_Utility.copyAmount(aInput, r.mFluidInputs[0]);
                r.mFluidOutputs[0] = GT_Utility.copyAmount(aOutput, r.mFluidOutputs[0]);
                r.mDuration = aDuration;
            }
        }).setProgressBar(GT_UITextures.PROGRESSBAR_ARROW_MULTIPLE, ProgressBar.Direction.RIGHT);
        public static final GT_Recipe_Map sFermentingRecipes = new GT_Recipe_Map(new HashSet<GT_Recipe>(50), "gt.recipe.fermenter", null, null, Mods.GregTech.getResourcePath("textures/gui/basicmachines", "Fermenter"), 0, 0, 0, 1, 1, "", 1, "", true, true).setProgressBar(GT_UITextures.PROGRESSBAR_ARROW_MULTIPLE, ProgressBar.Direction.RIGHT).setRecipeConfigFile("fermenting", GT_RecipeMapUtil.FIRST_FLUIDSTACK_OUTPUT);
        public static final GT_Recipe_Map sFluidSolidficationRecipes = new GT_Recipe_Map(new HashSet<GT_Recipe>(35000), "gt.recipe.fluidsolidifier", null, null, Mods.GregTech.getResourcePath("textures/gui/basicmachines", "FluidSolidifier"), 1, 1, 1, 1, 1, "", 1, "", true, true).setSlotOverlay(false, false, (IDrawable)GT_UITextures.OVERLAY_SLOT_MOLD).setRecipeConfigFile("fluidsolidifier", GT_RecipeMapUtil.FIRST_ITEM_OUTPUT).setRecipeSpecialHandler((GT_Recipe r) -> {
            if (ArrayUtils.isNotEmpty((Object[])r.mFluidInputs)) {
                if (Materials.PhasedGold.getMolten(1L).isFluidEqual(r.mFluidInputs[0])) {
                    r.mFluidInputs = new FluidStack[]{Materials.VibrantAlloy.getMolten(r.mFluidInputs[0].amount)};
                } else if (Materials.PhasedIron.getMolten(1L).isFluidEqual(r.mFluidInputs[0])) {
                    r.mFluidInputs = new FluidStack[]{Materials.PulsatingIron.getMolten(r.mFluidInputs[0].amount)};
                }
            }
        }).setProgressBar(GT_UITextures.PROGRESSBAR_ARROW, ProgressBar.Direction.RIGHT);
        public static final GT_Recipe_Map sFluidExtractionRecipes = new GT_Recipe_Map(new HashSet<GT_Recipe>(15000), "gt.recipe.fluidextractor", null, null, Mods.GregTech.getResourcePath("textures/gui/basicmachines", "FluidExtractor"), 1, 1, 1, 0, 1, "", 1, "", true, true).setSlotOverlay(false, false, (IDrawable)GT_UITextures.OVERLAY_SLOT_CENTRIFUGE).setRecipeConfigFile("fluidextractor", GT_RecipeMapUtil.FIRST_ITEM_INPUT).setRecipeSpecialHandler((GT_Recipe r) -> {
            if (ArrayUtils.isNotEmpty((Object[])r.mFluidInputs)) {
                if (Materials.PhasedGold.getMolten(1L).isFluidEqual(r.mFluidInputs[0])) {
                    r.mFluidInputs = new FluidStack[]{Materials.VibrantAlloy.getMolten(r.mFluidInputs[0].amount)};
                } else if (Materials.PhasedIron.getMolten(1L).isFluidEqual(r.mFluidInputs[0])) {
                    r.mFluidInputs = new FluidStack[]{Materials.PulsatingIron.getMolten(r.mFluidInputs[0].amount)};
                }
            }
        }).setProgressBar(GT_UITextures.PROGRESSBAR_EXTRACT, ProgressBar.Direction.RIGHT);
        public static final GT_Recipe_Map sBoxinatorRecipes = new GT_Recipe_Map(new HashSet<GT_Recipe>(2500), "gt.recipe.packager", null, null, Mods.GregTech.getResourcePath("textures/gui/basicmachines", "Packager"), 2, 1, 2, 0, 1, "", 1, "", true, true).setSlotOverlay(false, false, false, (IDrawable)GT_UITextures.OVERLAY_SLOT_BOX).setRecipeConfigFile("boxing", GT_RecipeMapUtil.FIRST_ITEM_OUTPUT).setSlotOverlay(false, true, (IDrawable)GT_UITextures.OVERLAY_SLOT_BOXED).setProgressBar(GT_UITextures.PROGRESSBAR_ARROW, ProgressBar.Direction.RIGHT);
        public static final GT_Recipe_Map sUnboxinatorRecipes = new GT_Recipe_Map_Unboxinator(new HashSet<GT_Recipe>(2500), "gt.recipe.unpackager", null, null, Mods.GregTech.getResourcePath("textures/gui/basicmachines", "Unpackager"), 1, 2, 1, 0, 1, "", 1, "", true, true).setSlotOverlay(false, false, (IDrawable)GT_UITextures.OVERLAY_SLOT_BOXED).setRecipeConfigFile("unboxing", GT_RecipeMapUtil.FIRST_ITEM_OUTPUT).setProgressBar(GT_UITextures.PROGRESSBAR_ARROW, ProgressBar.Direction.RIGHT);
        public static final GT_Recipe_Map sFusionRecipes = new GT_Recipe_Map_FluidOnly(new HashSet<GT_Recipe>(50), "gt.recipe.fusionreactor", "Fusion Reactor", null, Mods.GregTech.getResourcePath("textures/gui/basicmachines", "FusionReactor"), 0, 0, 0, 2, 1, "Start: ", 1, " EU", true, true).setProgressBar(GT_UITextures.PROGRESSBAR_ARROW, ProgressBar.Direction.RIGHT).useComparatorForNEI(true).setUsualFluidInputCount(2).setRecipeConfigFile("fusion", GT_RecipeMapUtil.FIRST_FLUID_OUTPUT).setDisableOptimize(true).setNEISpecialInfoFormatter(FusionSpecialValueFormatter.INSTANCE);
        public static final GT_Recipe_Map sComplexFusionRecipes = new GT_Recipe_Map_ComplexFusion(new HashSet<GT_Recipe>(50), "gt.recipe.complexfusionreactor", "Complex Fusion Reactor", null, Mods.GregTech.getResourcePath("textures/gui/basicmachines", "ComplexFusionReactor"), 3, 0, 0, 2, 1, "Start: ", 1, " EU", true, true).setProgressBar(GT_UITextures.PROGRESSBAR_ARROW, ProgressBar.Direction.RIGHT).setUsualFluidInputCount(16).setUsualFluidOutputCount(16).setNEITransferRect(new Rectangle(79, 34, 18, 18)).setLogoPos(80, 61).setNEISpecialInfoFormatter(FusionSpecialValueFormatter.INSTANCE).setDisableOptimize(true);
        public static final GT_Recipe_Map sCentrifugeRecipes = new GT_Recipe_Map(new HashSet<GT_Recipe>(1200), "gt.recipe.centrifuge", null, null, Mods.GregTech.getResourcePath("textures/gui/basicmachines", "Centrifuge"), 2, 6, 0, 0, 1, "", 1, "", true, true).setSlotOverlay(false, false, true, (IDrawable)GT_UITextures.OVERLAY_SLOT_CENTRIFUGE).setRecipeConfigFile("centrifuge", GT_RecipeMapUtil.FIRST_ITEM_OR_FLUID_INPUT).setSlotOverlay(false, false, false, (IDrawable)GT_UITextures.OVERLAY_SLOT_CANISTER).setSlotOverlay(true, false, (IDrawable)GT_UITextures.OVERLAY_SLOT_CENTRIFUGE_FLUID).setProgressBar(GT_UITextures.PROGRESSBAR_EXTRACT, ProgressBar.Direction.RIGHT);
        public static final GT_Recipe_Map sElectrolyzerRecipes = new GT_Recipe_Map(new HashSet<GT_Recipe>(300), "gt.recipe.electrolyzer", null, null, Mods.GregTech.getResourcePath("textures/gui/basicmachines", "Electrolyzer"), 2, 6, 0, 0, 1, "", 1, "", true, true).setSlotOverlay(false, false, true, (IDrawable)GT_UITextures.OVERLAY_SLOT_CHARGER).setRecipeConfigFile("electrolyzer", GT_RecipeMapUtil.FIRST_ITEM_OR_FLUID_INPUT).setSlotOverlay(false, false, false, (IDrawable)GT_UITextures.OVERLAY_SLOT_CANISTER).setSlotOverlay(true, false, (IDrawable)GT_UITextures.OVERLAY_SLOT_CHARGER_FLUID).setProgressBar(GT_UITextures.PROGRESSBAR_EXTRACT, ProgressBar.Direction.RIGHT);
        public static final GT_Recipe_Map sBlastRecipes = new GT_Recipe_Map(new HashSet<GT_Recipe>(800), "gt.recipe.blastfurnace", "Blast Furnace", null, Mods.GregTech.getResourcePath("textures/gui/basicmachines", "Default"), 6, 6, 1, 0, 1, "Heat Capacity: ", 1, " K", false, true).setProgressBar(GT_UITextures.PROGRESSBAR_ARROW, ProgressBar.Direction.RIGHT).setRecipeConfigFile("blastfurnace", GT_RecipeMapUtil.FIRST_ITEM_INPUT).setNEISpecialInfoFormatter(HeatingCoilSpecialValueFormatter.INSTANCE);
        public static final GT_Recipe_Map sPlasmaForgeRecipes = new GT_Recipe_Map_LargeNEI(new HashSet<GT_Recipe>(20), "gt.recipe.plasmaforge", "DTPF", null, Mods.GregTech.getResourcePath("textures/gui/basicmachines", "PlasmaForge"), 9, 9, 0, 0, 1, "Heat Capacity: ", 1, " K", false, true).setProgressBar(GT_UITextures.PROGRESSBAR_ARROW, ProgressBar.Direction.RIGHT).setUsualFluidInputCount(9).setUsualFluidOutputCount(9).setDisableOptimize(true).setNEISpecialInfoFormatter(HeatingCoilSpecialValueFormatter.INSTANCE);
        public static final GT_Recipe_Map sTranscendentPlasmaMixerRecipes = new TranscendentPlasmaMixerRecipeMap(new HashSet<GT_Recipe>(20), "gt.recipe.transcendentplasmamixerrecipes", "Transcendent Plasma Mixer", null, Mods.GregTech.getResourcePath("textures/gui/basicmachines", "PlasmaForge"), 1, 0, 0, 0, 1, "", 0, "", false, true).setDisableOptimize(true);
        public static final GT_Recipe_Map sFakeSpaceProjectRecipes = new GT_Recipe_Map((Collection)new HashSet(20), "gt.recipe.fakespaceprojects", "Space Projects", null, Mods.GregTech.getResourcePath("textures/gui/basicmachines", "Default"), 12, 0, 0, 0, 1, StatCollector.func_74838_a((String)"gt.specialvalue.stages") + " ", 1, "", false, true){
            IDrawable projectTexture;

            @Override
            public ModularWindow.Builder createNEITemplate(IItemHandlerModifiable itemInputsInventory, IItemHandlerModifiable itemOutputsInventory, IItemHandlerModifiable specialSlotInventory, IItemHandlerModifiable fluidInputsInventory, IItemHandlerModifiable fluidOutputsInventory, Supplier<Float> progressSupplier, Pos2d windowOffset) {
                ModularWindow.Builder builder = super.createNEITemplate(itemInputsInventory, itemOutputsInventory, specialSlotInventory, fluidInputsInventory, fluidOutputsInventory, progressSupplier, windowOffset);
                this.addRecipeSpecificDrawable(builder, windowOffset, () -> this.projectTexture, new Pos2d(124, 28), new Size(18, 18));
                return builder;
            }

            @Override
            public List<Pos2d> getItemInputPositions(int itemInputCount) {
                return UIHelper.getGridPositions(itemInputCount, 16, 28, 3);
            }

            @Override
            public List<Pos2d> getFluidInputPositions(int fluidInputCount) {
                return UIHelper.getGridPositions(fluidInputCount, 88, 28, 1);
            }

            @Override
            protected List<String> handleNEIItemInputTooltip(List<String> currentTip, GT_NEI_DefaultHandler.FixedPositionedStack pStack) {
                super.handleNEIItemOutputTooltip(currentTip, pStack);
                if (pStack.item != null && pStack.item.func_77973_b() instanceof GT_FluidDisplayItem) {
                    return currentTip;
                }
                currentTip.add(EnumChatFormatting.GRAY + StatCollector.func_74838_a((String)"Item Count: ") + GT_Utility.formatNumbers(pStack.realStackSize));
                return currentTip;
            }

            @Override
            public void drawNEIOverlays(GT_NEI_DefaultHandler.CachedDefaultRecipe neiCachedRecipe) {
                ISpaceProject project;
                for (PositionedStack stack : neiCachedRecipe.mInputs) {
                    if (!(stack instanceof GT_NEI_DefaultHandler.FixedPositionedStack) || stack.item == null || stack.item.func_77973_b() instanceof GT_FluidDisplayItem) continue;
                    int stackSize = ((GT_NEI_DefaultHandler.FixedPositionedStack)stack).realStackSize;
                    String displayString = stack.item.field_77994_a > 9999 ? ReadableNumberConverter.INSTANCE.toWideReadableForm((long)stackSize) : String.valueOf(stackSize);
                    this.drawNEIOverlayText(displayString, stack, 0xFFFFFF, 0.5f, true, Alignment.BottomRight);
                }
                if (neiCachedRecipe.mRecipe instanceof GT_FakeSpaceProjectRecipe && (project = SpaceProjectManager.getProject(((GT_FakeSpaceProjectRecipe)neiCachedRecipe.mRecipe).projectName)) != null) {
                    this.projectTexture = project.getTexture();
                    GuiDraw.drawStringC((String)(EnumChatFormatting.BOLD + project.getLocalizedName()), (int)85, (int)0, (int)0x404040, (boolean)false);
                }
            }

            @Override
            public void addProgressBarUI(ModularWindow.Builder builder, Supplier<Float> progressSupplier, Pos2d windowOffset) {
                int bar1Width = 17;
                int bar2Width = 18;
                builder.widget(new ProgressBar().setTexture(GT_UITextures.PROGRESSBAR_ASSEMBLY_LINE_1, 17).setDirection(ProgressBar.Direction.RIGHT).setProgress(() -> Float.valueOf(((Float)progressSupplier.get()).floatValue() * ((float)(bar1Width + bar2Width) / (float)bar1Width))).setSynced(false, false).setPos(new Pos2d(70, 28).add(windowOffset)).setSize(bar1Width, 72));
                builder.widget(new ProgressBar().setTexture(GT_UITextures.PROGRESSBAR_ASSEMBLY_LINE_2, 18).setDirection(ProgressBar.Direction.RIGHT).setProgress(() -> Float.valueOf((((Float)progressSupplier.get()).floatValue() - (float)bar1Width / (float)(bar1Width + bar2Width)) * ((float)(bar1Width + bar2Width) / (float)bar2Width))).setSynced(false, false).setPos(new Pos2d(106, 28).add(windowOffset)).setSize(bar2Width, 72));
            }
        }.useModularUI(true).setRenderRealStackSizes(false).setUsualFluidInputCount(4).setNEIBackgroundOffset(2, 23).setLogoPos(152, 83).setDisableOptimize(true);
        public static final GT_Recipe_Map sPrimitiveBlastRecipes = new GT_Recipe_Map(new HashSet<GT_Recipe>(200), "gt.recipe.primitiveblastfurnace", "Primitive Blast Furnace", null, Mods.GregTech.getResourcePath("textures/gui/basicmachines", "Default"), 3, 3, 1, 0, 1, "", 1, "", false, true).setProgressBar(GT_UITextures.PROGRESSBAR_ARROW, ProgressBar.Direction.RIGHT).setRecipeEmitter(builder -> {
            Optional<GT_Recipe> rr = builder.validateInputCount(1, 2).validateOutputCount(1, 2).validateNoInputFluid().validateNoOutputFluid().noOptimize().build();
            if (!rr.isPresent()) {
                return Collections.emptyList();
            }
            ItemStack aInput1 = builder.getItemInputBasic(0);
            ItemStack aInput2 = builder.getItemInputBasic(1);
            ItemStack aOutput1 = builder.getItemOutput(0);
            ItemStack aOutput2 = builder.getItemOutput(1);
            if (aInput1 == null && aInput2 == null || aOutput1 == null && aOutput2 == null) {
                return Collections.emptyList();
            }
            int aCoalAmount = builder.getMetadata(GT_RecipeConstants.ADDITIVE_AMOUNT);
            if (aCoalAmount <= 0) {
                return Collections.emptyList();
            }
            GT_RecipeMapUtil.GT_RecipeTemplate coll = GT_RecipeMapUtil.asTemplate(rr.get());
            for (Materials coal : new Materials[]{Materials.Coal, Materials.Charcoal}) {
                coll.derive().setInputs(aInput1, aInput2, coal.getGems(aCoalAmount)).setOutputs(aOutput1, aOutput2, Materials.DarkAsh.getDustTiny(aCoalAmount));
                coll.derive().setInputs(aInput1, aInput2, coal.getDust(aCoalAmount)).setOutputs(aOutput1, aOutput2, Materials.DarkAsh.getDustTiny(aCoalAmount));
            }
            int aDuration = builder.duration;
            if (Mods.Railcraft.isModLoaded()) {
                coll.derive().setInputs(aInput1, aInput2, RailcraftToolItems.getCoalCoke((int)(aCoalAmount / 2))).setOutputs(aOutput1, aOutput2, Materials.Ash.getDustTiny(aCoalAmount / 2)).setDuration(aDuration * 2 / 3);
            }
            if (Mods.GTPlusPlus.isModLoaded()) {
                ItemStack cactusCoke = GT_ModHandler.getModItem(Mods.GTPlusPlus.ID, "itemCactusCoke", (long)aCoalAmount * 2L);
                ItemStack sugarCoke = GT_ModHandler.getModItem(Mods.GTPlusPlus.ID, "itemSugarCoke", (long)aCoalAmount * 2L);
                coll.derive().setInputs(aInput1, aInput2, cactusCoke).setOutputs(aOutput1, aOutput2, Materials.Ash.getDustTiny(aCoalAmount * 2)).setDuration(aDuration * 2 / 3);
                coll.derive().setInputs(aInput1, aInput2, sugarCoke).setOutputs(aOutput1, aOutput2, Materials.Ash.getDustTiny(aCoalAmount * 2)).setDuration(aDuration * 2 / 3);
            }
            if (!(aInput1 != null && aInput1.field_77994_a > 6 || aInput2 != null && aInput2.field_77994_a > 6 || aOutput1 != null && aOutput1.field_77994_a > 6 || aOutput2 != null && aOutput2.field_77994_a > 6)) {
                aInput1 = GT_Utility.multiplyStack(10L, aInput1);
                aInput2 = GT_Utility.multiplyStack(10L, aInput2);
                aOutput1 = GT_Utility.multiplyStack(10L, aOutput1);
                aOutput2 = GT_Utility.multiplyStack(10L, aOutput2);
                for (Materials coal : new Materials[]{Materials.Coal, Materials.Charcoal}) {
                    coll.derive().setInputs(aInput1, aInput2, coal.getBlocks(aCoalAmount)).setOutputs(aOutput1, aOutput2, Materials.DarkAsh.getDust(aCoalAmount)).setDuration(aDuration * 10);
                    coll.derive().setInputs(aInput1, aInput2, coal.getBlocks(aCoalAmount)).setOutputs(aOutput1, aOutput2, Materials.DarkAsh.getDust(aCoalAmount)).setDuration(aDuration * 10);
                }
                if (Mods.Railcraft.isModLoaded()) {
                    coll.derive().setInputs(aInput1, aInput2, EnumCube.COKE_BLOCK.getItem(aCoalAmount / 2)).setOutputs(aOutput1, aOutput2, Materials.Ash.getDust(aCoalAmount / 2)).setDuration(aDuration * 20 / 3);
                }
            }
            return coll.getAll();
        }).setRecipeConfigFile("primitiveblastfurnace", GT_RecipeMapUtil.FIRST_ITEM_INPUT);
        public static final GT_Recipe_Map sImplosionRecipes = new GT_Recipe_Map(new HashSet<GT_Recipe>(900), "gt.recipe.implosioncompressor", "Implosion Compressor", null, Mods.GregTech.getResourcePath("textures/gui/basicmachines", "Default"), 2, 2, 2, 0, 1, "", 1, "", true, true).setSlotOverlay(false, false, true, (IDrawable)GT_UITextures.OVERLAY_SLOT_IMPLOSION).setSlotOverlay(false, false, false, (IDrawable)GT_UITextures.OVERLAY_SLOT_EXPLOSIVE).setRecipeConfigFile("implosion", GT_RecipeMapUtil.FIRST_ITEM_INPUT).setRecipeEmitter(b -> {
            switch (b.getItemInputsBasic().length) {
                case 0: {
                    return Collections.emptyList();
                }
                case 1: {
                    break;
                }
                default: {
                    return b.build().map(Collections::singletonList).orElse(Collections.emptyList());
                }
            }
            Optional<GT_Recipe> t = b.noOptimize().duration(20).eut(30).validateInputCount(1, 1).validateOutputCount(1, 2).build();
            if (!t.isPresent()) {
                return Collections.emptyList();
            }
            ItemStack input = b.getItemInputBasic(0);
            GT_RecipeMapUtil.GT_RecipeTemplate coll = GT_RecipeMapUtil.asTemplate(t.get());
            int tExplosives = Math.min(b.getMetadata(GT_RecipeConstants.ADDITIVE_AMOUNT), 64);
            int tGunpowder = tExplosives << 1;
            int tDynamite = Math.max(1, tExplosives >> 1);
            int tTNT = tExplosives;
            int tITNT = Math.max(1, tExplosives >> 2);
            if (tGunpowder < 65) {
                coll.derive().setInputs(input, ItemList.Block_Powderbarrel.get(tGunpowder, new Object[0]));
            }
            if (tDynamite < 17) {
                coll.derive().setInputs(input, GT_ModHandler.getIC2Item("dynamite", (long)tDynamite, null));
            }
            coll.derive().setInputs(input, new ItemStack(Blocks.field_150335_W, tTNT));
            coll.derive().setInputs(input, GT_ModHandler.getIC2Item("industrialTnt", (long)tITNT, null));
            return coll.getAll();
        }).setDisableOptimize(true).setProgressBar(GT_UITextures.PROGRESSBAR_COMPRESS, ProgressBar.Direction.RIGHT);
        public static final GT_Recipe_Map sVacuumRecipes = new GT_Recipe_Map(new HashSet<GT_Recipe>(305), "gt.recipe.vacuumfreezer", "Vacuum Freezer", null, Mods.GregTech.getResourcePath("textures/gui/basicmachines", "Default"), 1, 1, 0, 0, 1, "", 1, "", false, true).setProgressBar(GT_UITextures.PROGRESSBAR_ARROW, ProgressBar.Direction.RIGHT).setRecipeConfigFile("vacuumfreezer", GT_RecipeMapUtil.FIRST_ITEM_INPUT).setRecipeEmitter(b -> {
            FluidStack out;
            FluidStack in;
            b.noOptimize();
            if (GT_Utility.isArrayOfLength(b.getItemInputsBasic(), 1) && GT_Utility.isArrayOfLength(b.getItemOutputs(), 1) && GT_Utility.isArrayEmptyOrNull(b.getFluidInputs()) && GT_Utility.isArrayEmptyOrNull(b.getFluidOutputs()) && (in = GT_Utility.getFluidForFilledItem(b.getItemInputBasic(0), true)) != null && (out = GT_Utility.getFluidForFilledItem(b.getItemOutput(0), true)) != null) {
                return Arrays.asList(b.build().get(), b.fluidInputs(in).fluidOutputs(out).noItemInputs().noItemOutputs().build().get());
            }
            return GT_RecipeMapUtil.buildOrEmpty(b);
        }).setUsualFluidInputCount(2);
        public static final GT_Recipe_Map sChemicalRecipes = new GT_Recipe_Map(new HashSet<GT_Recipe>(1170), "gt.recipe.chemicalreactor", null, null, Mods.GregTech.getResourcePath("textures/gui/basicmachines", "ChemicalReactor"), 2, 2, 1, 0, 1, "", 1, "", true, true).setSlotOverlay(false, false, true, (IDrawable)GT_UITextures.OVERLAY_SLOT_MOLECULAR_1).setSlotOverlay(false, false, false, (IDrawable)GT_UITextures.OVERLAY_SLOT_MOLECULAR_2).setSlotOverlay(true, false, (IDrawable)GT_UITextures.OVERLAY_SLOT_MOLECULAR_3).setSlotOverlay(false, true, (IDrawable)GT_UITextures.OVERLAY_SLOT_VIAL_1).setSlotOverlay(true, true, (IDrawable)GT_UITextures.OVERLAY_SLOT_VIAL_2).setRecipeConfigFile("chemicalreactor", GT_RecipeMapUtil.FIRST_ITEM_OR_FLUID_OUTPUT).setProgressBar(GT_UITextures.PROGRESSBAR_ARROW_MULTIPLE, ProgressBar.Direction.RIGHT).setDisableOptimize(true);
        public static final GT_Recipe_Map sMultiblockChemicalRecipes = new GT_Recipe_Map_LargeChemicalReactor().setProgressBar(GT_UITextures.PROGRESSBAR_ARROW_MULTIPLE, ProgressBar.Direction.RIGHT).setUsualFluidInputCount(6).setUsualFluidOutputCount(6).setDisableOptimize(true);
        public static final GT_Recipe_Map sDistillationRecipes = new GT_Recipe_Map_DistillationTower().setRecipeConfigFile("distillation", GT_RecipeMapUtil.FIRST_FLUIDSTACK_INPUT).setProgressBar(GT_UITextures.PROGRESSBAR_ARROW_MULTIPLE, ProgressBar.Direction.RIGHT).setUsualFluidOutputCount(11).setDisableOptimize(true);
        public static final GT_Recipe_Map_OilCracker sCrackingRecipes = (GT_Recipe_Map_OilCracker)new GT_Recipe_Map_OilCracker().setRecipeConfigFile("cracking", GT_RecipeMapUtil.FIRST_FLUIDSTACK_INPUT).setProgressBar(GT_UITextures.PROGRESSBAR_ARROW_MULTIPLE, ProgressBar.Direction.RIGHT).setUsualFluidInputCount(2);
        @Deprecated
        public static final GT_Recipe_Map sCrakingRecipes = sCrackingRecipes;
        public static final GT_Recipe_Map sPyrolyseRecipes = new GT_Recipe_Map(new HashSet<GT_Recipe>(150), "gt.recipe.pyro", "Pyrolyse Oven", null, Mods.GregTech.getResourcePath("textures/gui/basicmachines", "Default"), 2, 1, 1, 0, 1, "", 1, "", true, true).setProgressBar(GT_UITextures.PROGRESSBAR_ARROW, ProgressBar.Direction.RIGHT).setDisableOptimize(true).setRecipeConfigFile("pyrolyse", GT_RecipeMapUtil.FIRST_ITEM_INPUT);
        public static final GT_Recipe_Map sWiremillRecipes = new GT_Recipe_Map(new HashSet<GT_Recipe>(450), "gt.recipe.wiremill", null, null, Mods.GregTech.getResourcePath("textures/gui/basicmachines", "Wiremill"), 2, 1, 1, 0, 1, "", 1, "", true, true).setSlotOverlay(false, false, (IDrawable)GT_UITextures.OVERLAY_SLOT_WIREMILL).setRecipeConfigFile("wiremill", GT_RecipeMapUtil.FIRST_ITEM_INPUT).setProgressBar(GT_UITextures.PROGRESSBAR_WIREMILL, ProgressBar.Direction.RIGHT);
        public static final GT_Recipe_Map sBenderRecipes = new GT_Recipe_Map(new HashSet<GT_Recipe>(5000), "gt.recipe.metalbender", null, null, Mods.GregTech.getResourcePath("textures/gui/basicmachines", "Bender"), 2, 1, 2, 0, 1, "", 1, "", true, true).setSlotOverlay(false, false, (IDrawable)GT_UITextures.OVERLAY_SLOT_BENDER).setRecipeConfigFile("bender", GT_RecipeMapUtil.FIRST_ITEM_INPUT).setProgressBar(GT_UITextures.PROGRESSBAR_BENDING, ProgressBar.Direction.RIGHT);
        public static final GT_Recipe_Map sAlloySmelterRecipes = new GT_Recipe_Map(new HashSet<GT_Recipe>(12000), "gt.recipe.alloysmelter", null, null, Mods.GregTech.getResourcePath("textures/gui/basicmachines", "AlloySmelter"), 2, 1, 2, 0, 1, "", 1, "", true, true).setSlotOverlay(false, false, (IDrawable)GT_UITextures.OVERLAY_SLOT_FURNACE).setRecipeEmitter(b -> {
            ItemStack aInput1;
            if (Materials.Graphite.contains(b.getItemInputBasic(0))) {
                return Collections.emptyList();
            }
            if (GT_Utility.isArrayOfLength(b.getItemInputsBasic(), 1) && (OrePrefixes.ingot.contains(aInput1 = b.getItemInputBasic(0)) || OrePrefixes.dust.contains(aInput1) || OrePrefixes.gem.contains(aInput1))) {
                return Collections.emptyList();
            }
            return GT_RecipeMapUtil.buildOrEmpty(b.validateNoInputFluid().validateNoOutputFluid().validateInputCount(1, 2).validateOutputCount(1, 1));
        }).setRecipeConfigFile("alloysmelting", r -> GT_Config.getStackConfigName(GT_Utility.isArrayOfLength(r.mInputs, 1) ? r.mInputs[0] : r.mOutputs[0])).setProgressBar(GT_UITextures.PROGRESSBAR_ARROW, ProgressBar.Direction.RIGHT).setSlotOverlaySteam(false, GT_UITextures.OVERLAY_SLOT_FURNACE_STEAM).setProgressBarSteam(GT_UITextures.PROGRESSBAR_ARROW_STEAM);
        public static final GT_Recipe_Map sAssemblerRecipes = new GT_Recipe_Map_Assembler(new HashSet<GT_Recipe>(8200), "gt.recipe.assembler", null, null, Mods.GregTech.getResourcePath("textures/gui/basicmachines", "Assembler2"), 9, 1, 1, 0, 1, "", 1, "", true, true).setSlotOverlay(false, false, (IDrawable)GT_UITextures.OVERLAY_SLOT_CIRCUIT).setRecipeConfigFile("assembling", GT_RecipeMapUtil.FIRST_ITEM_OUTPUT).setProgressBar(GT_UITextures.PROGRESSBAR_ASSEMBLE, ProgressBar.Direction.RIGHT).setDisableOptimize(true);
        public static final GT_Recipe_Map sCircuitAssemblerRecipes = new GT_Recipe_Map_Assembler(new HashSet<GT_Recipe>(605), "gt.recipe.circuitassembler", null, null, Mods.GregTech.getResourcePath("textures/gui/basicmachines", "CircuitAssembler"), 6, 1, 1, 0, 1, "", 1, "", true, true).setNEIUnificateOutput(!Mods.NEICustomDiagrams.isModLoaded()).setRecipeConfigFile("circuitassembler", GT_RecipeMapUtil.FIRST_ITEM_OUTPUT).setSlotOverlay(false, false, (IDrawable)GT_UITextures.OVERLAY_SLOT_CIRCUIT).setProgressBar(GT_UITextures.PROGRESSBAR_CIRCUIT_ASSEMBLER, ProgressBar.Direction.RIGHT);
        public static final GT_Recipe_Map sCannerRecipes = new GT_Recipe_Map(new HashSet<GT_Recipe>(900), "gt.recipe.canner", null, null, Mods.GregTech.getResourcePath("textures/gui/basicmachines", "Canner"), 2, 2, 1, 0, 1, "", 1, "", true, true).setSlotOverlay(false, false, true, (IDrawable)GT_UITextures.OVERLAY_SLOT_CANNER).setRecipeConfigFile("canning", GT_RecipeMapUtil.FIRST_ITEM_INPUT).setSlotOverlay(false, false, false, (IDrawable)GT_UITextures.OVERLAY_SLOT_CANISTER).setProgressBar(GT_UITextures.PROGRESSBAR_CANNER, ProgressBar.Direction.RIGHT);
        @Deprecated
        public static final GT_Recipe_Map sCNCRecipes = new GT_Recipe_Map(new HashSet<GT_Recipe>(100), "gt.recipe.cncmachine", "CNC Machine", null, Mods.GregTech.getResourcePath("textures/gui/basicmachines", "Default"), 2, 1, 2, 1, 1, "", 1, "", true, true).setProgressBar(GT_UITextures.PROGRESSBAR_ARROW, ProgressBar.Direction.RIGHT);
        public static final GT_Recipe_Map sLatheRecipes = new GT_Recipe_Map(new HashSet<GT_Recipe>(1150), "gt.recipe.lathe", null, null, Mods.GregTech.getResourcePath("textures/gui/basicmachines", "Lathe"), 1, 2, 1, 0, 1, "", 1, "", true, true).setSlotOverlay(false, false, (IDrawable)GT_UITextures.OVERLAY_SLOT_ROD_1).setSlotOverlay(false, true, true, (IDrawable)GT_UITextures.OVERLAY_SLOT_ROD_2).setSlotOverlay(false, true, false, (IDrawable)GT_UITextures.OVERLAY_SLOT_DUST).setRecipeConfigFile("lathe", GT_RecipeMapUtil.FIRST_ITEM_INPUT).setProgressBar(GT_UITextures.PROGRESSBAR_LATHE, ProgressBar.Direction.RIGHT).addSpecialTexture(5, 18, 98, 24, (IDrawable)GT_UITextures.PROGRESSBAR_LATHE_BASE);
        public static final GT_Recipe_Map sCutterRecipes = new GT_Recipe_Map(new HashSet<GT_Recipe>(5125), "gt.recipe.cuttingsaw", null, null, Mods.GregTech.getResourcePath("textures/gui/basicmachines", "Cutter4"), 2, 4, 1, 1, 1, "", 1, "", true, true).setSlotOverlay(false, false, (IDrawable)GT_UITextures.OVERLAY_SLOT_BOX).setSlotOverlay(false, true, true, (IDrawable)GT_UITextures.OVERLAY_SLOT_CUTTER_SLICED).setSlotOverlay(false, true, false, (IDrawable)GT_UITextures.OVERLAY_SLOT_DUST).setRecipeEmitter(b -> {
            b.validateInputCount(1, 2).validateOutputCount(1, 4).validateNoOutputFluid();
            if (b.getFluidInputs() != null || !b.isValid()) {
                return GT_RecipeMapUtil.buildOrEmpty(b.validateInputFluidCount(1, 1));
            }
            int aDuration = b.getDuration();
            int aEUt = b.getEUt();
            ArrayList ret = new ArrayList();
            b.copy().fluidInputs(Materials.Water.getFluid(GT_Utility.clamp(aDuration * aEUt / 320, 4, 1000))).duration(aDuration * 2).build().ifPresent(ret::add);
            b.copy().fluidInputs(GT_ModHandler.getDistilledWater(GT_Utility.clamp(aDuration * aEUt / 426, 3, 750))).duration(aDuration * 2).build().ifPresent(ret::add);
            b.fluidInputs(Materials.Lubricant.getFluid(GT_Utility.clamp(aDuration * aEUt / 1280, 1, 250))).duration(aDuration).build().ifPresent(ret::add);
            return ret;
        }).setRecipeConfigFile("cutting", GT_RecipeMapUtil.FIRST_ITEM_INPUT).setProgressBar(GT_UITextures.PROGRESSBAR_CUT, ProgressBar.Direction.RIGHT);
        public static final GT_Recipe_Map sSlicerRecipes = new GT_Recipe_Map(new HashSet<GT_Recipe>(20), "gt.recipe.slicer", null, null, Mods.GregTech.getResourcePath("textures/gui/basicmachines", "Slicer"), 2, 1, 2, 0, 1, "", 1, "", true, true).setSlotOverlay(false, false, true, (IDrawable)GT_UITextures.OVERLAY_SLOT_SQUARE).setSlotOverlay(false, false, false, (IDrawable)GT_UITextures.OVERLAY_SLOT_SLICE_SHAPE).setSlotOverlay(false, true, (IDrawable)GT_UITextures.OVERLAY_SLOT_SLICER_SLICED).setRecipeConfigFile("slicer", GT_RecipeMapUtil.FIRST_ITEM_OUTPUT).setProgressBar(GT_UITextures.PROGRESSBAR_SLICE, ProgressBar.Direction.RIGHT);
        public static final GT_Recipe_Map sExtruderRecipes = new GT_Recipe_Map(new HashSet<GT_Recipe>(13000), "gt.recipe.extruder", null, null, Mods.GregTech.getResourcePath("textures/gui/basicmachines", "Extruder"), 2, 1, 2, 0, 1, "", 1, "", true, true).setSlotOverlay(false, false, false, (IDrawable)GT_UITextures.OVERLAY_SLOT_EXTRUDER_SHAPE).setRecipeConfigFile("extruder", GT_RecipeMapUtil.FIRST_ITEM_OUTPUT).setProgressBar(GT_UITextures.PROGRESSBAR_EXTRUDE, ProgressBar.Direction.RIGHT);
        public static final GT_Recipe_Map sHammerRecipes = new GT_Recipe_Map(new HashSet<GT_Recipe>(3800), "gt.recipe.hammer", null, null, Mods.GregTech.getResourcePath("textures/gui/basicmachines", "Hammer"), 2, 2, 1, 0, 1, "", 1, "", true, true).setUsualFluidInputCount(2).setUsualFluidOutputCount(2).setSlotOverlay(false, false, (IDrawable)GT_UITextures.OVERLAY_SLOT_HAMMER).setRecipeConfigFile("forgehammer", GT_RecipeMapUtil.FIRST_ITEM_OUTPUT).setProgressBar(GT_UITextures.PROGRESSBAR_HAMMER, ProgressBar.Direction.DOWN).addSpecialTexture(20, 6, 78, 42, (IDrawable)GT_UITextures.PROGRESSBAR_HAMMER_BASE).setSlotOverlaySteam(false, GT_UITextures.OVERLAY_SLOT_HAMMER_STEAM).setProgressBarSteam(GT_UITextures.PROGRESSBAR_HAMMER_STEAM).addSpecialTextureSteam(20, 6, 78, 42, GT_UITextures.PROGRESSBAR_HAMMER_BASE_STEAM);
        public static final GT_Recipe_Map sAmplifiers = new GT_Recipe_Map(new HashSet<GT_Recipe>(2), "gt.recipe.uuamplifier", null, null, Mods.GregTech.getResourcePath("textures/gui/basicmachines", "Amplifabricator"), 1, 0, 1, 0, 1, "", 1, "", true, true).setSlotOverlay(false, false, (IDrawable)GT_UITextures.OVERLAY_SLOT_CENTRIFUGE).setSlotOverlay(true, true, (IDrawable)GT_UITextures.OVERLAY_SLOT_UUA).setRecipeConfigFile("amplifier", GT_RecipeMapUtil.FIRST_ITEM_INPUT).setProgressBar(GT_UITextures.PROGRESSBAR_EXTRACT, ProgressBar.Direction.RIGHT);
        public static final GT_Recipe_Map sMassFabFakeRecipes = new GT_Recipe_Map(new HashSet<GT_Recipe>(2), "gt.recipe.massfab", null, null, Mods.GregTech.getResourcePath("textures/gui/basicmachines", "Massfabricator"), 1, 0, 1, 0, 8, "", 1, "", true, true).setSlotOverlay(true, false, (IDrawable)GT_UITextures.OVERLAY_SLOT_UUA).setSlotOverlay(true, true, (IDrawable)GT_UITextures.OVERLAY_SLOT_UUM).setProgressBar(GT_UITextures.PROGRESSBAR_ARROW, ProgressBar.Direction.RIGHT);
        public static final GT_Recipe_Map_Fuel sDieselFuels = (GT_Recipe_Map_Fuel)new GT_Recipe_Map_Fuel(new HashSet<GT_Recipe>(20), "gt.recipe.dieselgeneratorfuel", "Combustion Generator Fuels", null, Mods.GregTech.getResourcePath("textures/gui/basicmachines", "Default"), 1, 1, 0, 0, 1, "Fuel Value: ", 1000, " EU", true, true).setProgressBar(GT_UITextures.PROGRESSBAR_ARROW, ProgressBar.Direction.RIGHT);
        public static final GT_Recipe_Map_Fuel sExtremeDieselFuels = (GT_Recipe_Map_Fuel)new GT_Recipe_Map_Fuel(new HashSet<GT_Recipe>(20), "gt.recipe.extremedieselgeneratorfuel", "Extreme Diesel Engine Fuel", null, Mods.GregTech.getResourcePath("textures/gui/basicmachines", "Default"), 1, 1, 0, 0, 1, "Fuel Value: ", 1000, " EU", true, true).setProgressBar(GT_UITextures.PROGRESSBAR_ARROW, ProgressBar.Direction.RIGHT);
        public static final GT_Recipe_Map_Fuel sTurbineFuels = (GT_Recipe_Map_Fuel)new GT_Recipe_Map_Fuel(new HashSet<GT_Recipe>(25), "gt.recipe.gasturbinefuel", "Gas Turbine Fuel", null, Mods.GregTech.getResourcePath("textures/gui/basicmachines", "Default"), 1, 1, 0, 0, 1, "Fuel Value: ", 1000, " EU", true, true).setProgressBar(GT_UITextures.PROGRESSBAR_ARROW, ProgressBar.Direction.RIGHT);
        public static final GT_Recipe_Map_Fuel sHotFuels = new GT_Recipe_Map_Fuel(new HashSet<GT_Recipe>(10), "gt.recipe.thermalgeneratorfuel", "Thermal Generator Fuels", null, Mods.GregTech.getResourcePath("textures/gui/basicmachines", "Default"), 1, 1, 0, 0, 1, "Fuel Value: ", 1000, " EU", true, false);
        public static final GT_Recipe_Map_Fuel sDenseLiquidFuels = (GT_Recipe_Map_Fuel)new GT_Recipe_Map_Fuel(new HashSet<GT_Recipe>(15), "gt.recipe.semifluidboilerfuels", "Semifluid Boiler Fuels", null, Mods.GregTech.getResourcePath("textures/gui/basicmachines", "Default"), 1, 1, 0, 0, 1, "Fuel Value: ", 1000, " EU", true, true).setProgressBar(GT_UITextures.PROGRESSBAR_ARROW, ProgressBar.Direction.RIGHT);
        public static final GT_Recipe_Map_Fuel sPlasmaFuels = (GT_Recipe_Map_Fuel)new GT_Recipe_Map_Fuel(new HashSet<GT_Recipe>(100), "gt.recipe.plasmageneratorfuels", "Plasma Generator Fuels", null, Mods.GregTech.getResourcePath("textures/gui/basicmachines", "Default"), 1, 1, 0, 0, 1, "Fuel Value: ", 1000, " EU", true, true).setProgressBar(GT_UITextures.PROGRESSBAR_ARROW, ProgressBar.Direction.RIGHT);
        public static final GT_Recipe_Map_Fuel sMagicFuels = (GT_Recipe_Map_Fuel)new GT_Recipe_Map_Fuel(new HashSet<GT_Recipe>(100), "gt.recipe.magicfuels", "Magic Energy Absorber Fuels", null, Mods.GregTech.getResourcePath("textures/gui/basicmachines", "Default"), 1, 1, 0, 0, 1, "Fuel Value: ", 1000, " EU", true, true).setProgressBar(GT_UITextures.PROGRESSBAR_ARROW, ProgressBar.Direction.RIGHT);
        public static final GT_Recipe_Map_Fuel sSmallNaquadahReactorFuels = (GT_Recipe_Map_Fuel)new GT_Recipe_Map_Fuel(new HashSet<GT_Recipe>(1), "gt.recipe.smallnaquadahreactor", "Naquadah Reactor MkI", null, Mods.GregTech.getResourcePath("textures/gui/basicmachines", "Default"), 1, 1, 0, 0, 1, "Fuel Value: ", 1000, " EU", true, true).setProgressBar(GT_UITextures.PROGRESSBAR_ARROW, ProgressBar.Direction.RIGHT);
        public static final GT_Recipe_Map_Fuel sLargeNaquadahReactorFuels = (GT_Recipe_Map_Fuel)new GT_Recipe_Map_Fuel(new HashSet<GT_Recipe>(1), "gt.recipe.largenaquadahreactor", "Naquadah Reactor MkII", null, Mods.GregTech.getResourcePath("textures/gui/basicmachines", "Default"), 1, 1, 0, 0, 1, "Fuel Value: ", 1000, " EU", true, true).setProgressBar(GT_UITextures.PROGRESSBAR_ARROW, ProgressBar.Direction.RIGHT);
        public static final GT_Recipe_Map_Fuel sHugeNaquadahReactorFuels = (GT_Recipe_Map_Fuel)new GT_Recipe_Map_Fuel(new HashSet<GT_Recipe>(1), "gt.recipe.fluidnaquadahreactor", "Naquadah Reactor MkIII", null, Mods.GregTech.getResourcePath("textures/gui/basicmachines", "Default"), 1, 1, 0, 0, 1, "Fuel Value: ", 1000, " EU", true, true).setProgressBar(GT_UITextures.PROGRESSBAR_ARROW, ProgressBar.Direction.RIGHT);
        public static final GT_Recipe_Map_Fuel sExtremeNaquadahReactorFuels = (GT_Recipe_Map_Fuel)new GT_Recipe_Map_Fuel(new HashSet<GT_Recipe>(1), "gt.recipe.hugenaquadahreactor", "Naquadah Reactor MkIV", null, Mods.GregTech.getResourcePath("textures/gui/basicmachines", "Default"), 1, 1, 0, 0, 1, "Fuel Value: ", 1000, " EU", true, true).setProgressBar(GT_UITextures.PROGRESSBAR_ARROW, ProgressBar.Direction.RIGHT);
        public static final GT_Recipe_Map_Fuel sUltraHugeNaquadahReactorFuels = (GT_Recipe_Map_Fuel)new GT_Recipe_Map_Fuel(new HashSet<GT_Recipe>(1), "gt.recipe.extrahugenaquadahreactor", "Naquadah Reactor MkV", null, Mods.GregTech.getResourcePath("textures/gui/basicmachines", "Default"), 1, 1, 0, 0, 1, "Fuel Value: ", 1000, " EU", true, true).setProgressBar(GT_UITextures.PROGRESSBAR_ARROW, ProgressBar.Direction.RIGHT);
        public static final GT_Recipe_Map_Fuel sFluidNaquadahReactorFuels = (GT_Recipe_Map_Fuel)new GT_Recipe_Map_Fuel(new HashSet<GT_Recipe>(1), "gt.recipe.fluidfuelnaquadahreactor", "Fluid Naquadah Reactor", null, Mods.GregTech.getResourcePath("textures/gui/basicmachines", "Default"), 1, 1, 0, 0, 1, "Fuel Value: ", 1000, " EU", true, true).setProgressBar(GT_UITextures.PROGRESSBAR_ARROW, ProgressBar.Direction.RIGHT);
        public static final GT_Recipe_Map sMultiblockElectrolyzerRecipes = new GT_Recipe_Map(new HashSet<GT_Recipe>(300), "gt.recipe.largeelectrolyzer", "Large(PA) Electrolyzer", null, Mods.GregTech.getResourcePath("textures/gui/basicmachines", "LCRNEI"), 1, 9, 0, 0, 1, "", 0, "", true, false).setRecipeEmitter(GT_RecipeMapUtil::buildRecipeForMultiblock);
        public static final GT_Recipe_Map sMultiblockCentrifugeRecipes = new GT_Recipe_Map(new HashSet<GT_Recipe>(1200), "gt.recipe.largecentrifuge", "Large(PA) Centrifuge", null, Mods.GregTech.getResourcePath("textures/gui/basicmachines", "LCRNEI"), 1, 9, 0, 0, 1, "", 0, "", true, false).setRecipeEmitter(GT_RecipeMapUtil::buildRecipeForMultiblock).setDisableOptimize(true);
        public static final GT_Recipe_Map sMultiblockMixerRecipes = new GT_Recipe_Map(new HashSet<GT_Recipe>(900), "gt.recipe.largemixer", "Large(PA) Mixer", null, Mods.GregTech.getResourcePath("textures/gui/basicmachines", "LCRNEI"), 9, 3, 0, 0, 1, "", 0, "", true, false).setRecipeEmitter(GT_RecipeMapUtil::buildRecipeForMultiblockNoCircuit).setDisableOptimize(true);
        public static final GT_Recipe_Map_LargeBoilerFakeFuels sLargeBoilerFakeFuels = (GT_Recipe_Map_LargeBoilerFakeFuels)new GT_Recipe_Map_LargeBoilerFakeFuels().setProgressBar(GT_UITextures.PROGRESSBAR_ARROW, ProgressBar.Direction.RIGHT).setDisableOptimize(true);
        public static final GT_Recipe_Map sNanoForge = new GT_Recipe_Map(new HashSet<GT_Recipe>(10), "gt.recipe.nanoforge", "Nano Forge", null, Mods.GregTech.getResourcePath("textures/gui/basicmachines", "LCRNEI"), 6, 2, 2, 1, 1, "Tier: ", 1, "", false, true).useModularUI(true).setUsualFluidInputCount(3).setDisableOptimize(true).setSlotOverlay(false, false, true, (IDrawable)GT_UITextures.OVERLAY_SLOT_LENS).setProgressBar(GT_UITextures.PROGRESSBAR_ASSEMBLE, ProgressBar.Direction.RIGHT);
        public static final GT_Recipe_Map sPCBFactory = new GT_Recipe_Map(new HashSet<GT_Recipe>(10), "gt.recipe.pcbfactory", "PCB Factory", null, Mods.GregTech.getResourcePath("textures/gui/basicmachines", "LCRNEI"), 6, 9, 3, 1, 1, "", 0, "", true, true).useModularUI(true).setUsualFluidInputCount(3).setUsualFluidOutputCount(0).setDisableOptimize(true).setProgressBar(GT_UITextures.PROGRESSBAR_ASSEMBLE, ProgressBar.Direction.RIGHT).setNEISpecialInfoFormatter((recipeInfo, applyPrefixAndSuffix) -> {
            ArrayList<String> result = new ArrayList<String>();
            int bitmap = recipeInfo.recipe.mSpecialValue;
            if ((bitmap & 1) > 0) {
                result.add(GT_Utility.trans("336", "PCB Factory Tier: ") + 1);
            } else if ((bitmap & 2) > 0) {
                result.add(GT_Utility.trans("336", "PCB Factory Tier: ") + 2);
            } else if ((bitmap & 4) > 0) {
                result.add(GT_Utility.trans("336", "PCB Factory Tier: ") + 3);
            }
            if ((bitmap & 8) > 0) {
                result.add(GT_Utility.trans("337", "Upgrade Required: ") + GT_Utility.trans("338", "Bio"));
            }
            return result;
        });
        public static final GT_Recipe_Map_IC2NuclearFake sIC2NuclearFakeRecipe = (GT_Recipe_Map_IC2NuclearFake)new GT_Recipe_Map_IC2NuclearFake().setDisableOptimize(true);
        public final Map<GT_ItemStack, Collection<GT_Recipe>> mRecipeItemMap = new HashMap<GT_ItemStack, Collection<GT_Recipe>>();
        public final Map<String, Collection<GT_Recipe>> mRecipeFluidMap = new HashMap<String, Collection<GT_Recipe>>();
        public final HashSet<String> mRecipeFluidNameMap = new HashSet();
        public final Collection<GT_Recipe> mRecipeList;
        public final String mUnlocalizedName;
        public final String mNEIName;
        public final String mNEIGUIPath;
        public final String mNEISpecialValuePre;
        public final String mNEISpecialValuePost;
        public final int mUsualInputCount;
        public final int mUsualOutputCount;
        public final int mNEISpecialValueMultiplier;
        public final int mMinimalInputItems;
        public final int mMinimalInputFluids;
        public final int mAmperage;
        public final boolean mNEIAllowed;
        public final boolean mShowVoltageAmperageInNEI;
        public boolean mNEIUnificateOutput = true;
        public final String mUniqueIdentifier;
        private boolean mHasFluidOutputs = false;
        private boolean mUsesSpecialSlot = false;
        private boolean isSpecialSlotSensitive = false;
        private int usualFluidInputCount;
        private int usualFluidOutputCount;
        public boolean useModularUI = false;
        private final TByteObjectMap<IDrawable> slotOverlays = new TByteObjectHashMap();
        private final TByteObjectMap<SteamTexture> slotOverlaysSteam = new TByteObjectHashMap();
        private FallbackableUITexture progressBarTexture;
        private FallbackableSteamTexture progressBarTextureSteam;
        public ProgressBar.Direction progressBarDirection = ProgressBar.Direction.RIGHT;
        public Size progressBarSize = new Size(20, 18);
        public Pos2d progressBarPos = new Pos2d(78, 24);
        public Rectangle neiTransferRect;
        private int progressBarImageSize;
        public final List<Pair<IDrawable, Pair<Size, Pos2d>>> specialTextures;
        public final List<Pair<SteamTexture, Pair<Size, Pos2d>>> specialTexturesSteam;
        public IDrawable logo;
        public Pos2d logoPos;
        public Size logoSize;
        public Pos2d neiBackgroundOffset;
        public Size neiBackgroundSize;
        protected final GT_GUIColorOverride colorOverride;
        private int neiTextColorOverride;
        private INEISpecialInfoFormatter neiSpecialInfoFormatter;
        private final boolean checkForCollision = true;
        private boolean allowNoInput;
        private boolean allowNoInputFluid;
        private boolean allowNoOutput;
        private boolean allowNoOutputFluid;
        private boolean disableOptimize;
        private Function<? super GT_RecipeBuilder, ? extends Iterable<? extends GT_Recipe>> recipeEmitter;
        private Function<? super GT_Recipe, ? extends GT_Recipe> specialHandler;
        private String recipeConfigCategory;
        private Function<? super GT_Recipe, String> recipeConfigKeyConvertor;
        private final List<IGT_RecipeMap> downstreams;
        public boolean useComparatorForNEI;
        public boolean renderRealStackSizes;

        @Nullable
        public static GT_Recipe_Map findRecipeMap(@Nonnull String unlocalizedName) {
            return sMappings.stream().filter(m -> unlocalizedName.equals(m.mUnlocalizedName)).findFirst().orElse(null);
        }

        public GT_Recipe_Map(Collection<GT_Recipe> aRecipeList, String aUnlocalizedName, String aLocalName, String aNEIName, String aNEIGUIPath, int aUsualInputCount, int aUsualOutputCount, int aMinimalInputItems, int aMinimalInputFluids, int aAmperage, String aNEISpecialValuePre, int aNEISpecialValueMultiplier, String aNEISpecialValuePost, boolean aShowVoltageAmperageInNEI, boolean aNEIAllowed) {
            this.neiTransferRect = new Rectangle(this.progressBarPos.x - 8, this.progressBarPos.y, this.progressBarSize.width + 16, this.progressBarSize.height);
            this.specialTextures = new ArrayList<Pair<IDrawable, Pair<Size, Pos2d>>>();
            this.specialTexturesSteam = new ArrayList<Pair<SteamTexture, Pair<Size, Pos2d>>>();
            this.logo = GT_UITextures.PICTURE_GT_LOGO_17x17_TRANSPARENT;
            this.logoPos = new Pos2d(152, 63);
            this.logoSize = new Size(17, 17);
            this.neiBackgroundOffset = new Pos2d(2, 3);
            this.neiBackgroundSize = new Size(172, 82);
            this.neiTextColorOverride = -1;
            this.checkForCollision = true;
            this.disableOptimize = false;
            this.recipeEmitter = this::defaultBuildRecipe;
            this.downstreams = new ArrayList<IGT_RecipeMap>(0);
            this.renderRealStackSizes = true;
            sMappings.add(this);
            this.mNEIAllowed = aNEIAllowed;
            this.mShowVoltageAmperageInNEI = aShowVoltageAmperageInNEI;
            this.mRecipeList = aRecipeList;
            this.mNEIName = aNEIName == null ? aUnlocalizedName : aNEIName;
            this.mNEIGUIPath = aNEIGUIPath.endsWith(".png") ? aNEIGUIPath : aNEIGUIPath + ".png";
            this.mNEISpecialValuePre = aNEISpecialValuePre;
            this.mNEISpecialValueMultiplier = aNEISpecialValueMultiplier;
            this.mNEISpecialValuePost = aNEISpecialValuePost;
            this.mAmperage = aAmperage;
            this.mUsualInputCount = aUsualInputCount;
            this.mUsualOutputCount = aUsualOutputCount;
            this.mMinimalInputItems = aMinimalInputItems;
            this.mMinimalInputFluids = aMinimalInputFluids;
            GregTech_API.sItemStackMappings.add(this.mRecipeItemMap);
            this.mUnlocalizedName = aUnlocalizedName;
            if (aLocalName != null) {
                GT_LanguageManager.addStringLocalization(this.mUnlocalizedName, aLocalName);
            }
            this.mUniqueIdentifier = String.format("%s_%d_%d_%d_%d_%d", aUnlocalizedName, aAmperage, aUsualInputCount, aUsualOutputCount, aMinimalInputFluids, aMinimalInputItems);
            this.progressBarTexture = new FallbackableUITexture(UITexture.fullImage((String)Mods.GregTech.ID, (String)("gui/progressbar/" + this.mUnlocalizedName)), GT_UITextures.PROGRESSBAR_ARROW);
            this.colorOverride = GT_GUIColorOverride.get(ModularUITextures.VANILLA_BACKGROUND.location);
            if (sIndexedMappings.put(this.mUniqueIdentifier, this) != null) {
                throw new IllegalArgumentException("Duplicate recipe map registered: " + this.mUniqueIdentifier);
            }
        }

        @Deprecated
        public GT_Recipe_Map(Collection<GT_Recipe> aRecipeList, String aUnlocalizedName, String aLocalName, String aNEIName, String aNEIGUIPath, int aUsualInputCount, int aUsualOutputCount, int aMinimalInputItems, int aMinimalInputFluids, int aAmperage, String aNEISpecialValuePre, int aNEISpecialValueMultiplier, String aNEISpecialValuePost, boolean aShowVoltageAmperageInNEI, boolean aNEIAllowed, boolean aNEIUnificateOutput) {
            this(aRecipeList, aUnlocalizedName, aLocalName, aNEIName, aNEIGUIPath, aUsualInputCount, aUsualOutputCount, aMinimalInputItems, aMinimalInputFluids, aAmperage, aNEISpecialValuePre, aNEISpecialValueMultiplier, aNEISpecialValuePost, aShowVoltageAmperageInNEI, aNEIAllowed);
            this.setNEIUnificateOutput(aNEIUnificateOutput);
        }

        public GT_Recipe_Map setDisableOptimize(boolean disableOptimize) {
            this.disableOptimize = disableOptimize;
            return this;
        }

        public GT_Recipe_Map setSpecialSlotSensitive(boolean isSpecialSlotSensitive) {
            this.isSpecialSlotSensitive = isSpecialSlotSensitive;
            return this;
        }

        public GT_Recipe_Map setNEIUnificateOutput(boolean mNEIUnificateOutput) {
            this.mNEIUnificateOutput = mNEIUnificateOutput;
            return this;
        }

        public GT_Recipe_Map useComparatorForNEI(boolean use) {
            this.useComparatorForNEI = use;
            return this;
        }

        public GT_Recipe_Map setRenderRealStackSizes(boolean renderRealStackSizes) {
            this.renderRealStackSizes = renderRealStackSizes;
            return this;
        }

        public GT_Recipe_Map useModularUI(boolean use) {
            this.useModularUI = use;
            return this;
        }

        public GT_Recipe_Map setSlotOverlay(boolean isFluid, boolean isOutput, boolean isFirst, boolean isSpecial, IDrawable slotOverlay) {
            this.useModularUI(true);
            this.slotOverlays.put((byte)((isFluid ? 1 : 0) + (isOutput ? 2 : 0) + (isFirst ? 4 : 0) + (isSpecial ? 8 : 0)), (Object)slotOverlay);
            return this;
        }

        public GT_Recipe_Map setSlotOverlay(boolean isFluid, boolean isOutput, boolean isFirst, IDrawable slotOverlay) {
            return this.setSlotOverlay(isFluid, isOutput, isFirst, false, slotOverlay);
        }

        public GT_Recipe_Map setSlotOverlay(boolean isFluid, boolean isOutput, IDrawable slotOverlay) {
            return this.setSlotOverlay(isFluid, isOutput, true, slotOverlay).setSlotOverlay(isFluid, isOutput, false, slotOverlay);
        }

        public GT_Recipe_Map setSlotOverlaySteam(boolean isFluid, boolean isOutput, boolean isFirst, boolean isSpecial, SteamTexture slotOverlay) {
            this.useModularUI(true);
            this.slotOverlaysSteam.put((byte)((isFluid ? 1 : 0) + (isOutput ? 2 : 0) + (isFirst ? 4 : 0) + (isSpecial ? 8 : 0)), (Object)slotOverlay);
            return this;
        }

        public GT_Recipe_Map setSlotOverlaySteam(boolean isOutput, boolean isFirst, SteamTexture slotOverlay) {
            return this.setSlotOverlaySteam(false, isOutput, isFirst, false, slotOverlay);
        }

        public GT_Recipe_Map setSlotOverlaySteam(boolean isOutput, SteamTexture slotOverlay) {
            return this.setSlotOverlaySteam(false, isOutput, true, false, slotOverlay).setSlotOverlaySteam(false, isOutput, false, false, slotOverlay);
        }

        public GT_Recipe_Map setProgressBar(UITexture progressBarTexture, ProgressBar.Direction progressBarDirection) {
            return this.setProgressBarWithFallback(new FallbackableUITexture(UITexture.fullImage((String)Mods.GregTech.ID, (String)("gui/progressbar/" + this.mUnlocalizedName)), progressBarTexture), progressBarDirection);
        }

        public GT_Recipe_Map setProgressBar(UITexture progressBarTexture) {
            return this.setProgressBar(progressBarTexture, ProgressBar.Direction.RIGHT);
        }

        public GT_Recipe_Map setProgressBarWithFallback(FallbackableUITexture progressBarTexture, ProgressBar.Direction progressBarDirection) {
            this.useModularUI(true);
            this.progressBarTexture = progressBarTexture;
            this.progressBarDirection = progressBarDirection;
            return this;
        }

        public GT_Recipe_Map setProgressBarSteam(SteamTexture progressBarTexture) {
            return this.setProgressBarSteamWithFallback(new FallbackableSteamTexture(SteamTexture.fullImage(Mods.GregTech.ID, "gui/progressbar/" + this.mUnlocalizedName + "_%s"), progressBarTexture));
        }

        public GT_Recipe_Map setProgressBarSteamWithFallback(FallbackableSteamTexture progressBarTexture) {
            this.progressBarTextureSteam = progressBarTexture;
            return this;
        }

        public GT_Recipe_Map setProgressBarSize(int x, int y) {
            this.useModularUI(true);
            this.progressBarSize = new Size(x, y);
            return this;
        }

        public GT_Recipe_Map setProgressBarPos(int x, int y) {
            this.useModularUI(true);
            this.progressBarPos = new Pos2d(x, y);
            return this;
        }

        public GT_Recipe_Map setProgressBarImageSize(int progressBarImageSize) {
            this.useModularUI(true);
            this.progressBarImageSize = progressBarImageSize;
            return this;
        }

        public GT_Recipe_Map setNEITransferRect(Rectangle neiTransferRect) {
            this.useModularUI(true);
            this.neiTransferRect = neiTransferRect;
            return this;
        }

        public GT_Recipe_Map addSpecialTexture(int width, int height, int x, int y, IDrawable texture) {
            this.useModularUI(true);
            this.specialTextures.add((Pair<IDrawable, Pair<Size, Pos2d>>)new ImmutablePair((Object)texture, (Object)new ImmutablePair((Object)new Size(width, height), (Object)new Pos2d(x, y))));
            return this;
        }

        public GT_Recipe_Map addSpecialTextureSteam(int width, int height, int x, int y, SteamTexture texture) {
            this.useModularUI(true);
            this.specialTexturesSteam.add((Pair<SteamTexture, Pair<Size, Pos2d>>)new ImmutablePair((Object)texture, (Object)new ImmutablePair((Object)new Size(width, height), (Object)new Pos2d(x, y))));
            return this;
        }

        public GT_Recipe_Map setUsualFluidInputCount(int usualFluidInputCount) {
            this.useModularUI(true);
            this.usualFluidInputCount = usualFluidInputCount;
            return this;
        }

        public GT_Recipe_Map setUsualFluidOutputCount(int usualFluidOutputCount) {
            this.useModularUI(true);
            this.usualFluidOutputCount = usualFluidOutputCount;
            return this;
        }

        public GT_Recipe_Map setLogo(IDrawable logo) {
            this.useModularUI(true);
            this.logo = logo;
            return this;
        }

        public GT_Recipe_Map setLogoPos(int x, int y) {
            this.useModularUI(true);
            this.logoPos = new Pos2d(x, y);
            return this;
        }

        public GT_Recipe_Map setLogoSize(int width, int height) {
            this.useModularUI(true);
            this.logoSize = new Size(width, height);
            return this;
        }

        public GT_Recipe_Map setNEIBackgroundOffset(int x, int y) {
            this.useModularUI(true);
            this.neiBackgroundOffset = new Pos2d(x, y);
            return this;
        }

        public GT_Recipe_Map setNEIBackgroundSize(int width, int height) {
            this.useModularUI(true);
            this.neiBackgroundSize = new Size(width, height);
            return this;
        }

        public GT_Recipe_Map setNEISpecialInfoFormatter(INEISpecialInfoFormatter neiSpecialInfoFormatter) {
            this.neiSpecialInfoFormatter = neiSpecialInfoFormatter;
            return this;
        }

        public GT_Recipe_Map setRecipeEmitter(Function<? super GT_RecipeBuilder, ? extends Iterable<? extends GT_Recipe>> func) {
            this.recipeEmitter = func;
            return this;
        }

        public GT_Recipe_Map combineRecipeEmitter(Function<? super GT_RecipeBuilder, ? extends Iterable<? extends GT_Recipe>> func) {
            Function<? super GT_RecipeBuilder, ? extends Iterable<? extends GT_Recipe>> cur = this.recipeEmitter;
            this.recipeEmitter = b -> Iterables.concat((Iterable)((Iterable)cur.apply((GT_RecipeBuilder)b)), (Iterable)((Iterable)func.apply((GT_RecipeBuilder)b)));
            return this;
        }

        public GT_Recipe_Map setRecipeEmitterSingle(Function<? super GT_RecipeBuilder, ? extends GT_Recipe> func) {
            return this.setRecipeEmitter(func.andThen(Collections::singletonList));
        }

        public GT_Recipe_Map combineRecipeEmitterSingle(Function<? super GT_RecipeBuilder, ? extends GT_Recipe> func) {
            return this.combineRecipeEmitter(func.andThen(Collections::singletonList));
        }

        private static <T> Function<? super T, ? extends T> withIdentityReturn(Consumer<T> func) {
            return r -> {
                func.accept(r);
                return r;
            };
        }

        public GT_Recipe_Map setRecipeSpecialHandler(Function<? super GT_Recipe, ? extends GT_Recipe> func) {
            this.specialHandler = func;
            return this;
        }

        public GT_Recipe_Map setRecipeSpecialHandler(Consumer<GT_Recipe> func) {
            return this.setRecipeSpecialHandler(GT_Recipe_Map.withIdentityReturn(func));
        }

        public GT_Recipe_Map chainRecipeSpecialHandler(Function<? super GT_Recipe, ? extends GT_Recipe> func) {
            this.specialHandler = this.specialHandler == null ? func : this.specialHandler.andThen(func);
            return this;
        }

        public GT_Recipe_Map chainRecipeSpecialHandler(Consumer<GT_Recipe> func) {
            return this.chainRecipeSpecialHandler(GT_Recipe_Map.withIdentityReturn(func));
        }

        public GT_Recipe_Map setRecipeConfigFile(String category, Function<? super GT_Recipe, String> keyConvertor) {
            if (StringUtils.isBlank((CharSequence)category) || keyConvertor == null) {
                throw new IllegalArgumentException();
            }
            this.recipeConfigCategory = category;
            this.recipeConfigKeyConvertor = keyConvertor;
            return this;
        }

        @Override
        public void addDownstream(IGT_RecipeMap downstream) {
            this.downstreams.add(downstream);
        }

        public GT_Recipe addRecipe(boolean aOptimize, ItemStack[] aInputs, ItemStack[] aOutputs, Object aSpecial, int[] aOutputChances, FluidStack[] aFluidInputs, FluidStack[] aFluidOutputs, int aDuration, int aEUt, int aSpecialValue) {
            return this.addRecipe(new GT_Recipe(aOptimize, aInputs, aOutputs, aSpecial, aOutputChances, aFluidInputs, aFluidOutputs, aDuration, aEUt, aSpecialValue));
        }

        public GT_Recipe addRecipe(int[] aOutputChances, FluidStack[] aFluidInputs, FluidStack[] aFluidOutputs, int aDuration, int aEUt, int aSpecialValue) {
            return this.addRecipe(new GT_Recipe(false, null, null, null, aOutputChances, aFluidInputs, aFluidOutputs, aDuration, aEUt, aSpecialValue), false, false, false);
        }

        public GT_Recipe addRecipe(boolean aOptimize, ItemStack[] aInputs, ItemStack[] aOutputs, Object aSpecial, FluidStack[] aFluidInputs, FluidStack[] aFluidOutputs, int aDuration, int aEUt, int aSpecialValue) {
            return this.addRecipe(new GT_Recipe(aOptimize, aInputs, aOutputs, aSpecial, null, aFluidInputs, aFluidOutputs, aDuration, aEUt, aSpecialValue));
        }

        public GT_Recipe addRecipe(GT_Recipe aRecipe) {
            return this.addRecipe(aRecipe, true, false, false);
        }

        protected GT_Recipe addRecipe(GT_Recipe aRecipe, boolean aCheckForCollisions, boolean aFakeRecipe, boolean aHidden) {
            aRecipe.mHidden = aHidden;
            aRecipe.mFakeRecipe = aFakeRecipe;
            if (aRecipe.mFluidInputs.length < this.mMinimalInputFluids && aRecipe.mInputs.length < this.mMinimalInputItems) {
                return null;
            }
            if (aCheckForCollisions && this.findRecipe(null, false, true, Long.MAX_VALUE, aRecipe.mFluidInputs, aRecipe.mInputs) != null) {
                return null;
            }
            return this.add(aRecipe);
        }

        public GT_Recipe addFakeRecipe(boolean aCheckForCollisions, ItemStack[] aInputs, ItemStack[] aOutputs, Object aSpecial, int[] aOutputChances, FluidStack[] aFluidInputs, FluidStack[] aFluidOutputs, int aDuration, int aEUt, int aSpecialValue) {
            return this.addFakeRecipe(aCheckForCollisions, new GT_Recipe(false, aInputs, aOutputs, aSpecial, aOutputChances, aFluidInputs, aFluidOutputs, aDuration, aEUt, aSpecialValue));
        }

        public GT_Recipe addFakeRecipe(boolean aCheckForCollisions, ItemStack[] aInputs, ItemStack[] aOutputs, Object aSpecial, FluidStack[] aFluidInputs, FluidStack[] aFluidOutputs, int aDuration, int aEUt, int aSpecialValue) {
            return this.addFakeRecipe(aCheckForCollisions, new GT_Recipe(false, aInputs, aOutputs, aSpecial, null, aFluidInputs, aFluidOutputs, aDuration, aEUt, aSpecialValue));
        }

        public GT_Recipe addFakeRecipe(boolean aCheckForCollisions, ItemStack[] aInputs, ItemStack[] aOutputs, Object aSpecial, FluidStack[] aFluidInputs, FluidStack[] aFluidOutputs, int aDuration, int aEUt, int aSpecialValue, boolean hidden) {
            return this.addFakeRecipe(aCheckForCollisions, new GT_Recipe(false, aInputs, aOutputs, aSpecial, null, aFluidInputs, aFluidOutputs, aDuration, aEUt, aSpecialValue), hidden);
        }

        public GT_Recipe addFakeRecipe(boolean aCheckForCollisions, ItemStack[] aInputs, ItemStack[] aOutputs, Object aSpecial, FluidStack[] aFluidInputs, FluidStack[] aFluidOutputs, int aDuration, int aEUt, int aSpecialValue, ItemStack[][] aAlt, boolean hidden) {
            return this.addFakeRecipe(aCheckForCollisions, new GT_Recipe_WithAlt(false, aInputs, aOutputs, aSpecial, null, aFluidInputs, aFluidOutputs, aDuration, aEUt, aSpecialValue, aAlt), hidden);
        }

        public GT_Recipe addFakeRecipe(boolean aCheckForCollisions, GT_Recipe aRecipe) {
            return this.addRecipe(aRecipe, aCheckForCollisions, true, false);
        }

        public GT_Recipe addFakeRecipe(boolean aCheckForCollisions, GT_Recipe aRecipe, boolean hidden) {
            return this.addRecipe(aRecipe, aCheckForCollisions, true, hidden);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @Nonnull
        public Collection<GT_Recipe> doAdd(GT_RecipeBuilder builder) {
            Iterable<? extends GT_Recipe> recipes = this.recipeEmitter.apply(builder);
            ArrayList<GT_Recipe> ret = new ArrayList<GT_Recipe>();
            for (GT_Recipe gT_Recipe : recipes) {
                void var5_5;
                String configKey;
                if (this.recipeConfigCategory != null && (configKey = this.recipeConfigKeyConvertor.apply(gT_Recipe)) != null && (gT_Recipe.mDuration = GregTech_API.sRecipeFile.get((Object)this.recipeConfigCategory, configKey, gT_Recipe.mDuration)) <= 0) continue;
                if (gT_Recipe.mFluidInputs.length < this.mMinimalInputFluids && gT_Recipe.mInputs.length < this.mMinimalInputItems) {
                    return null;
                }
                if (gT_Recipe.mSpecialValue == 0) {
                    int specialValue = 0;
                    if (builder.getMetadata(GT_RecipeConstants.LOW_GRAVITY, false).booleanValue()) {
                        specialValue -= 100;
                    }
                    if (builder.getMetadata(GT_RecipeConstants.CLEANROOM, false).booleanValue()) {
                        specialValue -= 200;
                    }
                    for (GT_RecipeBuilder.MetadataIdentifier<Integer> ident : GT_RecipeMapUtil.SPECIAL_VALUE_ALIASES) {
                        Integer metadata = builder.getMetadata(ident, null);
                        if (metadata == null) continue;
                        specialValue = metadata;
                        break;
                    }
                    gT_Recipe.mSpecialValue = specialValue;
                }
                if (this.specialHandler != null) {
                    GT_Recipe gT_Recipe2 = this.specialHandler.apply(gT_Recipe);
                }
                if (var5_5 == null) continue;
                if (this.findRecipe(null, false, true, Long.MAX_VALUE, var5_5.mFluidInputs, var5_5.mInputs) != null) {
                    String s;
                    StringBuilder errorInfo = new StringBuilder();
                    boolean hasAnEntry = false;
                    for (FluidStack fluidStack : var5_5.mFluidInputs) {
                        if (fluidStack == null || (s = fluidStack.getLocalizedName()) == null) continue;
                        if (hasAnEntry) {
                            errorInfo.append("+").append(s);
                        } else {
                            errorInfo.append(s);
                        }
                        hasAnEntry = true;
                    }
                    for (FluidStack fluidStack : var5_5.mInputs) {
                        if (fluidStack == null) continue;
                        s = fluidStack.func_82833_r();
                        if (hasAnEntry) {
                            errorInfo.append("+").append(s);
                        } else {
                            errorInfo.append(s);
                        }
                        hasAnEntry = true;
                    }
                    GT_RecipeBuilder.handleRecipeCollision(errorInfo.toString());
                    continue;
                }
                ret.add(this.add((GT_Recipe)var5_5));
            }
            if (!ret.isEmpty()) {
                builder.clearInvalid();
                for (IGT_RecipeMap iGT_RecipeMap : this.downstreams) {
                    iGT_RecipeMap.doAdd(builder);
                }
            }
            return ret;
        }

        public final Iterable<? extends GT_Recipe> defaultBuildRecipe(GT_RecipeBuilder builder) {
            GT_RecipeBuilder b = builder;
            if (this.disableOptimize && builder.optimize) {
                b = GT_Recipe_Map.copy(builder, b).noOptimize();
            }
            return GT_RecipeMapUtil.buildOrEmpty(b);
        }

        private static GT_RecipeBuilder copy(GT_RecipeBuilder original, GT_RecipeBuilder b) {
            return b == original ? b.copy() : b;
        }

        public GT_Recipe add(GT_Recipe aRecipe) {
            this.mRecipeList.add(aRecipe);
            for (FluidStack aFluid : aRecipe.mFluidInputs) {
                if (aFluid == null) continue;
                Collection tList = this.mRecipeFluidMap.computeIfAbsent(aFluid.getFluid().getName(), k -> new HashSet(1));
                tList.add(aRecipe);
                this.mRecipeFluidNameMap.add(aFluid.getFluid().getName());
            }
            if (aRecipe.mFluidOutputs.length != 0) {
                this.mHasFluidOutputs = true;
            }
            if (aRecipe.mSpecialItems != null) {
                this.mUsesSpecialSlot = true;
            }
            return this.addToItemMap(aRecipe);
        }

        public void reInit() {
            this.mRecipeItemMap.clear();
            for (GT_Recipe tRecipe : this.mRecipeList) {
                GT_OreDictUnificator.setStackArray(true, tRecipe.mInputs);
                GT_OreDictUnificator.setStackArray(true, tRecipe.mOutputs);
                this.addToItemMap(tRecipe);
            }
        }

        public boolean containsInput(ItemStack aStack) {
            return aStack != null && (this.mRecipeItemMap.containsKey(new GT_ItemStack(aStack)) || this.mRecipeItemMap.containsKey(new GT_ItemStack(aStack, true)));
        }

        public boolean containsInput(FluidStack aFluid) {
            return aFluid != null && this.containsInput(aFluid.getFluid());
        }

        public boolean containsInput(Fluid aFluid) {
            return aFluid != null && this.mRecipeFluidNameMap.contains(aFluid.getName());
        }

        @Nullable
        public final GT_Recipe findRecipe(IHasWorldObjectAndCoords aTileEntity, boolean aNotUnificated, long aVoltage, FluidStack[] aFluids, ItemStack ... aInputs) {
            return this.findRecipe(aTileEntity, (GT_Recipe)null, aNotUnificated, aVoltage, aFluids, (ItemStack)null, aInputs);
        }

        @Nullable
        public final GT_Recipe findRecipe(IHasWorldObjectAndCoords aTileEntity, boolean aNotUnificated, boolean aDontCheckStackSizes, long aVoltage, FluidStack[] aFluids, ItemStack ... aInputs) {
            return this.findRecipe(aTileEntity, (GT_Recipe)null, aNotUnificated, aDontCheckStackSizes, aVoltage, aFluids, (ItemStack)null, aInputs);
        }

        @Nullable
        public final GT_Recipe findRecipe(IHasWorldObjectAndCoords aTileEntity, GT_Recipe aRecipe, boolean aNotUnificated, long aVoltage, FluidStack[] aFluids, ItemStack ... aInputs) {
            return this.findRecipe(aTileEntity, aRecipe, aNotUnificated, aVoltage, aFluids, (ItemStack)null, aInputs);
        }

        @Nullable
        public final GT_Recipe findRecipe(IHasWorldObjectAndCoords aTileEntity, GT_Recipe aRecipe, boolean aNotUnificated, boolean aDontCheckStackSizes, long aVoltage, FluidStack[] aFluids, ItemStack ... aInputs) {
            return this.findRecipe(aTileEntity, aRecipe, aNotUnificated, aDontCheckStackSizes, aVoltage, aFluids, (ItemStack)null, aInputs);
        }

        @Nullable
        public final GT_Recipe findRecipe(IHasWorldObjectAndCoords aTileEntity, GT_Recipe aRecipe, boolean aNotUnificated, long aVoltage, FluidStack[] aFluids, ItemStack aSpecialSlot, ItemStack ... aInputs) {
            return this.findRecipe(aTileEntity, aRecipe, aNotUnificated, false, aVoltage, aFluids, aSpecialSlot, aInputs);
        }

        @Nullable
        public GT_Recipe findRecipe(IHasWorldObjectAndCoords aTileEntity, GT_Recipe aRecipe, boolean aNotUnificated, boolean aDontCheckStackSizes, long aVoltage, FluidStack[] aFluids, ItemStack aSpecialSlot, ItemStack ... aInputs) {
            FindRecipeResult result = this.findRecipeWithResult(aRecipe, aNotUnificated, aDontCheckStackSizes, aVoltage, aFluids, aSpecialSlot, aInputs);
            return result.isSuccessful() ? result.getRecipe() : null;
        }

        @Nonnull
        public FindRecipeResult findRecipeWithResult(GT_Recipe aRecipe, boolean aNotUnificated, boolean aDontCheckStackSizes, long aVoltage, FluidStack[] aFluids, ItemStack aSpecialSlot, ItemStack ... aInputs) {
            Collection<GT_Recipe> tRecipes;
            int n;
            if (this.mRecipeList.isEmpty()) {
                return FindRecipeResult.NOT_FOUND;
            }
            if (GregTech_API.sPostloadFinished) {
                int n2;
                FluidStack[] fluidStackArray;
                int tAmount;
                if (this.mMinimalInputFluids > 0) {
                    if (aFluids == null) {
                        return FindRecipeResult.NOT_FOUND;
                    }
                    tAmount = 0;
                    fluidStackArray = aFluids;
                    n = fluidStackArray.length;
                    for (n2 = 0; n2 < n; ++n2) {
                        FluidStack aFluid = fluidStackArray[n2];
                        if (aFluid == null) continue;
                        ++tAmount;
                    }
                    if (tAmount < this.mMinimalInputFluids) {
                        return FindRecipeResult.NOT_FOUND;
                    }
                }
                if (this.mMinimalInputItems > 0) {
                    if (aInputs == null) {
                        return FindRecipeResult.NOT_FOUND;
                    }
                    tAmount = 0;
                    fluidStackArray = aInputs;
                    n = fluidStackArray.length;
                    for (n2 = 0; n2 < n; ++n2) {
                        FluidStack aInput = fluidStackArray[n2];
                        if (aInput == null) continue;
                        ++tAmount;
                    }
                    if (tAmount < this.mMinimalInputItems) {
                        return FindRecipeResult.NOT_FOUND;
                    }
                }
            }
            if (aNotUnificated) {
                aInputs = GT_OreDictUnificator.getStackArray(true, aInputs);
            }
            if (aRecipe != null && !aRecipe.mFakeRecipe && aRecipe.mCanBeBuffered && aRecipe.isRecipeInputEqual(false, aDontCheckStackSizes, aFluids, aInputs) && (!this.isSpecialSlotSensitive || GT_Utility.areStacksEqualOrNull((ItemStack)aRecipe.mSpecialItems, aSpecialSlot))) {
                return aRecipe.mEnabled && aVoltage * (long)this.mAmperage >= (long)aRecipe.mEUt ? FindRecipeResult.ofSuccess(aRecipe) : FindRecipeResult.ofInsufficientVoltage(aRecipe);
            }
            if (this.mUsualInputCount > 0 && aInputs != null) {
                ItemStack[] itemStackArray = aInputs;
                int n3 = itemStackArray.length;
                for (n = 0; n < n3; ++n) {
                    ItemStack tStack = itemStackArray[n];
                    if (tStack == null) continue;
                    tRecipes = this.mRecipeItemMap.get(new GT_ItemStack(tStack));
                    if (tRecipes != null) {
                        for (GT_Recipe tRecipe : tRecipes) {
                            if (tRecipe.mFakeRecipe || !tRecipe.isRecipeInputEqual(false, aDontCheckStackSizes, aFluids, aInputs) || this.isSpecialSlotSensitive && !GT_Utility.areStacksEqualOrNull((ItemStack)tRecipe.mSpecialItems, aSpecialSlot)) continue;
                            return tRecipe.mEnabled && aVoltage * (long)this.mAmperage >= (long)tRecipe.mEUt ? FindRecipeResult.ofSuccess(tRecipe) : FindRecipeResult.ofInsufficientVoltage(tRecipe);
                        }
                    }
                    if ((tRecipes = this.mRecipeItemMap.get(new GT_ItemStack(tStack, true))) == null) continue;
                    for (GT_Recipe tRecipe : tRecipes) {
                        if (tRecipe.mFakeRecipe || !tRecipe.isRecipeInputEqual(false, aDontCheckStackSizes, aFluids, aInputs) || this.isSpecialSlotSensitive && !GT_Utility.areStacksEqualOrNull((ItemStack)tRecipe.mSpecialItems, aSpecialSlot)) continue;
                        return tRecipe.mEnabled && aVoltage * (long)this.mAmperage >= (long)tRecipe.mEUt ? FindRecipeResult.ofSuccess(tRecipe) : FindRecipeResult.ofInsufficientVoltage(tRecipe);
                    }
                }
            }
            if (this.mMinimalInputItems == 0 && aFluids != null) {
                for (FluidStack aFluid : aFluids) {
                    if (aFluid == null || (tRecipes = this.mRecipeFluidMap.get(aFluid.getFluid().getName())) == null) continue;
                    for (GT_Recipe tRecipe : tRecipes) {
                        if (tRecipe.mFakeRecipe || !tRecipe.isRecipeInputEqual(false, aDontCheckStackSizes, aFluids, aInputs) || this.isSpecialSlotSensitive && !GT_Utility.areStacksEqualOrNull((ItemStack)tRecipe.mSpecialItems, aSpecialSlot)) continue;
                        return tRecipe.mEnabled && aVoltage * (long)this.mAmperage >= (long)tRecipe.mEUt ? FindRecipeResult.ofSuccess(tRecipe) : FindRecipeResult.ofInsufficientVoltage(tRecipe);
                    }
                }
            }
            return FindRecipeResult.NOT_FOUND;
        }

        protected GT_Recipe addToItemMap(GT_Recipe aRecipe) {
            for (ItemStack aStack : aRecipe.mInputs) {
                if (aStack == null) continue;
                GT_ItemStack tStack = new GT_ItemStack(aStack);
                Collection tList = this.mRecipeItemMap.computeIfAbsent(tStack, k -> new HashSet(1));
                tList.add(aRecipe);
            }
            return aRecipe;
        }

        public boolean hasFluidOutputs() {
            return this.mHasFluidOutputs;
        }

        public boolean hasFluidInputs() {
            return this.mRecipeFluidNameMap.size() != 0;
        }

        public boolean usesSpecialSlot() {
            return this.mUsesSpecialSlot;
        }

        public int getUsualFluidInputCount() {
            return Math.max(this.usualFluidInputCount, this.hasFluidInputs() ? 1 : 0);
        }

        public int getUsualFluidOutputCount() {
            return Math.max(this.usualFluidOutputCount, this.hasFluidOutputs() ? 1 : 0);
        }

        @Nullable
        public IDrawable getOverlayForSlot(boolean isFluid, boolean isOutput, int index, boolean isSpecial) {
            byte overlayKey = (byte)((isFluid ? 1 : 0) + (isOutput ? 2 : 0) + (index == 0 ? 4 : 0) + (isSpecial ? 8 : 0));
            if (this.slotOverlays.containsKey(overlayKey)) {
                return (IDrawable)this.slotOverlays.get(overlayKey);
            }
            return null;
        }

        @Nullable
        public SteamTexture getOverlayForSlotSteam(boolean isFluid, boolean isOutput, int index, boolean isSpecial) {
            byte overlayKey = (byte)((isFluid ? 1 : 0) + (isOutput ? 2 : 0) + (index == 0 ? 4 : 0) + (isSpecial ? 8 : 0));
            if (this.slotOverlaysSteam.containsKey(overlayKey)) {
                return (SteamTexture)this.slotOverlaysSteam.get(overlayKey);
            }
            return null;
        }

        @Nullable
        public SteamTexture getOverlayForSlotSteam(boolean isOutput, boolean isFirst) {
            byte overlayKey = (byte)((isOutput ? 2 : 0) + (isFirst ? 4 : 0));
            if (this.slotOverlaysSteam.containsKey(overlayKey)) {
                return (SteamTexture)this.slotOverlaysSteam.get(overlayKey);
            }
            return null;
        }

        public UITexture getProgressBarTexture() {
            return this.progressBarTexture.get();
        }

        public FallbackableUITexture getProgressBarTextureRaw() {
            return this.progressBarTexture;
        }

        public UITexture getProgressBarTextureSteam(SteamVariant steamVariant) {
            return this.progressBarTextureSteam.get(steamVariant);
        }

        public int getProgressBarImageSize() {
            int n;
            if (this.progressBarImageSize != 0) {
                return this.progressBarImageSize;
            }
            switch (this.progressBarDirection) {
                case UP: 
                case DOWN: {
                    n = this.progressBarSize.height;
                    break;
                }
                case CIRCULAR_CW: {
                    n = Math.max(this.progressBarSize.width, this.progressBarSize.height);
                    break;
                }
                default: {
                    n = this.progressBarSize.width;
                }
            }
            return n;
        }

        public ModularWindow.Builder createNEITemplate(IItemHandlerModifiable itemInputsInventory, IItemHandlerModifiable itemOutputsInventory, IItemHandlerModifiable specialSlotInventory, IItemHandlerModifiable fluidInputsInventory, IItemHandlerModifiable fluidOutputsInventory, Supplier<Float> progressSupplier, Pos2d windowOffset) {
            ModularWindow.Builder builder = ModularWindow.builder((Size)this.neiBackgroundSize).setBackground(new IDrawable[]{ModularUITextures.VANILLA_BACKGROUND});
            UIHelper.forEachSlots((i, backgrounds, pos) -> builder.widget(SlotWidget.phantom((IItemHandlerModifiable)itemInputsInventory, (int)i).setBackground(backgrounds).setPos(pos).setSize(18, 18)), (i, backgrounds, pos) -> builder.widget(SlotWidget.phantom((IItemHandlerModifiable)itemOutputsInventory, (int)i).setBackground(backgrounds).setPos(pos).setSize(18, 18)), (i, backgrounds, pos) -> {
                if (this.usesSpecialSlot()) {
                    builder.widget(SlotWidget.phantom((IItemHandlerModifiable)specialSlotInventory, (int)0).setBackground(backgrounds).setPos(pos).setSize(18, 18));
                }
            }, (i, backgrounds, pos) -> builder.widget(SlotWidget.phantom((IItemHandlerModifiable)fluidInputsInventory, (int)i).setBackground(backgrounds).setPos(pos).setSize(18, 18)), (i, backgrounds, pos) -> builder.widget(SlotWidget.phantom((IItemHandlerModifiable)fluidOutputsInventory, (int)i).setBackground(backgrounds).setPos(pos).setSize(18, 18)), (IDrawable)ModularUITextures.ITEM_SLOT, (IDrawable)ModularUITextures.FLUID_SLOT, this, this.mUsualInputCount, this.mUsualOutputCount, this.getUsualFluidInputCount(), this.getUsualFluidOutputCount(), SteamVariant.NONE, windowOffset);
            this.addProgressBarUI(builder, progressSupplier, windowOffset);
            this.addGregTechLogoUI(builder, windowOffset);
            for (Pair<IDrawable, Pair<Size, Pos2d>> specialTexture : this.specialTextures) {
                builder.widget(new DrawableWidget().setDrawable((IDrawable)specialTexture.getLeft()).setSize((Size)((Pair)specialTexture.getRight()).getLeft()).setPos(((Pos2d)((Pair)specialTexture.getRight()).getRight()).add(windowOffset)));
            }
            return builder;
        }

        public void addProgressBarUI(ModularWindow.Builder builder, Supplier<Float> progressSupplier, Pos2d windowOffset) {
            builder.widget(new ProgressBar().setTexture(this.getProgressBarTexture(), 20).setDirection(this.progressBarDirection).setProgress(progressSupplier).setSynced(false, false).setPos(this.progressBarPos.add(windowOffset)).setSize(this.progressBarSize));
        }

        public void addGregTechLogoUI(ModularWindow.Builder builder, Pos2d windowOffset) {
            builder.widget(new DrawableWidget().setDrawable(this.logo).setSize(this.logoSize).setPos(this.logoPos.add(windowOffset)));
        }

        public void addRecipeSpecificDrawable(ModularWindow.Builder builder, Pos2d windowOffset, Supplier<IDrawable> supplier, Pos2d pos, Size size) {
            builder.widget(new DrawableWidget().setDrawable(supplier).setSize(size).setPos(pos.add(windowOffset)));
        }

        public List<Pos2d> getItemInputPositions(int itemInputCount) {
            return UIHelper.getItemInputPositions(itemInputCount);
        }

        public List<Pos2d> getItemOutputPositions(int itemOutputCount) {
            return UIHelper.getItemOutputPositions(itemOutputCount);
        }

        public Pos2d getSpecialItemPosition() {
            return UIHelper.getSpecialItemPosition();
        }

        public List<Pos2d> getFluidInputPositions(int fluidInputCount) {
            return UIHelper.getFluidInputPositions(fluidInputCount);
        }

        public List<Pos2d> getFluidOutputPositions(int fluidOutputCount) {
            return UIHelper.getFluidOutputPositions(fluidOutputCount);
        }

        public void drawNEIDescription(NEIRecipeInfo recipeInfo) {
            this.drawNEIEnergyInfo(recipeInfo);
            this.drawNEIDurationInfo(recipeInfo);
            this.drawNEISpecialInfo(recipeInfo);
            this.drawNEIRecipeOwnerInfo(recipeInfo);
        }

        protected void drawNEIEnergyInfo(NEIRecipeInfo recipeInfo) {
            GT_Recipe recipe = recipeInfo.recipe;
            Power power = recipeInfo.power;
            if (power.getEuPerTick() > 0) {
                this.drawNEIText(recipeInfo, GT_Utility.trans("152", "Total: ") + power.getTotalPowerString());
                String amperage = power.getAmperageString();
                String powerUsage = power.getPowerUsageString();
                if (amperage == null || amperage.equals("unspecified") || powerUsage.contains("(OC)")) {
                    Power originalPower;
                    this.drawNEIText(recipeInfo, GT_Utility.trans("153", "Usage: ") + powerUsage);
                    if (GT_Mod.gregtechproxy.mNEIOriginalVoltage && !((originalPower = this.getPowerFromRecipeMap()) instanceof UnspecifiedEUPower)) {
                        originalPower.computePowerUsageAndDuration(recipe.mEUt, recipe.mDuration);
                        this.drawNEIText(recipeInfo, GT_Utility.trans("275", "Original voltage: ") + originalPower.getVoltageString());
                    }
                    if (amperage != null && !amperage.equals("unspecified") && !amperage.equals("1")) {
                        this.drawNEIText(recipeInfo, GT_Utility.trans("155", "Amperage: ") + amperage);
                    }
                } else if (amperage.equals("1")) {
                    this.drawNEIText(recipeInfo, GT_Utility.trans("154", "Voltage: ") + power.getVoltageString());
                } else {
                    this.drawNEIText(recipeInfo, GT_Utility.trans("153", "Usage: ") + powerUsage);
                    this.drawNEIText(recipeInfo, GT_Utility.trans("154", "Voltage: ") + power.getVoltageString());
                    this.drawNEIText(recipeInfo, GT_Utility.trans("155", "Amperage: ") + amperage);
                }
            }
        }

        protected void drawNEIDurationInfo(NEIRecipeInfo recipeInfo) {
            Power power = recipeInfo.power;
            if (power.getDurationTicks() > 0) {
                String textToDraw = GT_Utility.trans("158", "Time: ");
                if (GT_Mod.gregtechproxy.mNEIRecipeSecondMode) {
                    textToDraw = textToDraw + power.getDurationStringSeconds();
                    if (power.getDurationSeconds() <= 1.0) {
                        textToDraw = textToDraw + String.format(" (%s)", power.getDurationStringTicks());
                    }
                } else {
                    textToDraw = textToDraw + power.getDurationStringTicks();
                }
                this.drawNEIText(recipeInfo, textToDraw);
            }
        }

        protected void drawNEISpecialInfo(NEIRecipeInfo recipeInfo) {
            String[] recipeDesc = recipeInfo.recipe.getNeiDesc();
            if (recipeDesc != null) {
                for (String s : recipeDesc) {
                    this.drawOptionalNEIText(recipeInfo, s);
                }
            } else if (this.neiSpecialInfoFormatter != null) {
                this.drawNEITextMultipleLines(recipeInfo, this.neiSpecialInfoFormatter.format(recipeInfo, this::formatSpecialValue));
            } else {
                this.drawOptionalNEIText(recipeInfo, this.getNEISpecialInfo(recipeInfo.recipe.mSpecialValue));
            }
        }

        protected String getNEISpecialInfo(int specialValue) {
            if (specialValue == -100 && GT_Mod.gregtechproxy.mLowGravProcessing) {
                return GT_Utility.trans("159", "Needs Low Gravity");
            }
            if (specialValue == -200 && GT_Mod.gregtechproxy.mEnableCleanroom) {
                return GT_Utility.trans("160", "Needs Cleanroom");
            }
            if (specialValue == -201) {
                return GT_Utility.trans("206", "Scan for Assembly Line");
            }
            if (specialValue == -300 && GT_Mod.gregtechproxy.mEnableCleanroom) {
                return GT_Utility.trans("160.1", "Needs Cleanroom & LowGrav");
            }
            if (specialValue == -400) {
                return GT_Utility.trans("216", "Deprecated Recipe");
            }
            if (this.hasSpecialValueFormat()) {
                return this.formatSpecialValue(specialValue);
            }
            return null;
        }

        private boolean hasSpecialValueFormat() {
            return GT_Utility.isStringValid(this.mNEISpecialValuePre) || GT_Utility.isStringValid(this.mNEISpecialValuePost);
        }

        protected String formatSpecialValue(int specialValue) {
            return this.mNEISpecialValuePre + GT_Utility.formatNumbers((long)specialValue * (long)this.mNEISpecialValueMultiplier) + this.mNEISpecialValuePost;
        }

        protected void drawNEIRecipeOwnerInfo(NEIRecipeInfo recipeInfo) {
            GT_Recipe recipe = recipeInfo.recipe;
            if (GT_Mod.gregtechproxy.mNEIRecipeOwner) {
                if (recipe.owners.size() > 1) {
                    this.drawNEIText(recipeInfo, EnumChatFormatting.ITALIC + GT_Utility.trans("273", "Original Recipe by: ") + recipe.owners.get(0).getName());
                    for (int i = 1; i < recipe.owners.size(); ++i) {
                        this.drawNEIText(recipeInfo, EnumChatFormatting.ITALIC + GT_Utility.trans("274", "Modified by: ") + recipe.owners.get(i).getName());
                    }
                } else if (recipe.owners.size() > 0) {
                    this.drawNEIText(recipeInfo, EnumChatFormatting.ITALIC + GT_Utility.trans("272", "Recipe by: ") + recipe.owners.get(0).getName());
                }
            }
            if (GT_Mod.gregtechproxy.mNEIRecipeOwnerStackTrace && recipe.stackTraces != null && !recipe.stackTraces.isEmpty()) {
                this.drawNEIText(recipeInfo, "stackTrace:");
                for (StackTraceElement stackTrace : recipe.stackTraces.get(0)) {
                    this.drawNEIText(recipeInfo, stackTrace.toString());
                }
            }
        }

        protected void drawNEIText(NEIRecipeInfo recipeInfo, String text) {
            this.drawNEIText(recipeInfo, text, 10);
        }

        protected void drawNEIText(NEIRecipeInfo recipeInfo, String text, int yShift) {
            this.drawNEIText(recipeInfo, text, 10, yShift);
        }

        protected void drawNEIText(NEIRecipeInfo recipeInfo, String text, int xStart, int yShift) {
            Minecraft.func_71410_x().field_71466_p.func_78276_b(text, xStart, recipeInfo.yPos, this.neiTextColorOverride != -1 ? this.neiTextColorOverride : 0);
            recipeInfo.yPos += yShift;
        }

        protected void drawOptionalNEIText(NEIRecipeInfo recipeInfo, String text) {
            if (GT_Utility.isStringValid(text) && !text.equals("unspecified")) {
                this.drawNEIText(recipeInfo, text, 10);
            }
        }

        protected void drawNEITextMultipleLines(NEIRecipeInfo recipeInfo, List<String> texts) {
            for (String text : texts) {
                this.drawNEIText(recipeInfo, text, 10);
            }
        }

        public List<String> handleNEIItemTooltip(ItemStack stack, List<String> currentTip, GT_NEI_DefaultHandler.CachedDefaultRecipe neiCachedRecipe) {
            for (PositionedStack pStack : neiCachedRecipe.mInputs) {
                if (stack != pStack.item) continue;
                if (!(pStack instanceof GT_NEI_DefaultHandler.FixedPositionedStack)) break;
                currentTip = this.handleNEIItemInputTooltip(currentTip, (GT_NEI_DefaultHandler.FixedPositionedStack)pStack);
                break;
            }
            for (PositionedStack pStack : neiCachedRecipe.mOutputs) {
                if (stack != pStack.item) continue;
                if (!(pStack instanceof GT_NEI_DefaultHandler.FixedPositionedStack)) break;
                currentTip = this.handleNEIItemOutputTooltip(currentTip, (GT_NEI_DefaultHandler.FixedPositionedStack)pStack);
                break;
            }
            return currentTip;
        }

        protected List<String> handleNEIItemInputTooltip(List<String> currentTip, GT_NEI_DefaultHandler.FixedPositionedStack pStack) {
            if (pStack.isNotConsumed()) {
                currentTip.add(EnumChatFormatting.GRAY + GT_Utility.trans("151", "Does not get consumed in the process"));
            }
            return currentTip;
        }

        protected List<String> handleNEIItemOutputTooltip(List<String> currentTip, GT_NEI_DefaultHandler.FixedPositionedStack pStack) {
            if (pStack.isChanceBased()) {
                currentTip.add(EnumChatFormatting.GRAY + GT_Utility.trans("150", "Chance: ") + pStack.getChanceText());
            }
            return currentTip;
        }

        public void drawNEIOverlays(GT_NEI_DefaultHandler.CachedDefaultRecipe neiCachedRecipe) {
            for (PositionedStack stack : neiCachedRecipe.mInputs) {
                if (!(stack instanceof GT_NEI_DefaultHandler.FixedPositionedStack)) continue;
                this.drawNEIOverlayForInput((GT_NEI_DefaultHandler.FixedPositionedStack)stack);
            }
            for (PositionedStack stack : neiCachedRecipe.mOutputs) {
                if (!(stack instanceof GT_NEI_DefaultHandler.FixedPositionedStack)) continue;
                this.drawNEIOverlayForOutput((GT_NEI_DefaultHandler.FixedPositionedStack)stack);
            }
        }

        protected void drawNEIOverlayForInput(GT_NEI_DefaultHandler.FixedPositionedStack stack) {
            if (stack.isNotConsumed()) {
                this.drawNEIOverlayText("NC", stack);
            }
        }

        protected void drawNEIOverlayForOutput(GT_NEI_DefaultHandler.FixedPositionedStack stack) {
            if (stack.isChanceBased()) {
                this.drawNEIOverlayText(stack.getChanceText(), stack);
            }
        }

        protected void drawNEIOverlayText(String text, PositionedStack stack, int color, float scale, boolean shadow, Alignment alignment) {
            FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
            int width = fontRenderer.func_78256_a(text);
            int x = (int)((float)(stack.relx + 8 + 8 * alignment.x) / scale) - width / 2 * (alignment.x + 1);
            int y = (int)((float)(stack.rely + 8 + 8 * alignment.y) / scale) - fontRenderer.field_78288_b / 2 * (alignment.y + 1) - (alignment.y - 1) / 2;
            GlStateManager.pushMatrix();
            GlStateManager.scale((float)scale, (float)scale, (float)1.0f);
            fontRenderer.func_85187_a(text, x, y, color, shadow);
            GlStateManager.popMatrix();
        }

        protected void drawNEIOverlayText(String text, PositionedStack stack) {
            this.drawNEIOverlayText(text, stack, this.colorOverride.getTextColorOrDefault("nei_overlay_yellow", 16635957), 0.5f, false, Alignment.TopLeft);
        }

        public void updateNEITextColorOverride() {
            this.neiTextColorOverride = this.colorOverride.getTextColorOrDefault("nei", -1);
        }

        public Power getPowerFromRecipeMap() {
            EUPower power = this.mShowVoltageAmperageInNEI ? new EUPower(1, this.mAmperage) : new UnspecifiedEUPower(1, this.mAmperage);
            return power;
        }

        @Deprecated
        public ArrayList<PositionedStack> getInputPositionedStacks(GT_Recipe recipe) {
            return null;
        }

        @Deprecated
        public ArrayList<PositionedStack> getOutputPositionedStacks(GT_Recipe recipe) {
            return null;
        }

        public void addRecipe(Object o, FluidStack[] fluidInputArray, FluidStack[] fluidOutputArray) {
        }

        static {
            sCentrifugeRecipes.addDownstream(sMultiblockCentrifugeRecipes.deepCopyInput());
            sMixerRecipes.addDownstream(sMultiblockMixerRecipes.deepCopyInput());
            sElectrolyzerRecipes.addDownstream(sMultiblockElectrolyzerRecipes.deepCopyInput());
            sDieselFuels.addDownstream(IGT_RecipeMap.newRecipeMap(b -> b.build().map(sLargeBoilerFakeFuels::addDieselRecipe).map(Collections::singletonList).orElse(Collections.emptyList())));
            sDenseLiquidFuels.addDownstream(IGT_RecipeMap.newRecipeMap(b -> b.build().map(sLargeBoilerFakeFuels::addDenseLiquidRecipe).map(Collections::singletonList).orElse(Collections.emptyList())));
        }

        public static class TranscendentPlasmaMixerRecipeMap
        extends GT_Recipe_Map {
            public TranscendentPlasmaMixerRecipeMap(Collection<GT_Recipe> aRecipeList, String aUnlocalizedName, String aLocalName, String aNEIName, String aNEIGUIPath, int aUsualInputCount, int aUsualOutputCount, int aMinimalInputItems, int aMinimalInputFluids, int aAmperage, String aNEISpecialValuePre, int aNEISpecialValueMultiplier, String aNEISpecialValuePost, boolean aShowVoltageAmperageInNEI, boolean aNEIAllowed) {
                super(aRecipeList, aUnlocalizedName, aLocalName, aNEIName, aNEIGUIPath, aUsualInputCount, aUsualOutputCount, aMinimalInputItems, aMinimalInputFluids, aAmperage, aNEISpecialValuePre, aNEISpecialValueMultiplier, aNEISpecialValuePost, aShowVoltageAmperageInNEI, aNEIAllowed);
                this.useModularUI(true);
                this.setUsualFluidInputCount(20);
                this.setUsualFluidOutputCount(1);
                this.setProgressBarPos(86, 44);
                this.setNEITransferRect(new Rectangle(this.progressBarPos.x - 8, this.progressBarPos.y, this.progressBarSize.width + 16, this.progressBarSize.height));
                this.setLogoPos(87, 99);
                this.setNEIBackgroundSize(172, 118);
            }

            @Override
            public List<Pos2d> getItemInputPositions(int itemInputCount) {
                return UIHelper.getGridPositions(itemInputCount, 60, 8, 1);
            }

            @Override
            public List<Pos2d> getFluidInputPositions(int fluidInputCount) {
                return UIHelper.getGridPositions(fluidInputCount, 6, 26, 4, 5);
            }

            @Override
            public List<Pos2d> getFluidOutputPositions(int fluidOutputCount) {
                return UIHelper.getGridPositions(fluidOutputCount, 114, 44, 1);
            }

            @Override
            protected void drawNEIEnergyInfo(NEIRecipeInfo recipeInfo) {
                this.drawNEIText(recipeInfo, GT_Utility.trans("152", "Total: ") + GT_Utility.formatNumbers(1000L * (long)recipeInfo.recipe.mDuration / 100L * (long)recipeInfo.recipe.mEUt) + " EU");
                long averageUsage = 10L * (long)recipeInfo.recipe.mEUt;
                this.drawNEIText(recipeInfo, "Average: " + GT_Utility.formatNumbers(averageUsage) + " EU/t" + GT_Utility.getTierNameWithParentheses(averageUsage));
            }
        }

        public static class GT_FakeSpaceProjectRecipe
        extends GT_Recipe {
            public final String projectName;

            public GT_FakeSpaceProjectRecipe(boolean aOptimize, ItemStack[] aInputs, FluidStack[] aFluidInputs, int aDuration, int aEUt, int aSpecialValue, String projectName) {
                super(aOptimize, aInputs, null, null, null, aFluidInputs, null, aDuration, aEUt, aSpecialValue);
                this.projectName = projectName;
            }
        }
    }

    public static class GT_Recipe_Map_Fuel
    extends GT_Recipe_Map {
        private final Map<String, GT_Recipe> mRecipesByFluidInput = new HashMap<String, GT_Recipe>();

        public GT_Recipe_Map_Fuel(Collection<GT_Recipe> aRecipeList, String aUnlocalizedName, String aLocalName, String aNEIName, String aNEIGUIPath, int aUsualInputCount, int aUsualOutputCount, int aMinimalInputItems, int aMinimalInputFluids, int aAmperage, String aNEISpecialValuePre, int aNEISpecialValueMultiplier, String aNEISpecialValuePost, boolean aShowVoltageAmperageInNEI, boolean aNEIAllowed) {
            super(aRecipeList, aUnlocalizedName, aLocalName, aNEIName, aNEIGUIPath, aUsualInputCount, aUsualOutputCount, aMinimalInputItems, aMinimalInputFluids, aAmperage, aNEISpecialValuePre, aNEISpecialValueMultiplier, aNEISpecialValuePost, aShowVoltageAmperageInNEI, aNEIAllowed);
            this.setDisableOptimize(true);
        }

        public GT_Recipe addFuel(ItemStack aInput, ItemStack aOutput, int aFuelValueInEU) {
            return this.addFuel(aInput, aOutput, null, null, 10000, aFuelValueInEU);
        }

        public GT_Recipe addFuel(ItemStack aInput, ItemStack aOutput, int aChance, int aFuelValueInEU) {
            return this.addFuel(aInput, aOutput, null, null, aChance, aFuelValueInEU);
        }

        public GT_Recipe addFuel(FluidStack aFluidInput, FluidStack aFluidOutput, int aFuelValueInEU) {
            return this.addFuel(null, null, aFluidInput, aFluidOutput, 10000, aFuelValueInEU);
        }

        public GT_Recipe addFuel(ItemStack aInput, ItemStack aOutput, FluidStack aFluidInput, FluidStack aFluidOutput, int aFuelValueInEU) {
            return this.addFuel(aInput, aOutput, aFluidInput, aFluidOutput, 10000, aFuelValueInEU);
        }

        public GT_Recipe addFuel(ItemStack aInput, ItemStack aOutput, FluidStack aFluidInput, FluidStack aFluidOutput, int aChance, int aFuelValueInEU) {
            return this.addRecipe(true, new ItemStack[]{aInput}, new ItemStack[]{aOutput}, null, new int[]{aChance}, new FluidStack[]{aFluidInput}, new FluidStack[]{aFluidOutput}, 0, 0, aFuelValueInEU);
        }

        @Override
        public GT_Recipe add(GT_Recipe aRecipe) {
            aRecipe = super.add(aRecipe);
            if (aRecipe.mInputs != null && GT_Utility.getNonnullElementCount(aRecipe.mInputs) == 1L && (aRecipe.mFluidInputs == null || GT_Utility.getNonnullElementCount(aRecipe.mFluidInputs) == 0L)) {
                FluidStack tFluid = GT_Utility.getFluidForFilledItem(aRecipe.mInputs[0], true);
                if (tFluid != null) {
                    tFluid.amount = 0;
                    this.mRecipesByFluidInput.put(tFluid.getUnlocalizedName(), aRecipe);
                }
            } else if ((aRecipe.mInputs == null || GT_Utility.getNonnullElementCount(aRecipe.mInputs) == 0L) && aRecipe.mFluidInputs != null && GT_Utility.getNonnullElementCount(aRecipe.mFluidInputs) == 1L && aRecipe.mFluidInputs[0] != null) {
                this.mRecipesByFluidInput.put(aRecipe.mFluidInputs[0].getUnlocalizedName(), aRecipe);
            }
            return aRecipe;
        }

        public GT_Recipe findFuel(FluidStack aFluidInput) {
            return this.mRecipesByFluidInput.get(aFluidInput.getUnlocalizedName());
        }
    }

    public static class GT_Recipe_Map_LargeBoilerFakeFuels
    extends GT_Recipe_Map {
        private static final List<String> ALLOWED_SOLID_FUELS = Arrays.asList(GregTech_API.sMachineFile.mConfig.getStringList("LargeBoiler.allowedFuels", ConfigCategories.machineconfig.toString(), new String[]{"gregtech:gt.blockreinforced:6", "gregtech:gt.blockreinforced:7"}, "Allowed fuels for the Large Titanium Boiler and Large Tungstensteel Boiler"));

        public GT_Recipe_Map_LargeBoilerFakeFuels() {
            super(new HashSet<GT_Recipe>(55), "gt.recipe.largeboilerfakefuels", "Large Boiler", null, Mods.GregTech.getResourcePath("textures/gui/basicmachines", "Default"), 1, 1, 1, 0, 1, "", 1, "", true, true);
            GT_Recipe explanatoryRecipe = new GT_Recipe(true, new ItemStack[0], new ItemStack[0], null, null, null, null, 1, 1, 1);
            explanatoryRecipe.setNeiDesc("Not all solid fuels are listed.", "Any item that burns in a", "vanilla furnace will burn in", "a Large Bronze or Steel Boiler.");
            this.addRecipe(explanatoryRecipe);
        }

        public static boolean isAllowedSolidFuel(ItemStack stack) {
            return GT_Recipe_Map_LargeBoilerFakeFuels.isAllowedSolidFuel(Item.field_150901_e.func_148750_c((Object)stack.func_77973_b()), stack.func_77960_j());
        }

        public static boolean isAllowedSolidFuel(String itemRegistryName, int meta) {
            return ALLOWED_SOLID_FUELS.contains(itemRegistryName + ":" + meta);
        }

        public static boolean addAllowedSolidFuel(ItemStack stack) {
            return GT_Recipe_Map_LargeBoilerFakeFuels.addAllowedSolidFuel(Item.field_150901_e.func_148750_c((Object)stack.func_77973_b()), stack.func_77960_j());
        }

        public static boolean addAllowedSolidFuel(String itemregistryName, int meta) {
            return ALLOWED_SOLID_FUELS.add(itemregistryName + ":" + meta);
        }

        public GT_Recipe addDenseLiquidRecipe(GT_Recipe recipe) {
            return this.addRecipe(recipe, (double)recipe.mSpecialValue / 10.0);
        }

        public GT_Recipe addDieselRecipe(GT_Recipe recipe) {
            return this.addRecipe(recipe, (double)recipe.mSpecialValue / 40.0);
        }

        public void addSolidRecipes(ItemStack ... itemStacks) {
            for (ItemStack itemStack : itemStacks) {
                this.addSolidRecipe(itemStack);
            }
        }

        public GT_Recipe addSolidRecipe(ItemStack fuelItemStack) {
            boolean allowedFuel = false;
            if (fuelItemStack != null) {
                String registryName = Item.field_150901_e.func_148750_c((Object)fuelItemStack.func_77973_b());
                allowedFuel = ALLOWED_SOLID_FUELS.contains(registryName + ":" + fuelItemStack.func_77960_j());
            }
            return this.addRecipe(new GT_Recipe(true, new ItemStack[]{fuelItemStack}, new ItemStack[0], null, null, null, null, 1, 0, GT_ModHandler.getFuelValue(fuelItemStack) / 1600), (double)GT_ModHandler.getFuelValue(fuelItemStack) / 1600.0, allowedFuel);
        }

        private GT_Recipe addRecipe(GT_Recipe recipe, double baseBurnTime, boolean isAllowedFuel) {
            recipe = new GT_Recipe(recipe, true);
            double floatErrorCorrection = 1.0E-4;
            double bronzeBurnTime = baseBurnTime * 2.0 + floatErrorCorrection;
            bronzeBurnTime -= bronzeBurnTime % 0.05;
            double steelBurnTime = baseBurnTime + floatErrorCorrection;
            steelBurnTime -= steelBurnTime % 0.05;
            double titaniumBurnTime = baseBurnTime * 0.3 + floatErrorCorrection;
            titaniumBurnTime -= titaniumBurnTime % 0.05;
            double tungstensteelBurnTime = baseBurnTime * 0.15 + floatErrorCorrection;
            tungstensteelBurnTime -= tungstensteelBurnTime % 0.05;
            if (isAllowedFuel) {
                recipe.setNeiDesc("Burn time in seconds:", String.format("Bronze Boiler: %.4f", bronzeBurnTime), String.format("Steel Boiler: %.4f", steelBurnTime), String.format("Titanium Boiler: %.4f", titaniumBurnTime), String.format("Tungstensteel Boiler: %.4f", tungstensteelBurnTime));
            } else {
                recipe.setNeiDesc("Burn time in seconds:", String.format("Bronze Boiler: %.4f", bronzeBurnTime), String.format("Steel Boiler: %.4f", steelBurnTime), "Titanium Boiler: Not allowed", "Tungstenst. Boiler: Not allowed");
            }
            return super.addRecipe(recipe);
        }

        private GT_Recipe addRecipe(GT_Recipe recipe, double baseBurnTime) {
            recipe = new GT_Recipe(recipe, true);
            double floatErrorCorrection = 1.0E-4;
            double bronzeBurnTime = baseBurnTime * 2.0 + floatErrorCorrection;
            bronzeBurnTime -= bronzeBurnTime % 0.05;
            double steelBurnTime = baseBurnTime + floatErrorCorrection;
            steelBurnTime -= steelBurnTime % 0.05;
            recipe.setNeiDesc("Burn time in seconds:", String.format("Bronze Boiler: %.4f", bronzeBurnTime), String.format("Steel Boiler: %.4f", steelBurnTime), "Titanium Boiler: Not allowed", "Tungstenst. Boiler: Not allowed");
            return super.addRecipe(recipe);
        }
    }

    public static class GT_Recipe_Map_AssemblyLineFake
    extends GT_Recipe_Map {
        public GT_Recipe_Map_AssemblyLineFake(Collection<GT_Recipe> aRecipeList, String aUnlocalizedName, String aLocalName, String aNEIName, String aNEIGUIPath, int aUsualInputCount, int aUsualOutputCount, int aMinimalInputItems, int aMinimalInputFluids, int aAmperage, String aNEISpecialValuePre, int aNEISpecialValueMultiplier, String aNEISpecialValuePost, boolean aShowVoltageAmperageInNEI, boolean aNEIAllowed) {
            super(aRecipeList, aUnlocalizedName, aLocalName, aNEIName, aNEIGUIPath, aUsualInputCount, aUsualOutputCount, aMinimalInputItems, aMinimalInputFluids, aAmperage, aNEISpecialValuePre, aNEISpecialValueMultiplier, aNEISpecialValuePost, aShowVoltageAmperageInNEI, aNEIAllowed);
            this.setNEITransferRect(new Rectangle(146, 26, 10, 18));
        }

        @Override
        public List<Pos2d> getItemInputPositions(int itemInputCount) {
            return UIHelper.getGridPositions(itemInputCount, 16, 8, 4);
        }

        @Override
        public List<Pos2d> getItemOutputPositions(int itemOutputCount) {
            return Collections.singletonList(new Pos2d(142, 8));
        }

        @Override
        public Pos2d getSpecialItemPosition() {
            return new Pos2d(142, 44);
        }

        @Override
        public List<Pos2d> getFluidInputPositions(int fluidInputCount) {
            return UIHelper.getGridPositions(fluidInputCount, 106, 8, 1);
        }

        @Override
        public void addProgressBarUI(ModularWindow.Builder builder, Supplier<Float> progressSupplier, Pos2d windowOffset) {
            int bar1Width = 17;
            int bar2Width = 18;
            builder.widget(new ProgressBar().setTexture(GT_UITextures.PROGRESSBAR_ASSEMBLY_LINE_1, 17).setDirection(ProgressBar.Direction.RIGHT).setProgress(() -> Float.valueOf(((Float)progressSupplier.get()).floatValue() * ((float)(bar1Width + bar2Width) / (float)bar1Width))).setSynced(false, false).setPos(new Pos2d(88, 8).add(windowOffset)).setSize(bar1Width, 72));
            builder.widget(new ProgressBar().setTexture(GT_UITextures.PROGRESSBAR_ASSEMBLY_LINE_2, 18).setDirection(ProgressBar.Direction.RIGHT).setProgress(() -> Float.valueOf((((Float)progressSupplier.get()).floatValue() - (float)bar1Width / (float)(bar1Width + bar2Width)) * ((float)(bar1Width + bar2Width) / (float)bar2Width))).setSynced(false, false).setPos(new Pos2d(124, 8).add(windowOffset)).setSize(bar2Width, 72));
            builder.widget(new ProgressBar().setTexture(GT_UITextures.PROGRESSBAR_ASSEMBLY_LINE_3, 18).setDirection(ProgressBar.Direction.UP).setProgress(progressSupplier).setSynced(false, false).setPos(new Pos2d(146, 26).add(windowOffset)).setSize(10, 18));
        }
    }

    public static class GT_Recipe_Map_ComplexFusion
    extends GT_Recipe_Map {
        public GT_Recipe_Map_ComplexFusion(Collection<GT_Recipe> aRecipeList, String aUnlocalizedName, String aLocalName, String aNEIName, String aNEIGUIPath, int aUsualInputCount, int aUsualOutputCount, int aMinimalInputItems, int aMinimalInputFluids, int aAmperage, String aNEISpecialValuePre, int aNEISpecialValueMultiplier, String aNEISpecialValuePost, boolean aShowVoltageAmperageInNEI, boolean aNEIAllowed) {
            super(aRecipeList, aUnlocalizedName, aLocalName, aNEIName, aNEIGUIPath, aUsualInputCount, aUsualOutputCount, aMinimalInputItems, aMinimalInputFluids, aAmperage, aNEISpecialValuePre, aNEISpecialValueMultiplier, aNEISpecialValuePost, aShowVoltageAmperageInNEI, aNEIAllowed);
        }

        @Override
        public GT_Recipe addRecipe(int[] aOutputChances, FluidStack[] aFluidInputs, FluidStack[] aFluidOutputs, int aDuration, int aEUt, int aSpecialValue) {
            return this.addRecipe(new GT_Recipe(false, null, null, null, aOutputChances, aFluidInputs, aFluidOutputs, aDuration, aEUt, aSpecialValue), false, false, false);
        }

        @Override
        public List<Pos2d> getFluidInputPositions(int fluidInputCount) {
            return UIHelper.getGridPositions(fluidInputCount, 7, 9, 4);
        }

        @Override
        public List<Pos2d> getFluidOutputPositions(int fluidOutputCount) {
            return UIHelper.getGridPositions(fluidOutputCount, 97, 9, 4);
        }
    }

    private static class ReplicatorFakeMap
    extends GT_Recipe_Map {
        public ReplicatorFakeMap(Collection<GT_Recipe> aRecipeList, String aUnlocalizedName, String aLocalName, String aNEIName, String aNEIGUIPath, int aUsualInputCount, int aUsualOutputCount, int aMinimalInputItems, int aMinimalInputFluids, int aAmperage, String aNEISpecialValuePre, int aNEISpecialValueMultiplier, String aNEISpecialValuePost, boolean aShowVoltageAmperageInNEI, boolean aNEIAllowed) {
            super(aRecipeList, aUnlocalizedName, aLocalName, aNEIName, aNEIGUIPath, aUsualInputCount, aUsualOutputCount, aMinimalInputItems, aMinimalInputFluids, aAmperage, aNEISpecialValuePre, aNEISpecialValueMultiplier, aNEISpecialValuePost, aShowVoltageAmperageInNEI, aNEIAllowed);
        }

        @Override
        public GT_Recipe addFakeRecipe(boolean aCheckForCollisions, ItemStack[] aInputs, ItemStack[] aOutputs, Object aSpecial, FluidStack[] aFluidInputs, FluidStack[] aFluidOutputs, int aDuration, int aEUt, int aSpecialValue) {
            AtomicInteger ai = new AtomicInteger();
            Optional.ofNullable(GT_OreDictUnificator.getAssociation(aOutputs[0])).map(itemData -> itemData.mMaterial).map(materialsStack -> materialsStack.mMaterial).map(materials -> materials.mElement).map(Element::getMass).ifPresent(e -> {
                aFluidInputs[0].amount = (int)GT_MetaTileEntity_Replicator.cubicFluidMultiplier(e);
                ai.set(GT_Utility.safeInt((long)aFluidInputs[0].amount * 512L, 1));
            });
            return this.addFakeRecipe(aCheckForCollisions, new GT_Recipe(false, aInputs, aOutputs, aSpecial, null, aFluidInputs, aFluidOutputs, ai.get(), aEUt, aSpecialValue));
        }
    }

    public static class GT_Recipe_WithAlt
    extends GT_Recipe {
        ItemStack[][] mOreDictAlt;

        GT_Recipe_WithAlt(ItemStack[] mInputs, ItemStack[] mOutputs, FluidStack[] mFluidInputs, FluidStack[] mFluidOutputs, int[] mChances, Object mSpecialItems, int mDuration, int mEUt, int mSpecialValue, boolean mEnabled, boolean mHidden, boolean mFakeRecipe, boolean mCanBeBuffered, boolean mNeedsEmptyOutput, String[] neiDesc, ItemStack[][] mOreDictAlt) {
            super(mInputs, mOutputs, mFluidInputs, mFluidOutputs, mChances, mSpecialItems, mDuration, mEUt, mSpecialValue, mEnabled, mHidden, mFakeRecipe, mCanBeBuffered, mNeedsEmptyOutput, neiDesc);
            this.mOreDictAlt = mOreDictAlt;
        }

        public GT_Recipe_WithAlt(boolean aOptimize, ItemStack[] aInputs, ItemStack[] aOutputs, Object aSpecialItems, int[] aChances, FluidStack[] aFluidInputs, FluidStack[] aFluidOutputs, int aDuration, int aEUt, int aSpecialValue, ItemStack[][] aAlt) {
            super(aOptimize, aInputs, aOutputs, aSpecialItems, aChances, aFluidInputs, aFluidOutputs, aDuration, aEUt, aSpecialValue);
            this.mOreDictAlt = aAlt;
        }

        public Object getAltRepresentativeInput(int aIndex) {
            if (aIndex < 0) {
                return null;
            }
            if (aIndex < this.mOreDictAlt.length && this.mOreDictAlt[aIndex] != null && this.mOreDictAlt[aIndex].length > 0) {
                ItemStack[] rStacks = new ItemStack[this.mOreDictAlt[aIndex].length];
                for (int i = 0; i < this.mOreDictAlt[aIndex].length; ++i) {
                    rStacks[i] = GT_Utility.copyOrNull(this.mOreDictAlt[aIndex][i]);
                }
                return rStacks;
            }
            if (aIndex >= this.mInputs.length) {
                return null;
            }
            return GT_Utility.copyOrNull(this.mInputs[aIndex]);
        }
    }

    public static class GT_Recipe_Map_OilCracker
    extends GT_Recipe_Map {
        private final Set<String> mValidCatalystFluidNames = new HashSet<String>();

        public GT_Recipe_Map_OilCracker() {
            super(new HashSet<GT_Recipe>(70), "gt.recipe.craker", "Oil Cracker", null, Mods.GregTech.getResourcePath("textures/gui/basicmachines", "OilCracker"), 1, 1, 1, 2, 1, "", 1, "", true, true);
        }

        @Override
        public GT_Recipe add(GT_Recipe aRecipe) {
            GT_Recipe ret = super.add(aRecipe);
            if (ret != null && ret.mFluidInputs != null && ret.mFluidInputs.length > 1 && ret.mFluidInputs[1] != null) {
                this.mValidCatalystFluidNames.add(ret.mFluidInputs[1].getFluid().getName());
            }
            return ret;
        }

        public boolean isValidCatalystFluid(FluidStack aFluidStack) {
            return this.mValidCatalystFluidNames.contains(aFluidStack.getFluid().getName());
        }
    }

    public static class GT_Recipe_Map_DistillationTower
    extends GT_Recipe_Map {
        public GT_Recipe_Map_DistillationTower() {
            super(new HashSet<GT_Recipe>(110), "gt.recipe.distillationtower", "Distillation Tower", null, Mods.GregTech.getResourcePath("textures/gui/basicmachines", "DistillationTower"), 2, 1, 0, 0, 1, "", 1, "", true, true);
            this.setLogoPos(80, 62);
        }

        @Override
        public IDrawable getOverlayForSlot(boolean isFluid, boolean isOutput, int index, boolean isSpecial) {
            if (isOutput) {
                if (isFluid) {
                    return GT_UITextures.OVERLAY_SLOTS_NUMBER[index + 1];
                }
                return GT_UITextures.OVERLAY_SLOTS_NUMBER[0];
            }
            return super.getOverlayForSlot(isFluid, false, index, isSpecial);
        }

        @Override
        public List<Pos2d> getItemOutputPositions(int itemOutputCount) {
            return Collections.singletonList(new Pos2d(106, 62));
        }

        @Override
        public List<Pos2d> getFluidOutputPositions(int fluidOutputCount) {
            ArrayList<Pos2d> results = new ArrayList<Pos2d>();
            for (int i = 1; i < fluidOutputCount + 1; ++i) {
                results.add(new Pos2d(106 + i % 3 * 18, 62 - i / 3 * 18));
            }
            return results;
        }
    }

    public static class GT_Recipe_Map_LargeChemicalReactor
    extends GT_Recipe_Map_LargeNEI {
        private static final int TOTAL_INPUT_COUNT = 6;
        private static final int OUTPUT_COUNT = 6;

        public GT_Recipe_Map_LargeChemicalReactor() {
            super(new HashSet<GT_Recipe>(1000), "gt.recipe.largechemicalreactor", "Large Chemical Reactor", null, Mods.GregTech.getResourcePath("textures/gui/basicmachines", "LCRNEI"), 6, 6, 0, 0, 1, "", 1, "", true, true);
        }

        @Override
        public GT_Recipe addRecipe(boolean aOptimize, ItemStack[] aInputs, ItemStack[] aOutputs, Object aSpecial, int[] aOutputChances, FluidStack[] aFluidInputs, FluidStack[] aFluidOutputs, int aDuration, int aEUt, int aSpecialValue) {
            ItemData itemData;
            aOptimize = false;
            ArrayList<ItemStack> adjustedInputs = new ArrayList<ItemStack>();
            ArrayList<ItemStack> adjustedOutputs = new ArrayList<ItemStack>();
            ArrayList<FluidStack> adjustedFluidInputs = new ArrayList<FluidStack>();
            ArrayList<FluidStack> adjustedFluidOutputs = new ArrayList<FluidStack>();
            aInputs = aInputs == null ? new ItemStack[]{} : ArrayExt.withoutTrailingNulls(aInputs, ItemStack[]::new);
            for (ItemStack input : aInputs) {
                FluidStack inputFluidContent = FluidContainerRegistry.getFluidForFilledItem((ItemStack)input);
                if (inputFluidContent != null) {
                    inputFluidContent.amount *= input.field_77994_a;
                    if (inputFluidContent.getFluid().getName().equals("ic2steam")) {
                        inputFluidContent = GT_ModHandler.getSteam(inputFluidContent.amount);
                    }
                    adjustedFluidInputs.add(inputFluidContent);
                } else {
                    itemData = GT_OreDictUnificator.getItemData(input);
                    if (itemData != null && itemData.hasValidPrefixMaterialData() && itemData.mMaterial.mMaterial == Materials.Empty) continue;
                    if (itemData != null && itemData.hasValidPrefixMaterialData() && itemData.mPrefix == OrePrefixes.cell) {
                        ItemStack dustStack = itemData.mMaterial.mMaterial.getDust(input.field_77994_a);
                        if (dustStack != null) {
                            adjustedInputs.add(dustStack);
                        } else {
                            adjustedInputs.add(input);
                        }
                    } else {
                        adjustedInputs.add(input);
                    }
                }
                if (aFluidInputs != null) continue;
                aFluidInputs = new FluidStack[]{};
            }
            Collections.addAll(adjustedFluidInputs, aFluidInputs);
            aInputs = adjustedInputs.toArray(new ItemStack[0]);
            aFluidInputs = adjustedFluidInputs.toArray(new FluidStack[0]);
            aOutputs = aOutputs == null ? new ItemStack[]{} : ArrayExt.withoutTrailingNulls(aOutputs, ItemStack[]::new);
            for (ItemStack output : aOutputs) {
                FluidStack outputFluidContent = FluidContainerRegistry.getFluidForFilledItem((ItemStack)output);
                if (outputFluidContent != null) {
                    outputFluidContent.amount *= output.field_77994_a;
                    if (outputFluidContent.getFluid().getName().equals("ic2steam")) {
                        outputFluidContent = GT_ModHandler.getSteam(outputFluidContent.amount);
                    }
                    adjustedFluidOutputs.add(outputFluidContent);
                    continue;
                }
                itemData = GT_OreDictUnificator.getItemData(output);
                if (itemData != null && itemData.hasValidPrefixMaterialData() && itemData.mMaterial.mMaterial == Materials.Empty) continue;
                adjustedOutputs.add(output);
            }
            if (aFluidOutputs == null) {
                aFluidOutputs = new FluidStack[]{};
            }
            Collections.addAll(adjustedFluidOutputs, aFluidOutputs);
            aOutputs = adjustedOutputs.toArray(new ItemStack[0]);
            aFluidOutputs = adjustedFluidOutputs.toArray(new FluidStack[0]);
            return super.addRecipe(aOptimize, aInputs, aOutputs, aSpecial, aOutputChances, aFluidInputs, aFluidOutputs, aDuration, aEUt, aSpecialValue);
        }
    }

    public static class GT_Recipe_Map_IC2NuclearFake
    extends GT_Recipe_Map {
        public GT_Recipe_Map_IC2NuclearFake() {
            super(new HashSet<GT_Recipe>(10), "gt.recipe.ic2nuke", "Fission", null, Mods.GregTech.getResourcePath("textures/gui/basicmachines", "Default"), 1, 1, 1, 0, 1, "", 1, "", true, true);
            this.setLogo((IDrawable)GT_UITextures.PICTURE_RADIATION_WARNING);
            this.setLogoPos(152, 24);
            this.setNEIBackgroundSize(172, 60);
            this.setProgressBar(GT_UITextures.PROGRESSBAR_ARROW, ProgressBar.Direction.RIGHT);
        }

        public GT_Recipe addBreederCell(ItemStack input, ItemStack output, boolean reflector, int heatStep, int heatMultiplier, int requiredPulses) {
            return this.addFakeRecipe(input, output, reflector ? "Neutron reflecting breeder cell" : "Heat neutral Breeder Cell", String.format("Every %d reactor hull heat", heatStep), String.format("increase speed by %d00%%", heatMultiplier), String.format("Required pulses: %d", requiredPulses));
        }

        public GT_Recipe addFakeRecipe(ItemStack input, ItemStack output, String ... neiDesc) {
            GT_Recipe r = new GT_Recipe(new ItemStack[]{input}, new ItemStack[]{output}, null, new int[]{10000}, null, null, 0, 0, 0);
            r.setNeiDesc(neiDesc);
            return this.addRecipe(r, true, true, false);
        }
    }

    public static class GT_Recipe_Map_Printer
    extends GT_Recipe_Map {
        public GT_Recipe_Map_Printer(Collection<GT_Recipe> aRecipeList, String aUnlocalizedName, String aLocalName, String aNEIName, String aNEIGUIPath, int aUsualInputCount, int aUsualOutputCount, int aMinimalInputItems, int aMinimalInputFluids, int aAmperage, String aNEISpecialValuePre, int aNEISpecialValueMultiplier, String aNEISpecialValuePost, boolean aShowVoltageAmperageInNEI, boolean aNEIAllowed) {
            super(aRecipeList, aUnlocalizedName, aLocalName, aNEIName, aNEIGUIPath, aUsualInputCount, aUsualOutputCount, aMinimalInputItems, aMinimalInputFluids, aAmperage, aNEISpecialValuePre, aNEISpecialValueMultiplier, aNEISpecialValuePost, aShowVoltageAmperageInNEI, aNEIAllowed);
        }

        @Override
        @Nonnull
        public FindRecipeResult findRecipeWithResult(GT_Recipe aRecipe, boolean aNotUnificated, boolean aDontCheckStackSizes, long aVoltage, FluidStack[] aFluids, ItemStack aSpecialSlot, ItemStack ... aInputs) {
            FindRecipeResult result = super.findRecipeWithResult(aRecipe, aNotUnificated, aDontCheckStackSizes, aVoltage, aFluids, aSpecialSlot, aInputs);
            if (aInputs == null || aInputs.length == 0 || aInputs[0] == null || aFluids == null || aFluids.length == 0 || aFluids[0] == null || !GregTech_API.sPostloadFinished) {
                return result;
            }
            Dyes aDye = null;
            for (Dyes tDye : Dyes.VALUES) {
                if (!tDye.isFluidDye(aFluids[0])) continue;
                aDye = tDye;
                break;
            }
            if (aDye == null) {
                return result;
            }
            if (!result.isSuccessful()) {
                ItemStack tOutput = GT_ModHandler.getAllRecipeOutput(null, aInputs[0], aInputs[0], aInputs[0], aInputs[0], ItemList.DYE_ONLY_ITEMS[aDye.mIndex].get(1L, new Object[0]), aInputs[0], aInputs[0], aInputs[0], aInputs[0]);
                if (tOutput != null) {
                    GT_Recipe recipe = this.addRecipe(new GT_Recipe(true, new ItemStack[]{GT_Utility.copyAmount(8L, aInputs[0])}, new ItemStack[]{tOutput}, null, null, new FluidStack[]{new FluidStack(aFluids[0].getFluid(), 144)}, null, 256, 2, 0), false, false, true);
                    return recipe != null ? FindRecipeResult.ofSuccess(recipe) : FindRecipeResult.NOT_FOUND;
                }
                tOutput = GT_ModHandler.getAllRecipeOutput(null, aInputs[0], ItemList.DYE_ONLY_ITEMS[aDye.mIndex].get(1L, new Object[0]));
                if (tOutput != null) {
                    GT_Recipe recipe = this.addRecipe(new GT_Recipe(true, new ItemStack[]{GT_Utility.copyAmount(1L, aInputs[0])}, new ItemStack[]{tOutput}, null, null, new FluidStack[]{new FluidStack(aFluids[0].getFluid(), 144)}, null, 32, 2, 0), false, false, true);
                    return recipe != null ? FindRecipeResult.ofSuccess(recipe) : FindRecipeResult.NOT_FOUND;
                }
            } else {
                GT_Recipe rRecipe = result.getRecipeNonNull();
                if (aInputs[0].func_77973_b() == Items.field_151121_aF) {
                    if (!ItemList.Tool_DataStick.isStackEqual(aSpecialSlot, false, true)) {
                        return FindRecipeResult.NOT_FOUND;
                    }
                    NBTTagCompound tNBT = aSpecialSlot.func_77978_p();
                    if (tNBT == null || GT_Utility.isStringInvalid(tNBT.func_74779_i("title")) || GT_Utility.isStringInvalid(tNBT.func_74779_i("author"))) {
                        return FindRecipeResult.NOT_FOUND;
                    }
                    rRecipe = rRecipe.copy();
                    rRecipe.mCanBeBuffered = false;
                    rRecipe.mOutputs[0].func_77982_d(tNBT);
                    return FindRecipeResult.ofSuccess(rRecipe);
                }
                if (aInputs[0].func_77973_b() == Items.field_151148_bJ) {
                    if (!ItemList.Tool_DataStick.isStackEqual(aSpecialSlot, false, true)) {
                        return FindRecipeResult.NOT_FOUND;
                    }
                    NBTTagCompound tNBT = aSpecialSlot.func_77978_p();
                    if (tNBT == null || !tNBT.func_74764_b("map_id")) {
                        return FindRecipeResult.NOT_FOUND;
                    }
                    rRecipe = rRecipe.copy();
                    rRecipe.mCanBeBuffered = false;
                    rRecipe.mOutputs[0].func_77964_b((int)tNBT.func_74765_d("map_id"));
                    return FindRecipeResult.ofSuccess(rRecipe);
                }
                if (ItemList.Paper_Punch_Card_Empty.isStackEqual(aInputs[0], false, true)) {
                    if (!ItemList.Tool_DataStick.isStackEqual(aSpecialSlot, false, true)) {
                        return FindRecipeResult.NOT_FOUND;
                    }
                    NBTTagCompound tNBT = aSpecialSlot.func_77978_p();
                    if (tNBT == null || !tNBT.func_74764_b("GT.PunchCardData")) {
                        return FindRecipeResult.NOT_FOUND;
                    }
                    rRecipe = rRecipe.copy();
                    rRecipe.mCanBeBuffered = false;
                    rRecipe.mOutputs[0].func_77982_d(GT_Utility.getNBTContainingString(new NBTTagCompound(), "GT.PunchCardData", tNBT.func_74779_i("GT.PunchCardData")));
                    return FindRecipeResult.ofSuccess(rRecipe);
                }
            }
            return result;
        }

        @Override
        public boolean containsInput(ItemStack aStack) {
            return true;
        }

        @Override
        public boolean containsInput(FluidStack aFluid) {
            return super.containsInput(aFluid) || Dyes.isAnyFluidDye(aFluid);
        }

        @Override
        public boolean containsInput(Fluid aFluid) {
            return super.containsInput(aFluid) || Dyes.isAnyFluidDye(aFluid);
        }
    }

    public static class GT_Recipe_Map_FormingPress
    extends GT_Recipe_Map {
        public GT_Recipe_Map_FormingPress(Collection<GT_Recipe> aRecipeList, String aUnlocalizedName, String aLocalName, String aNEIName, String aNEIGUIPath, int aUsualInputCount, int aUsualOutputCount, int aMinimalInputItems, int aMinimalInputFluids, int aAmperage, String aNEISpecialValuePre, int aNEISpecialValueMultiplier, String aNEISpecialValuePost, boolean aShowVoltageAmperageInNEI, boolean aNEIAllowed) {
            super(aRecipeList, aUnlocalizedName, aLocalName, aNEIName, aNEIGUIPath, aUsualInputCount, aUsualOutputCount, aMinimalInputItems, aMinimalInputFluids, aAmperage, aNEISpecialValuePre, aNEISpecialValueMultiplier, aNEISpecialValuePost, aShowVoltageAmperageInNEI, aNEIAllowed);
        }

        @Override
        @Nonnull
        public FindRecipeResult findRecipeWithResult(GT_Recipe aRecipe, boolean aNotUnificated, boolean aDontCheckStackSizes, long aVoltage, FluidStack[] aFluids, ItemStack aSpecialSlot, ItemStack ... aInputs) {
            FindRecipeResult result = super.findRecipeWithResult(aRecipe, aNotUnificated, aDontCheckStackSizes, aVoltage, aFluids, aSpecialSlot, aInputs);
            if (aInputs == null || aInputs.length < 2 || !GregTech_API.sPostloadFinished) {
                return result;
            }
            if (!result.isSuccessful()) {
                return this.findRenamingRecipe(aInputs);
            }
            for (ItemStack aMold : aInputs) {
                if (!ItemList.Shape_Mold_Credit.isStackEqual(aMold, false, true)) continue;
                NBTTagCompound tNBT = aMold.func_77978_p();
                if (tNBT == null) {
                    tNBT = new NBTTagCompound();
                }
                if (!tNBT.func_74764_b("credit_security_id")) {
                    tNBT.func_74772_a("credit_security_id", System.nanoTime());
                }
                aMold.func_77982_d(tNBT);
                GT_Recipe rRecipe = result.getRecipeNonNull();
                rRecipe = rRecipe.copy();
                rRecipe.mCanBeBuffered = false;
                rRecipe.mOutputs[0].func_77982_d(tNBT);
                return FindRecipeResult.ofSuccess(rRecipe);
            }
            return result;
        }

        private ItemStack findNameMoldIndex(ItemStack[] inputs) {
            for (ItemStack stack : inputs) {
                if (!ItemList.Shape_Mold_Name.isStackEqual(stack, false, true)) continue;
                return stack;
            }
            return null;
        }

        private ItemStack findStackToRename(ItemStack[] inputs, ItemStack mold) {
            for (ItemStack stack : inputs) {
                if (stack == mold || stack == null) continue;
                return stack;
            }
            return null;
        }

        @Nonnull
        private FindRecipeResult findRenamingRecipe(ItemStack[] inputs) {
            ItemStack mold = this.findNameMoldIndex(inputs);
            if (mold == null) {
                return FindRecipeResult.NOT_FOUND;
            }
            ItemStack input = this.findStackToRename(inputs, mold);
            if (input == null) {
                return FindRecipeResult.NOT_FOUND;
            }
            ItemStack output = GT_Utility.copyAmount(1L, input);
            if (output == null) {
                return FindRecipeResult.NOT_FOUND;
            }
            output.func_151001_c(mold.func_82833_r());
            GT_Recipe recipe = new GT_Recipe(false, new ItemStack[]{GT_Utility.copyAmount(0L, mold), GT_Utility.copyAmount(1L, input)}, new ItemStack[]{output}, null, null, null, null, 128, 8, 0);
            recipe.mCanBeBuffered = false;
            recipe.isNBTSensitive = true;
            return FindRecipeResult.ofSuccess(recipe);
        }
    }

    public static class GT_Recipe_Map_Assembler
    extends GT_Recipe_Map {
        public GT_Recipe_Map_Assembler(Collection<GT_Recipe> aRecipeList, String aUnlocalizedName, String aLocalName, String aNEIName, String aNEIGUIPath, int aUsualInputCount, int aUsualOutputCount, int aMinimalInputItems, int aMinimalInputFluids, int aAmperage, String aNEISpecialValuePre, int aNEISpecialValueMultiplier, String aNEISpecialValuePost, boolean aShowVoltageAmperageInNEI, boolean aNEIAllowed) {
            super(aRecipeList, aUnlocalizedName, aLocalName, aNEIName, aNEIGUIPath, aUsualInputCount, aUsualOutputCount, aMinimalInputItems, aMinimalInputFluids, aAmperage, aNEISpecialValuePre, aNEISpecialValueMultiplier, aNEISpecialValuePost, aShowVoltageAmperageInNEI, aNEIAllowed);
        }

        @Override
        @Nonnull
        public FindRecipeResult findRecipeWithResult(GT_Recipe aRecipe, boolean aNotUnificated, boolean aDontCheckStackSizes, long aVoltage, FluidStack[] aFluids, ItemStack aSpecialSlot, ItemStack ... aInputs) {
            FindRecipeResult result = super.findRecipeWithResult(aRecipe, true, aDontCheckStackSizes, aVoltage, aFluids, aSpecialSlot, aInputs);
            if (aInputs == null || aInputs.length == 0 || aInputs[0] == null || !result.isSuccessful() || !GregTech_API.sPostloadFinished) {
                return result;
            }
            GT_Recipe rRecipe = result.getRecipeNonNull();
            for (ItemStack aInput : aInputs) {
                if (!ItemList.Paper_Printed_Pages.isStackEqual(aInput, false, true)) continue;
                rRecipe = rRecipe.copy();
                rRecipe.mCanBeBuffered = false;
                rRecipe.mOutputs[0].func_77982_d(aInput.func_77978_p());
            }
            return FindRecipeResult.ofSuccess(rRecipe);
        }
    }

    public static class GT_Recipe_Map_Macerator
    extends GT_Recipe_Map {
        public GT_Recipe_Map_Macerator(Collection<GT_Recipe> aRecipeList, String aUnlocalizedName, String aLocalName, String aNEIName, String aNEIGUIPath, int aUsualInputCount, int aUsualOutputCount, int aMinimalInputItems, int aMinimalInputFluids, int aAmperage, String aNEISpecialValuePre, int aNEISpecialValueMultiplier, String aNEISpecialValuePost, boolean aShowVoltageAmperageInNEI, boolean aNEIAllowed) {
            super(aRecipeList, aUnlocalizedName, aLocalName, aNEIName, aNEIGUIPath, aUsualInputCount, aUsualOutputCount, aMinimalInputItems, aMinimalInputFluids, aAmperage, aNEISpecialValuePre, aNEISpecialValueMultiplier, aNEISpecialValuePost, aShowVoltageAmperageInNEI, aNEIAllowed);
        }

        @Override
        @Nonnull
        public FindRecipeResult findRecipeWithResult(GT_Recipe aRecipe, boolean aNotUnificated, boolean aDontCheckStackSizes, long aVoltage, FluidStack[] aFluids, ItemStack aSpecialSlot, ItemStack ... aInputs) {
            if (aInputs == null || aInputs.length == 0 || aInputs[0] == null || !GregTech_API.sPostloadFinished) {
                return super.findRecipeWithResult(aRecipe, aNotUnificated, aDontCheckStackSizes, aVoltage, aFluids, aSpecialSlot, aInputs);
            }
            FindRecipeResult result = super.findRecipeWithResult(aRecipe, aNotUnificated, aDontCheckStackSizes, aVoltage, aFluids, aSpecialSlot, aInputs);
            if (result.isSuccessful()) {
                return result;
            }
            try {
                List tRecipeOutputs = RailcraftCraftingManager.rockCrusher.getRecipe(GT_Utility.copyAmount(1L, aInputs[0])).getRandomizedOuputs();
                if (tRecipeOutputs != null) {
                    GT_Recipe recipe = new GT_Recipe(false, new ItemStack[]{GT_Utility.copyAmount(1L, aInputs[0])}, tRecipeOutputs.toArray(new ItemStack[0]), null, null, null, null, 800, 2, 0);
                    recipe.mCanBeBuffered = false;
                    recipe.mNeedsEmptyOutput = true;
                    return FindRecipeResult.ofSuccess(recipe);
                }
            }
            catch (NoClassDefFoundError e) {
                if (GT_Values.D1) {
                    GT_Log.err.println("Railcraft Not loaded");
                }
            }
            catch (NullPointerException e) {
                // empty catch block
            }
            ItemStack tComparedInput = GT_Utility.copyOrNull(aInputs[0]);
            ItemStack[] tOutputItems = GT_ModHandler.getMachineOutput(tComparedInput, Recipes.macerator.getRecipes(), true, new NBTTagCompound(), null, null, null);
            if (tComparedInput != null && GT_Utility.arrayContainsNonNull(tOutputItems)) {
                return FindRecipeResult.ofSuccess(new GT_Recipe(false, new ItemStack[]{GT_Utility.copyAmount((long)(aInputs[0].field_77994_a - tComparedInput.field_77994_a), aInputs[0])}, tOutputItems, null, null, null, null, 400, 2, 0));
            }
            return FindRecipeResult.NOT_FOUND;
        }

        @Override
        public boolean containsInput(ItemStack aStack) {
            return super.containsInput(aStack) || GT_Utility.arrayContainsNonNull(GT_ModHandler.getMachineOutput(GT_Utility.copyAmount(64L, aStack), Recipes.macerator.getRecipes(), false, new NBTTagCompound(), null, null, null));
        }
    }

    public static class GT_Recipe_Map_Recycler
    extends GT_Recipe_Map_NonGTRecipes {
        public GT_Recipe_Map_Recycler(Collection<GT_Recipe> aRecipeList, String aUnlocalizedName, String aLocalName, String aNEIName, String aNEIGUIPath, int aUsualInputCount, int aUsualOutputCount, int aMinimalInputItems, int aMinimalInputFluids, int aAmperage, String aNEISpecialValuePre, int aNEISpecialValueMultiplier, String aNEISpecialValuePost, boolean aShowVoltageAmperageInNEI, boolean aNEIAllowed) {
            super(aRecipeList, aUnlocalizedName, aLocalName, aNEIName, aNEIGUIPath, aUsualInputCount, aUsualOutputCount, aMinimalInputItems, aMinimalInputFluids, aAmperage, aNEISpecialValuePre, aNEISpecialValueMultiplier, aNEISpecialValuePost, aShowVoltageAmperageInNEI, aNEIAllowed);
        }

        @Override
        @Nonnull
        public FindRecipeResult findRecipeWithResult(GT_Recipe aRecipe, boolean aNotUnificated, boolean aDontCheckStackSizes, long aVoltage, FluidStack[] aFluids, ItemStack aSpecialSlot, ItemStack ... aInputs) {
            if (aInputs == null || aInputs.length == 0 || aInputs[0] == null) {
                return FindRecipeResult.NOT_FOUND;
            }
            if (aRecipe != null && aRecipe.isRecipeInputEqual(false, true, aFluids, aInputs)) {
                return FindRecipeResult.ofSuccess(aRecipe);
            }
            return FindRecipeResult.ofSuccess(new GT_Recipe(false, new ItemStack[]{GT_Utility.copyAmount(1L, aInputs[0])}, new ItemStack[]{GT_ModHandler.getRecyclerOutput(aInputs[0], 0)}, null, new int[]{1250}, null, null, 45, 1, 0));
        }

        @Override
        public boolean containsInput(ItemStack aStack) {
            return GT_ModHandler.getRecyclerOutput(aStack, 0) != null;
        }
    }

    public static class GT_Recipe_Map_FluidCanner
    extends GT_Recipe_Map {
        public GT_Recipe_Map_FluidCanner(Collection<GT_Recipe> aRecipeList, String aUnlocalizedName, String aLocalName, String aNEIName, String aNEIGUIPath, int aUsualInputCount, int aUsualOutputCount, int aMinimalInputItems, int aMinimalInputFluids, int aAmperage, String aNEISpecialValuePre, int aNEISpecialValueMultiplier, String aNEISpecialValuePost, boolean aShowVoltageAmperageInNEI, boolean aNEIAllowed) {
            super(aRecipeList, aUnlocalizedName, aLocalName, aNEIName, aNEIGUIPath, aUsualInputCount, aUsualOutputCount, aMinimalInputItems, aMinimalInputFluids, aAmperage, aNEISpecialValuePre, aNEISpecialValueMultiplier, aNEISpecialValuePost, aShowVoltageAmperageInNEI, aNEIAllowed);
        }

        @Override
        @Nonnull
        public FindRecipeResult findRecipeWithResult(GT_Recipe aRecipe, boolean aNotUnificated, boolean aDontCheckStackSizes, long aVoltage, FluidStack[] aFluids, ItemStack aSpecialSlot, ItemStack ... aInputs) {
            ItemStack tOutput;
            FluidStack tFluid;
            FindRecipeResult result = super.findRecipeWithResult(aRecipe, aNotUnificated, aDontCheckStackSizes, aVoltage, aFluids, aSpecialSlot, aInputs);
            if (aInputs == null || aInputs.length == 0 || aInputs[0] == null || result.isSuccessful() || !GregTech_API.sPostloadFinished) {
                return result;
            }
            if (aFluids != null && aFluids.length > 0 && aFluids[0] != null && (tFluid = GT_Utility.getFluidForFilledItem(tOutput = GT_Utility.fillFluidContainer(aFluids[0], aInputs[0], false, true), true)) != null) {
                GT_Recipe recipe = new GT_Recipe(false, new ItemStack[]{GT_Utility.copyAmount(1L, aInputs[0])}, new ItemStack[]{tOutput}, null, null, new FluidStack[]{tFluid}, null, Math.max(tFluid.amount / 64, 16), 1, 0);
                recipe.mCanBeBuffered = false;
                return FindRecipeResult.ofSuccess(recipe);
            }
            FluidStack tFluid2 = GT_Utility.getFluidForFilledItem(aInputs[0], true);
            if (tFluid2 != null) {
                GT_Recipe recipe = new GT_Recipe(false, new ItemStack[]{GT_Utility.copyAmount(1L, aInputs[0])}, new ItemStack[]{GT_Utility.getContainerItem(aInputs[0], true)}, null, null, null, new FluidStack[]{tFluid2}, Math.max(tFluid2.amount / 64, 16), 1, 0);
                recipe.mCanBeBuffered = false;
                return FindRecipeResult.ofSuccess(recipe);
            }
            return FindRecipeResult.NOT_FOUND;
        }

        @Override
        public boolean containsInput(ItemStack aStack) {
            return aStack != null && (super.containsInput(aStack) || aStack.func_77973_b() instanceof IFluidContainerItem && ((IFluidContainerItem)aStack.func_77973_b()).getCapacity(aStack) > 0);
        }

        @Override
        public boolean containsInput(FluidStack aFluid) {
            return true;
        }

        @Override
        public boolean containsInput(Fluid aFluid) {
            return true;
        }
    }

    public static class GT_Recipe_Map_Unboxinator
    extends GT_Recipe_Map {
        public GT_Recipe_Map_Unboxinator(Collection<GT_Recipe> aRecipeList, String aUnlocalizedName, String aLocalName, String aNEIName, String aNEIGUIPath, int aUsualInputCount, int aUsualOutputCount, int aMinimalInputItems, int aMinimalInputFluids, int aAmperage, String aNEISpecialValuePre, int aNEISpecialValueMultiplier, String aNEISpecialValuePost, boolean aShowVoltageAmperageInNEI, boolean aNEIAllowed) {
            super(aRecipeList, aUnlocalizedName, aLocalName, aNEIName, aNEIGUIPath, aUsualInputCount, aUsualOutputCount, aMinimalInputItems, aMinimalInputFluids, aAmperage, aNEISpecialValuePre, aNEISpecialValueMultiplier, aNEISpecialValuePost, aShowVoltageAmperageInNEI, aNEIAllowed);
        }

        @Override
        @Nonnull
        public FindRecipeResult findRecipeWithResult(GT_Recipe aRecipe, boolean aNotUnificated, boolean aDontCheckStackSizes, long aVoltage, FluidStack[] aFluids, ItemStack aSpecialSlot, ItemStack ... aInputs) {
            if (aInputs == null || aInputs.length == 0 || !ItemList.IC2_Scrapbox.isStackEqual(aInputs[0], false, true)) {
                return super.findRecipeWithResult(aRecipe, aNotUnificated, aDontCheckStackSizes, aVoltage, aFluids, aSpecialSlot, aInputs);
            }
            ItemStack tOutput = GT_ModHandler.getRandomScrapboxDrop();
            if (tOutput == null) {
                return super.findRecipeWithResult(aRecipe, aNotUnificated, aDontCheckStackSizes, aVoltage, aFluids, aSpecialSlot, aInputs);
            }
            GT_Recipe rRecipe = new GT_Recipe(false, new ItemStack[]{ItemList.IC2_Scrapbox.get(1L, new Object[0])}, new ItemStack[]{tOutput}, null, null, null, null, 16, 1, 0);
            rRecipe.mCanBeBuffered = false;
            rRecipe.mNeedsEmptyOutput = true;
            return FindRecipeResult.ofSuccess(rRecipe);
        }

        @Override
        public boolean containsInput(ItemStack aStack) {
            return ItemList.IC2_Scrapbox.isStackEqual(aStack, false, true) || super.containsInput(aStack);
        }
    }

    public static class GT_Recipe_Map_Microwave
    extends GT_Recipe_Map_NonGTRecipes {
        public GT_Recipe_Map_Microwave(Collection<GT_Recipe> aRecipeList, String aUnlocalizedName, String aLocalName, String aNEIName, String aNEIGUIPath, int aUsualInputCount, int aUsualOutputCount, int aMinimalInputItems, int aMinimalInputFluids, int aAmperage, String aNEISpecialValuePre, int aNEISpecialValueMultiplier, String aNEISpecialValuePost, boolean aShowVoltageAmperageInNEI, boolean aNEIAllowed) {
            super(aRecipeList, aUnlocalizedName, aLocalName, aNEIName, aNEIGUIPath, aUsualInputCount, aUsualOutputCount, aMinimalInputItems, aMinimalInputFluids, aAmperage, aNEISpecialValuePre, aNEISpecialValueMultiplier, aNEISpecialValuePost, aShowVoltageAmperageInNEI, aNEIAllowed);
        }

        @Override
        @Nonnull
        public FindRecipeResult findRecipeWithResult(GT_Recipe aRecipe, boolean aNotUnificated, boolean aDontCheckStackSizes, long aVoltage, FluidStack[] aFluids, ItemStack aSpecialSlot, ItemStack ... aInputs) {
            if (aInputs == null || aInputs.length == 0 || aInputs[0] == null) {
                return FindRecipeResult.NOT_FOUND;
            }
            if (aRecipe != null && aRecipe.isRecipeInputEqual(false, true, aFluids, aInputs)) {
                return FindRecipeResult.ofSuccess(aRecipe);
            }
            ItemStack tOutput = GT_ModHandler.getSmeltingOutput(aInputs[0], false, null);
            if (GT_Utility.areStacksEqual(aInputs[0], new ItemStack(Items.field_151122_aG, 1, Short.MAX_VALUE))) {
                return FindRecipeResult.ofSuccess(new GT_Recipe(false, new ItemStack[]{GT_Utility.copyAmount(1L, aInputs[0])}, new ItemStack[]{GT_Utility.getWrittenBook("Manual_Microwave", ItemList.Book_Written_03.get(1L, new Object[0]))}, null, null, null, null, 32, 4, 0));
            }
            for (ItemStack tStack : new ItemStack[]{GT_Utility.getContainerItem(aInputs[0], true), aInputs[0], GT_Utility.getContainerItem(tOutput, true), tOutput}) {
                if (tStack == null) continue;
                if (GT_Utility.areStacksEqual(tStack, new ItemStack(Blocks.field_150424_aL, 1, Short.MAX_VALUE), true) || GT_Utility.areStacksEqual(tStack, new ItemStack(Blocks.field_150335_W, 1, Short.MAX_VALUE), true) || GT_Utility.areStacksEqual(tStack, new ItemStack(Items.field_151110_aK, 1, Short.MAX_VALUE), true) || GT_Utility.areStacksEqual(tStack, new ItemStack(Items.field_151154_bQ, 1, Short.MAX_VALUE), true) || GT_Utility.areStacksEqual(tStack, new ItemStack(Items.field_151152_bP, 1, Short.MAX_VALUE), true) || GT_Utility.areStacksEqual(tStack, new ItemStack(Items.field_151059_bz, 1, Short.MAX_VALUE), true)) {
                    GT_Log.exp.println("Microwave Explosion due to TNT || EGG || FIREWORKCHARGE || FIREWORK || FIRE CHARGE");
                    return FindRecipeResult.EXPLODE;
                }
                ItemData tData = GT_OreDictUnificator.getItemData(tStack);
                if (tData != null) {
                    if (tData.mMaterial != null && tData.mMaterial.mMaterial != null) {
                        if (tData.mMaterial.mMaterial.contains(SubTag.METAL) || tData.mMaterial.mMaterial.contains(SubTag.EXPLOSIVE)) {
                            GT_Log.exp.println("Microwave Explosion due to METAL insertion");
                            return FindRecipeResult.EXPLODE;
                        }
                        if (tData.mMaterial.mMaterial.contains(SubTag.FLAMMABLE)) {
                            GT_Log.exp.println("Microwave INFLAMMATION due to FLAMMABLE insertion");
                            return FindRecipeResult.ON_FIRE;
                        }
                    }
                    for (MaterialStack tMaterial : tData.mByProducts) {
                        if (tMaterial == null) continue;
                        if (tMaterial.mMaterial.contains(SubTag.METAL) || tMaterial.mMaterial.contains(SubTag.EXPLOSIVE)) {
                            GT_Log.exp.println("Microwave Explosion due to METAL insertion");
                            return FindRecipeResult.EXPLODE;
                        }
                        if (!tMaterial.mMaterial.contains(SubTag.FLAMMABLE)) continue;
                        GT_Log.exp.println("Microwave INFLAMMATION due to FLAMMABLE insertion");
                        return FindRecipeResult.ON_FIRE;
                    }
                }
                if (TileEntityFurnace.func_145952_a((ItemStack)tStack) <= 0) continue;
                GT_Log.exp.println("Microwave INFLAMMATION due to BURNABLE insertion");
                return FindRecipeResult.ON_FIRE;
            }
            return tOutput == null ? FindRecipeResult.NOT_FOUND : FindRecipeResult.ofSuccess(new GT_Recipe(false, new ItemStack[]{GT_Utility.copyAmount(1L, aInputs[0])}, new ItemStack[]{tOutput}, null, null, null, null, 32, 4, 0));
        }

        @Override
        public boolean containsInput(ItemStack aStack) {
            return GT_ModHandler.getSmeltingOutput(aStack, false, null) != null;
        }
    }

    public static class GT_Recipe_Map_Furnace
    extends GT_Recipe_Map_NonGTRecipes {
        public GT_Recipe_Map_Furnace(Collection<GT_Recipe> aRecipeList, String aUnlocalizedName, String aLocalName, String aNEIName, String aNEIGUIPath, int aUsualInputCount, int aUsualOutputCount, int aMinimalInputItems, int aMinimalInputFluids, int aAmperage, String aNEISpecialValuePre, int aNEISpecialValueMultiplier, String aNEISpecialValuePost, boolean aShowVoltageAmperageInNEI, boolean aNEIAllowed) {
            super(aRecipeList, aUnlocalizedName, aLocalName, aNEIName, aNEIGUIPath, aUsualInputCount, aUsualOutputCount, aMinimalInputItems, aMinimalInputFluids, aAmperage, aNEISpecialValuePre, aNEISpecialValueMultiplier, aNEISpecialValuePost, aShowVoltageAmperageInNEI, aNEIAllowed);
        }

        @Override
        @Nonnull
        public FindRecipeResult findRecipeWithResult(GT_Recipe aRecipe, boolean aNotUnificated, boolean aDontCheckStackSizes, long aVoltage, FluidStack[] aFluids, ItemStack aSpecialSlot, ItemStack ... aInputs) {
            if (aInputs == null || aInputs.length == 0 || aInputs[0] == null) {
                return FindRecipeResult.NOT_FOUND;
            }
            if (aRecipe != null && aRecipe.isRecipeInputEqual(false, true, aFluids, aInputs)) {
                return FindRecipeResult.ofSuccess(aRecipe);
            }
            ItemStack tOutput = GT_ModHandler.getSmeltingOutput(aInputs[0], false, null);
            return tOutput == null ? FindRecipeResult.NOT_FOUND : FindRecipeResult.ofSuccess(new GT_Recipe(false, new ItemStack[]{GT_Utility.copyAmount(1L, aInputs[0])}, new ItemStack[]{tOutput}, null, null, null, null, 128, 4, 0));
        }

        @Override
        public boolean containsInput(ItemStack aStack) {
            return GT_ModHandler.getSmeltingOutput(aStack, false, null) != null;
        }
    }

    public static abstract class GT_Recipe_Map_NonGTRecipes
    extends GT_Recipe_Map {
        public GT_Recipe_Map_NonGTRecipes(Collection<GT_Recipe> aRecipeList, String aUnlocalizedName, String aLocalName, String aNEIName, String aNEIGUIPath, int aUsualInputCount, int aUsualOutputCount, int aMinimalInputItems, int aMinimalInputFluids, int aAmperage, String aNEISpecialValuePre, int aNEISpecialValueMultiplier, String aNEISpecialValuePost, boolean aShowVoltageAmperageInNEI, boolean aNEIAllowed) {
            super(aRecipeList, aUnlocalizedName, aLocalName, aNEIName, aNEIGUIPath, aUsualInputCount, aUsualOutputCount, aMinimalInputItems, aMinimalInputFluids, aAmperage, aNEISpecialValuePre, aNEISpecialValueMultiplier, aNEISpecialValuePost, aShowVoltageAmperageInNEI, aNEIAllowed);
        }

        @Override
        public boolean containsInput(ItemStack aStack) {
            return false;
        }

        @Override
        public boolean containsInput(FluidStack aFluid) {
            return false;
        }

        @Override
        public boolean containsInput(Fluid aFluid) {
            return false;
        }

        @Override
        public GT_Recipe addRecipe(boolean aOptimize, ItemStack[] aInputs, ItemStack[] aOutputs, Object aSpecial, int[] aOutputChances, FluidStack[] aFluidInputs, FluidStack[] aFluidOutputs, int aDuration, int aEUt, int aSpecialValue) {
            return null;
        }

        @Override
        public GT_Recipe addRecipe(boolean aOptimize, ItemStack[] aInputs, ItemStack[] aOutputs, Object aSpecial, FluidStack[] aFluidInputs, FluidStack[] aFluidOutputs, int aDuration, int aEUt, int aSpecialValue) {
            return null;
        }

        @Override
        public GT_Recipe addRecipe(GT_Recipe aRecipe) {
            return null;
        }

        @Override
        public GT_Recipe addFakeRecipe(boolean aCheckForCollisions, ItemStack[] aInputs, ItemStack[] aOutputs, Object aSpecial, int[] aOutputChances, FluidStack[] aFluidInputs, FluidStack[] aFluidOutputs, int aDuration, int aEUt, int aSpecialValue) {
            return null;
        }

        @Override
        public GT_Recipe addFakeRecipe(boolean aCheckForCollisions, ItemStack[] aInputs, ItemStack[] aOutputs, Object aSpecial, FluidStack[] aFluidInputs, FluidStack[] aFluidOutputs, int aDuration, int aEUt, int aSpecialValue) {
            return null;
        }

        @Override
        public GT_Recipe addFakeRecipe(boolean aCheckForCollisions, ItemStack[] aInputs, ItemStack[] aOutputs, Object aSpecial, FluidStack[] aFluidInputs, FluidStack[] aFluidOutputs, int aDuration, int aEUt, int aSpecialValue, boolean hidden) {
            return null;
        }

        @Override
        public GT_Recipe addFakeRecipe(boolean aCheckForCollisions, GT_Recipe aRecipe) {
            return null;
        }

        @Override
        public GT_Recipe add(GT_Recipe aRecipe) {
            return null;
        }

        @Override
        public void reInit() {
        }

        @Override
        protected GT_Recipe addToItemMap(GT_Recipe aRecipe) {
            return null;
        }
    }

    public static class GT_Recipe_Map_FluidOnly
    extends GT_Recipe_Map {
        public GT_Recipe_Map_FluidOnly(Collection<GT_Recipe> aRecipeList, String aUnlocalizedName, String aLocalName, String aNEIName, String aNEIGUIPath, int aUsualInputCount, int aUsualOutputCount, int aMinimalInputItems, int aMinimalInputFluids, int aAmperage, String aNEISpecialValuePre, int aNEISpecialValueMultiplier, String aNEISpecialValuePost, boolean aShowVoltageAmperageInNEI, boolean aNEIAllowed) {
            super(aRecipeList, aUnlocalizedName, aLocalName, aNEIName, aNEIGUIPath, aUsualInputCount, aUsualOutputCount, aMinimalInputItems, aMinimalInputFluids, aAmperage, aNEISpecialValuePre, aNEISpecialValueMultiplier, aNEISpecialValuePost, aShowVoltageAmperageInNEI, aNEIAllowed);
            this.useModularUI(true);
        }

        @Override
        public List<Pos2d> getFluidInputPositions(int fluidInputCount) {
            return UIHelper.getItemInputPositions(fluidInputCount);
        }

        @Override
        public List<Pos2d> getFluidOutputPositions(int fluidOutputCount) {
            return UIHelper.getItemOutputPositions(fluidOutputCount);
        }
    }

    public static class GT_Recipe_Map_LargeNEI
    extends GT_Recipe_Map {
        private static final int xDirMaxCount = 3;
        private static final int yOrigin = 8;

        public GT_Recipe_Map_LargeNEI(Collection<GT_Recipe> aRecipeList, String aUnlocalizedName, String aLocalName, String aNEIName, String aNEIGUIPath, int aUsualInputCount, int aUsualOutputCount, int aMinimalInputItems, int aMinimalInputFluids, int aAmperage, String aNEISpecialValuePre, int aNEISpecialValueMultiplier, String aNEISpecialValuePost, boolean aShowVoltageAmperageInNEI, boolean aNEIAllowed) {
            super(aRecipeList, aUnlocalizedName, aLocalName, aNEIName, aNEIGUIPath, aUsualInputCount, aUsualOutputCount, aMinimalInputItems, aMinimalInputFluids, aAmperage, aNEISpecialValuePre, aNEISpecialValueMultiplier, aNEISpecialValuePost, aShowVoltageAmperageInNEI, aNEIAllowed);
            this.useModularUI(true);
            this.setLogoPos(80, 62);
        }

        @Override
        public List<Pos2d> getItemInputPositions(int itemInputCount) {
            return UIHelper.getGridPositions(itemInputCount, 16, 8, 3);
        }

        @Override
        public List<Pos2d> getItemOutputPositions(int itemOutputCount) {
            return UIHelper.getGridPositions(itemOutputCount, 106, 8, 3);
        }

        @Override
        public List<Pos2d> getFluidInputPositions(int fluidInputCount) {
            return UIHelper.getGridPositions(fluidInputCount, 16, 8 + this.getItemRowCount() * 18, 3);
        }

        @Override
        public List<Pos2d> getFluidOutputPositions(int fluidOutputCount) {
            return UIHelper.getGridPositions(fluidOutputCount, 106, 8 + this.getItemRowCount() * 18, 3);
        }

        @Override
        public ModularWindow.Builder createNEITemplate(IItemHandlerModifiable itemInputsInventory, IItemHandlerModifiable itemOutputsInventory, IItemHandlerModifiable specialSlotInventory, IItemHandlerModifiable fluidInputsInventory, IItemHandlerModifiable fluidOutputsInventory, Supplier<Float> progressSupplier, Pos2d windowOffset) {
            this.setNEIBackgroundSize(172, 82 + Math.max(this.getItemRowCount() + this.getFluidRowCount() - 4, 0) * 18);
            return super.createNEITemplate(itemInputsInventory, itemOutputsInventory, specialSlotInventory, fluidInputsInventory, fluidOutputsInventory, progressSupplier, windowOffset);
        }

        private int getItemRowCount() {
            return (Math.max(this.mUsualInputCount, this.mUsualOutputCount) - 1) / 3 + 1;
        }

        private int getFluidRowCount() {
            return (Math.max(this.getUsualFluidInputCount(), this.getUsualFluidOutputCount()) - 1) / 3 + 1;
        }
    }

    public static class GT_Recipe_AssemblyLine {
        public static final ArrayList<GT_Recipe_AssemblyLine> sAssemblylineRecipes = new ArrayList();
        public ItemStack mResearchItem;
        public int mResearchTime;
        public ItemStack[] mInputs;
        public FluidStack[] mFluidInputs;
        public ItemStack mOutput;
        public int mDuration;
        public int mEUt;
        public ItemStack[][] mOreDictAlt;
        private int mPersistentHash;

        private static void checkInvalidRecipes() {
            int invalidCount = 0;
            GT_Log.out.println("Started assline validation");
            for (GT_Recipe_AssemblyLine recipe : sAssemblylineRecipes) {
                if (recipe.getPersistentHash() != 0) continue;
                ++invalidCount;
                GT_Log.err.printf("Invalid recipe: %s%n", recipe);
            }
            if (invalidCount > 0) {
                throw new RuntimeException("There are " + invalidCount + " invalid assembly line recipe(s)! Check GregTech.log for details!");
            }
        }

        public GT_Recipe_AssemblyLine(ItemStack aResearchItem, int aResearchTime, ItemStack[] aInputs, FluidStack[] aFluidInputs, ItemStack aOutput, int aDuration, int aEUt) {
            this(aResearchItem, aResearchTime, aInputs, aFluidInputs, aOutput, aDuration, aEUt, new ItemStack[aInputs.length][]);
            int tPersistentHash = 1;
            for (ItemStack itemStack : aInputs) {
                tPersistentHash = tPersistentHash * 31 + GT_Utility.persistentHash(itemStack, true, false);
            }
            tPersistentHash = tPersistentHash * 31 + GT_Utility.persistentHash(aResearchItem, true, false);
            tPersistentHash = tPersistentHash * 31 + GT_Utility.persistentHash(aOutput, true, false);
            for (ItemStack itemStack : aFluidInputs) {
                tPersistentHash = tPersistentHash * 31 + GT_Utility.persistentHash((FluidStack)itemStack, true, false);
            }
            tPersistentHash = tPersistentHash * 31 + aResearchTime;
            tPersistentHash = tPersistentHash * 31 + aDuration;
            tPersistentHash = tPersistentHash * 31 + aEUt;
            this.setPersistentHash(tPersistentHash);
        }

        public GT_Recipe_AssemblyLine(ItemStack aResearchItem, int aResearchTime, ItemStack[] aInputs, FluidStack[] aFluidInputs, ItemStack aOutput, int aDuration, int aEUt, ItemStack[][] aAlt) {
            this.mResearchItem = aResearchItem;
            this.mResearchTime = aResearchTime;
            this.mInputs = aInputs;
            this.mFluidInputs = aFluidInputs;
            this.mOutput = aOutput;
            this.mDuration = aDuration;
            this.mEUt = aEUt;
            this.mOreDictAlt = aAlt;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            Object[] thisInputs = new GT_ItemStack[this.mInputs.length];
            int totalInputStackSize = 0;
            for (int i = 0; i < this.mInputs.length; ++i) {
                thisInputs[i] = new GT_ItemStack(this.mInputs[i]);
                totalInputStackSize += ((GT_ItemStack)thisInputs[i]).mStackSize;
            }
            int inputHash = Arrays.deepHashCode(thisInputs);
            int inputFluidHash = Arrays.deepHashCode(this.mFluidInputs);
            GT_ItemStack thisOutput = new GT_ItemStack(this.mOutput);
            GT_ItemStack thisResearch = new GT_ItemStack(this.mResearchItem);
            int miscRecipeDataHash = Arrays.deepHashCode(new Object[]{totalInputStackSize, this.mDuration, this.mEUt, thisOutput, thisResearch, this.mResearchTime});
            result = 31 * result + inputFluidHash;
            result = 31 * result + inputHash;
            result = 31 * result + miscRecipeDataHash;
            return result;
        }

        public boolean equals(Object obj) {
            int i;
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof GT_Recipe_AssemblyLine)) {
                return false;
            }
            GT_Recipe_AssemblyLine other = (GT_Recipe_AssemblyLine)obj;
            if (this.mInputs.length != other.mInputs.length) {
                return false;
            }
            if (this.mFluidInputs.length != other.mFluidInputs.length) {
                return false;
            }
            GT_ItemStack output1 = new GT_ItemStack(this.mOutput);
            GT_ItemStack output2 = new GT_ItemStack(other.mOutput);
            if (!output1.equals(output2)) {
                return false;
            }
            GT_ItemStack scan1 = new GT_ItemStack(this.mResearchItem);
            GT_ItemStack scan2 = new GT_ItemStack(other.mResearchItem);
            if (!scan1.equals(scan2)) {
                return false;
            }
            GT_ItemStack[] thisInputs = new GT_ItemStack[this.mInputs.length];
            GT_ItemStack[] otherInputs = new GT_ItemStack[other.mInputs.length];
            for (i = 0; i < thisInputs.length; ++i) {
                thisInputs[i] = new GT_ItemStack(this.mInputs[i]);
                otherInputs[i] = new GT_ItemStack(other.mInputs[i]);
            }
            for (i = 0; i < thisInputs.length; ++i) {
                if (thisInputs[i].equals(otherInputs[i]) && thisInputs[i].mStackSize == otherInputs[i].mStackSize) continue;
                return false;
            }
            for (i = 0; i < this.mFluidInputs.length; ++i) {
                if (this.mFluidInputs[i].isFluidStackIdentical(other.mFluidInputs[i])) continue;
                return false;
            }
            return this.mDuration == other.mDuration && this.mEUt == other.mEUt && this.mResearchTime == other.mResearchTime;
        }

        public int getPersistentHash() {
            if (this.mPersistentHash == 0) {
                GT_Log.err.println("Assline recipe persistent hash has not been set! Recipe: " + this.mOutput);
            }
            return this.mPersistentHash;
        }

        public String toString() {
            return "GT_Recipe_AssemblyLine{mResearchItem=" + this.mResearchItem + ", mResearchTime=" + this.mResearchTime + ", mInputs=" + Arrays.toString(this.mInputs) + ", mFluidInputs=" + Arrays.toString(this.mFluidInputs) + ", mOutput=" + this.mOutput + ", mDuration=" + this.mDuration + ", mEUt=" + this.mEUt + ", mOreDictAlt=" + Arrays.toString((Object[])this.mOreDictAlt) + '}';
        }

        public void setPersistentHash(int aPersistentHash) {
            if (this.mPersistentHash != 0) {
                throw new IllegalStateException("Cannot set persistent hash twice!");
            }
            this.mPersistentHash = aPersistentHash == 0 ? 1 : aPersistentHash;
        }

        static {
            if (!Boolean.getBoolean("com.gtnh.gt5u.ignore-invalid-assline-recipe")) {
                GregTech_API.sFirstWorldTick.add(GT_Recipe_AssemblyLine::checkInvalidRecipes);
            } else {
                GT_Log.out.println("NOT CHECKING INVALID ASSLINE RECIPE.");
            }
        }
    }
}

