/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines.basic;

import gregtech.api.enums.MachineType;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_BasicMachine;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GT_OreDictUnificator;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_Utility;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class GT_MetaTileEntity_PotionBrewer
extends GT_MetaTileEntity_BasicMachine {
    public GT_MetaTileEntity_PotionBrewer(int aID, String aName, String aNameRegional, int aTier) {
        super(aID, aName, aNameRegional, aTier, 1, MachineType.BREWERY.tooltipDescription(), 1, 0, "PotionBrewer.png", "", TextureFactory.of(TextureFactory.of(Textures.BlockIcons.OVERLAY_SIDE_POTIONBREWER_ACTIVE), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_SIDE_POTIONBREWER_ACTIVE_GLOW).glow().build()), TextureFactory.of(TextureFactory.of(Textures.BlockIcons.OVERLAY_SIDE_POTIONBREWER), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_SIDE_POTIONBREWER_GLOW).glow().build()), TextureFactory.of(TextureFactory.of(Textures.BlockIcons.OVERLAY_FRONT_POTIONBREWER_ACTIVE), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_POTIONBREWER_ACTIVE_GLOW).glow().build()), TextureFactory.of(TextureFactory.of(Textures.BlockIcons.OVERLAY_FRONT_POTIONBREWER), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_POTIONBREWER_GLOW).glow().build()), TextureFactory.of(TextureFactory.of(Textures.BlockIcons.OVERLAY_TOP_POTIONBREWER_ACTIVE), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_TOP_POTIONBREWER_ACTIVE_GLOW).glow().build()), TextureFactory.of(TextureFactory.of(Textures.BlockIcons.OVERLAY_TOP_POTIONBREWER), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_TOP_POTIONBREWER_GLOW).glow().build()), TextureFactory.of(TextureFactory.of(Textures.BlockIcons.OVERLAY_BOTTOM_POTIONBREWER_ACTIVE), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_BOTTOM_POTIONBREWER_ACTIVE_GLOW).glow().build()), TextureFactory.of(TextureFactory.of(Textures.BlockIcons.OVERLAY_BOTTOM_POTIONBREWER), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_BOTTOM_POTIONBREWER_GLOW).glow().build()));
    }

    public GT_MetaTileEntity_PotionBrewer(String aName, int aTier, String aDescription, ITexture[][][] aTextures, String aGUIName, String aNEIName) {
        super(aName, aTier, 1, aDescription, aTextures, 1, 0, aGUIName, aNEIName);
    }

    public GT_MetaTileEntity_PotionBrewer(String aName, int aTier, String[] aDescription, ITexture[][][] aTextures, String aGUIName, String aNEIName) {
        super(aName, aTier, 1, aDescription, aTextures, 1, 0, aGUIName, aNEIName);
    }

    @Override
    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MetaTileEntity_PotionBrewer(this.mName, (int)this.mTier, this.mDescriptionArray, this.mTextures, this.mGUIName, this.mNEIName);
    }

    @Override
    public GT_Recipe.GT_Recipe_Map getRecipeList() {
        return GT_Recipe.GT_Recipe_Map.sBrewingRecipes;
    }

    @Override
    public int checkRecipe() {
        String tInputName;
        int tCheck = super.checkRecipe();
        if (tCheck != 0) {
            return tCheck;
        }
        this.calculateOverclockedNess(4, 128);
        if (this.mMaxProgresstime == 0x7FFFFFFE && this.mEUt == 0x7FFFFFFE) {
            return 1;
        }
        FluidStack aFluid = this.getFillableStack();
        if (this.getDrainableStack() == null && aFluid != null && this.getInputAt(0) != null && (tInputName = aFluid.getFluid().getName()).startsWith("potion.")) {
            String tModifier;
            int tFirstDot = (tInputName = tInputName.replaceFirst("potion.", "")).indexOf(46) + 1;
            String string = tModifier = tFirstDot <= 0 ? "" : tInputName.substring(tFirstDot);
            if (!tModifier.isEmpty()) {
                tInputName = tInputName.replaceFirst("." + tModifier, "");
            }
            if (GT_Utility.areStacksEqual(new ItemStack(Items.field_151071_bq, 1, 0), this.getInputAt(0))) {
                if (tInputName.equals("poison")) {
                    return this.setOutput("potion.damage" + tModifier);
                }
                if (tInputName.equals("health")) {
                    return this.setOutput("potion.damage" + tModifier);
                }
                if (tInputName.equals("waterbreathing")) {
                    return this.setOutput("potion.damage" + tModifier);
                }
                if (tInputName.equals("nightvision")) {
                    return this.setOutput("potion.invisibility" + tModifier);
                }
                if (tInputName.equals("fireresistance")) {
                    return this.setOutput("potion.slowness" + tModifier);
                }
                if (tInputName.equals("speed")) {
                    return this.setOutput("potion.slowness" + tModifier);
                }
                if (tInputName.equals("strength")) {
                    return this.setOutput("potion.weakness" + tModifier);
                }
                if (tInputName.equals("regen")) {
                    return this.setOutput("potion.poison" + tModifier);
                }
                return this.setOutput("potion.weakness");
            }
            if (GT_Utility.areStacksEqual(GT_OreDictUnificator.get(OrePrefixes.dust, Materials.Glowstone, 1L), this.getInputAt(0))) {
                if (!tModifier.startsWith("strong")) {
                    return this.setOutput("potion." + tInputName + ".strong" + (tModifier.isEmpty() ? "" : "." + tModifier));
                }
                if (tModifier.startsWith("long")) {
                    return this.setOutput("potion." + tInputName + tModifier.replaceFirst("long", ""));
                }
                return this.setOutput("potion.thick");
            }
            if (GT_Utility.areStacksEqual(GT_OreDictUnificator.get(OrePrefixes.dust, Materials.Redstone, 1L), this.getInputAt(0))) {
                if (!tModifier.startsWith("long")) {
                    return this.setOutput("potion." + tInputName + ".long" + (tModifier.isEmpty() ? "" : "." + tModifier));
                }
                if (tModifier.startsWith("strong")) {
                    return this.setOutput("potion." + tInputName + tModifier.replaceFirst("strong", ""));
                }
                return this.setOutput("potion.mundane");
            }
            if (GT_Utility.areStacksEqual(GT_OreDictUnificator.get(OrePrefixes.dust, Materials.Gunpowder, 1L), this.getInputAt(0))) {
                if (!tInputName.endsWith(".splash")) {
                    return this.setOutput("potion." + tInputName + ".splash");
                }
                return this.setOutput("potion.mundane");
            }
        }
        return 0;
    }

    private int setOutput(String aFluidName) {
        if (this.getFillableStack().amount < 750) {
            return 0;
        }
        this.mOutputFluid = FluidRegistry.getFluidStack((String)aFluidName, (int)750);
        if (this.mOutputFluid == null) {
            this.mOutputFluid = FluidRegistry.getFluidStack((String)"potion.mundane", (int)this.getFillableStack().amount);
        }
        --this.getInputAt((int)0).field_77994_a;
        this.getFillableStack().amount -= 750;
        return 2;
    }

    @Override
    public boolean allowPutStackValidated(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, ForgeDirection side, ItemStack aStack) {
        return super.allowPutStackValidated(aBaseMetaTileEntity, aIndex, side, aStack) && this.getRecipeList().containsInput(aStack);
    }

    @Override
    public boolean isFluidInputAllowed(FluidStack aFluid) {
        return aFluid.getFluid().getName().startsWith("potion.") || super.isFluidInputAllowed(aFluid);
    }

    @Override
    public int getCapacity() {
        return GT_MetaTileEntity_PotionBrewer.getCapacityForTier(this.mTier);
    }
}

