/*
 * Decompiled with CFR 0.152.
 */
package pers.gwyog.gtneioreplugin.util;

import gregtech.api.GregTech_API;
import gregtech.api.enums.Materials;
import gregtech.api.objects.ItemData;
import gregtech.api.util.GT_OreDictUnificator;
import gregtech.common.GT_Worldgen_GT_Ore_Layer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import net.minecraft.item.ItemStack;
import pers.gwyog.gtneioreplugin.util.GT5CFGHelper;

public class GT5OreLayerHelper {
    private static final int DIMENSION_COUNT = 33;
    public static final Integer[] weightPerWorld = new Integer[33];
    public static final Integer[] DimIDs = new Integer[33];
    public static final HashMap<String, OreLayerWrapper> mapOreLayerWrapper = new HashMap();
    public static final HashMap<OreLayerWrapper, String> bufferedDims = new HashMap();
    public static final HashMap<String, NormalOreDimensionWrapper> dimToOreWrapper = new HashMap();

    public static void init() {
        Arrays.fill((Object[])weightPerWorld, (Object)0);
        Arrays.fill((Object[])DimIDs, (Object)0);
        for (GT_Worldgen_GT_Ore_Layer tWorldGen : GT_Worldgen_GT_Ore_Layer.sList) {
            mapOreLayerWrapper.put(tWorldGen.mWorldGenName, new OreLayerWrapper(tWorldGen));
        }
        for (OreLayerWrapper layer : mapOreLayerWrapper.values()) {
            bufferedDims.put(layer, GT5OreLayerHelper.getDims(layer));
        }
        bufferedDims.forEach((veinInfo, dims) -> {
            if (dims.equals("Not available in any Galactic Dim!")) {
                return;
            }
            for (String dim : dims.split(",")) {
                if (dim.isEmpty()) continue;
                NormalOreDimensionWrapper dimensionOres = dimToOreWrapper.getOrDefault(dim, new NormalOreDimensionWrapper());
                dimensionOres.internalDimOreList.add((OreLayerWrapper)veinInfo);
                dimToOreWrapper.put(dim, dimensionOres);
            }
            for (String dim : dimToOreWrapper.keySet()) {
                GT5OreLayerHelper.dimToOreWrapper.get(dim).calculateWeights();
            }
        });
    }

    public static String getDims(OreLayerWrapper oreLayer) {
        return GT5CFGHelper.GT5CFG(oreLayer.veinName.replace("ore.mix.custom.", "").replace("ore.mix.", ""));
    }

    public static class OreLayerWrapper {
        public final String veinName;
        public final String worldGenHeightRange;
        public final short[] Meta = new short[4];
        public final short randomWeight;
        public final short size;
        public final short density;
        public final Materials mPrimaryVeinMaterial;
        public final Materials mSecondaryMaterial;
        public final Materials mBetweenMaterial;
        public final Materials mSporadicMaterial;

        public OreLayerWrapper(GT_Worldgen_GT_Ore_Layer worldGen) {
            this.veinName = worldGen.mWorldGenName;
            this.Meta[0] = worldGen.mPrimaryMeta;
            this.Meta[1] = worldGen.mSecondaryMeta;
            this.Meta[2] = worldGen.mBetweenMeta;
            this.Meta[3] = worldGen.mSporadicMeta;
            ItemData primaryVeinData = GT_OreDictUnificator.getAssociation((ItemStack)new ItemStack(GregTech_API.sBlockOres1, 1, (int)worldGen.mPrimaryMeta));
            this.mPrimaryVeinMaterial = primaryVeinData != null ? primaryVeinData.mMaterial.mMaterial : null;
            ItemData secondaryVeinData = GT_OreDictUnificator.getAssociation((ItemStack)new ItemStack(GregTech_API.sBlockOres1, 1, (int)worldGen.mSecondaryMeta));
            this.mSecondaryMaterial = secondaryVeinData != null ? secondaryVeinData.mMaterial.mMaterial : null;
            ItemData betweenVeinData = GT_OreDictUnificator.getAssociation((ItemStack)new ItemStack(GregTech_API.sBlockOres1, 1, (int)worldGen.mBetweenMeta));
            this.mBetweenMaterial = betweenVeinData != null ? betweenVeinData.mMaterial.mMaterial : null;
            ItemData sporadicVeinData = GT_OreDictUnificator.getAssociation((ItemStack)new ItemStack(GregTech_API.sBlockOres1, 1, (int)worldGen.mSporadicMeta));
            this.mSporadicMaterial = sporadicVeinData != null ? sporadicVeinData.mMaterial.mMaterial : null;
            this.size = worldGen.mSize;
            this.density = worldGen.mDensity;
            this.worldGenHeightRange = worldGen.mMinY + "-" + worldGen.mMaxY;
            this.randomWeight = worldGen.mWeight;
        }

        public List<ItemStack> getVeinLayerOre(int maximumMaterialIndex, int veinLayer) {
            ArrayList<ItemStack> stackList = new ArrayList<ItemStack>();
            for (int i = 0; i < maximumMaterialIndex; ++i) {
                stackList.add(this.getLayerOre(veinLayer, i));
            }
            return stackList;
        }

        public ItemStack getLayerOre(int veinLayer, int materialIndex) {
            return new ItemStack(GregTech_API.sBlockOres1, 1, this.Meta[veinLayer] + materialIndex * 1000);
        }

        public boolean containsOre(short materialIndex) {
            return this.Meta[0] == materialIndex || this.Meta[1] == materialIndex || this.Meta[2] == materialIndex || this.Meta[3] == materialIndex;
        }
    }

    public static class NormalOreDimensionWrapper {
        public final ArrayList<OreLayerWrapper> internalDimOreList = new ArrayList();
        public final HashMap<OreLayerWrapper, Double> oreVeinToProbabilityInDimension = new HashMap();

        private void calculateWeights() {
            int totalWeight = 0;
            for (OreLayerWrapper oreVein : this.internalDimOreList) {
                totalWeight += oreVein.randomWeight;
            }
            for (OreLayerWrapper oreVein : this.internalDimOreList) {
                this.oreVeinToProbabilityInDimension.put(oreVein, (double)oreVein.randomWeight / (double)totalWeight);
            }
        }
    }
}

