/*
 * Decompiled with CFR 0.152.
 */
package com.mitchej123.hodgepodge.util;

import com.google.common.base.Utf8;
import com.mitchej123.hodgepodge.Common;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;

public final class PacketPrevalidation {
    private PacketPrevalidation() {
    }

    public static void validationError(String errorType, String badData) {
        IllegalArgumentException validationEx = new IllegalArgumentException("Invalid packet data encoded: " + errorType + "; data=\"" + StringEscapeUtils.escapeJava((String)badData) + "\"");
        Common.log.error("Packet validation error", (Throwable)validationEx);
        if (Common.config.validatePacketEncodingBeforeSendingShouldCrash) {
            throw validationEx;
        }
    }

    public static void validateLimitedString(String value, int maxLen) {
        if (value == null) {
            PacketPrevalidation.validationError("Null string passed to a ByteBuf encoder", "null");
            return;
        }
        int utf8Len = Utf8.encodedLength((CharSequence)value);
        if (utf8Len > maxLen) {
            PacketPrevalidation.validationError("String longer than " + maxLen, StringUtils.substring((String)value, (int)0, (int)maxLen));
        }
    }
}

