/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.client.render;

import com.creativemd.creativecore.client.block.BlockRenderHelper;
import com.creativemd.creativecore.client.block.IBlockAccessFake;
import com.creativemd.creativecore.common.utils.CubeObject;
import com.creativemd.littletiles.client.render.LittleThreadedRenderer;
import com.creativemd.littletiles.client.render.RenderingThread;
import com.creativemd.littletiles.common.tileentity.TileEntityLittleTiles;
import com.creativemd.littletiles.common.utils.LittleTile;
import com.creativemd.littletiles.utils.TileList;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.chunk.Chunk;

public class LittleBlockRenderHelper {
    public static LittleThreadedRenderer renderBlocks = new LittleThreadedRenderer(RenderBlocks.getInstance());
    public static IBlockAccessFake fake = null;

    public static void renderBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer, TileEntityLittleTiles te) {
        te.isRendering = true;
        int lightValue = Minecraft.func_71410_x().field_71441_e.func_72957_l(x, y, z);
        boolean needThread = false;
        Chunk chunk = Minecraft.func_71410_x().field_71441_e.func_72938_d(x, z);
        TileList<LittleTile> tiles = te.getTiles();
        for (LittleTile tile : tiles) {
            ArrayList<CubeObject> cubes = tile.getRenderingCubes();
            boolean threaded = false;
            if (tile.canBlockBeThreaded()) {
                needThread = true;
                continue;
            }
            BlockRenderHelper.renderCubes((IBlockAccess)world, cubes, (int)x, (int)y, (int)z, (Block)block, (RenderBlocks)renderer, null);
        }
        if (needThread) {
            if (te.needFullRenderUpdate || lightValue != te.lightValue || te.lastRendered == null) {
                te.lightValue = lightValue;
                RenderingThread.renderer = renderer;
                RenderingThread.addCoordToUpdate(te.func_145831_w(), new ChunkCoordinates(x, y, z));
                te.needFullRenderUpdate = false;
            }
            if (te.lastRendered != null) {
                for (int j = 0; j < te.lastRendered.size(); ++j) {
                    te.lastRendered.get(j).renderVertex();
                }
            }
        }
        te.lightValue = lightValue;
        te.isRendering = false;
    }
}

