/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.network.abstractpackets;

import java.io.IOException;
import logisticspipes.network.LPDataInputStream;
import logisticspipes.network.LPDataOutputStream;
import logisticspipes.network.abstractpackets.CoordinatesPacket;
import logisticspipes.network.abstractpackets.ModernPacket;
import logisticspipes.network.packets.orderer.RequestSubmitPacket;
import logisticspipes.utils.item.ItemIdentifierStack;

public abstract class RequestPacket
extends CoordinatesPacket {
    private ItemIdentifierStack stack;
    private int dimension;

    public RequestPacket(int id) {
        super(id);
    }

    @Override
    public ModernPacket template() {
        return new RequestSubmitPacket(this.getId());
    }

    @Override
    public void writeData(LPDataOutputStream data) throws IOException {
        super.writeData(data);
        data.writeItemIdentifierStack(this.stack);
        data.writeInt(this.dimension);
    }

    @Override
    public void readData(LPDataInputStream data) throws IOException {
        super.readData(data);
        this.stack = data.readItemIdentifierStack();
        this.dimension = data.readInt();
    }

    public ItemIdentifierStack getStack() {
        return this.stack;
    }

    public RequestPacket setStack(ItemIdentifierStack stack) {
        this.stack = stack;
        return this;
    }

    public int getDimension() {
        return this.dimension;
    }

    public RequestPacket setDimension(int dimension) {
        this.dimension = dimension;
        return this;
    }
}

