/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.doors.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import net.malisis.core.block.IBoundingBox;
import net.malisis.core.util.TileEntityUtils;
import net.malisis.doors.MalisisDoors;
import net.malisis.doors.ProxyAccess;
import net.malisis.doors.entity.VanishingTileEntity;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class VanishingBlock
extends BlockContainer {
    public static final int typeWoodFrame = 0;
    public static final int typeIronFrame = 1;
    public static final int typeGoldFrame = 2;
    public static final int typeDiamondFrame = 3;
    public static final int flagPowered = 4;
    public static final int flagInTransition = 8;
    private static IIcon[] icons = new IIcon[4];
    public static int renderId = -1;
    public int renderPass = -1;

    public VanishingBlock() {
        super(Material.field_151575_d);
        this.func_149663_c("vanishing_block");
        this.func_149647_a(MalisisDoors.tab);
        this.func_149711_c(0.5f);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister register) {
        VanishingBlock.icons[0] = register.func_94245_a("malisisdoors:vanishing_block_wood");
        VanishingBlock.icons[1] = register.func_94245_a("malisisdoors:vanishing_block_iron");
        VanishingBlock.icons[2] = register.func_94245_a("malisisdoors:vanishing_block_gold");
        VanishingBlock.icons[3] = register.func_94245_a("malisisdoors:vanishing_block_diamond");
    }

    public IIcon func_149691_a(int side, int frameType) {
        return icons[frameType & 3];
    }

    public boolean isPowered(World world, int x, int y, int z) {
        return world.func_147439_a(x, y, z) == this && (world.func_72805_g(x, y, z) & 4) != 0;
    }

    public void setPowerState(World world, int x, int y, int z, boolean powered) {
        if (world.func_147439_a(x, y, z) != this) {
            return;
        }
        if (this.isPowered(world, x, y, z) == powered) {
            return;
        }
        VanishingTileEntity te = (VanishingTileEntity)((Object)TileEntityUtils.getTileEntity(VanishingTileEntity.class, (IBlockAccess)world, (int)x, (int)y, (int)z));
        if (te == null) {
            return;
        }
        te.setPowerState(powered);
        if (powered) {
            world.func_72921_c(x, y, z, te.field_145847_g | 4, 2);
        } else {
            world.func_72921_c(x, y, z, te.field_145847_g & 0xFFFFFFFB, 2);
        }
        world.func_147464_a(x, y, z, (Block)this, 1);
    }

    public boolean shouldPropagate(World world, int x, int y, int z, VanishingTileEntity source) {
        if (world.func_147439_a(x, y, z) != this) {
            return false;
        }
        if ((source.func_145832_p() & 3) == 0) {
            return true;
        }
        VanishingTileEntity dest = (VanishingTileEntity)((Object)TileEntityUtils.getTileEntity(VanishingTileEntity.class, (IBlockAccess)world, (int)x, (int)y, (int)z));
        if (dest == null) {
            return false;
        }
        if (source.copiedBlock == null || dest.copiedBlock == null) {
            return true;
        }
        if ((source.func_145832_p() & 3) == 1 && source.copiedBlock == dest.copiedBlock) {
            return true;
        }
        return (source.func_145832_p() & 3) == 2 && source.copiedBlock == dest.copiedBlock && source.copiedMetadata == dest.copiedMetadata;
    }

    public void propagateState(World world, int x, int y, int z) {
        VanishingTileEntity te = (VanishingTileEntity)((Object)TileEntityUtils.getTileEntity(VanishingTileEntity.class, (IBlockAccess)world, (int)x, (int)y, (int)z));
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            if (!this.shouldPropagate(world, x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ, te)) continue;
            this.setPowerState(world, x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ, te.powered);
        }
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer p, int side, float hitX, float hitY, float hitZ) {
        ItemStack is = p.func_70694_bm();
        if (is == null) {
            return false;
        }
        VanishingTileEntity te = (VanishingTileEntity)((Object)TileEntityUtils.getTileEntity(VanishingTileEntity.class, (IBlockAccess)world, (int)x, (int)y, (int)z));
        if (te == null || te.copiedBlock != null) {
            return false;
        }
        if (!te.setBlock(is, p, side, hitX, hitY, hitZ)) {
            return false;
        }
        if (!p.field_71075_bZ.field_75098_d) {
            --is.field_77994_a;
        }
        world.func_147471_g(x, y, z);
        ((World)ProxyAccess.get((IBlockAccess)world)).func_147459_d(x, y, z, te.copiedBlock);
        return true;
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        if (world.field_72995_K) {
            return;
        }
        boolean powered = world.func_72864_z(x, y, z);
        if (powered || block.func_149744_f() && block != this) {
            if (this.isPowered(world, x, y, z) != powered) {
                world.func_72908_a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "malisisdoors:portal", 0.3f, 0.5f);
            }
            this.setPowerState(world, x, y, z, powered);
        }
    }

    public void func_149674_a(World world, int x, int y, int z, Random rand) {
        this.propagateState(world, x, y, z);
    }

    public void func_149749_a(World world, int x, int y, int z, Block block, int j) {
        VanishingTileEntity te = (VanishingTileEntity)world.func_147438_o(x, y, z);
        if (te != null && te.copiedBlock != null) {
            te.copiedBlock.func_149697_b(world, x, y, z, te.copiedMetadata, 0);
        }
        world.func_147475_p(x, y, z);
    }

    public boolean isSideSolid(IBlockAccess world, int x, int y, int z, ForgeDirection side) {
        return false;
    }

    public AxisAlignedBB func_149668_a(World world, int x, int y, int z) {
        if ((world.func_72805_g(x, y, z) & 0xC) != 0) {
            return null;
        }
        VanishingTileEntity te = (VanishingTileEntity)((Object)TileEntityUtils.getTileEntity(VanishingTileEntity.class, (IBlockAccess)world, (int)x, (int)y, (int)z));
        if (te == null || te.copiedBlock == null) {
            return AxisAlignedBB.func_72330_a((double)x, (double)y, (double)z, (double)(x + 1), (double)(y + 1), (double)(z + 1));
        }
        return te.copiedBlock.func_149668_a((World)ProxyAccess.get((IBlockAccess)world), x, y, z);
    }

    public void func_149743_a(World world, int x, int y, int z, AxisAlignedBB mask, List list, Entity entity) {
        if ((world.func_72805_g(x, y, z) & 0xC) != 0) {
            return;
        }
        VanishingTileEntity te = (VanishingTileEntity)((Object)TileEntityUtils.getTileEntity(VanishingTileEntity.class, (IBlockAccess)world, (int)x, (int)y, (int)z));
        if (te == null || te.copiedBlock == null) {
            super.func_149743_a(world, x, y, z, mask, list, entity);
            return;
        }
        te.copiedBlock.func_149743_a((World)ProxyAccess.get((IBlockAccess)world), x, y, z, mask, list, entity);
    }

    public void func_149719_a(IBlockAccess world, int x, int y, int z) {
        if ((world.func_72805_g(x, y, z) & 0xC) != 0) {
            this.func_149676_a(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
        } else {
            VanishingTileEntity te = (VanishingTileEntity)((Object)TileEntityUtils.getTileEntity(VanishingTileEntity.class, (IBlockAccess)world, (int)x, (int)y, (int)z));
            if (te == null || te.copiedBlock == null) {
                this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
            } else {
                te.copiedBlock.func_149719_a(ProxyAccess.get(world), x, y, z);
            }
        }
    }

    public AxisAlignedBB func_149633_g(World world, int x, int y, int z) {
        VanishingTileEntity te = (VanishingTileEntity)((Object)TileEntityUtils.getTileEntity(VanishingTileEntity.class, (IBlockAccess)world, (int)x, (int)y, (int)z));
        if (te == null || te.powered || te.inTransition) {
            return AxisAlignedBB.func_72330_a((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0);
        }
        this.func_149719_a((IBlockAccess)world, x, y, z);
        if (te == null || te.copiedBlock == null) {
            return AxisAlignedBB.func_72330_a((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)1.0);
        }
        return te.copiedBlock.func_149633_g((World)ProxyAccess.get((IBlockAccess)world), x, y, z);
    }

    public MovingObjectPosition func_149731_a(World world, int x, int y, int z, Vec3 src, Vec3 dest) {
        VanishingTileEntity te = (VanishingTileEntity)((Object)TileEntityUtils.getTileEntity(VanishingTileEntity.class, (IBlockAccess)world, (int)x, (int)y, (int)z));
        if (te == null || te.powered || te.inTransition) {
            this.func_149676_a(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
            return super.func_149731_a(world, x, y, z, src, dest);
        }
        if (te == null || te.copiedBlock == null) {
            return super.func_149731_a(world, x, y, z, src, dest);
        }
        World proxy = (World)ProxyAccess.get((IBlockAccess)world);
        if (proxy == world && te.copiedBlock instanceof IBoundingBox) {
            return super.func_149731_a(world, x, y, z, src, dest);
        }
        return te.copiedBlock.func_149731_a(proxy, x, y, z, src, dest);
    }

    @SideOnly(value=Side.CLIENT)
    public Item func_149694_d(World worldIn, int x, int y, int z) {
        return Item.func_150898_a((Block)MalisisDoors.Blocks.vanishingBlock);
    }

    public void func_149666_a(Item item, CreativeTabs tab, List list) {
        list.add(new ItemStack(item, 1, 0));
        list.add(new ItemStack(item, 1, 1));
        list.add(new ItemStack(item, 1, 2));
        list.add(new ItemStack(item, 1, 3));
    }

    public int func_149692_a(int metadata) {
        return metadata;
    }

    public boolean func_149721_r() {
        return false;
    }

    public boolean func_149662_c() {
        return false;
    }

    public float func_149685_I() {
        return 0.9f;
    }

    public TileEntity func_149915_a(World world, int metadata) {
        return new VanishingTileEntity(metadata);
    }

    public boolean canRenderInPass(int pass) {
        this.renderPass = pass;
        return true;
    }

    public int func_149701_w() {
        return 1;
    }

    public int func_149645_b() {
        return renderId;
    }
}

