/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.doors.door.block;

import java.util.ArrayList;
import net.malisis.core.block.BoundingBoxType;
import net.malisis.core.block.MalisisBlock;
import net.malisis.core.util.AABBUtils;
import net.malisis.core.util.BlockPos;
import net.malisis.core.util.BlockState;
import net.malisis.core.util.EntityUtils;
import net.malisis.core.util.TileEntityUtils;
import net.malisis.core.util.chunkcollision.ChunkCollision;
import net.malisis.core.util.chunkcollision.IChunkCollidable;
import net.malisis.core.util.chunklistener.IBlockListener;
import net.malisis.doors.MalisisDoors;
import net.malisis.doors.door.block.Door;
import net.malisis.doors.door.tileentity.BigDoorTileEntity;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BigDoor
extends MalisisBlock
implements ITileEntityProvider,
IChunkCollidable,
IBlockListener {
    public static int renderId;
    public static int renderPass;
    private AxisAlignedBB defaultBoundingBox = AxisAlignedBB.func_72330_a((double)0.0, (double)0.0, (double)0.8125, (double)4.0, (double)5.0, (double)1.0);
    private Type type;

    public BigDoor(Type type) {
        super(Material.field_151575_d);
        this.type = type;
        this.func_149711_c(5.0f);
        this.func_149752_b(10.0f);
        this.func_149672_a(field_149769_e);
        this.func_149663_c(type.name);
        this.func_149647_a(MalisisDoors.tab);
    }

    public void func_149651_a(IIconRegister register) {
        this.field_149761_L = register.func_94245_a("malisisdoors:" + this.type.name);
    }

    public String func_149702_O() {
        return "malisisdoors:" + this.type.name + "_item";
    }

    public boolean func_149707_d(World world, int x, int y, int z, int side) {
        if (side != 1) {
            return false;
        }
        ForgeDirection dir = ForgeDirection.getOrientation((int)side).getOpposite();
        return world.func_147439_a(x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ).isSideSolid((IBlockAccess)world, x, y, z, dir);
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase player, ItemStack itemStack) {
        ForgeDirection dir = EntityUtils.getEntityFacing((Entity)player);
        int metadata = Door.dirToInt(dir);
        world.func_72921_c(x, y, z, metadata, 2);
        ChunkCollision.get().replaceBlocks(world, new BlockState((IBlockAccess)world, x, y, z));
        BigDoorTileEntity te = (BigDoorTileEntity)((Object)TileEntityUtils.getTileEntity(BigDoorTileEntity.class, (IBlockAccess)world, (int)x, (int)y, (int)z));
        if (te != null) {
            te.setFrameState(BlockState.fromNBT((NBTTagCompound)itemStack.func_77978_p()));
        }
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return true;
        }
        BigDoorTileEntity te = (BigDoorTileEntity)((Object)TileEntityUtils.getTileEntity(BigDoorTileEntity.class, (IBlockAccess)world, (int)x, (int)y, (int)z));
        if (te == null) {
            return true;
        }
        te.openOrCloseDoor();
        return true;
    }

    public AxisAlignedBB[] getPlacedBoundingBox(IBlockAccess world, int x, int y, int z, int side, EntityPlayer player, ItemStack itemStack) {
        ForgeDirection dir = EntityUtils.getEntityFacing((Entity)player);
        return AABBUtils.rotate((AxisAlignedBB[])new AxisAlignedBB[]{this.defaultBoundingBox.func_72329_c()}, (ForgeDirection)dir);
    }

    public AxisAlignedBB[] getBoundingBox(IBlockAccess world, int x, int y, int z, BoundingBoxType type) {
        BigDoorTileEntity te = (BigDoorTileEntity)((Object)TileEntityUtils.getTileEntity(BigDoorTileEntity.class, (IBlockAccess)world, (int)x, (int)y, (int)z));
        if (te == null) {
            return AABBUtils.identities();
        }
        AxisAlignedBB[] aabbs = new AxisAlignedBB[]{this.defaultBoundingBox.func_72329_c()};
        if (type == BoundingBoxType.RENDER) {
            aabbs[0].field_72339_c = -0.5;
        } else if ((type == BoundingBoxType.COLLISION || type == BoundingBoxType.CHUNKCOLLISION || type == BoundingBoxType.RAYTRACE) && (te.isOpened() || te.isMoving())) {
            aabbs = new AxisAlignedBB[]{AxisAlignedBB.func_72330_a((double)0.0, (double)0.0, (double)-0.5, (double)0.5, (double)4.0, (double)1.0), AxisAlignedBB.func_72330_a((double)3.5, (double)0.0, (double)-0.5, (double)4.0, (double)4.0, (double)1.0), AxisAlignedBB.func_72330_a((double)0.0, (double)4.0, (double)0.8125, (double)4.0, (double)5.0, (double)1.0)};
        }
        return AABBUtils.rotate((AxisAlignedBB[])aabbs, (ForgeDirection)Door.intToDir(te.getDirection()));
    }

    public int blockRange() {
        return 5;
    }

    public TileEntity func_149915_a(World world, int metadata) {
        return new BigDoorTileEntity();
    }

    public boolean removedByPlayer(World world, EntityPlayer player, int x, int y, int z) {
        BigDoorTileEntity te;
        if (!player.field_71075_bZ.field_75098_d && (te = (BigDoorTileEntity)((Object)TileEntityUtils.getTileEntity(BigDoorTileEntity.class, (IBlockAccess)world, (int)x, (int)y, (int)z))) != null) {
            this.func_149642_a(world, x, y, z, te.getDroppedItemStack());
        }
        return super.removedByPlayer(world, player, x, y, z);
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        return new ArrayList<ItemStack>();
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public int func_149645_b() {
        return renderId;
    }

    public int func_149701_w() {
        return 1;
    }

    public boolean canRenderInPass(int pass) {
        renderPass = pass;
        return true;
    }

    public boolean onBlockSet(World world, BlockPos pos, BlockState state) {
        if (!state.getBlock().isReplaceable((IBlockAccess)world, state.getX(), state.getY(), state.getZ())) {
            return true;
        }
        for (AxisAlignedBB aabb : AABBUtils.getCollisionBoundingBoxes((World)world, (BlockState)new BlockState(pos, (Block)this), (boolean)true)) {
            if (!state.getPos().isInside(aabb)) continue;
            return false;
        }
        return true;
    }

    public boolean onBlockRemoved(World world, BlockPos pos, BlockPos blockPos) {
        return true;
    }

    static {
        renderPass = -1;
    }

    public static enum Type {
        CARRIAGE("carriage_door", Items.field_151135_aq),
        MEDIEVAL("medieval_door", MalisisDoors.Items.doorSpruceItem);

        public String name;
        public Item door;

        private Type(String name, Item door) {
            this.name = name;
            this.door = door;
        }
    }
}

