/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.doors.entity;

import java.util.HashSet;
import java.util.Set;
import net.malisis.core.util.TileEntityUtils;
import net.malisis.doors.block.GarageDoor;
import net.malisis.doors.door.DoorState;
import net.malisis.doors.door.tileentity.DoorTileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;

public class GarageDoorTileEntity
extends DoorTileEntity {
    public static final int maxOpenTime = 10;

    public boolean isTopDoor() {
        return this == this.getTopDoor();
    }

    @Override
    public int getOpeningTime() {
        return this.getDoors().size() * 10;
    }

    public GarageDoorTileEntity getTopDoor() {
        GarageDoorTileEntity topDoor = this.getGarageDoor(ForgeDirection.UP);
        return topDoor != null ? topDoor.getTopDoor() : this;
    }

    public Set<GarageDoorTileEntity> getDoors() {
        HashSet<GarageDoorTileEntity> childDoors = new HashSet<GarageDoorTileEntity>();
        this.getTopDoor().addChildDoors(childDoors);
        return childDoors;
    }

    public void addChildDoors(Set<GarageDoorTileEntity> childDoors) {
        childDoors.add(this);
        GarageDoorTileEntity bottomDoor = this.getGarageDoor(ForgeDirection.DOWN);
        if (bottomDoor != null) {
            bottomDoor.addChildDoors(childDoors);
        }
    }

    public GarageDoorTileEntity getGarageDoor(ForgeDirection dir) {
        GarageDoorTileEntity te = (GarageDoorTileEntity)((Object)TileEntityUtils.getTileEntity(GarageDoorTileEntity.class, (IBlockAccess)this.func_145831_w(), (int)(this.field_145851_c + dir.offsetX), (int)(this.field_145848_d + dir.offsetY), (int)(this.field_145849_e + dir.offsetZ)));
        if (te == null) {
            return null;
        }
        if (te.getDirection() != this.getDirection()) {
            return null;
        }
        return te;
    }

    @Override
    public void setPowered(boolean powered) {
        if (this.isMoving()) {
            return;
        }
        if (this.isOpened() == powered) {
            return;
        }
        if (this.state == DoorState.OPENING && powered || this.state == DoorState.CLOSING && !powered) {
            return;
        }
        DoorState newState = powered ? DoorState.OPENING : DoorState.CLOSING;
        for (GarageDoorTileEntity te : this.getDoors()) {
            te.setDoorState(newState);
        }
        GarageDoorTileEntity te = this.getGarageDoor(GarageDoor.isEastOrWest(this.field_145847_g) ? ForgeDirection.NORTH : ForgeDirection.EAST);
        if (te != null) {
            te.setPowered(powered);
        }
        if ((te = this.getGarageDoor(GarageDoor.isEastOrWest(this.field_145847_g) ? ForgeDirection.SOUTH : ForgeDirection.WEST)) != null) {
            te.setPowered(powered);
        }
    }

    @Override
    public void playSound() {
    }

    @Override
    public void func_145845_h() {
        if (this.state == DoorState.CLOSED || this.state == DoorState.OPENED) {
            return;
        }
        if (this.timer.elapsedTick() > (long)this.getOpeningTime()) {
            this.setDoorState(this.state == DoorState.CLOSING ? DoorState.CLOSED : DoorState.OPENED);
        }
    }

    @Override
    public AxisAlignedBB getRenderBoundingBox() {
        Set<GarageDoorTileEntity> childDoors = this.getDoors();
        return AxisAlignedBB.func_72330_a((double)(this.field_145851_c - childDoors.size()), (double)(this.field_145848_d - childDoors.size()), (double)(this.field_145849_e - childDoors.size()), (double)(this.field_145851_c + childDoors.size() + 1), (double)(this.field_145848_d + 1), (double)(this.field_145849_e + childDoors.size() + 1));
    }
}

