/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.modularui.api.fluids;

import com.gtnewhorizons.modularui.api.fluids.IFluidTankLong;
import com.gtnewhorizons.modularui.api.fluids.IFluidTanksHandler;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.tuple.Pair;

public class ListFluidHandler
implements IFluidTanksHandler {
    protected final Iterable<? extends IFluidTanksHandler> fluidHandlers;

    public ListFluidHandler(Iterable<? extends IFluidTanksHandler> fluidHandlers) {
        this.fluidHandlers = fluidHandlers;
    }

    @Override
    public int getTanks() {
        int tanks = 0;
        for (IFluidTanksHandler iFluidTanksHandler : this.fluidHandlers) {
            tanks += iFluidTanksHandler.getTanks();
        }
        return tanks;
    }

    @Override
    public FluidStack getFluidStackInTank(int tank) {
        Pair<? extends IFluidTanksHandler, Integer> result = this.findFluidHandler(tank);
        return ((IFluidTanksHandler)result.getLeft()).getFluidStackInTank((Integer)result.getRight());
    }

    @Override
    public FluidStack fill(int tank, Fluid fluid, long amount, boolean simulate) {
        Pair<? extends IFluidTanksHandler, Integer> result = this.findFluidHandler(tank);
        return ((IFluidTanksHandler)result.getLeft()).fill((Integer)result.getRight(), fluid, amount, simulate);
    }

    @Override
    public FluidStack drain(int tank, long amount, boolean simulate) {
        Pair<? extends IFluidTanksHandler, Integer> result = this.findFluidHandler(tank);
        return ((IFluidTanksHandler)result.getLeft()).drain((Integer)result.getRight(), amount, simulate);
    }

    @Override
    public long getTankCapacity(int tank) {
        Pair<? extends IFluidTanksHandler, Integer> result = this.findFluidHandler(tank);
        return ((IFluidTanksHandler)result.getLeft()).getTankCapacity((Integer)result.getRight());
    }

    @Override
    public long getTankStoredAmount(int tank) {
        Pair<? extends IFluidTanksHandler, Integer> result = this.findFluidHandler(tank);
        return ((IFluidTanksHandler)result.getLeft()).getTankStoredAmount((Integer)result.getRight());
    }

    protected Pair<? extends IFluidTanksHandler, Integer> findFluidHandler(int tank) {
        int searching = 0;
        for (IFluidTanksHandler iFluidTanksHandler : this.fluidHandlers) {
            int amountOfTanks = iFluidTanksHandler.getTanks();
            if (tank < searching || tank >= searching + amountOfTanks) continue;
            return Pair.of((Object)iFluidTanksHandler, (Object)(tank - searching));
        }
        throw new RuntimeException("Tank " + tank + " not in valid range - [0," + this.getTanks() + ")");
    }

    @Override
    public void setFluidInTank(int tank, Fluid fluid, long amount) {
        Pair<? extends IFluidTanksHandler, Integer> result = this.findFluidHandler(tank);
        ((IFluidTanksHandler)result.getLeft()).setFluidInTank((Integer)result.getRight(), fluid, amount);
    }

    @Override
    public IFluidTankLong getFluidTank(int tank) {
        Pair<? extends IFluidTanksHandler, Integer> result = this.findFluidHandler(tank);
        return ((IFluidTanksHandler)result.getLeft()).getFluidTank(tank);
    }

    @Override
    public Fluid getFluidInTank(int tank) {
        Pair<? extends IFluidTanksHandler, Integer> result = this.findFluidHandler(tank);
        return ((IFluidTanksHandler)result.getLeft()).getFluidInTank(tank);
    }
}

