/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.modularui.common.internal.wrapper;

import codechicken.lib.render.FontUtils;
import codechicken.nei.ItemPanels;
import codechicken.nei.NEIClientUtils;
import codechicken.nei.VisiblityData;
import codechicken.nei.api.INEIGuiHandler;
import codechicken.nei.api.TaggedInventoryArea;
import codechicken.nei.guihook.GuiContainerManager;
import codechicken.nei.guihook.IContainerDrawHandler;
import codechicken.nei.guihook.IContainerInputHandler;
import codechicken.nei.guihook.IContainerObjectHandler;
import com.gtnewhorizons.modularui.api.GlStateManager;
import com.gtnewhorizons.modularui.api.drawable.GuiHelper;
import com.gtnewhorizons.modularui.api.drawable.Text;
import com.gtnewhorizons.modularui.api.math.Alignment;
import com.gtnewhorizons.modularui.api.math.Color;
import com.gtnewhorizons.modularui.api.math.Pos2d;
import com.gtnewhorizons.modularui.api.math.Size;
import com.gtnewhorizons.modularui.api.screen.Cursor;
import com.gtnewhorizons.modularui.api.screen.ModularUIContext;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.widget.IDragAndDropHandler;
import com.gtnewhorizons.modularui.api.widget.IHasStackUnderMouse;
import com.gtnewhorizons.modularui.api.widget.IVanillaSlot;
import com.gtnewhorizons.modularui.api.widget.IWidgetParent;
import com.gtnewhorizons.modularui.api.widget.Interactable;
import com.gtnewhorizons.modularui.api.widget.Widget;
import com.gtnewhorizons.modularui.common.internal.network.NetworkUtils;
import com.gtnewhorizons.modularui.common.internal.wrapper.BaseSlot;
import com.gtnewhorizons.modularui.common.internal.wrapper.ModularUIContainer;
import com.gtnewhorizons.modularui.common.widget.SlotWidget;
import com.gtnewhorizons.modularui.config.Config;
import com.gtnewhorizons.modularui.mixins.GuiContainerAccessor;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiLabel;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class ModularGui
extends GuiContainer
implements INEIGuiHandler {
    private final ModularUIContext context;
    private Pos2d mousePos = Pos2d.ZERO;
    @Nullable
    private Object lastClicked;
    private long lastClick = -1L;
    private long lastFocusedClick = -1L;
    private int drawCalls = 0;
    private long drawTime = 0L;
    private int fps = 0;
    private float partialTicks;

    public ModularGui(ModularUIContainer container) {
        super((Container)container);
        this.context = container.getContext();
        this.context.initializeClient(this);
    }

    public ModularUIContext getContext() {
        return this.context;
    }

    public Cursor getCursor() {
        return this.context.getCursor();
    }

    public Pos2d getMousePos() {
        return this.mousePos;
    }

    public void setMainWindowArea(Pos2d pos, Size size) {
        this.field_147003_i = pos.x;
        this.field_147009_r = pos.y;
        this.field_146999_f = size.width;
        this.field_147000_g = size.height;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.context.resize(new Size(this.field_146294_l, this.field_146295_m));
        this.context.buildWindowOnStart();
        this.context.getCurrentWindow().onOpen();
    }

    public GuiContainerAccessor getAccessor() {
        return (GuiContainerAccessor)((Object)this);
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.mousePos = new Pos2d(mouseX, mouseY);
        int i = this.field_147003_i;
        int j = this.field_147009_r;
        this.func_146976_a(partialTicks, mouseX, mouseY);
        GlStateManager.disableLighting();
        GlStateManager.disableDepth();
        this.drawVanillaElements(mouseX, mouseY, partialTicks);
        GlStateManager.pushMatrix();
        GlStateManager.color(1.0f, 1.0f, 1.0f, 1.0f);
        GlStateManager.enableRescaleNormal();
        this.getAccessor().setHoveredSlot(null);
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
        GlStateManager.enableRescaleNormal();
        GlStateManager.color(1.0f, 1.0f, 1.0f, 1.0f);
        RenderHelper.func_74520_c();
        if (this.shouldShowNEI()) {
            for (IContainerDrawHandler drawHandler : GuiContainerManager.drawHandlers) {
                drawHandler.renderObjects((GuiContainer)this, mouseX, mouseY);
            }
            for (IContainerDrawHandler drawHandler : GuiContainerManager.drawHandlers) {
                drawHandler.postRenderObjects((GuiContainer)this, mouseX, mouseY);
            }
            if (!this.shouldRenderOurTooltip() && this.shouldRenderNEITooltip() && GuiContainerManager.getManager() != null) {
                GuiContainerManager.getManager().renderToolTips(mouseX, mouseY);
            }
        }
        GL11.glDisable((int)2929);
        GlStateManager.color(1.0f, 1.0f, 1.0f, 1.0f);
        RenderHelper.func_74518_a();
        this.func_146979_b(mouseX, mouseY);
        RenderHelper.func_74520_c();
        this.getAccessor().setHoveredSlot(null);
        Widget hovered = this.getCursor().getHovered();
        if (hovered instanceof IVanillaSlot) {
            this.getAccessor().setHoveredSlot(((IVanillaSlot)((Object)hovered)).getMcSlot());
        }
        GlStateManager.color(1.0f, 1.0f, 1.0f, 1.0f);
        GlStateManager.pushMatrix();
        GlStateManager.translate(i, j, 0.0f);
        GlStateManager.popMatrix();
        InventoryPlayer inventoryplayer = this.field_146297_k.field_71439_g.field_71071_by;
        ItemStack itemstack = this.getAccessor().getDraggedStack() == null ? inventoryplayer.func_70445_o() : this.getAccessor().getDraggedStack();
        GlStateManager.translate(i, j, 0.0f);
        if (itemstack != null) {
            int k2 = this.getAccessor().getDraggedStack() == null ? 8 : 16;
            String s = null;
            if (this.getAccessor().getDraggedStack() != null && this.getAccessor().getIsRightMouseClick()) {
                itemstack = itemstack.func_77946_l();
                itemstack.field_77994_a = (int)Math.ceil((float)itemstack.field_77994_a / 2.0f);
            } else if (this.isDragSplitting() && this.getDragSlots().size() > 1) {
                itemstack = itemstack.func_77946_l();
                itemstack.field_77994_a = this.getAccessor().getDragSplittingRemnant();
                if (itemstack.field_77994_a < 1) {
                    s = EnumChatFormatting.YELLOW + "0";
                }
            }
            this.drawItemStack(itemstack, mouseX - i - 8, mouseY - j - k2, s);
        }
        if (this.getAccessor().getReturningStack() != null) {
            float f = (float)(Minecraft.func_71386_F() - this.getAccessor().getReturningStackTime()) / 100.0f;
            if (f >= 1.0f) {
                f = 1.0f;
                this.getAccessor().setReturningStack(null);
            }
            int l2 = this.getAccessor().getReturningStackDestSlot().field_75223_e - this.getAccessor().getTouchUpX();
            int i3 = this.getAccessor().getReturningStackDestSlot().field_75221_f - this.getAccessor().getTouchUpY();
            int l1 = this.getAccessor().getTouchUpX() + (int)((float)l2 * f);
            int i2 = this.getAccessor().getTouchUpY() + (int)((float)i3 * f);
            this.drawItemStack(this.getAccessor().getReturningStack(), l1, i2, null);
        }
        GlStateManager.popMatrix();
        if (Config.debug) {
            GlStateManager.disableDepth();
            GlStateManager.disableLighting();
            GlStateManager.enableBlend();
            this.drawDebugScreen();
            GlStateManager.color(1.0f, 1.0f, 1.0f, 1.0f);
        }
        GlStateManager.enableLighting();
        GlStateManager.enableDepth();
        GlStateManager.enableRescaleNormal();
        RenderHelper.func_74519_b();
    }

    private void drawItemStack(ItemStack stack, int x, int y, String altText) {
        GlStateManager.translate(0.0f, 0.0f, 32.0f);
        GlStateManager.enableDepth();
        this.field_73735_i = 200.0f;
        ModularGui.field_146296_j.field_77023_b = 200.0f;
        FontRenderer font = GuiHelper.getFontRenderer(stack);
        field_146296_j.func_82406_b(font, this.field_146297_k.func_110434_K(), stack, x, y);
        field_146296_j.func_94148_a(font, this.field_146297_k.func_110434_K(), stack, x, y - (this.getDragSlots() != null ? 0 : 8), altText);
        GuiHelper.afterRenderItemAndEffectIntoGUI(stack);
        this.field_73735_i = 0.0f;
        ModularGui.field_146296_j.field_77023_b = 0.0f;
        GlStateManager.disableDepth();
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        if (Config.debug) {
            long time = Minecraft.func_71386_F() / 1000L;
            if (this.drawTime != time) {
                this.fps = this.drawCalls;
                this.drawCalls = 0;
                this.drawTime = time;
            }
            ++this.drawCalls;
        }
        this.context.forEachWindowBottomToTop(window -> window.frameUpdate(partialTicks));
        this.func_146276_q_();
        GlStateManager.disableRescaleNormal();
        RenderHelper.func_74518_a();
        GlStateManager.disableLighting();
        GlStateManager.disableDepth();
        for (ModularWindow window2 : this.context.getOpenWindowsReversed()) {
            if (!window2.isEnabled()) continue;
            window2.drawWidgets(partialTicks, false);
        }
        GlStateManager.enableRescaleNormal();
        GlStateManager.enableLighting();
        RenderHelper.func_74519_b();
        this.partialTicks = partialTicks;
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        GlStateManager.pushMatrix();
        GlStateManager.disableRescaleNormal();
        RenderHelper.func_74518_a();
        GlStateManager.disableLighting();
        GlStateManager.disableDepth();
        Widget hovered = this.context.getCursor().getHovered();
        if (this.shouldRenderOurTooltip()) {
            if (hovered instanceof IVanillaSlot && ((IVanillaSlot)((Object)hovered)).getMcSlot().func_75216_d() && !this.context.getCursor().isHoldingSomething()) {
                this.renderToolTip(((IVanillaSlot)((Object)hovered)).getMcSlot().func_75211_c(), mouseX, mouseY, ((IVanillaSlot)((Object)hovered)).getExtraTooltip(), ((IVanillaSlot)((Object)hovered)).getOverwriteItemStackTooltip());
            } else if (hovered.getTooltipShowUpDelay() <= this.context.getCursor().getTimeHovered()) {
                String transferRectTooltip;
                ArrayList<Text> tooltip = new ArrayList<Text>(hovered.getTooltip());
                if (hovered.hasNEITransferRect() && (transferRectTooltip = hovered.getNEITransferRectTooltip()) != null) {
                    tooltip.add(new Text(transferRectTooltip).color(Color.WHITE.normal));
                }
                if (!tooltip.isEmpty()) {
                    GuiHelper.drawHoveringText(tooltip, this.context.getMousePos(), this.context.getScaledScreenSize(), 400, 1.0f, false, Alignment.CenterLeft, hovered.isTooltipHasSpaceAfterFirstLine());
                }
            }
            GlStateManager.disableDepth();
        }
        if (this.context.getCurrentWindow().isEnabled()) {
            this.context.getCurrentWindow().drawWidgets(this.partialTicks, true);
        }
        this.context.getCursor().draw(this.partialTicks);
        GlStateManager.enableRescaleNormal();
        GlStateManager.enableLighting();
        RenderHelper.func_74519_b();
        GlStateManager.popMatrix();
    }

    protected boolean shouldRenderOurTooltip() {
        return this.context.getCursor().getHovered() != null;
    }

    protected boolean shouldRenderNEITooltip() {
        for (IContainerObjectHandler objectHandler : GuiContainerManager.objectHandlers) {
            ItemStack item = objectHandler.getStackUnderMouse((GuiContainer)this, this.context.getCursor().getPos().x, this.context.getCursor().getPos().y);
            if (item == null) continue;
            return true;
        }
        return false;
    }

    public void drawDebugScreen() {
        int i;
        Size screenSize = this.context.getScaledScreenSize();
        int neiYOffset = this.shouldShowNEI() ? 20 : 0;
        int color = Color.rgb(180, 40, 115);
        int lineY = screenSize.height - 13 - neiYOffset;
        this.func_73731_b(FontUtils.fontRenderer, "Mouse Pos: " + this.getMousePos(), 5, lineY, color);
        lineY -= 11;
        this.func_73731_b(FontUtils.fontRenderer, "FPS: " + this.fps, 5, screenSize.height - 24 - neiYOffset, color);
        lineY -= 11;
        Widget hovered = this.context.getCursor().findHoveredWidget(true);
        if (hovered != null) {
            Size size = hovered.getSize();
            Pos2d pos = hovered.getAbsolutePos();
            IWidgetParent parent = hovered.getParent();
            ModularGui.drawBorder(pos.x, pos.y, size.width, size.height, color, 1.0f);
            ModularGui.drawBorder(parent.getAbsolutePos().x, parent.getAbsolutePos().y, parent.getSize().width, parent.getSize().height, Color.withAlpha(color, 0.3f), 1.0f);
            ModularGui.drawText("Pos: " + hovered.getPos(), 5.0f, lineY, 1.0f, color, false);
            ModularGui.drawText("Size: " + size, 5.0f, lineY -= 11, 1.0f, color, false);
            ModularGui.drawText("Parent: " + (parent instanceof ModularWindow ? "ModularWindow" : parent.toString()), 5.0f, lineY -= 11, 1.0f, color, false);
            ModularGui.drawText("Class: " + hovered, 5.0f, lineY -= 11, 1.0f, color, false);
            lineY -= 11;
            if (hovered instanceof SlotWidget) {
                BaseSlot slot = ((SlotWidget)hovered).getMcSlot();
                ModularGui.drawText("Slot Index: " + slot.getSlotIndex(), 5.0f, lineY, 1.0f, color, false);
                ModularGui.drawText("Slot Number: " + slot.field_75222_d, 5.0f, lineY -= 11, 1.0f, color, false);
                ModularGui.drawText("Shift-Click Priority: " + (slot.getShiftClickPriority() != Integer.MIN_VALUE ? Integer.valueOf(slot.getShiftClickPriority()) : "DISABLED"), 5.0f, lineY -= 11, 1.0f, color, false);
            }
        }
        color = Color.withAlpha(color, 25);
        for (i = 5; i < screenSize.width; i += 5) {
            this.func_73728_b(i, 0, screenSize.height, color);
        }
        for (i = 5; i < screenSize.height; i += 5) {
            this.func_73730_a(0, screenSize.width, i, color);
        }
        ModularGui.func_73734_a((int)this.mousePos.x, (int)this.mousePos.y, (int)(this.mousePos.x + 1), (int)(this.mousePos.y + 1), (int)Color.withAlpha(Color.GREEN.normal, 0.8f));
    }

    protected void renderToolTip(ItemStack stack, int x, int y, List<String> extraLines, Function<List<String>, List<String>> overwriteItemStackTooltip) {
        List<String> lines = new ArrayList<String>();
        if (stack != null) {
            lines.addAll(GuiHelper.getItemTooltip(stack));
        }
        lines.addAll(extraLines);
        if (overwriteItemStackTooltip != null) {
            lines = overwriteItemStackTooltip.apply(lines);
        }
        GuiContainerManager.drawPagedTooltip((FontRenderer)GuiHelper.getFontRenderer(stack), (int)(x + 12), (int)(y - 12), lines);
    }

    protected void drawVanillaElements(int mouseX, int mouseY, float partialTicks) {
        for (Object guiButton : this.field_146292_n) {
            ((GuiButton)guiButton).func_146112_a(this.field_146297_k, mouseX, mouseY);
        }
        for (Object guiLabel : this.field_146293_o) {
            ((GuiLabel)guiLabel).func_146159_a(this.field_146297_k, mouseX, mouseY);
        }
    }

    public void func_73876_c() {
        super.func_73876_c();
        this.context.onClientTick();
        for (ModularWindow window : this.context.getOpenWindowsReversed()) {
            window.update();
        }
        this.context.getCursor().updateHovered();
        this.context.getCursor().onScreenUpdate();
    }

    private boolean isDoubleClick(long lastClick, long currentClick) {
        return currentClick - lastClick < 500L;
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) {
        long time = Minecraft.func_71386_F();
        boolean doubleClick = this.isDoubleClick(this.lastClick, time);
        this.lastClick = time;
        for (Interactable interactable : this.context.getCurrentWindow().getInteractionListeners()) {
            if (this.shouldSkipClick(interactable)) continue;
            interactable.onClick(mouseButton, doubleClick);
        }
        if (this.context.getCursor().onMouseClick(mouseButton)) {
            this.lastFocusedClick = time;
            return;
        }
        Object probablyClicked = null;
        boolean wasSuccess = false;
        boolean wasReject = false;
        doubleClick = this.isDoubleClick(this.lastFocusedClick, time);
        block9: for (Object hovered : this.getCursor().getAllHovered()) {
            Widget widget;
            if (this.shouldSkipClick(hovered)) break;
            if (this.context.getCursor().onHoveredClick(mouseButton, hovered)) {
                probablyClicked = hovered;
                break;
            }
            if (hovered instanceof ModularWindow) {
                probablyClicked = hovered;
                wasReject = true;
                break;
            }
            if (hovered instanceof Widget && (widget = (Widget)hovered).hasNEITransferRect()) {
                if (mouseButton == 0) {
                    widget.handleTransferRectMouseClick(false);
                } else if (mouseButton == 1) {
                    widget.handleTransferRectMouseClick(true);
                }
                probablyClicked = hovered;
                break;
            }
            if (!(hovered instanceof Interactable)) continue;
            Interactable interactable = (Interactable)hovered;
            Interactable.ClickResult result = interactable.onClick(mouseButton, doubleClick && this.lastClicked == interactable);
            switch (result) {
                case IGNORE: {
                    continue block9;
                }
                case ACKNOWLEDGED: {
                    if (probablyClicked != null) continue block9;
                    probablyClicked = interactable;
                    continue block9;
                }
                case REJECT: {
                    probablyClicked = null;
                    wasReject = true;
                    break block9;
                }
                case DELEGATE: {
                    probablyClicked = null;
                    break block9;
                }
                case ACCEPT: {
                    probablyClicked = interactable;
                    break block9;
                }
                case SUCCESS: {
                    probablyClicked = interactable;
                    wasSuccess = true;
                    this.getCursor().updateFocused((Widget)((Object)interactable));
                    break block9;
                }
                default: {
                    continue block9;
                }
            }
        }
        this.lastClicked = probablyClicked;
        if (!wasSuccess) {
            this.getCursor().updateFocused(null);
        }
        if (probablyClicked == null && !wasReject) {
            super.func_73864_a(mouseX, mouseY, mouseButton);
        } else if (this.shouldShowNEI()) {
            for (IContainerInputHandler inputhander : GuiContainerManager.inputHandlers) {
                inputhander.onMouseClicked((GuiContainer)this, mouseX, mouseY, mouseButton);
            }
        }
        this.lastFocusedClick = time;
    }

    private boolean isNEIWantToHandleDragAndDrop() {
        return this.shouldShowNEI() && (ItemPanels.itemPanel.draggedStack != null || ItemPanels.bookmarkPanel.draggedStack != null);
    }

    private boolean shouldSkipClick(Object object) {
        return this.isNEIWantToHandleDragAndDrop() && object instanceof IDragAndDropHandler;
    }

    protected void func_146286_b(int mouseX, int mouseY, int mouseButton) {
        for (Interactable interactable : this.context.getCurrentWindow().getInteractionListeners()) {
            interactable.onClickReleased(mouseButton);
        }
        if (!this.context.getCursor().onMouseReleased(mouseButton) && (this.lastClicked == null || this.lastClicked instanceof Interactable && !((Interactable)this.lastClicked).onClickReleased(mouseButton)) && !(this.lastClicked instanceof ModularWindow)) {
            super.func_146286_b(mouseX, mouseY, mouseButton);
        }
    }

    protected void func_146273_a(int mouseX, int mouseY, int mouseButton, long timeSinceLastClick) {
        super.func_146273_a(mouseX, mouseY, mouseButton, timeSinceLastClick);
        for (Interactable interactable : this.context.getCurrentWindow().getInteractionListeners()) {
            interactable.onMouseDragged(mouseButton, timeSinceLastClick);
        }
        if (this.lastClicked != null && this.lastClicked instanceof Interactable) {
            ((Interactable)this.lastClicked).onMouseDragged(mouseButton, timeSinceLastClick);
        }
    }

    protected void func_73869_a(char typedChar, int keyCode) {
        if (keyCode == 46 && ModularGui.func_146271_m() && ModularGui.func_146272_n()) {
            Config.debug = !Config.debug;
        }
        for (Interactable interactable : this.context.getCurrentWindow().getInteractionListeners()) {
            interactable.onKeyPressed(typedChar, keyCode);
        }
        Widget focused = this.getCursor().getFocused();
        if (focused instanceof Interactable && ((Interactable)((Object)focused)).onKeyPressed(typedChar, keyCode)) {
            return;
        }
        boolean skipSuper = false;
        for (Object hovered : this.getCursor().getAllHovered()) {
            if (hovered instanceof ModularWindow && hovered != this.getContext().getMainWindow()) {
                skipSuper = true;
                break;
            }
            if (focused != hovered && hovered instanceof Interactable && ((Interactable)hovered).onKeyPressed(typedChar, keyCode)) {
                return;
            }
            if (!(hovered instanceof SlotWidget) && !(hovered instanceof IHasStackUnderMouse)) continue;
            break;
        }
        if (keyCode == 1 || this.field_146297_k.field_71474_y.field_151445_Q.func_151463_i() == keyCode) {
            if (Config.closeWindowsAtOnce) {
                this.context.tryClose();
            } else {
                Iterator<Object> iterator = this.context.getOpenWindows().iterator();
                if (iterator.hasNext()) {
                    ModularWindow window = (ModularWindow)iterator.next();
                    if (!window.isClientOnly()) {
                        this.context.sendClientPacket(5, null, window, NetworkUtils.EMPTY_PACKET);
                    }
                    window.tryClose();
                }
            }
        } else if (!skipSuper) {
            super.func_73869_a(typedChar, keyCode);
        }
    }

    public boolean mouseScrolled(int direction) {
        Widget focused = this.getCursor().getFocused();
        if (focused instanceof Interactable && ((Interactable)((Object)focused)).onMouseScroll(direction)) {
            return true;
        }
        boolean foundFirstElement = false;
        for (Object hovered : this.getCursor().getAllHovered()) {
            if (!foundFirstElement && hovered instanceof ModularWindow) {
                return true;
            }
            if (focused != hovered && hovered instanceof Interactable && ((Interactable)hovered).onMouseScroll(direction)) {
                return true;
            }
            foundFirstElement = true;
        }
        return false;
    }

    public void onMouseScrolled(int direction) {
        for (Interactable interactable : this.context.getCurrentWindow().getInteractionListeners()) {
            interactable.onMouseScroll(direction);
        }
    }

    public Slot func_146975_c(int x, int y) {
        for (Object hovered : this.getCursor().getAllHovered()) {
            if (!(hovered instanceof SlotWidget)) continue;
            return ((SlotWidget)hovered).getMcSlot();
        }
        return null;
    }

    protected boolean func_146983_a(int keyCode) {
        Widget hovered = this.getCursor().getHovered();
        if (hovered instanceof SlotWidget && ((SlotWidget)hovered).getMcSlot().getParentWidget().getWindow().isClientOnly()) {
            return false;
        }
        return super.func_146983_a(keyCode);
    }

    public void func_146281_b() {
        this.context.getCloseListeners().forEach(Runnable::run);
    }

    public boolean isDragSplitting() {
        return this.getAccessor().isDragSplittingInternal();
    }

    public Set<Slot> getDragSlots() {
        return this.getAccessor().getDragSplittingSlots();
    }

    public static RenderItem getItemRenderer() {
        return field_146296_j;
    }

    public static void setItemRenderer(RenderItem renderer) {
        field_146296_j = renderer;
    }

    public float getZ() {
        return this.field_73735_i;
    }

    public void setZ(float z) {
        this.field_73735_i = z;
    }

    public FontRenderer getFontRenderer() {
        return FontUtils.fontRenderer;
    }

    @SideOnly(value=Side.CLIENT)
    public static void drawBorder(float x, float y, float width, float height, int color, float border) {
        ModularGui.drawSolidRect(x - border, y - border, width + 2.0f * border, border, color);
        ModularGui.drawSolidRect(x - border, y + height, width + 2.0f * border, border, color);
        ModularGui.drawSolidRect(x - border, y, border, height, color);
        ModularGui.drawSolidRect(x + width, y, border, height, color);
    }

    @SideOnly(value=Side.CLIENT)
    public static void drawSolidRect(float x, float y, float width, float height, int color) {
        ModularGui.drawRect(x, y, x + width, y + height, color);
        GlStateManager.color(1.0f, 1.0f, 1.0f, 1.0f);
        GlStateManager.enableBlend();
    }

    @SideOnly(value=Side.CLIENT)
    public static void drawText(String text, float x, float y, float scale, int color, boolean shadow) {
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        GlStateManager.disableBlend();
        GlStateManager.pushMatrix();
        GlStateManager.scale(scale, scale, 0.0f);
        float sf = 1.0f / scale;
        fontRenderer.func_85187_a(text, (int)(x * sf), (int)(y * sf), color, shadow);
        GlStateManager.popMatrix();
        GlStateManager.enableBlend();
    }

    public static void drawRect(float left, float top, float right, float bottom, int color) {
        if (left < right) {
            float i = left;
            left = right;
            right = i;
        }
        if (top < bottom) {
            float j = top;
            top = bottom;
            bottom = j;
        }
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        Tessellator tessellator = Tessellator.field_78398_a;
        GlStateManager.enableBlend();
        GlStateManager.disableTexture2D();
        GlStateManager.tryBlendFuncSeparate(GlStateManager.SourceFactor.SRC_ALPHA, GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, GlStateManager.SourceFactor.ONE, GlStateManager.DestFactor.ZERO);
        GlStateManager.color(r, g, b, a);
        tessellator.func_78382_b();
        tessellator.func_78377_a((double)left, (double)bottom, 0.0);
        tessellator.func_78377_a((double)right, (double)bottom, 0.0);
        tessellator.func_78377_a((double)right, (double)top, 0.0);
        tessellator.func_78377_a((double)left, (double)top, 0.0);
        tessellator.func_78381_a();
        GlStateManager.enableTexture2D();
        GlStateManager.disableBlend();
    }

    private boolean shouldShowNEI() {
        return this.getContext().doShowNEI();
    }

    public boolean handleDragNDrop(GuiContainer gui, int mousex, int mousey, ItemStack draggedStack, int button) {
        if (!(gui instanceof ModularGui) || NEIClientUtils.getHeldItem() != null) {
            return false;
        }
        Widget hovered = this.getContext().getCursor().getHovered();
        if (hovered instanceof IDragAndDropHandler) {
            return ((IDragAndDropHandler)((Object)hovered)).handleDragAndDrop(draggedStack, button);
        }
        return false;
    }

    public boolean hideItemPanelSlot(GuiContainer gui, int x, int y, int w, int h) {
        if (!(gui instanceof ModularGui)) {
            return false;
        }
        Rectangle neiSlotRectangle = new Rectangle(x, y, w, h);
        for (ModularWindow window : this.getContext().getOpenWindows()) {
            if (!window.getRectangle().intersects(neiSlotRectangle)) continue;
            return true;
        }
        ArrayList activeWidgets = new ArrayList();
        for (ModularWindow window : this.getContext().getOpenWindows()) {
            IWidgetParent.forEachByLayer(window, true, widget -> !widget.isRespectNEIArea(), widget -> {
                if (widget.isRespectNEIArea()) {
                    activeWidgets.add(widget);
                }
                return false;
            });
        }
        for (Widget widget2 : activeWidgets) {
            Rectangle widgetAbsoluteRectangle = widget2.getRenderAbsoluteRectangle();
            if (!widgetAbsoluteRectangle.intersects(neiSlotRectangle)) continue;
            return true;
        }
        return false;
    }

    public VisiblityData modifyVisiblity(GuiContainer gui, VisiblityData currentVisibility) {
        return currentVisibility;
    }

    public Iterable<Integer> getItemSpawnSlots(GuiContainer gui, ItemStack item) {
        return Collections.emptyList();
    }

    public List<TaggedInventoryArea> getInventoryAreas(GuiContainer gui) {
        return null;
    }
}

