/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.modularui.common.widget;

import com.gtnewhorizons.modularui.ModularUI;
import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.forge.IItemHandlerModifiable;
import com.gtnewhorizons.modularui.api.forge.PlayerMainInvWrapper;
import com.gtnewhorizons.modularui.api.math.Alignment;
import com.gtnewhorizons.modularui.api.math.Pos2d;
import com.gtnewhorizons.modularui.api.math.Size;
import com.gtnewhorizons.modularui.api.widget.Widget;
import com.gtnewhorizons.modularui.common.internal.wrapper.BaseSlot;
import com.gtnewhorizons.modularui.common.widget.FluidSlotWidget;
import com.gtnewhorizons.modularui.common.widget.MultiChildWidget;
import com.gtnewhorizons.modularui.common.widget.SlotWidget;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fluids.IFluidTank;

public class SlotGroup
extends MultiChildWidget {
    public static final int PLAYER_INVENTORY_HEIGHT = 76;

    public static SlotGroup playerInventoryGroup(EntityPlayer player) {
        return SlotGroup.playerInventoryGroup(player, null);
    }

    public static SlotGroup playerInventoryGroup(EntityPlayer player, IDrawable background) {
        PlayerMainInvWrapper wrapper = new PlayerMainInvWrapper(player.field_71071_by);
        SlotGroup slotGroup = new SlotGroup();
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                SlotWidget slot = new SlotWidget(new BaseSlot(wrapper, col + (row + 1) * 9)).setPos(new Pos2d(col * 18, row * 18));
                slotGroup.addSlot(slot);
                if (background == null) continue;
                slot.setBackground(background);
            }
        }
        for (int i = 0; i < 9; ++i) {
            SlotWidget slot = new SlotWidget(new BaseSlot(wrapper, i)).setPos(new Pos2d(i * 18, 58));
            slotGroup.addSlot(slot);
            if (background == null) continue;
            slot.setBackground(background);
        }
        return slotGroup;
    }

    public static ItemGroupBuilder ofItemHandler(IItemHandlerModifiable itemHandler, int slotsPerRow) {
        return new ItemGroupBuilder(itemHandler, slotsPerRow);
    }

    public static FluidGroupBuilder ofFluidTanks(List<IFluidTank> fluidTanks, int slotsPerRow) {
        return new FluidGroupBuilder(fluidTanks, slotsPerRow);
    }

    public SlotGroup setOnDragAndDropComplete(Consumer<Widget> onDragAndDropComplete) {
        for (Widget child : this.children) {
            if (child instanceof SlotWidget) {
                ((SlotWidget)child).setOnDragAndDropComplete(onDragAndDropComplete);
            }
            if (!(child instanceof FluidSlotWidget)) continue;
            ((FluidSlotWidget)child).setOnDragAndDropComplete(onDragAndDropComplete);
        }
        return this;
    }

    @Override
    public void onInit() {
    }

    public SlotGroup addSlot(SlotWidget slotWidget) {
        this.addChild(slotWidget);
        return this;
    }

    public static class BuilderWithPattern {
        private final List<String> rows = new ArrayList<String>();
        private final Map<Character, Function<Integer, Widget>> widgetCreatorMap = new HashMap<Character, Function<Integer, Widget>>();
        private Size cellSize = new Size(18, 18);
        private Size totalSize;
        private Alignment alignment = Alignment.TopLeft;

        public BuilderWithPattern setCellSize(Size cellSize) {
            this.cellSize = cellSize;
            return this;
        }

        public BuilderWithPattern setSize(Size totalSize, Alignment contentAlignment) {
            this.totalSize = totalSize;
            this.alignment = contentAlignment;
            return this;
        }

        public BuilderWithPattern setSize(Size totalSize) {
            return this.setSize(totalSize, this.alignment);
        }

        public BuilderWithPattern row(String row) {
            this.rows.add(row);
            return this;
        }

        public BuilderWithPattern where(char c, Function<Integer, Widget> widgetCreator) {
            this.widgetCreatorMap.put(Character.valueOf(c), widgetCreator);
            return this;
        }

        public BuilderWithPattern where(char c, IItemHandlerModifiable inventory) {
            this.widgetCreatorMap.put(Character.valueOf(c), i -> new SlotWidget(inventory, (int)i));
            return this;
        }

        public BuilderWithPattern where(char c, IFluidTank[] inventory) {
            this.widgetCreatorMap.put(Character.valueOf(c), i -> new FluidSlotWidget(inventory[i]));
            return this;
        }

        public BuilderWithPattern where(char c, List<IFluidTank> inventory) {
            this.widgetCreatorMap.put(Character.valueOf(c), i -> new FluidSlotWidget((IFluidTank)inventory.get((int)i)));
            return this;
        }

        public SlotGroup build() {
            int maxRowWith = 0;
            for (String row : this.rows) {
                maxRowWith = Math.max(maxRowWith, row.length());
            }
            Size contentSize = new Size(maxRowWith * this.cellSize.width, this.rows.size() * this.cellSize.height);
            Pos2d offsetPos = Pos2d.ZERO;
            if (this.totalSize != null) {
                offsetPos = this.alignment.getAlignedPos(this.totalSize, contentSize);
            }
            HashMap<Character, AtomicInteger> charCount = new HashMap<Character, AtomicInteger>();
            SlotGroup slotGroup = new SlotGroup();
            for (int i = 0; i < this.rows.size(); ++i) {
                String row = this.rows.get(i);
                for (int j = 0; j < row.length(); ++j) {
                    char c = row.charAt(j);
                    if (c == ' ') continue;
                    Function<Integer, Widget> widgetCreator = this.widgetCreatorMap.get(Character.valueOf(c));
                    if (widgetCreator == null) {
                        ModularUI.logger.warn("Key {} was not found in Slot group.", new Object[]{Character.valueOf(c)});
                        continue;
                    }
                    Widget widget = widgetCreator.apply(charCount.computeIfAbsent(Character.valueOf(c), key -> new AtomicInteger()).getAndIncrement());
                    if (widget == null) continue;
                    slotGroup.addChild(widget.setPos(offsetPos.add(j * this.cellSize.width, i * this.cellSize.height)));
                }
            }
            return slotGroup;
        }
    }

    public static class FluidGroupBuilder {
        private final List<IFluidTank> fluidTanks;
        private final int slotsPerRow;
        private Integer startFromSlot;
        private Integer endAtSlot;
        private Boolean phantom;
        private Boolean controlsAmount;

        private FluidGroupBuilder(List<IFluidTank> fluidTanks, int slotsPerRow) {
            this.fluidTanks = fluidTanks;
            this.slotsPerRow = slotsPerRow;
        }

        public SlotGroup build() {
            if (this.startFromSlot == null) {
                this.startFromSlot = 0;
            }
            if (this.endAtSlot == null) {
                this.endAtSlot = this.fluidTanks.size() - 1;
            }
            if (this.phantom == null) {
                this.phantom = false;
            }
            if (this.controlsAmount == null) {
                this.controlsAmount = true;
            }
            SlotGroup slotGroup = new SlotGroup();
            if (this.startFromSlot > this.endAtSlot) {
                return slotGroup;
            }
            int x = 0;
            int y = 0;
            for (int i = this.startFromSlot.intValue(); i < this.endAtSlot + 1; ++i) {
                FluidSlotWidget toAdd = this.phantom != false ? FluidSlotWidget.phantom(this.fluidTanks.get(i), this.controlsAmount) : new FluidSlotWidget(this.fluidTanks.get(i));
                toAdd.setPos(new Pos2d(x * 18, y * 18));
                slotGroup.addChild(toAdd);
                if (++x != this.slotsPerRow) continue;
                x = 0;
                ++y;
            }
            return slotGroup;
        }

        public FluidGroupBuilder startFromSlot(int startFromSlot) {
            this.startFromSlot = Math.max(startFromSlot, 0);
            return this;
        }

        public FluidGroupBuilder endAtSlot(int endAtSlot) {
            this.endAtSlot = Math.min(endAtSlot, this.fluidTanks.size() - 1);
            return this;
        }

        public FluidGroupBuilder phantom(boolean phantom) {
            this.phantom = phantom;
            return this;
        }

        public FluidGroupBuilder controlsAmount(boolean controlsAmount) {
            this.controlsAmount = controlsAmount;
            return this;
        }
    }

    public static class ItemGroupBuilder {
        private final IItemHandlerModifiable itemHandler;
        private final int slotsPerRow;
        private Integer startFromSlot;
        private Integer endAtSlot;
        private Integer shiftClickPriority;
        private boolean canInsert = true;
        private boolean canTake = true;
        private boolean phantom = false;
        private IDrawable[] background;
        private Function<Integer, BaseSlot> slotCreator;
        private Consumer<SlotWidget> applyForWidget;
        private Function<BaseSlot, SlotWidget> widgetCreator;

        private ItemGroupBuilder(IItemHandlerModifiable itemHandler, int slotsPerRow) {
            this.itemHandler = itemHandler;
            this.slotsPerRow = Math.max(slotsPerRow, 1);
        }

        public SlotGroup build() {
            if (this.startFromSlot == null) {
                this.startFromSlot = 0;
            }
            if (this.endAtSlot == null) {
                this.endAtSlot = this.itemHandler.getSlots() - 1;
            }
            SlotGroup slotGroup = new SlotGroup();
            if (this.startFromSlot > this.endAtSlot) {
                return slotGroup;
            }
            int x = 0;
            int y = 0;
            for (int i = this.startFromSlot.intValue(); i < this.endAtSlot + 1; ++i) {
                BaseSlot baseSlot = this.slotCreator != null ? this.slotCreator.apply(i) : new BaseSlot(this.itemHandler, i, this.phantom);
                baseSlot.setAccess(this.canTake, this.canInsert);
                if (this.shiftClickPriority != null) {
                    baseSlot.setShiftClickPriority(this.shiftClickPriority);
                }
                SlotWidget toAdd = this.widgetCreator != null ? this.widgetCreator.apply(baseSlot) : new SlotWidget(baseSlot);
                toAdd.setBackground(this.background).setPos(x * 18, y * 18);
                if (this.applyForWidget != null) {
                    this.applyForWidget.accept(toAdd);
                }
                slotGroup.addSlot(toAdd);
                if (++x != this.slotsPerRow) continue;
                x = 0;
                ++y;
            }
            return slotGroup;
        }

        public ItemGroupBuilder startFromSlot(int startFromSlot) {
            this.startFromSlot = Math.max(startFromSlot, 0);
            return this;
        }

        public ItemGroupBuilder endAtSlot(int endAtSlot) {
            this.endAtSlot = Math.min(endAtSlot, this.itemHandler.getSlots() - 1);
            return this;
        }

        public ItemGroupBuilder shiftClickPriority(int shiftClickPriority) {
            this.shiftClickPriority = shiftClickPriority;
            return this;
        }

        public ItemGroupBuilder canInsert(boolean canInsert) {
            this.canInsert = canInsert;
            return this;
        }

        public ItemGroupBuilder canTake(boolean canTake) {
            this.canTake = canTake;
            return this;
        }

        public ItemGroupBuilder phantom(boolean phantom) {
            this.phantom = phantom;
            return this;
        }

        public ItemGroupBuilder background(IDrawable ... background) {
            this.background = background;
            return this;
        }

        public ItemGroupBuilder slotCreator(Function<Integer, BaseSlot> slotCreator) {
            this.slotCreator = slotCreator;
            return this;
        }

        public ItemGroupBuilder applyForWidget(Consumer<SlotWidget> consumer) {
            this.applyForWidget = consumer;
            return this;
        }

        public ItemGroupBuilder widgetCreator(Function<BaseSlot, SlotWidget> widgetCreator) {
            this.widgetCreator = widgetCreator;
            return this;
        }
    }
}

