/*
 * Decompiled with CFR 0.152.
 */
package me.eigenraven.personalspace.world;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import com.google.common.collect.Lists;
import cpw.mods.fml.common.registry.GameRegistry;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.io.File;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import me.eigenraven.personalspace.CommonProxy;
import me.eigenraven.personalspace.Config;
import me.eigenraven.personalspace.PersonalSpaceMod;
import me.eigenraven.personalspace.world.PersonalWorldProvider;
import net.minecraft.block.Block;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.gen.FlatLayerInfo;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import org.apache.commons.lang3.tuple.MutablePair;

public class DimensionConfig {
    private String saveDirOverride = "";
    private int skyColor = 12638463;
    private float starBrightness = 1.0f;
    private boolean weatherEnabled = false;
    private boolean nightTime = false;
    private boolean cloudsEnabled = true;
    private SkyType skyType = SkyType.VANILLA;
    private boolean generatingVegetation = false;
    private boolean generatingTrees = false;
    private boolean allowGenerationChanges = false;
    private String biomeId = "Plains";
    private ArrayList<FlatLayerInfo> layers = Lists.newArrayList();
    private boolean needsSaving = true;
    public static final String PRESET_UW_VOID = "";
    public static final String PRESET_UW_GARDEN = "minecraft:bedrock;minecraft:dirt*3;minecraft:grass";
    public static final String PRESET_UW_MINING = "minecraft:bedrock*4;minecraft:stone*58;minecraft:dirt;minecraft:grass";
    public static final Pattern PRESET_VALIDATION_PATTERN = Pattern.compile("^([^:\\*;]+:[^:\\*;]+(\\*\\d+)?;)*([^:\\*;]+:[^:\\*;]+(\\*\\d+)?)?$");

    public void writeToPacket(MCDataOutput pkt) {
        pkt.writeString(this.saveDirOverride);
        pkt.writeInt(this.skyColor);
        pkt.writeFloat(this.starBrightness);
        pkt.writeVarInt(this.getRawBiomeId());
        pkt.writeBoolean(this.nightTime);
        pkt.writeBoolean(this.cloudsEnabled);
        pkt.writeVarInt(this.skyType.ordinal());
        pkt.writeBoolean(this.weatherEnabled);
        pkt.writeBoolean(this.generatingVegetation);
        pkt.writeBoolean(this.generatingTrees);
        pkt.writeBoolean(this.allowGenerationChanges);
        pkt.writeVarInt(this.layers.size());
        for (FlatLayerInfo info : this.layers) {
            pkt.writeVarInt(Block.func_149682_b((Block)info.func_151536_b()));
            pkt.writeVarInt(info.func_82657_a());
        }
    }

    public void readFromPacket(MCDataInput pkt) {
        this.saveDirOverride = pkt.readString();
        this.needsSaving = true;
        this.setSkyColor(pkt.readInt());
        this.setStarBrightness(pkt.readFloat());
        this.setBiomeId(BiomeGenBase.func_150565_n()[pkt.readVarInt()].field_76791_y);
        this.setNightTime(pkt.readBoolean());
        this.setCloudsEnabled(pkt.readBoolean());
        this.setSkyType(SkyType.fromOrdinal(pkt.readVarInt()));
        this.setWeatherEnabled(pkt.readBoolean());
        this.setGeneratingVegetation(pkt.readBoolean());
        this.setGeneratingTrees(pkt.readBoolean());
        this.setAllowGenerationChanges(pkt.readBoolean());
        int layerCount = pkt.readVarInt();
        ArrayList<FlatLayerInfo> layers = new ArrayList<FlatLayerInfo>(layerCount);
        int y = 0;
        for (int layerI = 0; layerI < layerCount; ++layerI) {
            int blockId = pkt.readVarInt();
            int count = pkt.readVarInt();
            FlatLayerInfo info = new FlatLayerInfo(count, Block.func_149729_e((int)blockId));
            info.func_82660_d(y);
            layers.add(info);
            y += count;
        }
        this.layers = layers;
    }

    public int syncWithFile(File file, boolean write, int dimId) {
        String VISUAL = "visual";
        String WORLDGEN = "worldgen";
        Configuration cfg = new Configuration(file);
        Property cur = cfg.get("visual", "skyColor", this.skyColor, PRESET_UW_VOID, 0, 0xFFFFFF);
        if (write) {
            cur.set(this.skyColor);
        } else {
            this.setSkyColor(cur.getInt());
        }
        cur = cfg.get("visual", "starBrightness", (double)this.starBrightness, PRESET_UW_VOID, 0.0, 1.0);
        if (write) {
            cur.set((double)this.starBrightness);
        } else {
            this.setStarBrightness((float)cur.getDouble());
        }
        cur = cfg.get("worldgen", "biomeId", this.getBiomeId());
        if (write) {
            cur.set(this.getBiomeId());
        } else {
            this.setBiomeId(cur.getString());
        }
        cur = cfg.get("visual", "weatherEnabled", this.weatherEnabled, PRESET_UW_VOID);
        if (write) {
            cur.set(this.weatherEnabled);
        } else {
            this.setWeatherEnabled(cur.getBoolean());
        }
        cur = cfg.get("visual", "nightTime", this.nightTime, PRESET_UW_VOID);
        if (write) {
            cur.set(this.nightTime);
        } else {
            this.setNightTime(cur.getBoolean());
        }
        cur = cfg.get("visual", "cloudsEnabled", this.cloudsEnabled, PRESET_UW_VOID);
        if (write) {
            cur.set(this.cloudsEnabled);
        } else {
            this.setCloudsEnabled(cur.getBoolean());
        }
        cur = cfg.get("visual", "skyType", this.skyType.ordinal(), PRESET_UW_VOID);
        if (write) {
            cur.set(this.skyType.ordinal());
        } else {
            this.setSkyType(SkyType.fromOrdinal(cur.getInt()));
        }
        cur = cfg.get("worldgen", "generatingTrees", this.generatingTrees, PRESET_UW_VOID);
        if (write) {
            cur.set(this.generatingTrees);
        } else {
            this.setGeneratingTrees(cur.getBoolean());
        }
        cur = cfg.get("worldgen", "generatingVegetation", this.generatingVegetation, PRESET_UW_VOID);
        if (write) {
            cur.set(this.generatingVegetation);
        } else {
            this.setGeneratingVegetation(cur.getBoolean());
        }
        cur = cfg.get("worldgen", "allowGenerationChanges", this.allowGenerationChanges, "One-time-use permission to change generation settings on the world");
        if (write) {
            cur.set(this.allowGenerationChanges);
        } else {
            this.setAllowGenerationChanges(cur.getBoolean());
        }
        cur = cfg.get("worldgen", "layers", this.getLayersAsString());
        if (write) {
            cur.set(this.getLayersAsString());
        } else {
            this.setLayers(cur.getString());
        }
        cur = cfg.get("worldgen", "dimId", dimId);
        if (write) {
            cur.set(dimId);
        } else {
            dimId = cur.getInt();
        }
        if (write) {
            cfg.save();
        }
        this.needsSaving = false;
        return dimId;
    }

    public static DimensionConfig fromPacket(MCDataInput pkt) {
        DimensionConfig cfg = new DimensionConfig();
        cfg.readFromPacket(pkt);
        return cfg;
    }

    public boolean copyFrom(DimensionConfig source, boolean copySaveInfo, boolean copyVisualInfo, boolean copyGenerationInfo) {
        this.needsSaving = false;
        if (copySaveInfo) {
            this.saveDirOverride = source.saveDirOverride;
        }
        if (copyVisualInfo) {
            this.setSkyColor(source.getSkyColor());
            this.setStarBrightness(source.getStarBrightness());
            this.setNightTime(source.isNightTime());
            this.setCloudsEnabled(source.isCloudsEnabled());
            this.setSkyType(source.getSkyType());
            this.setWeatherEnabled(source.isWeatherEnabled());
        }
        if (copyGenerationInfo) {
            this.setAllowGenerationChanges(source.getAllowGenerationChanges());
            this.setBiomeId(source.getBiomeId());
            this.setGeneratingTrees(source.isGeneratingTrees());
            this.setGeneratingVegetation(source.isGeneratingVegetation());
            this.layers = source.layers;
            this.needsSaving = true;
        }
        boolean modified = this.needsSaving;
        this.needsSaving = true;
        return modified;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerWithDimensionManager(int dimId, boolean isClient) {
        if (!DimensionManager.isDimensionRegistered((int)dimId)) {
            DimensionManager.registerProviderType((int)dimId, PersonalWorldProvider.class, (boolean)false);
            if (PersonalSpaceMod.isInThermos()) {
                try {
                    Class<?> bukkitWorldEnv = Class.forName("org.bukkit.World$Environment");
                    Field lookupField = bukkitWorldEnv.getDeclaredField("lookup");
                    lookupField.setAccessible(true);
                    Map lookup = (Map)lookupField.get(null);
                    if (lookup.remove(dimId) != null) {
                        PersonalSpaceMod.LOG.info("Removed bad thermos environment lookup entry for dimension {}", new Object[]{dimId});
                    }
                }
                catch (Exception e) {
                    PersonalSpaceMod.LOG.error("Couldn't adjust thermos environment lookup table", (Throwable)e);
                }
            }
            DimensionManager.registerDimension((int)dimId, (int)dimId);
            if (Config.debugLogging) {
                PersonalSpaceMod.LOG.info("DimensionConfig registered for dim {}, client {}", new Object[]{dimId, isClient, new Throwable()});
            }
        }
        TIntObjectHashMap<DimensionConfig> tIntObjectHashMap = CommonProxy.getDimensionConfigObjects(isClient);
        synchronized (tIntObjectHashMap) {
            if (!CommonProxy.getDimensionConfigObjects(isClient).containsKey(dimId)) {
                CommonProxy.getDimensionConfigObjects(isClient).put(dimId, (Object)this);
            } else {
                ((DimensionConfig)CommonProxy.getDimensionConfigObjects(isClient).get(dimId)).copyFrom(this, true, true, true);
            }
        }
    }

    public static int nextFreeDimId() {
        int nextId;
        AtomicInteger nextIdV = new AtomicInteger(Config.firstDimensionId);
        CommonProxy.getDimensionConfigObjects(false).forEachKey(id -> {
            if (nextIdV.get() <= id) {
                nextIdV.set(id + 1);
            }
            return true;
        });
        for (nextId = nextIdV.get(); DimensionManager.isDimensionRegistered((int)nextId) && nextId < 0x7FFFFFFE; ++nextId) {
        }
        assert (!DimensionManager.isDimensionRegistered((int)nextId));
        return nextId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DimensionConfig getForDimension(int dimId, boolean isClient) {
        TIntObjectHashMap<DimensionConfig> tIntObjectHashMap = CommonProxy.getDimensionConfigObjects(isClient);
        synchronized (tIntObjectHashMap) {
            return (DimensionConfig)CommonProxy.getDimensionConfigObjects(isClient).get(dimId);
        }
    }

    public void setSaveDirOverride(String override) {
        if (override == null) {
            override = PRESET_UW_VOID;
        }
        this.saveDirOverride = override;
    }

    public String getSaveDir(int dimId) {
        return this.saveDirOverride != null && this.saveDirOverride.length() > 0 ? this.saveDirOverride : String.format("PERSONAL_DIM_%d", dimId);
    }

    public float getStarBrightness() {
        return this.starBrightness;
    }

    public void setStarBrightness(float starBrightness) {
        if (starBrightness != this.starBrightness) {
            this.needsSaving = true;
            this.starBrightness = MathHelper.func_76131_a((float)starBrightness, (float)0.0f, (float)1.0f);
        }
    }

    public int getSkyColor() {
        return this.skyColor;
    }

    public void setSkyColor(int skyColor) {
        if (skyColor != this.skyColor) {
            this.needsSaving = true;
            this.skyColor = MathHelper.func_76125_a((int)skyColor, (int)0, (int)0xFFFFFF);
        }
    }

    public boolean isWeatherEnabled() {
        return this.weatherEnabled;
    }

    public void setWeatherEnabled(boolean weatherEnabled) {
        if (this.weatherEnabled != weatherEnabled) {
            this.needsSaving = true;
            this.weatherEnabled = weatherEnabled;
        }
    }

    public boolean isNightTime() {
        return this.nightTime;
    }

    public void setNightTime(boolean nightTime) {
        if (this.nightTime != nightTime) {
            this.needsSaving = true;
            this.nightTime = nightTime;
        }
    }

    public boolean isCloudsEnabled() {
        return this.cloudsEnabled;
    }

    public void setCloudsEnabled(boolean cloudsEnabled) {
        if (this.cloudsEnabled != cloudsEnabled) {
            this.needsSaving = true;
            this.cloudsEnabled = cloudsEnabled;
        }
    }

    public SkyType getSkyType() {
        return this.skyType;
    }

    public void setSkyType(SkyType skyType) {
        if (this.skyType != skyType) {
            this.needsSaving = true;
            this.skyType = skyType;
        }
    }

    public boolean isGeneratingVegetation() {
        return this.generatingVegetation;
    }

    public void setGeneratingVegetation(boolean generatingVegetation) {
        if (this.generatingVegetation != generatingVegetation) {
            this.needsSaving = true;
            this.generatingVegetation = generatingVegetation;
        }
    }

    public boolean isGeneratingTrees() {
        return this.generatingTrees;
    }

    public void setGeneratingTrees(boolean generatingTrees) {
        if (this.generatingTrees != generatingTrees) {
            this.needsSaving = true;
            this.generatingTrees = generatingTrees;
        }
    }

    public String getBiomeId() {
        return this.biomeId;
    }

    public int getRawBiomeId() {
        BiomeGenBase[] biomes = BiomeGenBase.func_150565_n();
        for (int i = 0; i < biomes.length; ++i) {
            if (biomes[i] == null || biomes[i].field_76791_y == null || !biomes[i].field_76791_y.equalsIgnoreCase(this.biomeId)) continue;
            return i;
        }
        return 1;
    }

    public void setBiomeId(String biomeId) {
        if (biomeId == null) {
            biomeId = "Plains";
        }
        if (!this.biomeId.equalsIgnoreCase(biomeId)) {
            this.needsSaving = true;
            this.biomeId = biomeId;
        }
    }

    public boolean getAllowGenerationChanges() {
        return this.allowGenerationChanges;
    }

    public void setAllowGenerationChanges(boolean allowGenerationChanges) {
        if (this.allowGenerationChanges != allowGenerationChanges) {
            this.needsSaving = true;
            this.allowGenerationChanges = allowGenerationChanges;
        }
    }

    public boolean needsSaving() {
        return this.needsSaving;
    }

    public static ArrayList<FlatLayerInfo> parseLayers(String preset) {
        if (preset == null) {
            return Lists.newArrayList();
        }
        if ((preset = preset.replaceAll("\\s+", PRESET_UW_VOID)).length() < 1 || !PRESET_VALIDATION_PATTERN.matcher(preset).matches()) {
            return Lists.newArrayList();
        }
        ArrayList<FlatLayerInfo> infos = new ArrayList<FlatLayerInfo>();
        int currY = 0;
        for (String layerStr : preset.split(";")) {
            if (layerStr.isEmpty()) continue;
            String[] components = layerStr.split("\\*", 2);
            String[] blockName = components[0].split(":");
            if (blockName.length != 2) {
                return Lists.newArrayList();
            }
            int blockCount = 1;
            if (components.length > 1) {
                try {
                    blockCount = Integer.parseInt(components[1]);
                }
                catch (NumberFormatException nfe) {
                    return Lists.newArrayList();
                }
            }
            blockCount = MathHelper.func_76125_a((int)blockCount, (int)1, (int)255);
            Block block = GameRegistry.findBlock((String)blockName[0], (String)blockName[1]);
            if (block == null) {
                return Lists.newArrayList();
            }
            FlatLayerInfo info = new FlatLayerInfo(blockCount, block, 0);
            info.func_82660_d(currY);
            infos.add(info);
            if ((currY += blockCount) > 255) break;
        }
        return infos;
    }

    public List<FlatLayerInfo> getLayers() {
        return Collections.unmodifiableList(this.layers);
    }

    public List<FlatLayerInfo> getMutableLayers() {
        return this.layers;
    }

    public static String layersToString(List<FlatLayerInfo> layers) {
        StringBuilder b = new StringBuilder();
        for (FlatLayerInfo info : layers) {
            int count = info.func_82657_a();
            if (count < 1) continue;
            GameRegistry.UniqueIdentifier block = GameRegistry.findUniqueIdentifierFor((Block)info.func_151536_b());
            if (block == null) {
                block = new GameRegistry.UniqueIdentifier("minecraft:air");
            }
            b.append(block.modId);
            b.append(':');
            b.append(block.name);
            if (count > 1) {
                b.append('*');
                b.append(count);
            }
            b.append(';');
        }
        if (b.length() > 0) {
            b.deleteCharAt(b.length() - 1);
        }
        return b.toString();
    }

    public String getLayersAsString() {
        return DimensionConfig.layersToString(this.layers);
    }

    public static boolean canUseLayers(String preset, boolean onClient) {
        if (preset == null) {
            preset = PRESET_UW_VOID;
        }
        if (preset.equals(PRESET_UW_GARDEN) || preset.equals(PRESET_UW_VOID) || preset.equals(PRESET_UW_MINING)) {
            return true;
        }
        ArrayList<FlatLayerInfo> infos = DimensionConfig.parseLayers(preset);
        if (infos.isEmpty() && !preset.trim().isEmpty()) {
            return false;
        }
        for (FlatLayerInfo info : infos) {
            String block = GameRegistry.findUniqueIdentifierFor((Block)info.func_151536_b()).toString();
            if (!onClient ? Config.allowedBlocks.contains(block) : PersonalSpaceMod.clientAllowedBlocks.contains(block)) continue;
            return false;
        }
        return true;
    }

    public static boolean canUseBiome(String biome, boolean onClient) {
        if (biome.equalsIgnoreCase("Plains")) {
            return true;
        }
        return onClient ? PersonalSpaceMod.clientAllowedBiomes.contains(biome.toLowerCase()) : Config.allowedBiomes.contains(biome.toLowerCase());
    }

    public void setLayers(String preset) {
        this.layers = DimensionConfig.parseLayers(preset);
    }

    public static MutablePair<DimensionConfig, Integer> fromUtilityWorldsWorld(String name) {
        int dimId;
        boolean isMining = name.startsWith("UW_MINING_");
        boolean isGarden = name.startsWith("UW_GARDEN_");
        boolean isVoid = name.startsWith("UW_VOID_");
        if (!(isMining || isGarden || isVoid)) {
            return null;
        }
        String dimIdStr = name.split("_", 3)[2];
        try {
            dimId = Integer.parseInt(dimIdStr);
        }
        catch (NumberFormatException nfe) {
            PersonalSpaceMod.LOG.warn("Couldn't parse dimension ID from folder name " + name, (Throwable)nfe);
            return null;
        }
        DimensionConfig cfg = new DimensionConfig();
        cfg.saveDirOverride = name;
        cfg.skyColor = isVoid ? 0 : 12638463;
        float f = cfg.starBrightness = isVoid ? 0.0f : 1.0f;
        if (isMining) {
            cfg.setLayers(PRESET_UW_MINING);
        } else if (isGarden) {
            cfg.setLayers(PRESET_UW_GARDEN);
            cfg.generatingVegetation = true;
        } else {
            cfg.setLayers(PRESET_UW_VOID);
        }
        return MutablePair.of((Object)cfg, (Object)dimId);
    }

    public int getGroundLevel() {
        if (this.layers.isEmpty()) {
            return 128;
        }
        int y = 0;
        for (FlatLayerInfo info : this.layers) {
            y += info.func_82657_a();
        }
        return MathHelper.func_76125_a((int)y, (int)0, (int)255);
    }

    public static enum SkyType {
        VANILLA(null, null),
        BARNADA_C("galaxyspace.BarnardsSystem.planets.barnardaC.dimension.sky.SkyProviderBarnardaC", "galaxyspace.BarnardsSystem.planets.barnardaC.dimension.sky.CloudProviderBarnardaC");

        public final String skyProvider;
        public final String cloudProvider;
        private Boolean isLoaded = null;

        private SkyType(String skyProvider, String cloudProvider) {
            this.skyProvider = skyProvider;
            this.cloudProvider = cloudProvider;
        }

        public static SkyType fromOrdinal(int ord) {
            return ord < 0 || ord >= SkyType.values().length ? VANILLA : SkyType.values()[ord];
        }

        public boolean isLoaded() {
            if (this.skyProvider == null && this.cloudProvider == null) {
                return true;
            }
            if (this.isLoaded == null) {
                try {
                    Class<?> skyClass = Class.forName(this.skyProvider);
                    Class<?> cloudClass = Class.forName(this.cloudProvider);
                    this.isLoaded = Boolean.TRUE;
                }
                catch (ClassNotFoundException e) {
                    this.isLoaded = Boolean.FALSE;
                }
            }
            return this.isLoaded;
        }

        private Object makeClass(String name) {
            if (name == null || !this.isLoaded()) {
                return null;
            }
            try {
                Class<?> klass = Class.forName(name);
                return klass.newInstance();
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                throw new RuntimeException(e);
            }
        }

        public Object makeSkyProvider() {
            return this.makeClass(this.skyProvider);
        }

        public Object makeCloudProvider() {
            return this.makeClass(this.cloudProvider);
        }

        public String getButtonText() {
            return this.toString().substring(0, 1);
        }

        public String getButtonTooltip() {
            return StatCollector.func_74838_a((String)("gui.personalWorld.skyType." + (Object)((Object)this)));
        }
    }
}

