/*
 * Decompiled with CFR 0.152.
 */
package com.sinthoras.visualprospecting.integration.model.locations;

import com.sinthoras.visualprospecting.Utils;
import com.sinthoras.visualprospecting.integration.model.locations.ILocationProvider;

public class DirtyChunkLocation
implements ILocationProvider {
    private final int blockX;
    private final int blockZ;
    private final int dimensionId;
    private final boolean dirty;

    public DirtyChunkLocation(int chunkX, int chunkZ, int dimensionId, boolean dirty) {
        this.blockX = Utils.coordChunkToBlock(chunkX);
        this.blockZ = Utils.coordChunkToBlock(chunkZ);
        this.dimensionId = dimensionId;
        this.dirty = dirty;
    }

    @Override
    public double getBlockX() {
        return (double)this.blockX + 0.5;
    }

    @Override
    public double getBlockZ() {
        return (double)this.blockZ + 0.5;
    }

    @Override
    public int getDimensionId() {
        return this.dimensionId;
    }

    public boolean isDirty() {
        return this.dirty;
    }
}

